/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.datagen;

import com.google.common.collect.ImmutableSet;
import com.voxelutopia.ultramarine.Ultramarine;
import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import com.voxelutopia.ultramarine.data.registry.ItemRegistry;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.BaseBlockPropertyHolder;
import com.voxelutopia.ultramarine.world.block.BaseSlab;
import com.voxelutopia.ultramarine.world.block.ConsumableDecorativeBlock;
import com.voxelutopia.ultramarine.world.block.StackableHalfBlock;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import com.voxelutopia.ultramarine.world.block.state.StackableBlockType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

public class ModBlockLootProvider
extends BlockLootSubProvider {
    static final Logger LOGGER = Ultramarine.getLogger();
    static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
    static final LootItemCondition.Builder HAS_SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_}));
    static final Set<Item> EXPLOSION_RESISTANT = (Set)Stream.of(Blocks.f_50752_).map(ItemLike::m_5456_).collect(ImmutableSet.toImmutableSet());
    protected final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
    private static final List<RegistryObject<Block>> NON_SIMPLE_BLOCKS = new ArrayList<RegistryObject<Block>>();
    private static final List<Class<? extends Block>> NON_SIMPLE_BLOCK_CLASSES = List.of(DropExperienceBlock.class, SlabBlock.class, ConsumableDecorativeBlock.class, StackableHalfBlock.class);

    public ModBlockLootProvider() {
        super(Set.of(), FeatureFlags.f_244280_.m_247355_());
    }

    protected void m_245660_() {
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> !NON_SIMPLE_BLOCKS.contains(blockRegistryObject)).forEach(this::simple);
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> blockRegistryObject.get() instanceof BaseSlab).forEach(blockRegistryObject -> this.slab((Block)blockRegistryObject.get(), ((Block)blockRegistryObject.get()).m_5456_()));
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> blockRegistryObject.get() instanceof StackableHalfBlock).forEach(blockRegistryObject -> this.stackableHalf((Block)blockRegistryObject.get(), ((Block)blockRegistryObject.get()).m_5456_()));
        this.ore(BlockRegistry.JADE_ORE, ItemRegistry.JADE);
        this.ore(BlockRegistry.DEEPSLATE_JADE_ORE, ItemRegistry.JADE);
        this.ore(BlockRegistry.HEMATITE_ORE, ItemRegistry.RAW_HEMATITE);
        this.ore(BlockRegistry.DEEPSLATE_HEMATITE_ORE, ItemRegistry.RAW_HEMATITE);
        this.abundantOre(BlockRegistry.MAGNESITE_ORE, ItemRegistry.MAGNESITE);
        this.abundantOre(BlockRegistry.DEEPSLATE_MAGNESITE_ORE, ItemRegistry.MAGNESITE);
        this.ore(BlockRegistry.NETHER_COBALT_ORE, ItemRegistry.RAW_COBALT);
        this.porcelainWithShards(BlockRegistry.BLUE_AND_WHITE_PORCELAIN_VASE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelainWithShards(BlockRegistry.LARGE_BLUE_AND_WHITE_PORCELAIN_VASE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelainWithShards(BlockRegistry.SHORT_BLUE_AND_WHITE_PORCELAIN_POT, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelainWithShards(BlockRegistry.TALL_BLUE_AND_WHITE_PORCELAIN_POT, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelainWithShards(BlockRegistry.BLUE_AND_WHITE_PORCELAIN_BOWL, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelain(BlockRegistry.PORCELAIN_TEAPOT, ItemRegistry.PORCELAIN_PIECE);
        this.porcelainWithShards(BlockRegistry.BLUE_AND_WHITE_PORCELAIN_FLOWERPOT, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelain(BlockRegistry.BLUE_PORCELAIN_FLOWERPOT, ItemRegistry.PORCELAIN_PIECE);
        this.porcelainWithShards(BlockRegistry.WINE_POT, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelainPlateWithShards(BlockRegistry.PLATED_MOONCAKES, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.porcelainPlate(BlockRegistry.PLATED_MUNG_BEAN_CAKES, ItemRegistry.PORCELAIN_PIECE);
        this.plateDrop(BlockRegistry.PLATED_HAM);
        this.plateDrop(BlockRegistry.PLATED_FISH);
        this.plateDrop(BlockRegistry.SCATTERED_CARROTS);
        this.plateDrop(BlockRegistry.XIAOLONGBAO);
        this.porcelain(BlockRegistry.SMALL_WHITE_PORCELAIN_VASE_BONSAI, ItemRegistry.PORCELAIN_PIECE);
        this.porcelain(BlockRegistry.MEDIUM_WHITE_PORCELAIN_VASE_BONSAI, ItemRegistry.PORCELAIN_PIECE);
        this.porcelain(BlockRegistry.LARGE_WHITE_PORCELAIN_VASE_BONSAI, ItemRegistry.PORCELAIN_PIECE);
        this.porcelain(BlockRegistry.SMALL_GREEN_PORCELAIN_VASE_BONSAI, ItemRegistry.PORCELAIN_PIECE);
        this.porcelain(BlockRegistry.GREEN_PORCELAIN_VASE_BONSAI, ItemRegistry.PORCELAIN_PIECE);
        this.porcelain(BlockRegistry.TALL_BLUE_VASE_BONSAI, ItemRegistry.PORCELAIN_PIECE);
        this.porcelainWithShards(BlockRegistry.TALL_BLUE_AND_WHITE_PORCELAIN_BONSAI, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE, ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS);
        this.addLootTable((Block)BlockRegistry.PAINTING_SCROLL.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().name("painting_scroll").m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.PAINTING_SCROLL.get())).m_79080_(HAS_SHEARS.m_81807_())).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42415_).m_142719_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.LONG_HANGING_PAINTING.get()))).m_142719_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.WHITE_LANDSCAPE_PAINTING.get()))).m_142719_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.HORIZONTAL_OLD_LANDSCAPE_PAINTING.get()))).m_142719_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.HORIZONTAL_CALLIGRAPHY.get()))).m_142719_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.HORIZONTAL_LANDSCAPE_PAINTING.get()))).m_142719_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.LONG_YELLOW_HANGING_PAINTING.get()))).m_142719_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.PORTRAIT.get()))).m_142719_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.HANGING_PAINTING_FAN.get()))).m_142719_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ItemRegistry.SINCERE_CALLIGRAPHY.get())))))));
    }

    void simple(RegistryObject<? extends Block> block) {
        this.addLootTable((Block)block.get(), this.createSimpleTable(block.getId().m_135815_(), (ItemLike)block.get()));
    }

    void ore(RegistryObject<? extends Block> block, RegistryObject<? extends Item> item) {
        this.addLootTable((Block)block.get(), this.createOreDrop(block.getId().m_135815_(), (Block)block.get(), (Item)item.get()));
    }

    void abundantOre(RegistryObject<? extends Block> block, RegistryObject<? extends Item> item) {
        this.addLootTable((Block)block.get(), this.createAbundantOreDrop(block.getId().m_135815_(), (Block)block.get(), (Item)item.get(), 1.0f, 3.0f));
    }

    void porcelain(RegistryObject<? extends Block> block, RegistryObject<? extends Item> piece) {
        this.addLootTable((Block)block.get(), ModBlockLootProvider.createPorcelainDrop(block.getId().m_135815_(), (ItemLike)block.get(), (ItemLike)piece.get()));
    }

    void porcelainWithShards(RegistryObject<? extends Block> block, RegistryObject<? extends Item> piece, RegistryObject<? extends Item> shards) {
        this.addLootTable((Block)block.get(), ModBlockLootProvider.createPorcelainDropWithShard(block.getId().m_135815_(), (ItemLike)block.get(), (ItemLike)piece.get(), (ItemLike)shards.get()));
    }

    void porcelainPlate(RegistryObject<? extends Block> block, RegistryObject<? extends Item> piece) {
        Object object = block.get();
        if (object instanceof ConsumableDecorativeBlock) {
            ConsumableDecorativeBlock consumable = (ConsumableDecorativeBlock)object;
            this.addLootTable((Block)block.get(), ModBlockLootProvider.createPorcelainDrop(block.getId().m_135815_(), (ItemLike)consumable.getPlate().m_41720_(), (ItemLike)piece.get()));
        } else {
            LOGGER.warn("Porcelain plate loot table was not added for block " + ((Block)block.get()).m_7705_());
        }
    }

    void porcelainPlateWithShards(RegistryObject<? extends Block> block, RegistryObject<? extends Item> piece, RegistryObject<? extends Item> shards) {
        Object object = block.get();
        if (object instanceof ConsumableDecorativeBlock) {
            ConsumableDecorativeBlock consumable = (ConsumableDecorativeBlock)object;
            this.addLootTable((Block)block.get(), ModBlockLootProvider.createPorcelainDropWithShard(block.getId().m_135815_(), (ItemLike)consumable.getPlate().m_41720_(), (ItemLike)piece.get(), (ItemLike)shards.get()));
        } else {
            LOGGER.warn("Porcelain plate loot table was not added for block " + ((Block)block.get()).m_7705_());
        }
    }

    void slab(Block block, Item item) {
        if (block instanceof SlabBlock) {
            SlabBlock slab = (SlabBlock)block;
            this.addLootTable(block, this.createSlabDrop(ModBlockLootProvider.name(block), slab, item));
        } else {
            LOGGER.warn("Slab loot table was not added for block " + block.m_7705_());
        }
    }

    void stackableHalf(Block block, Item item) {
        if (block instanceof StackableHalfBlock) {
            StackableHalfBlock stackable = (StackableHalfBlock)block;
            this.addLootTable(block, this.createStackableHalfDrop(ModBlockLootProvider.name(block), stackable, item));
        } else {
            LOGGER.warn("Stackable loot table was not added for block " + block.m_7705_());
        }
    }

    void plateDrop(RegistryObject<? extends Block> block) {
        Object object = block.get();
        if (object instanceof ConsumableDecorativeBlock) {
            ConsumableDecorativeBlock consumable = (ConsumableDecorativeBlock)object;
            this.addLootTable((Block)block.get(), this.createSimpleTable(block.getId().m_135815_(), (ItemLike)consumable.getPlate().m_41720_()));
        } else {
            LOGGER.warn("Plate drop loot table was not added for block " + ((Block)block.get()).m_7705_());
        }
    }

    protected LootTable.Builder createSimpleTable(String name, ItemLike block) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSingleItemTable(String name, Block block, Item drops) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)drops));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createSlabDrop(String name, SlabBlock block, Item item) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_79076_(LootItem.m_79579_((ItemLike)item).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.TOP)))).m_79076_(LootItem.m_79579_((ItemLike)item).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.BOTTOM)))).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createStackableHalfDrop(String name, StackableHalfBlock block, Item item) {
        LootPool.Builder builder = LootPool.m_79043_().name(name).m_79076_(LootItem.m_79579_((ItemLike)item).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(ModBlockStateProperties.STACKABLE_BLOCK_TYPE, (Comparable)((Object)StackableBlockType.SINGLE))))).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)item).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(ModBlockStateProperties.STACKABLE_BLOCK_TYPE, (Comparable)((Object)StackableBlockType.DOUBLE))))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createAbundantOreDrop(String name, Block block, Item drop, float min, float max) {
        return ModBlockLootProvider.createSilkTouchDispatchTable(block, name, (LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)drop).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))));
    }

    protected LootTable.Builder createOreDrop(String name, Block block, Item drop) {
        return ModBlockLootProvider.createSilkTouchDispatchTable(block, name, (LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)block, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)drop).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_))));
    }

    protected static LootTable.Builder createPorcelainDropWithShard(String name, ItemLike block, ItemLike piece, ItemLike shard) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79080_(HAS_SILK_TOUCH)).m_7170_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)piece).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.01f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)2))).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)shard).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.5f))))));
    }

    protected static LootTable.Builder createPorcelainDrop(String name, ItemLike block, ItemLike piece) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79080_(HAS_SILK_TOUCH)).m_7170_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)piece).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.2f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)2)))));
    }

    protected static LootTable.Builder createSelfDropDispatchTable(Block pBlock, String name, LootItemCondition.Builder pConditionBuilder, LootPoolEntryContainer.Builder<?> pAlternativeEntryBuilder) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().name(name).m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)pBlock).m_79080_(pConditionBuilder)).m_7170_(pAlternativeEntryBuilder)));
    }

    protected static LootTable.Builder createSilkTouchDispatchTable(Block pBlock, String name, LootPoolEntryContainer.Builder<?> pAlternativeEntryBuilder) {
        return ModBlockLootProvider.createSelfDropDispatchTable(pBlock, name, HAS_SILK_TOUCH, pAlternativeEntryBuilder);
    }

    void addLootTable(Block block, LootTable.Builder builder) {
        if (this.lootTables.containsKey(block)) {
            LOGGER.warn("Added duplicate loot table for block " + block.m_7705_());
        }
        this.lootTables.put(block, builder);
        this.m_247577_(block, builder);
    }

    private static String name(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_();
    }

    protected Iterable<Block> getKnownBlocks() {
        return BlockRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
    }

    static {
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> {
            Block block = (Block)blockRegistryObject.get();
            for (Class<? extends Block> clazz : NON_SIMPLE_BLOCK_CLASSES) {
                if (!clazz.isInstance(block)) continue;
                return true;
            }
            if (block instanceof BaseBlockPropertyHolder) {
                BaseBlockPropertyHolder baseBlock = (BaseBlockPropertyHolder)block;
                return baseBlock.getProperty().getMaterial() == BaseBlockProperty.BlockMaterial.PORCELAIN;
            }
            return false;
        }).forEach(NON_SIMPLE_BLOCKS::add);
        NON_SIMPLE_BLOCKS.addAll(List.of(BlockRegistry.PAINTING_SCROLL));
    }
}

