/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.datagen;

import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import com.voxelutopia.ultramarine.world.block.Censer;
import com.voxelutopia.ultramarine.world.block.CentralAxialBlock;
import com.voxelutopia.ultramarine.world.block.ConsumableDecorativeBlock;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import com.voxelutopia.ultramarine.world.block.HangingLantern;
import com.voxelutopia.ultramarine.world.block.Icicle;
import com.voxelutopia.ultramarine.world.block.LongTableBlock;
import com.voxelutopia.ultramarine.world.block.OpeningBlock;
import com.voxelutopia.ultramarine.world.block.OrientableSixSideBlock;
import com.voxelutopia.ultramarine.world.block.OrientableWallSideBlock;
import com.voxelutopia.ultramarine.world.block.Rafter;
import com.voxelutopia.ultramarine.world.block.RafterEnd;
import com.voxelutopia.ultramarine.world.block.RailingBlock;
import com.voxelutopia.ultramarine.world.block.RailingSlant;
import com.voxelutopia.ultramarine.world.block.RoofMainRidgeConnection;
import com.voxelutopia.ultramarine.world.block.RoofRidge;
import com.voxelutopia.ultramarine.world.block.RoofRidgeConnection;
import com.voxelutopia.ultramarine.world.block.RoofTiles;
import com.voxelutopia.ultramarine.world.block.SideAxialBlock;
import com.voxelutopia.ultramarine.world.block.SideBlock;
import com.voxelutopia.ultramarine.world.block.SixSideBlock;
import com.voxelutopia.ultramarine.world.block.SnowRoofRidge;
import com.voxelutopia.ultramarine.world.block.StackableHalfBlock;
import com.voxelutopia.ultramarine.world.block.WallSideBlock;
import com.voxelutopia.ultramarine.world.block.state.ChiralBlockType;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import com.voxelutopia.ultramarine.world.block.state.OrientableBlockType;
import com.voxelutopia.ultramarine.world.block.state.StackableBlockType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class ModBlockModelProvider
extends BlockStateProvider {
    public static final String BLOCK = "block/";
    private final Map<Pair<Direction, Direction>, Integer> rotations = Map.of(Pair.of((Object)Direction.NORTH, (Object)Direction.EAST), 0, Pair.of((Object)Direction.EAST, (Object)Direction.NORTH), 0, Pair.of((Object)Direction.EAST, (Object)Direction.SOUTH), 90, Pair.of((Object)Direction.SOUTH, (Object)Direction.EAST), 90, Pair.of((Object)Direction.SOUTH, (Object)Direction.WEST), 180, Pair.of((Object)Direction.WEST, (Object)Direction.SOUTH), 180, Pair.of((Object)Direction.WEST, (Object)Direction.NORTH), 270, Pair.of((Object)Direction.NORTH, (Object)Direction.WEST), 270);
    private final Map<RegistryObject<Block>, Integer> ROTATED_DECO = Map.of(BlockRegistry.CARRIAGE, 90, BlockRegistry.WOODEN_POLES, 90, BlockRegistry.GOLDEN_GLAZED_ROOF_CHARM, -90, BlockRegistry.GREEN_GLAZED_ROOF_CHARM, -90, BlockRegistry.DARK_PRISMARINE_CHIWEI, -90);
    private final List<RegistryObject<Block>> SKIP_DECO = List.of(BlockRegistry.BRICK_KILN, BlockRegistry.CHISEL_TABLE);

    public ModBlockModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "ultramarine", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.simpleBlock((Block)BlockRegistry.CYAN_BRICKS.get());
        this.slabAndStairs((Block)BlockRegistry.CYAN_BRICKS.get(), (Block)BlockRegistry.CYAN_BRICK_SLAB.get(), (Block)BlockRegistry.CYAN_BRICK_STAIRS.get());
        this.wall((Block)BlockRegistry.CYAN_BRICKS.get(), (Block)BlockRegistry.CYAN_BRICK_WALL.get());
        this.simpleBlock((Block)BlockRegistry.BLACK_BRICKS.get());
        this.slabAndStairs((Block)BlockRegistry.BLACK_BRICKS.get(), (Block)BlockRegistry.BLACK_BRICK_SLAB.get(), (Block)BlockRegistry.BLACK_BRICK_STAIRS.get());
        this.wall((Block)BlockRegistry.BLACK_BRICKS.get(), (Block)BlockRegistry.BLACK_BRICK_WALL.get());
        this.simpleBlock((Block)BlockRegistry.BROWNISH_RED_STONE_BRICKS.get());
        this.slabAndStairs((Block)BlockRegistry.BROWNISH_RED_STONE_BRICKS.get(), (Block)BlockRegistry.BROWNISH_RED_STONE_BRICK_SLAB.get(), (Block)BlockRegistry.BROWNISH_RED_STONE_BRICK_STAIRS.get());
        this.wall((Block)BlockRegistry.BROWNISH_RED_STONE_BRICKS.get(), (Block)BlockRegistry.BROWNISH_RED_STONE_BRICK_WALL.get());
        this.simpleBlock((Block)BlockRegistry.WHITE_AND_PINK_MIXED_BRICKS.get());
        this.slabAndStairs((Block)BlockRegistry.WHITE_AND_PINK_MIXED_BRICKS.get(), (Block)BlockRegistry.WHITE_AND_PINK_MIXED_BRICK_SLAB.get(), (Block)BlockRegistry.WHITE_AND_PINK_MIXED_BRICK_STAIRS.get());
        this.wall((Block)BlockRegistry.WHITE_AND_PINK_MIXED_BRICKS.get(), (Block)BlockRegistry.WHITE_AND_PINK_MIXED_BRICK_WALL.get());
        this.simpleBlock((Block)BlockRegistry.GREEN_WEATHERED_BRICKS.get());
        this.slabAndStairs((Block)BlockRegistry.GREEN_WEATHERED_BRICKS.get(), (Block)BlockRegistry.GREEN_WEATHERED_BRICK_SLAB.get(), (Block)BlockRegistry.GREEN_WEATHERED_BRICK_STAIRS.get());
        this.wall((Block)BlockRegistry.GREEN_WEATHERED_BRICKS.get(), (Block)BlockRegistry.GREEN_WEATHERED_BRICK_WALL.get());
        this.simpleBlock((Block)BlockRegistry.PALE_YELLOW_STONE.get());
        this.slabAndStairs((Block)BlockRegistry.PALE_YELLOW_STONE.get(), (Block)BlockRegistry.PALE_YELLOW_STONE_SLAB.get(), (Block)BlockRegistry.PALE_YELLOW_STONE_STAIRS.get());
        this.simpleBlock((Block)BlockRegistry.VARIEGATED_ROCKS.get());
        this.slabAndStairs((Block)BlockRegistry.VARIEGATED_ROCKS.get(), (Block)BlockRegistry.VARIEGATED_ROCK_SLAB.get(), (Block)BlockRegistry.VARIEGATED_ROCK_STAIRS.get());
        this.simpleBlock((Block)BlockRegistry.WEATHERED_STONE.get());
        this.slabAndStairs((Block)BlockRegistry.WEATHERED_STONE.get(), (Block)BlockRegistry.WEATHERED_STONE_SLAB.get(), (Block)BlockRegistry.WEATHERED_STONE_STAIRS.get());
        this.simpleBlock((Block)BlockRegistry.POLISHED_WEATHERED_STONE.get());
        this.slabAndStairs((Block)BlockRegistry.POLISHED_WEATHERED_STONE.get(), (Block)BlockRegistry.POLISHED_WEATHERED_STONE_SLAB.get(), (Block)BlockRegistry.POLISHED_WEATHERED_STONE_STAIRS.get());
        this.wall((Block)BlockRegistry.POLISHED_WEATHERED_STONE.get(), (Block)BlockRegistry.POLISHED_WEATHERED_STONE_WALL.get());
        this.simpleBlock((Block)BlockRegistry.GREEN_WEATHERED_STONE.get());
        this.simpleBlock((Block)BlockRegistry.LIGHT_CYAN_FLOOR_TILE.get());
        this.slabAndStairs((Block)BlockRegistry.LIGHT_CYAN_FLOOR_TILE.get(), (Block)BlockRegistry.LIGHT_CYAN_FLOOR_TILE_SLAB.get(), (Block)BlockRegistry.LIGHT_CYAN_FLOOR_TILE_STAIRS.get());
        this.wall((Block)BlockRegistry.LIGHT_CYAN_FLOOR_TILE.get(), (Block)BlockRegistry.LIGHT_CYAN_FLOOR_TILE_WALL.get());
        this.simpleBlock((Block)BlockRegistry.CYAN_FLOOR_TILE.get());
        this.slabAndStairs((Block)BlockRegistry.CYAN_FLOOR_TILE.get(), (Block)BlockRegistry.CYAN_FLOOR_TILE_SLAB.get(), (Block)BlockRegistry.CYAN_FLOOR_TILE_STAIRS.get());
        this.wall((Block)BlockRegistry.CYAN_FLOOR_TILE.get(), (Block)BlockRegistry.CYAN_FLOOR_TILE_WALL.get());
        this.simpleBlock((Block)BlockRegistry.DARK_CYAN_FLOOR_TILE.get());
        this.slabAndStairs((Block)BlockRegistry.DARK_CYAN_FLOOR_TILE.get(), (Block)BlockRegistry.DARK_CYAN_FLOOR_TILE_SLAB.get(), (Block)BlockRegistry.DARK_CYAN_FLOOR_TILE_STAIRS.get());
        this.wall((Block)BlockRegistry.DARK_CYAN_FLOOR_TILE.get(), (Block)BlockRegistry.DARK_CYAN_FLOOR_TILE_WALL.get());
        this.horizontalBlock((Block)BlockRegistry.LAYERED_CYAN_FLOOR_TILES.get(), (ModelFile)this.models().cubeAll(ModBlockModelProvider.name((Block)BlockRegistry.LAYERED_CYAN_FLOOR_TILES.get()), this.modBlockLoc((Block)BlockRegistry.LAYERED_CYAN_FLOOR_TILES.get())));
        this.horizontalBlock((Block)BlockRegistry.VERTICAL_CYAN_FLOOR_TILES.get(), (ModelFile)this.models().cubeAll(ModBlockModelProvider.name((Block)BlockRegistry.VERTICAL_CYAN_FLOOR_TILES.get()), this.modBlockLoc((Block)BlockRegistry.VERTICAL_CYAN_FLOOR_TILES.get())));
        this.horizontalBlock((Block)BlockRegistry.MIXED_CYAN_FLOOR_TILES.get(), (ModelFile)this.models().cubeAll(ModBlockModelProvider.name((Block)BlockRegistry.MIXED_CYAN_FLOOR_TILES.get()), this.modBlockLoc((Block)BlockRegistry.MIXED_CYAN_FLOOR_TILES.get())));
        this.simpleBlock((Block)BlockRegistry.CHISELED_CYAN_FLOOR_TILE.get());
        this.simpleBlock((Block)BlockRegistry.CUT_CYAN_FLOOR_TILES.get());
        this.simpleBlock((Block)BlockRegistry.WEATHERED_RED_STONE_TILE.get());
        this.slabAndStairs((Block)BlockRegistry.WEATHERED_RED_STONE_TILE.get(), (Block)BlockRegistry.WEATHERED_RED_STONE_TILE_SLAB.get(), (Block)BlockRegistry.WEATHERED_RED_STONE_TILE_STAIRS.get());
        this.wall((Block)BlockRegistry.WEATHERED_RED_STONE_TILE.get(), (Block)BlockRegistry.WEATHERED_RED_STONE_TILE_WALL.get());
        this.simpleBlock((Block)BlockRegistry.BLUE_AND_BLACK_TILE.get());
        this.slabAndStairs((Block)BlockRegistry.BLUE_AND_BLACK_TILE.get(), (Block)BlockRegistry.BLUE_AND_BLACK_TILE_SLAB.get(), (Block)BlockRegistry.BLUE_AND_BLACK_TILE_STAIRS.get());
        this.wall((Block)BlockRegistry.BLUE_AND_BLACK_TILE.get(), (Block)BlockRegistry.BLUE_AND_BLACK_TILE_WALL.get());
        this.simpleBlock((Block)BlockRegistry.GREEN_GLAZED_TILES.get());
        this.slabAndStairs((Block)BlockRegistry.GREEN_GLAZED_TILES.get(), (Block)BlockRegistry.GREEN_GLAZED_TILE_SLAB.get(), (Block)BlockRegistry.GREEN_GLAZED_TILE_STAIRS.get());
        this.simpleBlock((Block)BlockRegistry.BLACK_FLOOR_TILES.get(), (ModelFile)this.models().cubeAll(ModBlockModelProvider.name((Block)BlockRegistry.BLACK_FLOOR_TILES.get()), this.modBlockLoc((Block)BlockRegistry.BLACK_FLOOR_TILES.get())));
        this.horizontalBlock((Block)BlockRegistry.BLACK_FLOOR_TILES_LITTLE_MOSSY.get(), (ModelFile)((BlockModelBuilder)this.models().cube(ModBlockModelProvider.name((Block)BlockRegistry.BLACK_FLOOR_TILES_LITTLE_MOSSY.get()), this.modLoc("block/black_floor_tiles_little_moss_down"), this.modLoc("block/black_floor_tiles_little_moss_down"), this.modLoc("block/black_floor_tiles_little_moss_up"), this.modLoc("block/black_floor_tiles_little_moss_up"), this.modLoc("block/black_floor_tiles"), this.modLoc("block/black_floor_tiles"))).texture("particle", this.modLoc("block/black_floor_tiles")), 0);
        this.horizontalBlock((Block)BlockRegistry.BLACK_FLOOR_TILES_MODERATE_MOSSY.get(), (ModelFile)((BlockModelBuilder)this.models().cube(ModBlockModelProvider.name((Block)BlockRegistry.BLACK_FLOOR_TILES_MODERATE_MOSSY.get()), this.modLoc("block/black_floor_tiles_moderate_moss_right"), this.modLoc("block/black_floor_tiles_moderate_moss_right"), this.modLoc("block/black_floor_tiles"), this.modLoc("block/black_floor_tiles"), this.modLoc("block/black_floor_tiles_moderate_moss_up"), this.modLoc("block/black_floor_tiles_moderate_moss_up"))).texture("particle", this.modLoc("block/black_floor_tiles")), 0);
        this.horizontalBlock((Block)BlockRegistry.BLACK_FLOOR_TILES_VERY_MOSSY.get(), (ModelFile)((BlockModelBuilder)this.models().cube(ModBlockModelProvider.name((Block)BlockRegistry.BLACK_FLOOR_TILES_VERY_MOSSY.get()), this.modLoc("block/black_floor_tiles_big_moss_top_right"), this.modLoc("block/black_floor_tiles_big_moss_bottom_right"), this.modLoc("block/black_floor_tiles_big_moss_top_right"), this.modLoc("block/black_floor_tiles_big_moss_top_right"), this.modLoc("block/black_floor_tiles_big_moss_top_right"), this.modLoc("block/black_floor_tiles_big_moss_top_left"))).texture("particle", this.modLoc("block/black_floor_tiles")), 0);
        this.simpleBlock((Block)BlockRegistry.ROSEWOOD_PLANKS.get());
        this.slabAndStairs((Block)BlockRegistry.ROSEWOOD_PLANKS.get(), (Block)BlockRegistry.ROSEWOOD_SLAB.get(), (Block)BlockRegistry.ROSEWOOD_STAIRS.get());
        this.fence((Block)BlockRegistry.ROSEWOOD_PLANKS.get(), (Block)BlockRegistry.ROSEWOOD_FENCE.get());
        this.simpleBlock((Block)BlockRegistry.VARNISHED_ROSEWOOD.get());
        this.simpleBlock((Block)BlockRegistry.BAMBOO_MAT.get());
        this.slabAndStairs((Block)BlockRegistry.BAMBOO_MAT.get(), (Block)BlockRegistry.BAMBOO_MAT_SLAB.get(), (Block)BlockRegistry.BAMBOO_MAT_STAIRS.get());
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> blockRegistryObject.get() instanceof RoofTiles).forEach(tile -> this.roofTiles((Block)tile.get()));
        this.roofRidgeSideBottomTop((Block)BlockRegistry.BLACK_ROOF_RIDGE_UPPER.get(), this.sideLoc((Block)BlockRegistry.BLACK_ROOF_RIDGE_UPPER.get()), this.bottomLoc((Block)BlockRegistry.BLACK_ROOF_RIDGE_UPPER.get()), this.topLoc((Block)BlockRegistry.BLACK_ROOF_RIDGE_UPPER.get()));
        this.roofRidgeSideBottomTop((Block)BlockRegistry.BLACK_ROOF_RIDGE_LOWER.get(), this.sideLoc((Block)BlockRegistry.BLACK_ROOF_RIDGE_LOWER.get()), this.bottomLoc((Block)BlockRegistry.BLACK_ROOF_RIDGE_UPPER.get()), this.bottomLoc((Block)BlockRegistry.BLACK_ROOF_RIDGE_UPPER.get()));
        this.roofRidgeFrontSideBottomTop((Block)BlockRegistry.BLACK_ROOF_RIDGE_CONNECTION.get(), this.frontLoc((Block)BlockRegistry.BLACK_ROOF_RIDGE_CONNECTION.get()), this.sideLoc((Block)BlockRegistry.BLACK_ROOF_RIDGE_CONNECTION.get()), this.bottomLoc((Block)BlockRegistry.BLACK_ROOF_RIDGE_UPPER.get()), this.topLoc((Block)BlockRegistry.BLACK_ROOF_RIDGE_UPPER.get()));
        this.roofHorizontalRidgeFrontSideBottomTop((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_CONNECTION.get(), this.frontLoc((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_CONNECTION.get()), this.sideLoc((Block)BlockRegistry.BLACK_ROOF_RIDGE_CONNECTION.get()), this.frontLoc((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_CONNECTION.get()), this.topLoc((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_CONNECTION.get()));
        this.slabSideBottomTopNoFull((Block)BlockRegistry.BLACK_ROOF_RIDGE_UPPER_SLAB.get(), this.sideLoc((Block)BlockRegistry.BLACK_ROOF_RIDGE_UPPER_SLAB.get()), this.bottomLoc((Block)BlockRegistry.BLACK_ROOF_RIDGE_UPPER.get()), this.topLoc((Block)BlockRegistry.BLACK_ROOF_RIDGE_UPPER.get()));
        this.directionalSlabFrontSideBottomTopNoFull((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_SLAB.get(), this.frontLoc((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_SLAB.get()), this.sideLoc((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_SLAB.get()), this.bottomLoc((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_SLAB.get()), this.topLoc((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_SLAB.get()));
        this.roofRidgePanel((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_PANEL.get(), this.frontLoc((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_SLAB.get()), this.sideLoc((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_SLAB.get()), this.bottomLoc((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_SLAB.get()), this.topLoc((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_SLAB.get()));
        this.roofRidgePlate((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_PLATE.get(), this.frontLoc((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_SLAB.get()), this.sideLoc((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_SLAB.get()), this.bottomLoc((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_SLAB.get()), this.topLoc((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_SLAB.get()));
        this.straightStairs((Block)BlockRegistry.BLACK_MAIN_ROOF_RIDGE_STAIRS.get());
        this.roofRidgeSideBottomTop((Block)BlockRegistry.YELLOW_ROOF_RIDGE_UPPER.get(), this.sideLoc((Block)BlockRegistry.YELLOW_ROOF_RIDGE_UPPER.get()), this.bottomLoc((Block)BlockRegistry.YELLOW_ROOF_RIDGE_UPPER.get()), this.topLoc((Block)BlockRegistry.YELLOW_ROOF_RIDGE_UPPER.get()));
        this.roofRidgeSideBottomTop((Block)BlockRegistry.YELLOW_ROOF_RIDGE_LOWER.get(), this.sideLoc((Block)BlockRegistry.YELLOW_ROOF_RIDGE_LOWER.get()), this.bottomLoc((Block)BlockRegistry.YELLOW_ROOF_RIDGE_UPPER.get()), this.bottomLoc((Block)BlockRegistry.YELLOW_ROOF_RIDGE_UPPER.get()));
        this.roofRidgeFrontSideBottomTop((Block)BlockRegistry.YELLOW_ROOF_RIDGE_CONNECTION.get(), this.frontLoc((Block)BlockRegistry.YELLOW_ROOF_RIDGE_CONNECTION.get()), this.sideLoc((Block)BlockRegistry.YELLOW_ROOF_RIDGE_CONNECTION.get()), this.bottomLoc((Block)BlockRegistry.YELLOW_ROOF_RIDGE_UPPER.get()), this.topLoc((Block)BlockRegistry.YELLOW_ROOF_RIDGE_UPPER.get()));
        this.roofHorizontalRidgeFrontSideBottomTop((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_CONNECTION.get(), this.frontLoc((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_CONNECTION.get()), this.sideLoc((Block)BlockRegistry.YELLOW_ROOF_RIDGE_CONNECTION.get()), this.frontLoc((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_CONNECTION.get()), this.topLoc((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_CONNECTION.get()));
        this.slabSideBottomTopNoFull((Block)BlockRegistry.YELLOW_ROOF_RIDGE_UPPER_SLAB.get(), this.sideLoc((Block)BlockRegistry.YELLOW_ROOF_RIDGE_UPPER_SLAB.get()), this.bottomLoc((Block)BlockRegistry.YELLOW_ROOF_RIDGE_UPPER.get()), this.topLoc((Block)BlockRegistry.YELLOW_ROOF_RIDGE_UPPER.get()));
        this.directionalSlabFrontSideBottomTopNoFull((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_SLAB.get(), this.frontLoc((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_SLAB.get()), this.sideLoc((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_SLAB.get()), this.bottomLoc((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_SLAB.get()), this.topLoc((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_SLAB.get()));
        this.roofRidgePanel((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_PANEL.get(), this.frontLoc((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_SLAB.get()), this.sideLoc((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_SLAB.get()), this.bottomLoc((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_SLAB.get()), this.topLoc((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_SLAB.get()));
        this.roofRidgePlate((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_PLATE.get(), this.frontLoc((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_SLAB.get()), this.sideLoc((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_SLAB.get()), this.bottomLoc((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_SLAB.get()), this.topLoc((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_SLAB.get()));
        this.straightStairs((Block)BlockRegistry.YELLOW_MAIN_ROOF_RIDGE_STAIRS.get());
        this.woodenBracket((Block)BlockRegistry.OAK_BRACKET.get(), this.mcLoc("block/stripped_oak_log"));
        this.woodenBracket((Block)BlockRegistry.SPRUCE_BRACKET.get(), this.mcLoc("block/stripped_spruce_log"));
        this.woodenBracket((Block)BlockRegistry.BIRCH_BRACKET.get(), this.mcLoc("block/stripped_birch_log"));
        this.woodenBracket((Block)BlockRegistry.JUNGLE_BRACKET.get(), this.mcLoc("block/stripped_jungle_log"));
        this.woodenBracket((Block)BlockRegistry.ACACIA_BRACKET.get(), this.mcLoc("block/stripped_acacia_log"));
        this.woodenBracket((Block)BlockRegistry.DARK_OAK_BRACKET.get(), this.mcLoc("block/stripped_dark_oak_log"));
        this.woodenBracket((Block)BlockRegistry.CRIMSON_BRACKET.get(), this.mcLoc("block/stripped_crimson_stem"));
        this.woodenBracket((Block)BlockRegistry.WARPED_BRACKET.get(), this.mcLoc("block/stripped_warped_stem"));
        this.woodenBracket((Block)BlockRegistry.MANGROVE_BRACKET.get(), this.mcLoc("block/stripped_mangrove_log"));
        this.woodenBracket((Block)BlockRegistry.CHERRY_BRACKET.get(), this.mcLoc("block/stripped_cherry_log"));
        this.woodenBracket((Block)BlockRegistry.VARNISHED_ROSEWOOD_BRACKET.get(), this.modLoc("block/varnished_rosewood"));
        this.simpleBlock((Block)BlockRegistry.RED_CARVED_WOOD.get());
        this.carvedWoodenSlab((Block)BlockRegistry.RED_CARVED_WOODEN_SLAB.get(), (Block)BlockRegistry.RED_CARVED_WOOD.get());
        this.straightStairs((Block)BlockRegistry.RED_CARVED_WOODEN_STAIRS.get());
        this.simpleBlock((Block)BlockRegistry.BLUE_CARVED_WOOD.get());
        this.carvedWoodenSlab((Block)BlockRegistry.BLUE_CARVED_WOODEN_SLAB.get(), (Block)BlockRegistry.BLUE_CARVED_WOOD.get());
        this.straightStairs((Block)BlockRegistry.BLUE_CARVED_WOODEN_STAIRS.get());
        this.straightStairs((Block)BlockRegistry.BLUE_CARVED_WOODEN_BRACKET_STAIRS.get());
        this.horizontalBlockNoOffset((Block)BlockRegistry.BLUE_CARVED_WOODEN_BRACKET.get());
        this.simpleBlock((Block)BlockRegistry.CYAN_CARVED_WOOD.get());
        this.carvedWoodenSlab((Block)BlockRegistry.CYAN_CARVED_WOODEN_SLAB.get(), (Block)BlockRegistry.CYAN_CARVED_WOOD.get());
        this.straightStairs((Block)BlockRegistry.CYAN_CARVED_WOODEN_STAIRS.get());
        this.horizontalBlockNoOffset((Block)BlockRegistry.CYAN_CARVED_WOODEN_BRACKET.get());
        this.simpleBlock((Block)BlockRegistry.GREEN_CARVED_WOOD.get());
        this.carvedWoodenSlab((Block)BlockRegistry.GREEN_CARVED_WOODEN_SLAB.get(), (Block)BlockRegistry.GREEN_CARVED_WOOD.get());
        this.straightStairs((Block)BlockRegistry.GREEN_CARVED_WOODEN_STAIRS.get());
        this.horizontalBlockNoOffset((Block)BlockRegistry.GREEN_CARVED_WOODEN_BRACKET.get());
        this.simpleBlock((Block)BlockRegistry.ORANGE_AND_BLUE_CARVED_WOOD.get());
        this.simpleBlock((Block)BlockRegistry.ORANGE_AND_GREEN_CARVED_WOOD.get());
        this.simpleBlock((Block)BlockRegistry.GREEN_AND_BLUE_CARVED_WOOD.get());
        this.simpleBlock((Block)BlockRegistry.DARK_GREEN_AND_DARK_BLUE_CARVED_WOOD.get());
        this.simpleBlock((Block)BlockRegistry.DARK_BLUE_AND_DARK_GREEN_CARVED_WOOD.get());
        this.simpleBlock((Block)BlockRegistry.BLACK_WHITE_GREEN_CARVED_WOOD.get());
        this.simpleBlock((Block)BlockRegistry.BLACK_WHITE_BLUE_CARVED_WOOD.get());
        this.simpleBlock((Block)BlockRegistry.RED_AND_GREEN_CARVED_WOOD.get());
        this.simpleBlock((Block)BlockRegistry.BLUE_AND_RED_CARVED_WOOD.get());
        this.simpleBlock((Block)BlockRegistry.BLUE_WHITE_RED_CARVED_WOOD.get());
        this.simpleBlock((Block)BlockRegistry.GREEN_WHITE_RED_CARVED_WOOD.get());
        this.simpleBlock((Block)BlockRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_1.get());
        this.simpleBlock((Block)BlockRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_2.get());
        this.simpleBlock((Block)BlockRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_3.get());
        this.simpleBlock((Block)BlockRegistry.YELLOW_AND_GREEN_CARVED_WOOD.get());
        this.simpleBlock((Block)BlockRegistry.YELLOW_GREEN_BLUE_CARVED_WOOD.get());
        this.chiralWSMirror((Block)BlockRegistry.CARVED_DARK_OAK_BEAM.get(), this.mcLoc("block/dark_oak_log_top"));
        this.chiralWSMirror((Block)BlockRegistry.CARVED_DARK_OAK_BEAM_EDGE.get(), this.mcLoc("block/dark_oak_log_top"));
        this.simpleBlock((Block)BlockRegistry.GILDED_DARK_OAK.get());
        this.simpleBlock((Block)BlockRegistry.CHISELED_GILDED_DARK_OAK.get());
        this.slabSideEnd((Block)BlockRegistry.GILDED_DARK_OAK_SLAB.get(), (Block)BlockRegistry.GILDED_DARK_OAK.get(), this.sideLoc((Block)BlockRegistry.GILDED_DARK_OAK_SLAB.get()), this.blockLoc((Block)BlockRegistry.GILDED_DARK_OAK.get()));
        this.straightStairs((Block)BlockRegistry.GILDED_DARK_OAK_STAIRS.get());
        this.horizontalBlockNoOffset((Block)BlockRegistry.GILDED_DARK_OAK_BRACKET.get());
        this.simpleBlock((Block)BlockRegistry.CARVED_RED_PILLAR.get());
        this.sideBottomTop((Block)BlockRegistry.CARVED_RED_PILLAR_BASE.get());
        this.directionalSideEnd((Block)BlockRegistry.CARVED_RED_PILLAR_HEAD.get(), this.sideLoc((Block)BlockRegistry.CARVED_RED_PILLAR_HEAD.get()), this.modBlockLoc((Block)BlockRegistry.CARVED_RED_PILLAR.get()));
        this.sideBottomTop((Block)BlockRegistry.SPRUCE_PILLAR_BASE.get(), this.sideLoc((Block)BlockRegistry.SPRUCE_PILLAR_BASE.get()), this.mcLoc("block/smooth_stone"), this.mcLoc("block/spruce_log_top"));
        this.sideBottomTop((Block)BlockRegistry.STRIPPED_DARK_OAK_PILLAR_BASE.get(), this.sideLoc((Block)BlockRegistry.STRIPPED_DARK_OAK_PILLAR_BASE.get()), this.mcLoc("block/smooth_stone"), this.mcLoc("block/dark_oak_log_top"));
        this.directionalSideBottomTop((Block)BlockRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_1.get(), this.sideLoc((Block)BlockRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_1.get()), this.bottomLoc((Block)BlockRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_1.get()), this.mcLoc("block/dark_oak_log_top"));
        this.directionalSideEnd((Block)BlockRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_2.get(), this.sideLoc((Block)BlockRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_2.get()), this.endLoc((Block)BlockRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_2.get()));
        this.directionalSideEnd((Block)BlockRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_3.get(), this.sideLoc((Block)BlockRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_3.get()), this.mcLoc("block/dark_oak_log_top"));
        this.directionalSideEnd((Block)BlockRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_4.get(), this.sideLoc((Block)BlockRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_4.get()), this.endLoc((Block)BlockRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_4.get()));
        this.directionalSideBottomTop((Block)BlockRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_5.get(), this.sideLoc((Block)BlockRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_5.get()), this.bottomLoc((Block)BlockRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_5.get()), this.mcLoc("block/dark_oak_log_top"));
        this.directionalSideEnd((Block)BlockRegistry.CYAN_AND_WHITE_PILLAR_BASE.get(), this.sideLoc((Block)BlockRegistry.CYAN_AND_WHITE_PILLAR_BASE.get()), this.mcLoc("block/red_terracotta"));
        this.directionalSideEnd((Block)BlockRegistry.CYAN_AND_WHITE_DECORATED_PILLAR.get(), this.sideLoc((Block)BlockRegistry.CYAN_AND_WHITE_DECORATED_PILLAR.get()), this.mcLoc("block/red_terracotta"));
        this.directionalSideEnd((Block)BlockRegistry.CYAN_AND_WHITE_PILLAR_HEAD.get(), this.sideLoc((Block)BlockRegistry.CYAN_AND_WHITE_PILLAR_HEAD.get()), this.mcLoc("block/red_terracotta"));
        this.sideBottomTop((Block)BlockRegistry.STONE_PILLAR_BASE.get(), this.sideLoc((Block)BlockRegistry.STONE_PILLAR_BASE.get()), this.mcLoc("block/chiseled_stone_bricks"), this.mcLoc("block/chiseled_stone_bricks"));
        ResourceLocation GREEN_CARVED_FANGXIN_END = this.modLoc("block/green_carved_fangxin_end");
        ResourceLocation BLUE_WOOL = this.mcLoc("block/blue_wool");
        ResourceLocation BLUE_CONCRETE_POWDER = this.mcLoc("block/blue_concrete_powder");
        ResourceLocation GREEN_WOOL = this.mcLoc("block/green_wool");
        this.directionalSideEnd((Block)BlockRegistry.GREEN_FANGXIN.get(), this.sideLoc((Block)BlockRegistry.GREEN_FANGXIN.get()), this.endLoc((Block)BlockRegistry.GREEN_FANGXIN.get()));
        this.directionalSideEnd((Block)BlockRegistry.GREEN_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.GREEN_FANGXIN_EDGE.get()), this.endLoc((Block)BlockRegistry.GREEN_FANGXIN.get()));
        this.directionalSideEnd((Block)BlockRegistry.BLUE_FANGXIN.get(), this.sideLoc((Block)BlockRegistry.BLUE_FANGXIN.get()), GREEN_WOOL);
        this.chiralWSMirror((Block)BlockRegistry.BLUE_FANGXIN_EDGE.get(), BLUE_CONCRETE_POWDER);
        this.axisSideEnd((Block)BlockRegistry.CYAN_AND_BLUE_FANGXIN.get(), this.sideLoc((Block)BlockRegistry.CYAN_AND_BLUE_FANGXIN.get()), GREEN_CARVED_FANGXIN_END);
        this.directionalSideEnd((Block)BlockRegistry.CYAN_AND_BLUE_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.CYAN_AND_BLUE_FANGXIN_EDGE.get()), GREEN_CARVED_FANGXIN_END);
        this.directionalSideEnd((Block)BlockRegistry.CYAN_AND_BLUE_FANGXIN_EDGE_VARIANT.get(), this.sideLoc((Block)BlockRegistry.CYAN_AND_BLUE_FANGXIN_EDGE_VARIANT.get()), GREEN_CARVED_FANGXIN_END);
        this.axisSideEnd((Block)BlockRegistry.CYAN_BLUE_WHITE_FANGXIN.get(), this.sideLoc((Block)BlockRegistry.CYAN_BLUE_WHITE_FANGXIN.get()), GREEN_CARVED_FANGXIN_END);
        this.directionalSideEnd((Block)BlockRegistry.CYAN_BLUE_WHITE_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.CYAN_BLUE_WHITE_FANGXIN_EDGE.get()), GREEN_CARVED_FANGXIN_END);
        this.directionalSideEnd((Block)BlockRegistry.BLUE_AND_GREEN_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.BLUE_AND_GREEN_FANGXIN_EDGE.get()), GREEN_CARVED_FANGXIN_END);
        this.directionalSideEnd((Block)BlockRegistry.YELLOW_AND_GREEN_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.YELLOW_AND_GREEN_FANGXIN_EDGE.get()), GREEN_CARVED_FANGXIN_END);
        this.axisSideEnd((Block)BlockRegistry.DARK_BLUE_FANGXIN.get(), this.sideLoc((Block)BlockRegistry.DARK_BLUE_FANGXIN.get()), BLUE_WOOL);
        this.directionalSideEnd((Block)BlockRegistry.DARK_BLUE_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.DARK_BLUE_FANGXIN_EDGE.get()), BLUE_WOOL);
        this.axisSideEnd((Block)BlockRegistry.BLUE_AND_WHITE_FANGXIN.get(), this.sideLoc((Block)BlockRegistry.BLUE_AND_WHITE_FANGXIN.get()), GREEN_CARVED_FANGXIN_END);
        this.axisSideEnd((Block)BlockRegistry.GREEN_AND_DARK_BLUE_FANGXIN.get(), this.sideLoc((Block)BlockRegistry.GREEN_AND_DARK_BLUE_FANGXIN.get()), GREEN_CARVED_FANGXIN_END);
        this.axisSideEnd((Block)BlockRegistry.WHITE_AND_CYAN_FANGXIN.get(), this.sideLoc((Block)BlockRegistry.WHITE_AND_CYAN_FANGXIN.get()), BLUE_CONCRETE_POWDER);
        this.directionalSideEnd((Block)BlockRegistry.WHITE_AND_CYAN_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.WHITE_AND_CYAN_FANGXIN_EDGE.get()), BLUE_CONCRETE_POWDER);
        this.axisSideEnd((Block)BlockRegistry.WHITE_AND_BLUE_FANGXIN.get(), this.sideLoc((Block)BlockRegistry.WHITE_AND_BLUE_FANGXIN.get()), BLUE_CONCRETE_POWDER);
        this.directionalSideEnd((Block)BlockRegistry.WHITE_AND_BLUE_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.WHITE_AND_BLUE_FANGXIN_EDGE.get()), BLUE_CONCRETE_POWDER);
        this.chiralWSMirror((Block)BlockRegistry.RED_CYAN_BLUE_FANGXIN.get(), BLUE_CONCRETE_POWDER);
        this.directionalSideEnd((Block)BlockRegistry.RED_CYAN_BLUE_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.RED_CYAN_BLUE_FANGXIN_EDGE.get()), BLUE_CONCRETE_POWDER);
        this.directionalSideEnd((Block)BlockRegistry.BLUE_CYAN_BLUE_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.BLUE_CYAN_BLUE_FANGXIN_EDGE.get()), BLUE_CONCRETE_POWDER);
        this.chiralWSMirror((Block)BlockRegistry.BLUE_CYAN_RED_FANGXIN.get(), BLUE_CONCRETE_POWDER);
        this.directionalSideEnd((Block)BlockRegistry.BLUE_CYAN_RED_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.BLUE_CYAN_RED_FANGXIN_EDGE.get()), BLUE_CONCRETE_POWDER);
        this.chiralWSMirror((Block)BlockRegistry.CYAN_BLUE_CYAN_FANGXIN.get(), BLUE_CONCRETE_POWDER);
        this.chiralWSMirror((Block)BlockRegistry.RED_BLUE_RED_FANGXIN.get(), BLUE_CONCRETE_POWDER);
        this.directionalSideEnd((Block)BlockRegistry.CYAN_AND_YELLOW_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.CYAN_AND_YELLOW_FANGXIN_EDGE.get()), BLUE_WOOL);
        this.directionalSideEnd((Block)BlockRegistry.MING_BLUE_JINZHUOMO_SHINIANYU_XUANZI_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.MING_BLUE_JINZHUOMO_SHINIANYU_XUANZI_FANGXIN_EDGE.get()), GREEN_CARVED_FANGXIN_END);
        this.chiralWSMirror((Block)BlockRegistry.MING_BLUE_GILDED_JINZHUOMO_SHINIANYU_XUANZI_FANGXIN.get(), GREEN_CARVED_FANGXIN_END);
        this.chiralWSMirror((Block)BlockRegistry.MING_BLUE_GILDED_JINZHUOMO_SHINIANYU_XUANZI_FANGXIN_EDGE.get(), GREEN_CARVED_FANGXIN_END);
        this.chiralWSMirror((Block)BlockRegistry.MING_GREEN_GILDED_JINZHUOMO_SHINIANYU_XUANZI_FANGXIN.get(), GREEN_CARVED_FANGXIN_END);
        this.chiralWSMirror((Block)BlockRegistry.MING_GREEN_GILDED_JINZHUOMO_SHINIANYU_XUANZI_FANGXIN_EDGE.get(), GREEN_CARVED_FANGXIN_END);
        this.directionalSideEnd((Block)BlockRegistry.QING_BLUE_PLAIN_JINZHUOMO_SHINIANYU_FANGXIN.get(), this.sideLoc((Block)BlockRegistry.QING_BLUE_PLAIN_JINZHUOMO_SHINIANYU_FANGXIN.get()), GREEN_CARVED_FANGXIN_END);
        this.directionalSideEnd((Block)BlockRegistry.YUAN_NIANYUZHUANG_FANGXIN.get(), this.sideLoc((Block)BlockRegistry.YUAN_NIANYUZHUANG_FANGXIN.get()), BLUE_WOOL);
        this.directionalSideEnd((Block)BlockRegistry.YUAN_NIANYUZHUANG_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.YUAN_NIANYUZHUANG_FANGXIN_EDGE.get()), BLUE_WOOL);
        this.directionalSideEnd((Block)BlockRegistry.YUAN_PATTERNED_NIANYUZHUANG_FANGXIN.get(), this.sideLoc((Block)BlockRegistry.YUAN_PATTERNED_NIANYUZHUANG_FANGXIN.get()), BLUE_WOOL);
        this.directionalSideEnd((Block)BlockRegistry.YUAN_PATTERNED_NIANYUZHUANG_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.YUAN_PATTERNED_NIANYUZHUANG_FANGXIN_EDGE.get()), BLUE_WOOL);
        this.directionalSideEnd((Block)BlockRegistry.YUAN_GREEN_NIANYUZHUANG_FANGXIN.get(), this.sideLoc((Block)BlockRegistry.YUAN_GREEN_NIANYUZHUANG_FANGXIN.get()), BLUE_WOOL);
        this.directionalSideEnd((Block)BlockRegistry.YUAN_GREEN_NIANYUZHUANG_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.YUAN_GREEN_NIANYUZHUANG_FANGXIN_EDGE.get()), BLUE_WOOL);
        this.chiralWSMirror((Block)BlockRegistry.YUAN_PATTERNED_WUCHAIZHUANG_FANGXIN.get(), BLUE_WOOL);
        this.chiralWSMirror((Block)BlockRegistry.YUAN_PATTERNED_WUCHAIZHUANG_FANGXIN_EDGE.get(), BLUE_WOOL);
        this.directionalSideEnd((Block)BlockRegistry.YUAN_GREEN_WUCHAIZHUANG_FANGXIN.get(), this.sideLoc((Block)BlockRegistry.YUAN_GREEN_WUCHAIZHUANG_FANGXIN.get()), BLUE_WOOL);
        this.directionalSideEnd((Block)BlockRegistry.YUAN_GREEN_WUCHAIZHUANG_FANGXIN_EDGE.get(), this.sideLoc((Block)BlockRegistry.YUAN_GREEN_WUCHAIZHUANG_FANGXIN_EDGE.get()), BLUE_WOOL);
        this.directionalSideBottomTop((Block)BlockRegistry.BLUE_ZHAOTOU_EDGE.get(), this.sideLoc((Block)BlockRegistry.BLUE_ZHAOTOU_EDGE.get()), GREEN_WOOL, BLUE_WOOL);
        this.directionalSideBottomTop((Block)BlockRegistry.GREEN_AND_BLUE_ZHAOTOU.get(), this.sideLoc((Block)BlockRegistry.GREEN_AND_BLUE_ZHAOTOU.get()), GREEN_WOOL, BLUE_WOOL);
        this.directionalSideBottomTop((Block)BlockRegistry.BLUE_AND_GREEN_ZHAOTOU.get(), this.sideLoc((Block)BlockRegistry.BLUE_AND_GREEN_ZHAOTOU.get()), BLUE_WOOL, GREEN_WOOL);
        this.directionalSideEnd((Block)BlockRegistry.BLUE_AND_GREEN_DOUBLE_LAYERED_ZHAOTOU.get(), this.sideLoc((Block)BlockRegistry.BLUE_AND_GREEN_DOUBLE_LAYERED_ZHAOTOU.get()), this.endLoc((Block)BlockRegistry.BLUE_AND_GREEN_DOUBLE_LAYERED_ZHAOTOU.get()));
        this.directionalSideEnd((Block)BlockRegistry.CYAN_AND_RED_ZHAOTOU.get(), this.sideLoc((Block)BlockRegistry.CYAN_AND_RED_ZHAOTOU.get()), BLUE_CONCRETE_POWDER);
        this.directionalSideEnd((Block)BlockRegistry.CYAN_AND_BLUE_ZHAOTOU.get(), this.sideLoc((Block)BlockRegistry.CYAN_AND_BLUE_ZHAOTOU.get()), BLUE_CONCRETE_POWDER);
        this.directionalSideEnd((Block)BlockRegistry.GRAY_BLACK_RED_ZHAOTOU.get(), this.sideLoc((Block)BlockRegistry.GRAY_BLACK_RED_ZHAOTOU.get()), BLUE_WOOL);
        this.directionalSideEnd((Block)BlockRegistry.BLUE_GREEN_RED_ZHAOTOU.get(), this.sideLoc((Block)BlockRegistry.BLUE_GREEN_RED_ZHAOTOU.get()), BLUE_WOOL);
        this.directionalSideBottomTop((Block)BlockRegistry.RED_AND_BLUE_ZHAOTOU.get(), this.sideLoc((Block)BlockRegistry.RED_AND_BLUE_ZHAOTOU.get()), this.mcLoc("block/red_wool"), BLUE_WOOL);
        this.directionalSideEnd((Block)BlockRegistry.GREEN_AND_YELLOW_ZHAOTOU.get(), this.sideLoc((Block)BlockRegistry.GREEN_AND_YELLOW_ZHAOTOU.get()), GREEN_CARVED_FANGXIN_END);
        this.directionalSideEnd((Block)BlockRegistry.RED_GREEN_BLUE_ZHAOTOU.get(), this.sideLoc((Block)BlockRegistry.RED_GREEN_BLUE_ZHAOTOU.get()), GREEN_CARVED_FANGXIN_END);
        this.directionalSideEnd((Block)BlockRegistry.WHITE_BLUE_GREEN_ZHAOTOU.get(), this.sideLoc((Block)BlockRegistry.WHITE_BLUE_GREEN_ZHAOTOU.get()), this.endLoc((Block)BlockRegistry.WHITE_BLUE_GREEN_ZHAOTOU.get()));
        this.directionalSideEnd((Block)BlockRegistry.MING_YANZHUOMO_SHINIANYU_OUTER_ZHAOTOU.get(), this.sideLoc((Block)BlockRegistry.MING_YANZHUOMO_SHINIANYU_OUTER_ZHAOTOU.get()), GREEN_CARVED_FANGXIN_END);
        this.directionalSideEnd((Block)BlockRegistry.MING_YANZHUOMO_SHINIANYU_OUTER_ZHAOTOU_EDGE.get(), this.sideLoc((Block)BlockRegistry.MING_YANZHUOMO_SHINIANYU_OUTER_ZHAOTOU_EDGE.get()), GREEN_CARVED_FANGXIN_END);
        this.directionalSideEnd((Block)BlockRegistry.YUAN_NIANYUZHUANG_ZHAOTOU.get(), this.sideLoc((Block)BlockRegistry.YUAN_NIANYUZHUANG_ZHAOTOU.get()), BLUE_WOOL);
        this.directionalSideEnd((Block)BlockRegistry.YUAN_NIANYUZHUANG_ZHAOTOU_CONNECTION.get(), this.sideLoc((Block)BlockRegistry.YUAN_NIANYUZHUANG_ZHAOTOU_CONNECTION.get()), BLUE_WOOL);
        this.directionalSideBottomTop((Block)BlockRegistry.GREEN_BLUE_BLACK_GUTOU.get(), this.sideLoc((Block)BlockRegistry.GREEN_BLUE_BLACK_GUTOU.get()), this.mcLoc("block/black_wool"), this.mcLoc("block/white_wool"));
        this.directionalSideEnd((Block)BlockRegistry.BLUE_GREEN_YELLOW_GUTOU.get(), this.sideLoc((Block)BlockRegistry.BLUE_GREEN_YELLOW_GUTOU.get()), GREEN_WOOL);
        this.directionalSideEnd((Block)BlockRegistry.BLUE_AND_YELLOW_GUTOU.get(), this.sideLoc((Block)BlockRegistry.BLUE_AND_YELLOW_GUTOU.get()), GREEN_WOOL);
        this.directionalSideEnd((Block)BlockRegistry.MING_YANZHUOMO_SHINIANYU_OUTER_GUTOU_EDGE.get(), this.sideLoc((Block)BlockRegistry.MING_YANZHUOMO_SHINIANYU_OUTER_GUTOU_EDGE.get()), GREEN_WOOL);
        this.chiralWSMirror((Block)BlockRegistry.YUAN_NIANYUZHUANG_GUTOU.get(), BLUE_WOOL);
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> blockRegistryObject.get() instanceof Rafter).forEach(rafter -> this.shiftedAxisBlock((Block)rafter.get()));
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> blockRegistryObject.get() instanceof RafterEnd).forEach(rafterEnd -> this.shiftedDirectionalBlock((Block)rafterEnd.get(), 180));
        this.horizontalBlockOffset((Block)BlockRegistry.GILDED_DARK_OAK_BEAM_HEAD.get(), 180);
        this.simpleBlock((Block)BlockRegistry.RED_AND_CYAN_CARVED_ARCHITRAVE.get());
        this.slabSideEndNoFull((Block)BlockRegistry.RED_AND_CYAN_CARVED_ARCHITRAVE_SLAB.get(), this.sideLoc((Block)BlockRegistry.RED_AND_CYAN_CARVED_ARCHITRAVE_SLAB.get()), this.endLoc((Block)BlockRegistry.RED_AND_CYAN_CARVED_ARCHITRAVE_SLAB.get()));
        this.simpleBlock((Block)BlockRegistry.RED_AND_BLUE_CARVED_ARCHITRAVE.get());
        this.slabSideEndNoFull((Block)BlockRegistry.RED_AND_BLUE_CARVED_ARCHITRAVE_SLAB.get(), this.sideLoc((Block)BlockRegistry.RED_AND_BLUE_CARVED_ARCHITRAVE_SLAB.get()), this.endLoc((Block)BlockRegistry.RED_AND_BLUE_CARVED_ARCHITRAVE_SLAB.get()));
        this.slabSideEndNoFull((Block)BlockRegistry.EMPTY_TUANHUA_SLAB.get(), this.sideLoc((Block)BlockRegistry.EMPTY_TUANHUA_SLAB.get()), this.endLoc((Block)BlockRegistry.EMPTY_TUANHUA_SLAB.get()));
        this.slabSideEndNoFull((Block)BlockRegistry.FULL_TUANHUA_SLAB.get(), this.sideLoc((Block)BlockRegistry.FULL_TUANHUA_SLAB.get()), this.endLoc((Block)BlockRegistry.EMPTY_TUANHUA_SLAB.get()));
        this.slabSideEndNoFull((Block)BlockRegistry.RED_AND_CYAN_TUANHUA_SLAB.get(), this.sideLoc((Block)BlockRegistry.RED_AND_CYAN_TUANHUA_SLAB.get()), this.endLoc((Block)BlockRegistry.RED_AND_CYAN_TUANHUA_SLAB.get()));
        this.slabSideEndNoFull((Block)BlockRegistry.RED_CARVED_ARCHITRAVE.get(), this.sideLoc((Block)BlockRegistry.RED_CARVED_ARCHITRAVE.get()), this.mcLoc("block/red_concrete_powder"));
        this.slabSideEndNoFull((Block)BlockRegistry.WHITE_AND_RED_SLAB.get(), this.sideLoc((Block)BlockRegistry.WHITE_AND_RED_SLAB.get()), this.endLoc((Block)BlockRegistry.WHITE_AND_RED_SLAB.get()));
        this.railingBlock((Block)BlockRegistry.WHITE_MARBLE_RAILING.get());
        this.railingBlock((Block)BlockRegistry.CARVED_WOODEN_RAILING.get());
        this.vegetableBasket((StackableHalfBlock)BlockRegistry.CABBAGE_BASKET.get());
        this.vegetableBasket((StackableHalfBlock)BlockRegistry.CELERY_BASKET.get());
        this.vegetableBasket((StackableHalfBlock)BlockRegistry.ORANGE_BASKET.get());
        this.vegetableBasket((StackableHalfBlock)BlockRegistry.APPLE_BASKET.get());
        this.vegetableBasket((StackableHalfBlock)BlockRegistry.EGGPLANT_BASKET.get());
        this.vegetableBasket((StackableHalfBlock)BlockRegistry.PEAR_BASKET.get());
        this.horizontalBlock((Block)BlockRegistry.BOOKSHELF.get(), (ModelFile)((BlockModelBuilder)this.models().cube(ModBlockModelProvider.name((Block)BlockRegistry.BOOKSHELF.get()), this.modLoc("block/bookshelf_side"), this.modLoc("block/bookshelf_side"), this.modLoc("block/bookshelf_front"), this.modLoc("block/bookshelf_back"), this.modLoc("block/bookshelf_side"), this.modLoc("block/bookshelf_side"))).texture("particle", this.modLoc("block/bookshelf_side")), 0);
        this.horizontalBlock((Block)BlockRegistry.BOOKSHELF_VARIANT.get(), (ModelFile)((BlockModelBuilder)this.models().cube(ModBlockModelProvider.name((Block)BlockRegistry.BOOKSHELF_VARIANT.get()), this.modLoc("block/bookshelf_side"), this.modLoc("block/bookshelf_side"), this.modLoc("block/bookshelf_variant_front"), this.modLoc("block/bookshelf_variant_back"), this.modLoc("block/bookshelf_side"), this.modLoc("block/bookshelf_side"))).texture("particle", this.modLoc("block/bookshelf_side")), 0);
        this.getVariantBuilder((Block)BlockRegistry.LONG_TABLE.get()).forAllStates(state -> {
            boolean right;
            Direction.Axis axis = (Direction.Axis)state.m_61143_(LongTableBlock.AXIS);
            boolean left = (Boolean)state.m_61143_((Property)LongTableBlock.LEFT);
            String modelName = left ^ (right = ((Boolean)state.m_61143_((Property)LongTableBlock.RIGHT)).booleanValue()) ? (left ? "long_table_right" : "long_table_left") : (left ? "long_table_middle" : "long_table_single");
            ConfiguredModel.Builder model = ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + modelName)));
            return axis == Direction.Axis.X ? model.build() : model.rotationY(-90).build();
        });
        this.simpleBlock((Block)BlockRegistry.STONE_FLOWER_WINDOW.get());
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> blockRegistryObject.get() instanceof DecorativeBlock).filter(block -> !this.SKIP_DECO.contains(block)).forEach(decorativeBlock -> {
            DecorativeBlock block = (DecorativeBlock)decorativeBlock.get();
            if (this.ROTATED_DECO.containsKey(decorativeBlock)) {
                this.decorativeBlock(block, this.ROTATED_DECO.get(decorativeBlock));
            } else if (block instanceof ConsumableDecorativeBlock) {
                ConsumableDecorativeBlock consumableDecorativeBlock = (ConsumableDecorativeBlock)block;
                this.consumableDecorativeBlock(consumableDecorativeBlock);
            } else if (block instanceof Censer) {
                Censer censer = (Censer)block;
                this.censer(censer, 0);
            } else if (block instanceof OpeningBlock) {
                OpeningBlock openingBlock = (OpeningBlock)block;
                this.openingBlock(openingBlock);
            } else if (block instanceof HangingLantern) {
                HangingLantern lantern = (HangingLantern)block;
                this.hangingLantern(lantern);
            } else {
                this.decorativeBlock(block);
            }
        });
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> blockRegistryObject.get() instanceof SideBlock).forEach(sideBlock -> {
            SideBlock block = (SideBlock)sideBlock.get();
            if (block instanceof WallSideBlock) {
                WallSideBlock wallSideBlock = (WallSideBlock)block;
                if (block instanceof OrientableWallSideBlock) {
                    OrientableWallSideBlock orientableWallSideBlock = (OrientableWallSideBlock)block;
                    this.orientableWallSideBlock(orientableWallSideBlock);
                } else if (block instanceof Icicle) {
                    Icicle icicle = (Icicle)block;
                    this.icicle(icicle);
                } else {
                    this.wallSideBlock(wallSideBlock);
                }
            } else if (block instanceof SixSideBlock) {
                SixSideBlock sixSideBlock = (SixSideBlock)block;
                if (block instanceof OrientableSixSideBlock) {
                    OrientableSixSideBlock orientableSixFaceBlock = (OrientableSixSideBlock)block;
                    this.orientableSixSideBlock(orientableSixFaceBlock);
                } else {
                    this.sixSideBlock(sixSideBlock);
                }
            }
        });
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> blockRegistryObject.get() instanceof SideAxialBlock).forEach(sideAxial -> {
            SideAxialBlock block = (SideAxialBlock)sideAxial.get();
            if (block instanceof RailingSlant) {
                this.shiftedHorizontalBlockNoOffset((Block)block);
            } else {
                this.horizontalBlockOffset((Block)sideAxial.get(), 180);
            }
        });
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> blockRegistryObject.get() instanceof CentralAxialBlock).forEach(centralAxial -> this.axisBlock((Block)centralAxial.get()));
        this.horizontalBlock((Block)BlockRegistry.WOODWORKING_WORKBENCH.get(), (ModelFile)this.models().getExistingFile(this.blockLoc((Block)BlockRegistry.WOODWORKING_WORKBENCH.get())));
        this.getVariantBuilder((Block)BlockRegistry.BRICK_KILN.get()).forAllStates(blockState -> {
            ConfiguredModel.Builder modelFile = ConfiguredModel.builder();
            ResourceLocation resourceLocation = ModBlockModelProvider.resourceLocation((Block)BlockRegistry.BRICK_KILN.get());
            Object blockPath = (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_) != false ? resourceLocation.m_135815_() + "_on" : resourceLocation.m_135815_();
            return this.getDecorativeBlockConfiguredModels((DecorativeBlock)BlockRegistry.BRICK_KILN.get(), (BlockState)blockState, (String)blockPath, (ConfiguredModel.Builder<?>)modelFile, 180);
        });
        this.getVariantBuilder((Block)BlockRegistry.CHISEL_TABLE.get()).forAllStates(blockState -> {
            ConfiguredModel.Builder modelFile = ConfiguredModel.builder();
            ResourceLocation resourceLocation = ModBlockModelProvider.resourceLocation((Block)BlockRegistry.CHISEL_TABLE.get());
            String blockPath = resourceLocation.m_135815_();
            return this.getDecorativeBlockConfiguredModels((DecorativeBlock)BlockRegistry.CHISEL_TABLE.get(), (BlockState)blockState, blockPath, (ConfiguredModel.Builder<?>)modelFile, 0);
        });
        this.simpleBlock((Block)BlockRegistry.JADE_ORE.get());
        this.simpleBlock((Block)BlockRegistry.DEEPSLATE_JADE_ORE.get());
        this.simpleBlock((Block)BlockRegistry.MAGNESITE_ORE.get());
        this.simpleBlock((Block)BlockRegistry.DEEPSLATE_MAGNESITE_ORE.get());
        this.simpleBlock((Block)BlockRegistry.HEMATITE_ORE.get());
        this.simpleBlock((Block)BlockRegistry.DEEPSLATE_HEMATITE_ORE.get());
        this.simpleBlock((Block)BlockRegistry.NETHER_COBALT_ORE.get());
        this.simpleBlock((Block)BlockRegistry.JADE_BLOCK.get());
        this.simpleBlock((Block)BlockRegistry.BRONZE_BLOCK.get());
    }

    private ResourceLocation blockLoc(Block block) {
        return this.modLoc(BLOCK + ModBlockModelProvider.name(block));
    }

    private void existingModelBlock(Block block) {
        this.simpleBlock(block, (ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block))));
    }

    private void slabAndStairs(Block baseBlock, Block slabBlock, Block stairBlock) {
        this.slabBlock((SlabBlock)slabBlock, ModBlockModelProvider.resourceLocation(baseBlock), this.blockLoc(baseBlock));
        this.stairsBlock((StairBlock)stairBlock, this.blockLoc(baseBlock));
    }

    private void wall(Block baseBlock, Block wallBlock) {
        this.wallBlock((WallBlock)wallBlock, ModBlockModelProvider.name(wallBlock), this.blockLoc(baseBlock));
    }

    private void fence(Block baseBlock, Block fenceBlock) {
        this.fenceBlock((FenceBlock)fenceBlock, ModBlockModelProvider.name(fenceBlock), this.blockLoc(baseBlock));
    }

    private void wallSideBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(blockState -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block)))).rotationY((int)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_()).build());
    }

    private void icicle(Block block) {
        this.getVariantBuilder(block).forAllStates(blockState -> {
            int numVariants = ((Icicle)block).getNumVariants();
            int variant = (Integer)blockState.m_61143_((Property)Icicle.VARIANT);
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_" + Math.min(variant, numVariants - 1)))).rotationY((int)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_()).build();
        });
    }

    private void sixSideBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(blockState -> {
            ConfiguredModel.Builder model = ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block))));
            Direction direction = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_);
            if (direction == Direction.UP) {
                model.rotationX(90);
            } else if (direction == Direction.DOWN) {
                model.rotationX(-90);
            } else {
                model.rotationY((int)direction.m_122435_());
            }
            return model.build();
        });
    }

    private void orientableWallSideBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(blockState -> {
            ResourceLocation model = blockState.m_61143_(OrientableWallSideBlock.TYPE) == OrientableBlockType.LEFT ? this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_left") : this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_right");
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(model)).rotationY((int)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_()).build();
        });
    }

    private void orientableSixSideBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(blockState -> {
            ConfiguredModel.Builder modelBuilder = ConfiguredModel.builder();
            Direction faceDir = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_);
            Direction direction = (Direction)blockState.m_61143_((Property)ModBlockStateProperties.ON_FACE_DIRECTION);
            if (faceDir.m_122434_().m_122478_()) {
                modelBuilder.modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_top")));
                if (faceDir == Direction.DOWN) {
                    modelBuilder.rotationY((int)direction.m_122435_() + 180);
                } else if (faceDir == Direction.UP) {
                    modelBuilder.rotationX(180).rotationY((int)direction.m_122435_());
                }
            } else {
                StringBuilder suffix = new StringBuilder();
                suffix.append("_side");
                if (direction.m_122434_().m_122478_()) {
                    suffix.append("_").append(direction.m_122433_());
                } else if (direction == faceDir.m_122427_()) {
                    suffix.append("_left");
                } else if (direction == faceDir.m_122428_()) {
                    suffix.append("_right");
                } else {
                    suffix.append("_up");
                }
                modelBuilder.modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block) + suffix)));
                modelBuilder.rotationY((int)faceDir.m_122435_());
            }
            return modelBuilder.build();
        });
    }

    private void roofTiles(Block block) {
        if (!(block instanceof RoofTiles)) {
            return;
        }
        RoofTiles tile = (RoofTiles)block;
        String color = tile.getColor().toString();
        RoofTiles.RoofTileType type = tile.getType();
        ResourceLocation coloredParticle = this.modLoc("block/texture_" + color + "_roof_tiles");
        ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.modLoc(BLOCK + color + "_" + type).m_135815_(), this.modLoc(BLOCK + type))).texture("1", this.blockLoc(tile))).texture("particle", coloredParticle);
        ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.modLoc(BLOCK + color + "_" + type + "_shifted").m_135815_(), this.modLoc(BLOCK + type + "_shifted"))).texture("1", this.blockLoc(tile))).texture("particle", coloredParticle);
        for (int i = 1; i <= 15; ++i) {
            int layerToStage = (Integer)type.getSnowStages().get(i).getLeft();
            boolean usesSideSnow = (Boolean)type.getSnowStages().get(i).getRight();
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.modLoc(BLOCK + color + "_" + type + "_snow_layer_" + i).m_135815_(), this.modLoc(BLOCK + type))).texture("1", this.modLoc(BLOCK + ModBlockModelProvider.name(tile) + "_snow_stage_" + layerToStage))).texture("particle", coloredParticle);
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.modLoc(BLOCK + color + "_" + type + "_shifted_snow_layer_" + i).m_135815_(), this.modLoc(BLOCK + type + "_shifted"))).texture("1", this.modLoc(BLOCK + ModBlockModelProvider.name(tile) + "_snow_stage_" + layerToStage))).texture("particle", coloredParticle);
            if (!usesSideSnow) continue;
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.modLoc(BLOCK + color + "_" + type + "_snow_layer_" + i + "_none").m_135815_(), this.modLoc(BLOCK + type))).texture("1", this.modLoc(BLOCK + ModBlockModelProvider.name(tile) + "_snow_stage_" + layerToStage + "_none"))).texture("particle", coloredParticle);
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.modLoc(BLOCK + color + "_" + type + "_shifted_snow_layer_" + i + "_left").m_135815_(), this.modLoc(BLOCK + type + "_shifted"))).texture("1", this.modLoc(BLOCK + ModBlockModelProvider.name(tile) + "_snow_stage_" + layerToStage + "_left"))).texture("particle", coloredParticle);
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.modLoc(BLOCK + color + "_" + type + "_snow_layer_" + i + "_right").m_135815_(), this.modLoc(BLOCK + type))).texture("1", this.modLoc(BLOCK + ModBlockModelProvider.name(tile) + "_snow_stage_" + layerToStage + "_right"))).texture("particle", coloredParticle);
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.modLoc(BLOCK + color + "_" + type + "_shifted_snow_layer_" + i + "_none").m_135815_(), this.modLoc(BLOCK + type + "_shifted"))).texture("1", this.modLoc(BLOCK + ModBlockModelProvider.name(tile) + "_snow_stage_" + layerToStage + "_none"))).texture("particle", coloredParticle);
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.modLoc(BLOCK + color + "_" + type + "_snow_layer_" + i + "_left").m_135815_(), this.modLoc(BLOCK + type))).texture("1", this.modLoc(BLOCK + ModBlockModelProvider.name(tile) + "_snow_stage_" + layerToStage + "_left"))).texture("particle", coloredParticle);
            ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.modLoc(BLOCK + color + "_" + type + "_shifted_snow_layer_" + i + "_right").m_135815_(), this.modLoc(BLOCK + type + "_shifted"))).texture("1", this.modLoc(BLOCK + ModBlockModelProvider.name(tile) + "_snow_stage_" + layerToStage + "_right"))).texture("particle", coloredParticle);
        }
        this.getVariantBuilder(tile).forAllStates(blockState -> {
            int snow = (Integer)blockState.m_61143_((Property)RoofTiles.SNOW_LAYERS);
            StringBuilder builder = new StringBuilder();
            builder.append(BLOCK).append(ModBlockModelProvider.name(tile));
            if (((Boolean)blockState.m_61143_((Property)ModBlockStateProperties.SHIFTED)).booleanValue()) {
                builder.append("_shifted");
            }
            if (snow > 0) {
                builder.append("_snow_layer_").append(snow);
                boolean usesSideSnow = (Boolean)type.getSnowStages().get(snow).getRight();
                if (usesSideSnow && blockState.m_61143_(RoofTiles.SNOW_SIDE) != RoofTiles.SnowSide.BOTH) {
                    builder.append("_").append(((RoofTiles.SnowSide)((Object)((Object)blockState.m_61143_(RoofTiles.SNOW_SIDE)))).m_7912_());
                }
            }
            String modelName = builder.toString();
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(modelName))).rotationY((int)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_()).build();
        });
    }

    private void roofRidgeSideBottomTop(Block block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        if (!(block instanceof SnowRoofRidge)) {
            return;
        }
        if (block instanceof RoofRidge) {
            RoofRidge ridge = (RoofRidge)block;
            DyeColor color = ridge.getColor();
            SnowRoofRidge.RoofRidgeType type = ridge.getType();
            this.models().cubeBottomTop(ModBlockModelProvider.name(ridge), side, bottom, top);
            for (int layer = 1; layer <= 15; ++layer) {
                int snowStage = (Integer)SnowRoofRidge.SNOW_STAGES.get((Object)layer);
                if (snowStage == 0) {
                    this.models().cubeBottomTop(ModBlockModelProvider.name(ridge) + "_snow_layer_" + layer, side, bottom, top);
                    continue;
                }
                this.models().cubeBottomTop(ModBlockModelProvider.name(ridge) + "_snow_layer_" + layer, this.modLoc(side.m_135815_() + "_snow_stage_" + snowStage), bottom, this.mcLoc("block/snow"));
            }
            this.getVariantBuilder(ridge).forAllStates(blockState -> {
                int snow = (Integer)blockState.m_61143_((Property)RoofTiles.SNOW_LAYERS);
                StringBuilder builder = new StringBuilder();
                builder.append(BLOCK).append(ModBlockModelProvider.name(ridge));
                if (snow > 0) {
                    builder.append("_snow_layer_").append(snow);
                }
                String modelName = builder.toString();
                return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(modelName))).build();
            });
        }
    }

    private void roofRidgeFrontSideBottomTop(Block block, ResourceLocation front, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        if (!(block instanceof SnowRoofRidge)) {
            return;
        }
        if (block instanceof RoofRidgeConnection) {
            RoofRidgeConnection ridge = (RoofRidgeConnection)block;
            DyeColor color = ridge.getColor();
            SnowRoofRidge.RoofRidgeType type = ridge.getType();
            ((BlockModelBuilder)this.models().cube(ModBlockModelProvider.name(ridge), bottom, top, front, front, side, side)).texture("particle", side);
            for (int layer = 1; layer <= 15; ++layer) {
                int snowStage = (Integer)SnowRoofRidge.SNOW_STAGES.get((Object)layer);
                if (snowStage == 0) {
                    ((BlockModelBuilder)this.models().cube(ModBlockModelProvider.name(ridge) + "_snow_layer_" + layer, bottom, top, front, front, side, side)).texture("particle", side);
                    continue;
                }
                ((BlockModelBuilder)this.models().cube(ModBlockModelProvider.name(ridge) + "_snow_layer_" + layer, bottom, this.mcLoc("block/snow"), this.modLoc(front.m_135815_() + "_snow_stage_" + snowStage), this.modLoc(front.m_135815_() + "_snow_stage_" + snowStage), this.modLoc(side.m_135815_() + "_snow_stage_" + snowStage), this.modLoc(side.m_135815_() + "_snow_stage_" + snowStage))).texture("particle", side);
            }
            this.getVariantBuilder(ridge).forAllStates(blockState -> {
                int snow = (Integer)blockState.m_61143_((Property)RoofTiles.SNOW_LAYERS);
                StringBuilder builder = new StringBuilder();
                builder.append(BLOCK).append(ModBlockModelProvider.name(ridge));
                if (snow > 0) {
                    builder.append("_snow_layer_").append(snow);
                }
                String modelName = builder.toString();
                Direction.Axis axis = (Direction.Axis)blockState.m_61143_((Property)BlockStateProperties.f_61364_);
                if (axis == Direction.Axis.Z) {
                    return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(modelName))).build();
                }
                return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(modelName))).rotationY(90).build();
            });
        }
    }

    private void roofHorizontalRidgeFrontSideBottomTop(Block block, ResourceLocation front, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        if (!(block instanceof SnowRoofRidge)) {
            return;
        }
        if (block instanceof RoofMainRidgeConnection) {
            RoofMainRidgeConnection ridge = (RoofMainRidgeConnection)block;
            DyeColor color = ridge.getColor();
            SnowRoofRidge.RoofRidgeType type = ridge.getType();
            ((BlockModelBuilder)this.models().cube(ModBlockModelProvider.name((Block)ridge), bottom, top, front, front, side, side)).texture("particle", side);
            for (int layer = 1; layer <= 15; ++layer) {
                int snowStage = (Integer)SnowRoofRidge.SNOW_STAGES.get((Object)layer);
                if (snowStage == 0) {
                    ((BlockModelBuilder)this.models().cube(ModBlockModelProvider.name((Block)ridge) + "_snow_layer_" + layer, bottom, top, front, front, side, side)).texture("particle", side);
                    continue;
                }
                ((BlockModelBuilder)this.models().cube(ModBlockModelProvider.name((Block)ridge) + "_snow_layer_" + layer, bottom, this.mcLoc("block/snow"), this.modLoc(front.m_135815_() + "_snow_stage_" + snowStage), this.modLoc(front.m_135815_() + "_snow_stage_" + snowStage), this.modLoc(side.m_135815_() + "_snow_stage_" + snowStage), this.modLoc(side.m_135815_() + "_snow_stage_" + snowStage))).texture("particle", side);
            }
            this.getVariantBuilder((Block)ridge).forAllStates(blockState -> {
                int snow = (Integer)blockState.m_61143_((Property)RoofTiles.SNOW_LAYERS);
                StringBuilder builder = new StringBuilder();
                builder.append(BLOCK).append(ModBlockModelProvider.name((Block)ridge));
                if (snow > 0) {
                    builder.append("_snow_layer_").append(snow);
                }
                String modelName = builder.toString();
                return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(modelName))).rotationY((int)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_()).build();
            });
        }
    }

    private void shiftedDirectionalBlock(Block block, int rotation) {
        this.getVariantBuilder(block).forAllStates(blockState -> {
            if (!((Boolean)blockState.m_61143_((Property)ModBlockStateProperties.SHIFTED)).booleanValue()) {
                return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block)))).rotationY(rotation + (int)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_()).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_shifted"))).rotationY(rotation + (int)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_()).build();
        });
    }

    private void shiftedDirectionalBlock(Block block) {
        this.shiftedDirectionalBlock(block, 0);
    }

    private void axisBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(blockState -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block))));
            if (blockState.m_61143_((Property)BlockStateProperties.f_61364_) == Direction.Axis.X) {
                builder.rotationY(90);
            }
            return builder.build();
        });
    }

    private void shiftedAxisBlock(Block block) {
        this.getVariantBuilder(block).forAllStates(blockState -> {
            ConfiguredModel.Builder builder = (Boolean)blockState.m_61143_((Property)ModBlockStateProperties.SHIFTED) == false ? ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block)))) : ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_shifted")));
            if (blockState.m_61143_((Property)BlockStateProperties.f_61364_) == Direction.Axis.X) {
                builder.rotationY(90);
            }
            return builder.build();
        });
    }

    private void decorativeBlock(DecorativeBlock block) {
        this.decorativeBlock(block, 0);
    }

    private void decorativeBlock(DecorativeBlock block, int rotation) {
        this.getVariantBuilder((Block)block).forAllStates(blockState -> {
            ConfiguredModel.Builder modelFile = ConfiguredModel.builder();
            String blockPath = ModBlockModelProvider.name((Block)block);
            return this.getDecorativeBlockConfiguredModels(block, (BlockState)blockState, blockPath, (ConfiguredModel.Builder<?>)modelFile, rotation);
        });
    }

    private void consumableDecorativeBlock(ConsumableDecorativeBlock block) {
        this.consumableDecorativeBlock(block, 0);
    }

    private void consumableDecorativeBlock(ConsumableDecorativeBlock block, int rotation) {
        this.getVariantBuilder((Block)block).forAllStates(blockState -> {
            ConfiguredModel.Builder modelFile = ConfiguredModel.builder();
            int bites = (Integer)blockState.m_61143_((Property)ModBlockStateProperties.BITES);
            bites = Math.min(bites, block.getMaxBites());
            ResourceLocation resourceLocation = ModBlockModelProvider.resourceLocation((Block)block);
            String blockPath = resourceLocation.m_135815_() + "_" + bites;
            return this.getDecorativeBlockConfiguredModels(block, (BlockState)blockState, blockPath, (ConfiguredModel.Builder<?>)modelFile, rotation);
        });
    }

    private void censer(Censer block, int rotation) {
        this.getVariantBuilder((Block)block).forAllStates(blockState -> {
            ConfiguredModel.Builder modelFile = ConfiguredModel.builder();
            ResourceLocation resourceLocation = ModBlockModelProvider.resourceLocation((Block)block);
            Object blockPath = (Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61443_) != false ? "lit_" + resourceLocation.m_135815_() : resourceLocation.m_135815_();
            return this.getDecorativeBlockConfiguredModels(block, (BlockState)blockState, (String)blockPath, (ConfiguredModel.Builder<?>)modelFile, rotation);
        });
    }

    private void openingBlock(OpeningBlock block) {
        this.getVariantBuilder((Block)block).forAllStates(blockState -> {
            ConfiguredModel.Builder modelFile = ConfiguredModel.builder();
            String blockName = ModBlockModelProvider.name((Block)block);
            Object blockPath = ((Boolean)blockState.m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue() ? (blockState.m_61143_((Property)BlockStateProperties.f_61394_) == DoorHingeSide.LEFT ? blockName + "_open_left" : blockName + "_open_right") : blockName;
            return this.getDecorativeBlockConfiguredModels(block, (BlockState)blockState, (String)blockPath, (ConfiguredModel.Builder<?>)modelFile, 0);
        });
    }

    private void hangingLantern(HangingLantern lantern) {
        this.getVariantBuilder((Block)lantern).forAllStates(blockState -> {
            ConfiguredModel.Builder modelFile = ConfiguredModel.builder();
            String blockPath = ModBlockModelProvider.name((Block)lantern) + "_" + blockState.m_61143_((Property)ModBlockStateProperties.LANTERNS);
            return this.getDecorativeBlockConfiguredModels(lantern, (BlockState)blockState, blockPath, (ConfiguredModel.Builder<?>)modelFile, 0);
        });
    }

    private void vegetableBasket(StackableHalfBlock block) {
        String blockName = ModBlockModelProvider.name(block);
        this.getVariantBuilder(block).forAllStates(blockState -> {
            StackableBlockType type = (StackableBlockType)((Object)((Object)blockState.m_61143_(ModBlockStateProperties.STACKABLE_BLOCK_TYPE)));
            switch (type) {
                case SINGLE: {
                    return ConfiguredModel.builder().modelFile((ModelFile)this.models().slab(this.blockLoc(block).m_135815_(), this.modLoc("block/vegetable_basket_side"), this.modLoc("block/vegetable_basket_bottom"), this.modLoc(BLOCK + blockName + "_top"))).build();
                }
                case DOUBLE: {
                    return ConfiguredModel.builder().modelFile((ModelFile)this.models().cubeBottomTop(this.modLoc(BLOCK + blockName + "_double").m_135815_(), this.modLoc("block/vegetable_basket_side"), this.modLoc("block/vegetable_basket_bottom"), this.modLoc(BLOCK + blockName + "_top"))).build();
                }
            }
            return new ConfiguredModel[0];
        });
    }

    private void sideBottomTop(Block block) {
        String blockName = ModBlockModelProvider.name(block);
        this.sideBottomTop(block, this.modLoc(BLOCK + blockName + "_side"), this.modLoc(BLOCK + blockName + "_bottom"), this.modLoc(BLOCK + blockName + "_top"));
    }

    private void sideBottomTop(Block block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        String blockName = ModBlockModelProvider.name(block);
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeBottomTop(blockName, side, bottom, top);
        this.simpleBlock(block, (ModelFile)model);
    }

    private void axialFrontSideBottomTop(Block block, ResourceLocation front, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(ModBlockModelProvider.name(block), bottom, top, front, front, side, side)).texture("particle", side);
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.Z).modelForState().modelFile((ModelFile)model).addModel()).partialState().with((Property)BlockStateProperties.f_61364_, (Comparable)Direction.Axis.X).modelForState().modelFile((ModelFile)model).rotationY(90).addModel();
    }

    private void horizontalFrontSideBottomTop(Block block, ResourceLocation front, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)this.models().cube(ModBlockModelProvider.name(block), bottom, top, front, front, side, side)).texture("particle", side);
        this.horizontalBlock(block, (ModelFile)model, 0);
    }

    private void chiralWSMirror(Block block, ResourceLocation end) {
        this.directionalBlock(block, state -> {
            String path = ModBlockModelProvider.name(block);
            if (state.m_61138_(ModBlockStateProperties.CHIRAL_BLOCK_TYPE)) {
                ChiralBlockType chiralBlockType = (ChiralBlockType)((Object)((Object)state.m_61143_(ModBlockStateProperties.CHIRAL_BLOCK_TYPE)));
                if (chiralBlockType == ChiralBlockType.LEFT || chiralBlockType == ChiralBlockType.TOP) {
                    return ((BlockModelBuilder)this.models().cube(path, end, end, this.sideLoc(block), this.sideMirroredLoc(block), this.sideLoc(block), this.sideMirroredLoc(block))).texture("particle", this.sideLoc(block));
                }
                return ((BlockModelBuilder)this.models().cube(path + "_mirrored", end, end, this.sideMirroredLoc(block), this.sideLoc(block), this.sideMirroredLoc(block), this.sideLoc(block))).texture("particle", this.sideLoc(block));
            }
            return this.models().getExistingFile(this.modLoc(BLOCK + path));
        });
    }

    private void straightStairs(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(blockState -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block)))).rotationX(blockState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.BOTTOM ? 0 : 180).rotationY((int)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122427_().m_122435_() - 90 + (blockState.m_61143_((Property)BlockStateProperties.f_61402_) == Half.BOTTOM ? 0 : 180)).build(), new Property[]{BlockStateProperties.f_61362_});
    }

    private void horizontalBlockOffset(Block block, int offset) {
        this.horizontalBlock(block, (ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block))), offset);
    }

    private void horizontalBlockNoOffset(Block block) {
        this.horizontalBlock(block, (ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block))), 0);
    }

    private void woodenBracket(Block block, ResourceLocation texture) {
        this.horizontalBlock(block, (ModelFile)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.blockLoc(block).m_135815_(), this.modLoc("block/wooden_bracket"))).texture("1", texture)).texture("particle", texture), 0);
    }

    private void shiftedHorizontalBlockNoOffset(Block block) {
        this.horizontalBlock(block, state -> {
            Boolean shifted = (Boolean)state.m_61143_((Property)ModBlockStateProperties.SHIFTED);
            return shifted != false ? this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block))) : this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_shifted"));
        });
    }

    private void directionalSideBottomTop(Block block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        String blockName = ModBlockModelProvider.name(block);
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeBottomTop(blockName, side, bottom, top);
        this.directionalBlock(block, (ModelFile)model);
    }

    private void directionalSideEnd(Block block, ResourceLocation side, ResourceLocation end) {
        String blockName = ModBlockModelProvider.name(block);
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeBottomTop(blockName, side, end, end);
        this.directionalBlock(block, (ModelFile)model);
    }

    private void directionalBottomTop(Block block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        String blockName = ModBlockModelProvider.name(block);
        BlockModelBuilder model = (BlockModelBuilder)this.models().cubeBottomTop(blockName, side, bottom, top);
        this.directionalBlock(block, (ModelFile)model);
    }

    private void axisSideEnd(Block block, ResourceLocation side, ResourceLocation end) {
        this.axisBlock((RotatedPillarBlock)block, side, end);
    }

    private void slabSideEnd(Block block, Block full, ResourceLocation side, ResourceLocation end) {
        this.slabBlock((SlabBlock)block, ModBlockModelProvider.resourceLocation(full), side, end, end);
    }

    private void slabSideEndNoFull(Block block, ResourceLocation side, ResourceLocation end) {
        this.slabBlock((SlabBlock)block, (ModelFile)this.models().slab(ModBlockModelProvider.name(block), side, end, end), (ModelFile)this.models().slabTop(ModBlockModelProvider.name(block) + "_top", side, end, end), (ModelFile)this.models().cubeBottomTop(ModBlockModelProvider.name(block) + "double", side, end, end));
    }

    private void slabSideBottomTopNoFull(Block block, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.slabBlock((SlabBlock)block, (ModelFile)this.models().slab(ModBlockModelProvider.name(block), side, bottom, top), (ModelFile)this.models().slabTop(ModBlockModelProvider.name(block) + "_top", side, bottom, top), (ModelFile)this.models().cubeBottomTop(ModBlockModelProvider.name(block) + "double", side, bottom, top));
    }

    private void directionalSlabFrontSideBottomTopNoFull(Block block, ResourceLocation front, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            SlabType type = (SlabType)state.m_61143_((Property)BlockStateProperties.f_61397_);
            switch (type) {
                case TOP: {
                    builder.modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ModBlockModelProvider.name(block) + "_top", this.modLoc("block/roof_slab_top"))).texture("front", front)).texture("side", side)).texture("top", top)).texture("bottom", bottom)).texture("particle", front));
                    break;
                }
                case BOTTOM: {
                    builder.modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ModBlockModelProvider.name(block), this.modLoc("block/roof_slab"))).texture("front", front)).texture("side", side)).texture("top", top)).texture("bottom", bottom)).texture("particle", front));
                    break;
                }
                case DOUBLE: {
                    builder.modelFile((ModelFile)((BlockModelBuilder)this.models().cube(ModBlockModelProvider.name(block) + "_double", bottom, top, front, front, side, side)).texture("particle", front));
                }
            }
            builder.rotationY((int)direction.m_122435_());
            return builder.build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    private void roofRidgePanel(Block block, ResourceLocation front, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            builder.modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ModBlockModelProvider.name(block), this.modLoc("block/roof_panel"))).texture("front", front)).texture("side", side)).texture("bottom", bottom)).texture("top", top));
            builder.rotationY((int)direction.m_122435_());
            return builder.build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    private void roofRidgePlate(Block block, ResourceLocation front, ResourceLocation side, ResourceLocation bottom, ResourceLocation top) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            ConfiguredModel.Builder builder = ConfiguredModel.builder();
            Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            builder.modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ModBlockModelProvider.name(block), this.modLoc("block/roof_plate"))).texture("front", front)).texture("side", side)).texture("bottom", bottom)).texture("top", top));
            builder.rotationY((int)direction.m_122435_());
            return builder.build();
        }, new Property[]{BlockStateProperties.f_61362_});
    }

    private void carvedWoodenSlab(Block slab, Block full) {
        this.slabBlock((SlabBlock)slab, ModBlockModelProvider.resourceLocation(full), this.sideLoc(slab), this.blockLoc(full), this.blockLoc(full));
    }

    private ResourceLocation modBlockLoc(Block block) {
        return this.modLoc(BLOCK + ModBlockModelProvider.name(block));
    }

    private ResourceLocation sideLoc(Block block) {
        return this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_side");
    }

    private ResourceLocation frontLoc(Block block) {
        return this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_front");
    }

    private ResourceLocation bottomLoc(Block block) {
        return this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_bottom");
    }

    private ResourceLocation topLoc(Block block) {
        return this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_top");
    }

    private ResourceLocation sideMirroredLoc(Block block) {
        return this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_side_mirrored");
    }

    private ResourceLocation endLoc(Block block) {
        return this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_end");
    }

    private void railingBlock(Block block) {
        ModelFile.ExistingModelFile sideModel = this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_side"));
        ModelFile.ExistingModelFile panelModel = this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_panel"));
        ModelFile.ExistingModelFile sideModelShift = this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_side_shifted"));
        ModelFile.ExistingModelFile panelModelShift = this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_panel_shifted"));
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)this.getMultipartBuilder(block).part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_pole"))).addModel()).condition((Property)RailingBlock.SHIFTED, (Comparable[])new Boolean[]{false}).condition((Property)RailingBlock.UP, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)sideModel).addModel()).condition((Property)RailingBlock.SHIFTED, (Comparable[])new Boolean[]{false}).condition((Property)RailingBlock.UP, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.NORTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)sideModel).rotationY(90).addModel()).condition((Property)RailingBlock.SHIFTED, (Comparable[])new Boolean[]{false}).condition((Property)RailingBlock.UP, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)sideModel).rotationY(180).addModel()).condition((Property)RailingBlock.SHIFTED, (Comparable[])new Boolean[]{false}).condition((Property)RailingBlock.UP, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)sideModel).rotationY(270).addModel()).condition((Property)RailingBlock.SHIFTED, (Comparable[])new Boolean[]{false}).condition((Property)RailingBlock.UP, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.WEST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)panelModel).addModel()).condition((Property)RailingBlock.SHIFTED, (Comparable[])new Boolean[]{false}).condition((Property)RailingBlock.UP, (Comparable[])new Boolean[]{false}).condition((Property)RailingBlock.WEST, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)panelModel).rotationY(90).addModel()).condition((Property)RailingBlock.SHIFTED, (Comparable[])new Boolean[]{false}).condition((Property)RailingBlock.UP, (Comparable[])new Boolean[]{false}).condition((Property)RailingBlock.NORTH, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_pole_shifted"))).addModel()).condition((Property)RailingBlock.SHIFTED, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.UP, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)sideModelShift).addModel()).condition((Property)RailingBlock.SHIFTED, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.UP, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.NORTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)sideModelShift).rotationY(90).addModel()).condition((Property)RailingBlock.SHIFTED, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.UP, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)sideModelShift).rotationY(180).addModel()).condition((Property)RailingBlock.SHIFTED, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.UP, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.SOUTH, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)sideModelShift).rotationY(270).addModel()).condition((Property)RailingBlock.SHIFTED, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.UP, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.WEST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)panelModelShift).addModel()).condition((Property)RailingBlock.SHIFTED, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.UP, (Comparable[])new Boolean[]{false}).condition((Property)RailingBlock.WEST, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.EAST, (Comparable[])new Boolean[]{true}).end().part().modelFile((ModelFile)panelModelShift).rotationY(90).addModel()).condition((Property)RailingBlock.SHIFTED, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.UP, (Comparable[])new Boolean[]{false}).condition((Property)RailingBlock.NORTH, (Comparable[])new Boolean[]{true}).condition((Property)RailingBlock.SOUTH, (Comparable[])new Boolean[]{true}).end();
    }

    private ConfiguredModel[] getDecorativeBlockConfiguredModels(DecorativeBlock block, BlockState blockState, String blockPath, ConfiguredModel.Builder<?> modelFile, int rotation) {
        if (!block.isDirectional() && !block.isDiagonallyPlaceable()) {
            return modelFile.modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + blockPath))).build();
        }
        if (!block.isDirectional() && block.isDiagonallyPlaceable()) {
            if (((Boolean)blockState.m_61143_((Property)ModBlockStateProperties.DIAGONAL)).booleanValue()) {
                modelFile.modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + blockPath + "_diagonal")));
            } else {
                modelFile.modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + blockPath)));
            }
            return modelFile.build();
        }
        if (block.isDirectional() && !block.isDiagonallyPlaceable()) {
            modelFile.modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + blockPath)));
            return modelFile.rotationY((int)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + rotation).build();
        }
        if (!((Boolean)blockState.m_61143_((Property)ModBlockStateProperties.DIAGONAL)).booleanValue()) {
            modelFile.modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + blockPath)));
            return modelFile.rotationY((int)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122435_() + rotation).build();
        }
        modelFile.modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + blockPath + "_diagonal")));
        Pair directions = Pair.of((Object)((Direction)blockState.m_61143_((Property)BlockStateProperties.f_61374_)), (Object)((Direction)blockState.m_61143_((Property)ModBlockStateProperties.HORIZONTAL_FACING_SHIFT)));
        int deg = 0;
        if (this.rotations.containsKey(directions)) {
            deg = this.rotations.get(directions);
        }
        return modelFile.rotationY(deg - 90).build();
    }

    private void diagonallyPlaceableBlock(Block block) {
        ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)ModBlockStateProperties.DIAGONAL, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.blockLoc(block))).addModel()).partialState().with((Property)ModBlockStateProperties.DIAGONAL, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.models().getExistingFile(this.modLoc(BLOCK + ModBlockModelProvider.name(block) + "_diagonal"))).addModel();
    }

    private static String name(Block block) {
        return ModBlockModelProvider.resourceLocation(block).m_135815_();
    }

    private static ResourceLocation resourceLocation(Block block) {
        return Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block));
    }

    @NotNull
    public String m_6055_() {
        return "ultramarine Block Models";
    }
}

