/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.voxelutopia.ultramarine.data.recipe.ChiselTableRecipe;
import com.voxelutopia.ultramarine.data.registry.RecipeSerializerRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ChiselTableRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final Ingredient material;
    private final Ingredient template;
    protected final List<Ingredient> colors;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private static final RecipeSerializer<ChiselTableRecipe> SERIALIZER = (RecipeSerializer)RecipeSerializerRegistry.CHISEL_TABLE_SERIALIZER.get();

    public ChiselTableRecipeBuilder(ItemLike result, Ingredient material, Ingredient template, List<Ingredient> colors) {
        this.result = result.m_5456_();
        this.material = material;
        this.template = template;
        this.colors = colors;
    }

    public static ChiselTableRecipeBuilder chiselTableRecipe(Ingredient material, Ingredient template, Ingredient[] colors, ItemLike result) {
        List<Ingredient> colorList = Arrays.asList(colors).stream().filter(i -> !i.m_43947_()).toList();
        return new ChiselTableRecipeBuilder(result, material, template, colorList);
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancementBuilder.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.advancementBuilder.m_138396_(new ResourceLocation("minecraft", "recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.group == null ? "" : this.group, this.material, this.template, this.colors, this.result, this.advancementBuilder, new ResourceLocation(pRecipeId.m_135827_(), "recipes/" + pRecipeId.m_135815_())));
    }

    private static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final String group;
        private final Item result;
        private final Ingredient material;
        private final Ingredient template;
        protected final List<Ingredient> colors;
        private final Advancement.Builder advancementBuilder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation pId, String pGroup, Ingredient material, Ingredient template, List<Ingredient> colors, Item result, Advancement.Builder pAdvancement, ResourceLocation pAdvancementId) {
            this.id = pId;
            this.group = pGroup;
            this.result = result;
            this.material = material;
            this.template = template;
            this.colors = colors;
            this.advancementBuilder = pAdvancement;
            this.advancementId = pAdvancementId;
        }

        public void m_7917_(JsonObject pJson) {
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            pJson.add("material", this.material.m_43942_());
            pJson.add("template", this.template.m_43942_());
            JsonArray colorsJson = new JsonArray();
            for (Ingredient color : this.colors) {
                colorsJson.add(color.m_43942_());
            }
            pJson.add("colors", (JsonElement)colorsJson);
            pJson.addProperty("result", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return SERIALIZER;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancementBuilder.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

