/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.event;

import com.voxelutopia.ultramarine.Ultramarine;
import com.voxelutopia.ultramarine.data.ModBlockTags;
import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import com.voxelutopia.ultramarine.data.registry.EntityTypeRegistry;
import com.voxelutopia.ultramarine.data.registry.ItemRegistry;
import com.voxelutopia.ultramarine.data.registry.PoiTypeRegistry;
import com.voxelutopia.ultramarine.data.registry.VillagerProfessionRegistry;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import com.voxelutopia.ultramarine.world.block.SnowRoofRidge;
import com.voxelutopia.ultramarine.world.entity.TravellingMerchant;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber
public class CommonEventHandler {
    private static final Logger LOGGER = Ultramarine.getLogger();

    @SubscribeEvent
    public static void breakSpeed(PlayerEvent.BreakSpeed event) {
        BlockState state = event.getState();
        Player player = event.getEntity();
        if (state.m_204336_(ModBlockTags.MINEABLE_WITH_SHEARS) && player.m_21120_(player.m_7655_()).m_204117_(Tags.Items.SHEARS)) {
            event.setNewSpeed(event.getOriginalSpeed() * 4.0f);
        }
    }

    @SubscribeEvent
    public static void itemConversion(ItemExpireEvent event) {
        ItemEntity itemEntity = event.getEntity();
        ItemStack item = itemEntity.m_32055_();
        if (itemEntity.m_20069_() && item.m_150930_((Item)ItemRegistry.FIRED_BRICK.get())) {
            itemEntity.m_32045_(new ItemStack((ItemLike)ItemRegistry.CYAN_BRICK.get(), item.m_41613_()));
            itemEntity.m_9236_().m_6269_(null, (Entity)itemEntity, SoundEvents.f_12031_, SoundSource.NEUTRAL, 0.5f, 1.0f);
            event.setExtraLife(6000);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void chiselTableMultiblock(BlockEvent event) {
        BlockPos pos;
        if (event instanceof BlockEvent.EntityPlaceEvent) {
            BlockEvent.EntityPlaceEvent placeEvent = (BlockEvent.EntityPlaceEvent)event;
            BlockState placedBlock = placeEvent.getPlacedBlock();
            if (!placedBlock.m_60713_((Block)BlockRegistry.BRUSH_AND_INKSTONE.get())) {
                return;
            }
            pos = placeEvent.getPos();
            BlockState blockBelow = placeEvent.getLevel().m_8055_(pos.m_7495_());
            if (blockBelow.m_60713_((Block)BlockRegistry.PORCELAIN_INLAID_TABLE.get())) {
                placeEvent.getLevel().m_7731_(pos, (BlockState)((Block)BlockRegistry.CHISEL_TABLE.get()).m_49966_().m_61124_((Property)DecorativeBlock.f_54117_, (Comparable)((Direction)placedBlock.m_61143_((Property)DecorativeBlock.f_54117_))), 3);
            }
        }
        if (event instanceof BlockEvent.BreakEvent) {
            BlockEvent.BreakEvent breakEvent = (BlockEvent.BreakEvent)event;
            BlockState block = breakEvent.getState();
            pos = breakEvent.getPos();
            if (block.m_60713_((Block)BlockRegistry.PORCELAIN_INLAID_TABLE.get()) && breakEvent.getLevel().m_8055_(pos.m_7494_()).m_60713_((Block)BlockRegistry.CHISEL_TABLE.get())) {
                breakEvent.getLevel().m_7731_(pos.m_7494_(), (BlockState)((Block)BlockRegistry.BRUSH_AND_INKSTONE.get()).m_49966_().m_61124_((Property)DecorativeBlock.f_54117_, (Comparable)((Direction)block.m_61143_((Property)DecorativeBlock.f_54117_))), 3);
            }
        }
    }

    @SubscribeEvent
    public static void roofSnowFall(BlockEvent.NeighborNotifyEvent event) {
        BlockState blockBelow;
        Block block;
        if (event.getState().m_60713_(Blocks.f_50125_) && (block = (blockBelow = event.getLevel().m_8055_(event.getPos().m_7495_())).m_60734_()) instanceof SnowRoofRidge) {
            SnowRoofRidge ridge = (SnowRoofRidge)block;
            if ((Integer)blockBelow.m_61143_((Property)SnowRoofRidge.SNOW_LAYERS) < 15) {
                ridge.handleSnow(blockBelow, event.getLevel(), event.getPos().m_7495_());
                event.getLevel().m_7731_(event.getPos(), Blocks.f_50016_.m_49966_(), 3);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void travellingMerchantSpawnAttempt(TickEvent.LevelTickEvent event) {
        if (event.level.m_5776_() || event.phase != TickEvent.Phase.START || event.level.m_46472_() != Level.f_46428_) {
            return;
        }
        ServerLevel world = (ServerLevel)event.level;
        ServerLevelData levelData = (ServerLevelData)world.m_6106_();
        if (!(world.m_46469_().m_46207_(GameRules.f_46125_) && world.m_46469_().m_46207_(GameRules.f_46134_) && world.m_46469_().m_46207_(GameRules.f_46140_))) {
            return;
        }
        int wanderingTraderSpawnChance = levelData.m_6528_();
        if (world.m_46468_() % 24000L == 0L && world.f_46441_.m_188503_(100) < wanderingTraderSpawnChance) {
            CommonEventHandler.spawnTrader(world);
        }
    }

    private static void spawnTrader(ServerLevel world) {
        ServerPlayer player = world.m_8890_();
        if (player == null) {
            return;
        }
        BlockPos blockpos = player.m_20183_();
        world.m_8904_().m_27186_(poi -> poi.m_203565_(PoiTypeRegistry.TRADE_POI.getKey()), pos1 -> true, blockpos, 16, PoiManager.Occupancy.ANY).ifPresent(pos -> {
            BlockPos potentialSpawn = null;
            for (int i = 0; i < 10; ++i) {
                int z;
                int y;
                int x = pos.m_123341_() + world.f_46441_.m_188503_(8) - 4;
                BlockPos rolledPos = new BlockPos(x, y = world.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z = pos.m_123343_() + world.f_46441_.m_188503_(8) - 4), z);
                if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)world, (BlockPos)rolledPos, (EntityType)EntityType.f_20494_)) continue;
                potentialSpawn = rolledPos;
                break;
            }
            if (potentialSpawn == null) {
                return;
            }
            boolean hasSpaceAtSpawn = true;
            for (BlockPos blockPos : BlockPos.m_121940_(potentialSpawn, (BlockPos)potentialSpawn.m_7918_(1, 2, 1))) {
                if (world.m_8055_(blockPos).m_60812_((BlockGetter)world, blockPos).m_83281_()) continue;
                hasSpaceAtSpawn = false;
                break;
            }
            if (hasSpaceAtSpawn && !world.m_204166_(pos).m_203565_(Biomes.f_48173_)) {
                TravellingMerchant merchant = (TravellingMerchant)((EntityType)EntityTypeRegistry.TRAVELLING_MERCHANT.get()).m_262496_(world, potentialSpawn, MobSpawnType.EVENT);
                if (merchant == null) {
                    return;
                }
                merchant.m_35891_(12000);
                merchant.m_35883_(potentialSpawn);
                merchant.m_21446_(potentialSpawn, 8);
            }
        });
    }

    @SubscribeEvent
    public static void villagerTradesHandler(VillagerTradesEvent event) {
        VillagerProfession profession = event.getType();
        Int2ObjectMap trades = event.getTrades();
        if (profession == VillagerProfession.f_35595_) {
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)ItemRegistry.RAW_HEMATITE.get(), 2), 12, 10, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)ItemRegistry.MAGNESITE.get(), 2), 12, 10, 0.05f));
            ((List)trades.get(5)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 10), new ItemStack((ItemLike)ItemRegistry.JADE.get(), 1), 6, 20, 0.05f));
        }
        if (profession == VillagerProfession.f_35598_) {
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 6), new ItemStack((ItemLike)ItemRegistry.BRONZE_INGOT.get(), 1), 12, 10, 0.05f));
            ((List)trades.get(5)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 40), new ItemStack((ItemLike)ItemRegistry.CARRIAGE.get(), 1), 1, 10, 0.05f));
        }
        if (profession == VillagerProfession.f_35590_) {
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)ItemRegistry.POLISHED_ROSEWOOD_PLANK.get(), 8), 12, 5, 0.05f));
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 4), new ItemStack((ItemLike)ItemRegistry.POLISHED_EBONY_PLANK.get(), 8), 12, 5, 0.05f));
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 30), new ItemStack((ItemLike)ItemRegistry.SILK.get(), 4), 4, 10, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 20), new ItemStack((ItemLike)ItemRegistry.EMPTY_BAMBOO_TEA_BASKET.get(), 1), new ItemStack((ItemLike)ItemRegistry.BAMBOO_TEA_BASKET.get(), 1), 4, 10, 0.05f));
        }
        if (profession == VillagerProfession.f_35594_) {
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 20), new ItemStack((ItemLike)ItemRegistry.XUAN_PAPER.get(), 4), 10, 20, 0.05f));
            ((List)trades.get(5)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 30), new ItemStack((ItemLike)ItemRegistry.PORCELAIN_TEAPOT.get(), 1), 2, 20, 0.05f));
        }
        if (profession == VillagerProfession.f_35589_) {
            ((List)trades.get(5)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 40), new ItemStack((ItemLike)ItemRegistry.SUNDIAL.get(), 1), 1, 20, 0.05f));
        }
        if (profession == VillagerProfessionRegistry.COOK.get()) {
            ((List)trades.get(1)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)ItemRegistry.RAW_MEAT.get(), 10), new ItemStack((ItemLike)Items.f_42616_, 1), 12, 2, 0.05f));
            ((List)trades.get(1)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42485_, 15), new ItemStack((ItemLike)Items.f_42616_, 1), 12, 2, 0.05f));
            ((List)trades.get(1)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42579_, 15), new ItemStack((ItemLike)Items.f_42616_, 1), 12, 2, 0.05f));
            ((List)trades.get(1)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42581_, 20), new ItemStack((ItemLike)Items.f_42616_, 1), 12, 2, 0.05f));
            ((List)trades.get(1)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 8), new ItemStack((ItemLike)ItemRegistry.COOKED_MEAT.get(), 4), 12, 2, 0.05f));
            ((List)trades.get(2)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42658_, 15), new ItemStack((ItemLike)Items.f_42616_, 1), 12, 4, 0.05f));
            ((List)trades.get(2)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42697_, 15), new ItemStack((ItemLike)Items.f_42616_, 1), 12, 4, 0.05f));
            ((List)trades.get(2)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 6), new ItemStack((ItemLike)ItemRegistry.GREASE.get(), 2), 8, 5, 0.05f));
            ((List)trades.get(2)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 6), new ItemStack((ItemLike)ItemRegistry.FUR.get(), 2), 8, 5, 0.05f));
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42576_, 40), new ItemStack((ItemLike)Items.f_42616_, 2), 15, 8, 0.05f));
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42501_, 40), new ItemStack((ItemLike)Items.f_42616_, 1), 20, 8, 0.05f));
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42521_, 16), new ItemStack((ItemLike)Items.f_42616_, 1), 20, 8, 0.05f));
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 12), new ItemStack((ItemLike)ItemRegistry.MUNG_BEAN_CAKE.get(), 4), 12, 10, 0.05f));
            ((List)trades.get(3)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 12), new ItemStack((ItemLike)ItemRegistry.MOONCAKE.get(), 4), 12, 10, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 12), new ItemStack((ItemLike)ItemRegistry.CABBAGE_BASKET.get(), 1), 3, 20, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 12), new ItemStack((ItemLike)ItemRegistry.CELERY_BASKET.get(), 1), 3, 20, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 12), new ItemStack((ItemLike)ItemRegistry.ORANGE_BASKET.get(), 1), 3, 20, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 12), new ItemStack((ItemLike)ItemRegistry.APPLE_BASKET.get(), 1), 3, 20, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 12), new ItemStack((ItemLike)ItemRegistry.EGGPLANT_BASKET.get(), 1), 3, 20, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 12), new ItemStack((ItemLike)ItemRegistry.PEAR_BASKET.get(), 1), 3, 20, 0.05f));
            ((List)trades.get(4)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 5), new ItemStack((ItemLike)ItemRegistry.BAOZI.get(), 2), 6, 20, 0.05f));
            ((List)trades.get(5)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 25), new ItemStack((ItemLike)ItemRegistry.XIAOLONGBAO.get(), 1), 2, 30, 0.05f));
            ((List)trades.get(5)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 30), new ItemStack((ItemLike)ItemRegistry.WINE_POT.get(), 1), 2, 20, 0.05f));
            ((List)trades.get(5)).add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 40), new ItemStack((ItemLike)ItemRegistry.BOTTLE_GOURD.get(), 1), 1, 30, 0.05f));
        }
    }

    @SubscribeEvent
    public static void wanderingTraderHandler(WandererTradesEvent event) {
        List rareTrades = event.getRareTrades();
        rareTrades.add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 6), new ItemStack((ItemLike)ItemRegistry.INCENSE.get(), 1), 6, 30, 0.05f));
        rareTrades.add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 6), new ItemStack((ItemLike)ItemRegistry.SILK.get(), 1), 8, 30, 0.05f));
        rareTrades.add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 10), new ItemStack((ItemLike)ItemRegistry.JADE.get(), 1), 2, 30, 0.05f));
        rareTrades.add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 12), new ItemStack((ItemLike)ItemRegistry.PAINTING_SCROLL.get(), 1), 1, 30, 0.05f));
        rareTrades.add(($1, $2) -> new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, 20), new ItemStack((ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_VASE.get(), 1), 1, 30, 0.05f));
    }
}

