/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.shape.RawVoxelShape;
import com.voxelutopia.ultramarine.data.shape.ShapeFunction;
import com.voxelutopia.ultramarine.world.block.AxialBlock;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CentralAxialBlock
extends Block
implements AxialBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.f_61364_;
    protected Map<Direction.Axis, VoxelShape> shapeByAxis;
    private final boolean hasCollision;
    private final ShapeFunction shapeFunction;

    public CentralAxialBlock(BaseBlockProperty property, ShapeFunction shapeFunction, boolean hasCollision) {
        super(property.properties);
        BlockState state = (BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_(AXIS, (Comparable)Direction.Axis.X);
        this.m_49959_(state);
        this.shapeFunction = shapeFunction;
        this.hasCollision = hasCollision;
    }

    public CentralAxialBlock(BaseBlockProperty property, int thickness, int height, boolean hasCollision) {
        this(property, ShapeFunction.axialRotations(new RawVoxelShape(0.0, 0.0, (float)(16 - thickness) / 2.0f, 16.0, height, 16.0f - (float)(16 - thickness) / 2.0f)), hasCollision);
    }

    public CentralAxialBlock(BaseBlockProperty property, int thickness) {
        this(property, thickness, 16, false);
    }

    public CentralAxialBlock(BaseBlockProperty property, int thickness, int height) {
        this(property, thickness, height, true);
    }

    public CentralAxialBlock(BaseBlockProperty property, ShapeFunction shapeFunction) {
        this(property, shapeFunction, false);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeFunction.apply(pState);
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_));
        return (BlockState)state.m_61124_(AXIS, (Comparable)pContext.m_8125_().m_122427_().m_122434_());
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED});
        pBuilder.m_61104_(new Property[]{AXIS});
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.hasCollision ? this.m_5940_(pState, pLevel, pPos, pContext) : Shapes.m_83040_();
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        BlockState newState = pState;
        if (pRot == Rotation.CLOCKWISE_90 || pRot == Rotation.COUNTERCLOCKWISE_90) {
            newState = switch ((Direction.Axis)pState.m_61143_(AXIS)) {
                case Direction.Axis.X -> (BlockState)pState.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                case Direction.Axis.Z -> (BlockState)pState.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                default -> newState;
            };
        }
        return newState;
    }
}

