/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public interface DiagonallyPlaceable {
    public static final BooleanProperty DIAGONAL = ModBlockStateProperties.DIAGONAL;

    public boolean isDiagonallyPlaceable();

    default public boolean getDiagonalState(@NotNull BlockPlaceContext pContext) {
        return Math.round((pContext.m_7074_() + 180.0f) / 45.0f) % 2 == 1;
    }

    default public int getOctaRotationState(BlockPlaceContext pContext) {
        return Mth.m_14107_((double)((double)(pContext.m_7074_() * 8.0f / 360.0f) + 0.5)) & 7;
    }

    default public Pair<Direction, Direction> getMainAndShiftedDirections(BlockPlaceContext pContext) {
        int rotation = this.getOctaRotationState(pContext);
        return switch (rotation) {
            default -> Pair.of((Object)Direction.NORTH, (Object)Direction.NORTH);
            case 1 -> Pair.of((Object)Direction.NORTH, (Object)Direction.EAST);
            case 2 -> Pair.of((Object)Direction.EAST, (Object)Direction.EAST);
            case 3 -> Pair.of((Object)Direction.EAST, (Object)Direction.SOUTH);
            case 4 -> Pair.of((Object)Direction.SOUTH, (Object)Direction.SOUTH);
            case 5 -> Pair.of((Object)Direction.SOUTH, (Object)Direction.WEST);
            case 6 -> Pair.of((Object)Direction.WEST, (Object)Direction.WEST);
            case 7 -> Pair.of((Object)Direction.WEST, (Object)Direction.NORTH);
        };
    }

    default public void defineDiagonalProperty(StateDefinition.Builder<Block, BlockState> pBuilder) {
        if (this.isDiagonallyPlaceable()) {
            pBuilder.m_61104_(new Property[]{DIAGONAL});
        }
    }

    default public BlockState setDiagonalStateForPlacement(@NotNull BlockState state, BlockPlaceContext pContext) {
        return this.isDiagonallyPlaceable() ? (BlockState)state.m_61124_((Property)DIAGONAL, (Comparable)Boolean.valueOf(this.getDiagonalState(pContext))) : state;
    }
}

