/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.shape.RawVoxelShape;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.BaseBlockPropertyHolder;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class LongTableBlock
extends Block
implements BaseBlockPropertyHolder {
    public static final EnumProperty<Direction.Axis> AXIS = EnumProperty.m_61598_((String)"axis", Direction.Axis.class, (Enum[])new Direction.Axis[]{Direction.Axis.X, Direction.Axis.Z});
    public static final BooleanProperty LEFT = ModBlockStateProperties.LEFT;
    public static final BooleanProperty RIGHT = ModBlockStateProperties.RIGHT;
    protected final BaseBlockProperty property;
    private static final RawVoxelShape SURFACE = new RawVoxelShape(0.0, 14.0, 0.0, 16.0, 16.0, 16.0);
    private static final RawVoxelShape SURFACE_SINGLE_X = new RawVoxelShape(-4.0, 14.0, 0.0, 20.0, 16.0, 16.0);
    private static final RawVoxelShape LEGS_SINGLE_X_LEFT = new RawVoxelShape(17.5, 0.0, 0.5, 19.5, 16.0, 15.5);
    private static final RawVoxelShape LEGS_LONG_X_LEFT = new RawVoxelShape(13.5, 0.0, 0.5, 15.5, 16.0, 15.5);
    private static final Function<BlockState, VoxelShape> SHAPE_FUNCTION = Util.m_143827_(blockstate -> {
        boolean x;
        boolean left = (Boolean)blockstate.m_61143_((Property)LEFT);
        boolean right = (Boolean)blockstate.m_61143_((Property)RIGHT);
        boolean bl = x = blockstate.m_61143_(AXIS) == Direction.Axis.X;
        if (left && right) {
            return SURFACE.copy().toVoxelShape();
        }
        if (!left && !right) {
            return x ? Shapes.m_83124_((VoxelShape)SURFACE_SINGLE_X.copy().toVoxelShape(), (VoxelShape[])new VoxelShape[]{LEGS_SINGLE_X_LEFT.copy().toVoxelShape(), LEGS_SINGLE_X_LEFT.copy().mirrorZ().toVoxelShape()}) : Shapes.m_83124_((VoxelShape)SURFACE_SINGLE_X.copy().rotateY(90.0f).toVoxelShape(), (VoxelShape[])new VoxelShape[]{LEGS_SINGLE_X_LEFT.copy().rotateY(90.0f).toVoxelShape(), LEGS_SINGLE_X_LEFT.copy().mirrorZ().rotateY(90.0f).toVoxelShape()});
        }
        if (right) {
            return x ? Shapes.m_83110_((VoxelShape)SURFACE.copy().toVoxelShape(), (VoxelShape)LEGS_LONG_X_LEFT.copy().toVoxelShape()) : Shapes.m_83110_((VoxelShape)SURFACE.copy().toVoxelShape(), (VoxelShape)LEGS_LONG_X_LEFT.copy().rotateY(90.0f).toVoxelShape());
        }
        return x ? Shapes.m_83110_((VoxelShape)SURFACE.copy().toVoxelShape(), (VoxelShape)LEGS_LONG_X_LEFT.copy().mirrorZ().toVoxelShape()) : Shapes.m_83110_((VoxelShape)SURFACE.copy().toVoxelShape(), (VoxelShape)LEGS_LONG_X_LEFT.copy().mirrorZ().rotateY(90.0f).toVoxelShape());
    });

    public LongTableBlock(BaseBlockProperty property) {
        super(property.properties);
        this.property = property;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{AXIS, LEFT, RIGHT});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction.Axis axis = pContext.m_8125_().m_122427_().m_122434_();
        return (BlockState)((BlockState)((BlockState)Objects.requireNonNull(super.m_5573_(pContext)).m_61124_(AXIS, (Comparable)axis)).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false));
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        this.update(pLevel, pPos, new HashSet<BlockPos>());
    }

    private void update(Level level, BlockPos pos, Set<BlockPos> visited) {
        ArrayList<BlockPos> toVisit = new ArrayList<BlockPos>();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockPos neighbor = pos.m_7918_(x, 0, z);
                toVisit.add(neighbor);
            }
        }
        for (BlockPos p : toVisit) {
            if (visited.contains(p)) continue;
            visited.add(p);
            if (!this.isTableBlock(level, p)) continue;
            this.updateState(level, p);
            this.update(level, p, visited);
        }
    }

    private void updateState(Level level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return;
        }
        BlockState state = level.m_8055_(pos);
        BlockPos east = pos.m_122029_();
        BlockPos west = pos.m_122024_();
        boolean isTableAtEast = this.isTableBlock(level, east);
        boolean isTableAtWest = this.isTableBlock(level, west);
        if (isTableAtEast || isTableAtWest) {
            state = (BlockState)((BlockState)((BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.X)).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(isTableAtEast))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(isTableAtWest));
        } else {
            BlockPos north = pos.m_122012_();
            BlockPos south = pos.m_122019_();
            boolean isTableAtNorth = this.isTableBlock(level, north);
            boolean isTableAtSouth = this.isTableBlock(level, south);
            state = (BlockState)((BlockState)state.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(isTableAtNorth))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(isTableAtSouth));
            if (isTableAtNorth || isTableAtSouth) {
                state = (BlockState)state.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
            }
        }
        level.m_7731_(pos, state, 3);
    }

    private boolean isTableBlock(Level level, BlockPos pos) {
        if (!level.m_46749_(pos)) {
            return false;
        }
        return level.m_8055_(pos).m_60734_() == this;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        BlockState newState = pState;
        if (pRot == Rotation.CLOCKWISE_90 || pRot == Rotation.COUNTERCLOCKWISE_90) {
            newState = switch ((Direction.Axis)pState.m_61143_(AXIS)) {
                case Direction.Axis.X -> (BlockState)pState.m_61124_(AXIS, (Comparable)Direction.Axis.Z);
                case Direction.Axis.Z -> (BlockState)pState.m_61124_(AXIS, (Comparable)Direction.Axis.X);
                default -> newState;
            };
        } else if (pRot == Rotation.CLOCKWISE_180) {
            newState = (BlockState)((BlockState)pState.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf((Boolean)pState.m_61143_((Property)LEFT) == false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf((Boolean)pState.m_61143_((Property)RIGHT) == false));
        }
        return newState;
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return (BlockState)((BlockState)pState.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf((Boolean)pState.m_61143_((Property)LEFT) == false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf((Boolean)pState.m_61143_((Property)RIGHT) == false));
    }

    @Override
    public BaseBlockProperty getProperty() {
        return this.property;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_FUNCTION.apply(pState);
    }
}

