/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.shape.RawVoxelShape;
import com.voxelutopia.ultramarine.data.shape.ShapeFunction;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.SideBlock;
import com.voxelutopia.ultramarine.world.block.WallSideBlock;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import com.voxelutopia.ultramarine.world.block.state.OrientableBlockType;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OrientableWallSideBlock
extends WallSideBlock
implements SideBlock {
    public static final EnumProperty<OrientableBlockType> TYPE = ModBlockStateProperties.ORIENTABLE_BLOCK_TYPE;
    private final ShapeFunction shapeFunction;

    public OrientableWallSideBlock(BaseBlockProperty property) {
        this(property, ShapeFunction.sideOrientedShape(new RawVoxelShape(0.0, 0.0, 15.0, 16.0, 16.0, 16.0)));
    }

    public OrientableWallSideBlock(BaseBlockProperty property, ShapeFunction shapeFunction) {
        super(property);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_(TYPE, (Comparable)((Object)OrientableBlockType.LEFT))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeFunction = shapeFunction;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState state = this.m_49966_();
        FluidState fluidstate = pContext.m_43725_().m_6425_(pContext.m_8083_());
        Direction faceDir = pContext.m_43719_();
        Direction[] lookDirs = pContext.m_6232_();
        if (faceDir.m_122434_().m_122479_()) {
            state = (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)faceDir)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
            for (Direction dir : lookDirs) {
                if (!dir.m_122434_().m_122479_() || dir == faceDir || dir == faceDir.m_122424_()) continue;
                if (dir == faceDir.m_122424_().m_122427_()) {
                    state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)OrientableBlockType.LEFT));
                }
                if (dir != faceDir.m_122424_().m_122428_()) continue;
                state = (BlockState)state.m_61124_(TYPE, (Comparable)((Object)OrientableBlockType.RIGHT));
            }
            return state;
        }
        return null;
    }

    @Override
    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeFunction.apply(pState);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{TYPE});
    }

    @Override
    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    @Override
    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        BlockState newState = pState;
        if (pMirror != Mirror.NONE) {
            newState = (BlockState)newState.m_61124_(TYPE, (Comparable)((Object)((OrientableBlockType)((Object)pState.m_61143_(TYPE))).getOpposite()));
        }
        newState = (BlockState)newState.m_61124_((Property)FACING, (Comparable)pMirror.m_54842_().m_56528_((Direction)pState.m_61143_((Property)FACING)));
        return newState;
    }
}

