/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.shape.RawVoxelShape;
import com.voxelutopia.ultramarine.data.shape.ShapeFunction;
import com.voxelutopia.ultramarine.world.block.AxialBlock;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.BaseHorizontalDirectionalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SideAxialBlock
extends BaseHorizontalDirectionalBlock
implements AxialBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final ShapeFunction shapeFunction;
    private final boolean hasCollision;

    public SideAxialBlock(BaseBlockProperty property, ShapeFunction shapeFunction, boolean hasCollision) {
        super(property);
        BlockState state = (BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).m_61124_((Property)FACING, (Comparable)Direction.NORTH);
        this.m_49959_(state);
        this.shapeFunction = shapeFunction;
        this.hasCollision = hasCollision;
    }

    public SideAxialBlock(BaseBlockProperty property, int thickness, int height, boolean hasCollision) {
        this(property, ShapeFunction.cardinalRotations(new RawVoxelShape((float)(16 - thickness) / 2.0f, 0.0, 0.0, 16.0f - (float)(16 - thickness) / 2.0f, height, 16.0)), hasCollision);
    }

    public SideAxialBlock(BaseBlockProperty property, int thickness) {
        this(property, thickness, 16, false);
    }

    public SideAxialBlock(BaseBlockProperty property, ShapeFunction shape) {
        this(property, shape, false);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapeFunction.apply(pState);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_));
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{WATERLOGGED});
        pBuilder.m_61104_(new Property[]{FACING});
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.hasCollision ? this.m_5940_(pState, pLevel, pPos, pContext) : Shapes.m_83040_();
    }
}

