/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block.entity;

import com.voxelutopia.ultramarine.data.registry.BlockEntityRegistry;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class BottleGourdBlockEntity
extends BlockEntity {
    public static final int MAX_CHARGE = 6;
    private Potion potion;
    private int charges;
    private boolean filled;

    public BottleGourdBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.BOTTLE_GOURD.get(), pos, state);
    }

    public boolean addPotionCharge(Potion potion) {
        if (!this.filled) {
            this.potion = potion;
            this.charges = 1;
            this.filled = true;
            return true;
        }
        if (potion.equals(this.potion) && this.charges < 6) {
            ++this.charges;
            return true;
        }
        return false;
    }

    public Optional<Potion> takePotionCharge() {
        if (!this.filled || this.charges <= 0 || this.potion.equals(Potions.f_43598_)) {
            return Optional.empty();
        }
        Potion charge = this.potion;
        --this.charges;
        if (this.charges <= 0) {
            this.filled = false;
            this.potion = Potions.f_43598_;
        }
        return Optional.of(charge);
    }

    public boolean hasCharges() {
        return this.filled && this.charges > 0 && !this.potion.equals(Potions.f_43598_);
    }

    public int getCharges() {
        return this.charges;
    }

    public Potion getPotion() {
        return this.potion;
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.potion = Potion.m_43489_((String)pTag.m_128461_("Potion"));
        this.charges = pTag.m_128451_("Charges");
        this.filled = pTag.m_128471_("Filled");
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128359_("Potion", ForgeRegistries.POTIONS.getKey((Object)this.potion).toString());
        pTag.m_128405_("Charges", this.charges);
        pTag.m_128379_("Filled", this.filled);
    }
}

