/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block.menu;

import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import com.voxelutopia.ultramarine.data.registry.MenuTypeRegistry;
import com.voxelutopia.ultramarine.data.registry.RecipeTypeRegistry;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class BrickKilnMenu
extends AbstractContainerMenu {
    public static final int SLOT_INPUT_PRIMARY = 0;
    public static final int SLOT_INPUT_SECONDARY = 1;
    public static final int SLOT_FUEL = 2;
    public static final int SLOT_RESULT = 3;
    private static final int INV_SLOT_START = 4;
    private static final int INV_SLOT_END = 31;
    private static final int USE_ROW_SLOT_START = 31;
    private static final int USE_ROW_SLOT_END = 40;
    private final BlockEntity blockEntity;
    private final Player playerEntity;
    private final IItemHandler storage;
    private final IItemHandler inventory;
    private final ContainerData data;

    public BrickKilnMenu(int pId, BlockPos pos, Inventory inventory) {
        this(pId, pos, inventory, (IItemHandler)new ItemStackHandler(4), (ContainerData)new SimpleContainerData(4));
    }

    public BrickKilnMenu(int id, BlockPos pos, Inventory inventory, IItemHandler container, ContainerData containerData) {
        super((MenuType)MenuTypeRegistry.BRICK_KILN.get(), id);
        this.playerEntity = inventory.f_35978_;
        this.blockEntity = this.playerEntity.m_20193_().m_7702_(pos);
        this.storage = container;
        this.inventory = new InvWrapper((Container)inventory);
        this.data = containerData;
        this.m_38897_((Slot)new IngredientSlot(this.storage, 0, 46, 17));
        this.m_38897_((Slot)new IngredientSlot(this.storage, 1, 66, 17));
        this.m_38897_((Slot)new FuelSlot(this.storage, 2, 56, 53));
        this.m_38897_((Slot)new OutputSlot(this.storage, 3, 116, 35));
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 9; ++c) {
                this.m_38897_((Slot)new SlotItemHandler(this.inventory, c + r * 9 + 9, 8 + c * 18, 84 + r * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_((Slot)new SlotItemHandler(this.inventory, k, 8 + k * 18, 142));
        }
        this.m_38884_(this.data);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            itemstack = slotItem.m_41777_();
            if (pIndex == 3) {
                if (!this.m_38903_(slotItem, 4, 40, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotItem, itemstack);
            } else if (pIndex != 2 && pIndex != 0 && pIndex != 1 ? (this.canProcess(slotItem) ? !this.m_38903_(slotItem, 0, 2, false) : (BrickKilnMenu.isFuel(slotItem) ? !this.m_38903_(slotItem, 2, 3, false) : (pIndex >= 4 && pIndex < 31 ? !this.m_38903_(slotItem, 31, 40, false) : pIndex >= 31 && pIndex < 40 && !this.m_38903_(slotItem, 4, 31, false)))) : !this.m_38903_(slotItem, 4, 40, false)) {
                return ItemStack.f_41583_;
            }
            if (slotItem.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotItem.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, slotItem);
        }
        return itemstack;
    }

    protected boolean canProcess(ItemStack item) {
        return this.blockEntity.m_58904_().m_7465_().m_44013_((RecipeType)RecipeTypeRegistry.COMPOSITE_SMELTING.get()).stream().anyMatch(recipe -> recipe.partialMatch((Container)new SimpleContainer(new ItemStack[]{item}), this.blockEntity.m_58904_()));
    }

    public boolean m_6875_(Player pPlayer) {
        return BrickKilnMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_()), (Player)this.playerEntity, (Block)((Block)BlockRegistry.BRICK_KILN.get()));
    }

    public boolean isLit() {
        return this.data.m_6413_(0) > 0;
    }

    public int getBurnProgress() {
        int i = this.data.m_6413_(2);
        int j = this.data.m_6413_(3);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getLitProgress() {
        int i = this.data.m_6413_(1);
        if (i == 0) {
            i = 200;
        }
        return this.data.m_6413_(0) * 13 / i;
    }

    private static boolean isFuel(@NotNull ItemStack stack) {
        return ForgeHooks.getBurnTime((ItemStack)stack, (RecipeType)RecipeType.f_44108_) > 0;
    }

    static class IngredientSlot
    extends SlotItemHandler {
        public IngredientSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }
    }

    static class FuelSlot
    extends SlotItemHandler {
        public FuelSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return BrickKilnMenu.isFuel(stack);
        }
    }

    static class OutputSlot
    extends SlotItemHandler {
        public OutputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return false;
        }
    }
}

