/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block.menu;

import com.voxelutopia.ultramarine.Ultramarine;
import com.voxelutopia.ultramarine.data.ModItemTags;
import com.voxelutopia.ultramarine.data.recipe.ChiselTableRecipe;
import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import com.voxelutopia.ultramarine.data.registry.MenuTypeRegistry;
import com.voxelutopia.ultramarine.data.registry.RecipeTypeRegistry;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class ChiselTableMenu
extends AbstractContainerMenu {
    public static final int SLOT_MATERIAL = 0;
    public static final int SLOT_TEMPLATE = 1;
    public static final int SLOT_COLOR_START = 2;
    public static final int SLOT_COLOR_END = 6;
    public static final int SLOT_RESULT = 6;
    private static final int INV_SLOT_START = 7;
    private static final int INV_SLOT_END = 34;
    private static final int USE_ROW_SLOT_START = 34;
    private static final int USE_ROW_SLOT_END = 43;
    private static final Predicate<ItemStack> IS_WOOD = i -> i.m_204117_(ItemTags.f_13182_) || i.m_204117_(ModItemTags.POLISHED_PLANKS);
    private static final Predicate<ItemStack> IS_TEMPLATE = i -> i.m_204117_(ModItemTags.CHISEL_TEMPLATES);
    private static final Predicate<ItemStack> IS_COLOR = i -> i.m_204117_(ModItemTags.FORGE_DYES) || i.m_204117_(ModItemTags.DYE_POWDER);
    private final ContainerLevelAccess access;
    private final Player player;
    private final ItemStackHandler crafting = new ItemStackHandler(6);
    private final ItemStackHandler result = new ItemStackHandler(1);
    private final IItemHandler inventory;

    public ChiselTableMenu(int id, Inventory inventory) {
        this(id, inventory, ContainerLevelAccess.f_39287_);
    }

    public ChiselTableMenu(int id, Inventory inventory, ContainerLevelAccess access) {
        super((MenuType)MenuTypeRegistry.CHISEL_TABLE.get(), id);
        this.inventory = new InvWrapper((Container)inventory);
        this.access = access;
        this.player = inventory.f_35978_;
        this.m_38897_((Slot)new MaterialSlot((IItemHandler)this.crafting, 0, 26, 25));
        this.m_38897_((Slot)new TemplateSlot((IItemHandler)this.crafting, 1, 53, 25));
        int i = 2;
        int j = 0;
        while (i < 6) {
            this.m_38897_((Slot)new DyeSlot((IItemHandler)this.crafting, i, 26 + j * 18, 52));
            ++i;
            ++j;
        }
        this.m_38897_((Slot)new OutputSlot((IItemHandler)this.result, 0, 130, 34));
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 9; ++c) {
                this.m_38897_((Slot)new SlotItemHandler(this.inventory, c + r * 9 + 9, 8 + c * 18, 84 + r * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_((Slot)new SlotItemHandler(this.inventory, k, 8 + k * 18, 142));
        }
    }

    public void slotsChanged(SlotItemHandler slot) {
        this.m_38946_();
        if (slot.getSlotIndex() <= 6) {
            this.createResult();
        }
    }

    public void createResult() {
        Level level = this.player.m_9236_();
        Container ingredients = this.wrapIngredients();
        List list = level.m_7465_().m_44056_((RecipeType)RecipeTypeRegistry.CHISEL_TABLE.get(), ingredients, level);
        if (list.size() > 1) {
            Ultramarine.getLogger().warn("Duplicate chisel table recipe: ");
            list.forEach(recipe -> Ultramarine.getLogger().warn(recipe.m_6423_().m_135815_()));
        }
        if (list.isEmpty()) {
            this.result.setStackInSlot(0, ItemStack.f_41583_);
        } else {
            ChiselTableRecipe recipe2 = (ChiselTableRecipe)list.get(0);
            ItemStack resultItemStack = recipe2.m_5874_(ingredients, level.m_9598_());
            this.result.setStackInSlot(0, resultItemStack);
        }
    }

    protected void onTake(Player player, ItemStack itemStack, SlotItemHandler slot) {
        for (int i = 0; i < 6; ++i) {
            ItemStack item = this.crafting.getStackInSlot(i);
            this.crafting.setStackInSlot(i, item);
            if (i == 1) continue;
            item.m_41774_(1);
        }
        this.slotsChanged(slot);
    }

    public ItemStack m_7648_(Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            itemstack = slotItem.m_41777_();
            if (pIndex == 6) {
                slotItem.m_41720_().m_7836_(slotItem, pPlayer.m_9236_(), pPlayer);
                if (!this.m_38903_(slotItem, 7, 43, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(slotItem, itemstack);
            } else if (pIndex > 6 ? (IS_WOOD.test(slotItem) ? !this.m_38903_(slotItem, 0, 1, false) : (IS_TEMPLATE.test(slotItem) ? !this.m_38903_(slotItem, 1, 2, false) : (IS_COLOR.test(slotItem) ? !this.m_38903_(slotItem, 2, 6, false) : (pIndex < 34 ? !this.m_38903_(slotItem, 34, 43, false) : pIndex < 43 && !this.m_38903_(slotItem, 7, 34, false))))) : !this.m_38903_(slotItem, 7, 43, false)) {
                return ItemStack.f_41583_;
            }
            if (slotItem.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            slot.m_6654_();
            if (slotItem.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, slotItem);
            this.m_38946_();
        }
        return itemstack;
    }

    public boolean m_5882_(ItemStack pStack, Slot pSlot) {
        return ((SlotItemHandler)pSlot).getItemHandler() != this.result && super.m_5882_(pStack, pSlot);
    }

    public void m_6877_(Player pPlayer) {
        super.m_6877_(pPlayer);
        this.access.m_39292_((level, blockPos) -> this.m_150411_(pPlayer, this.wrapIngredients()));
    }

    private Container wrapIngredients() {
        SimpleContainer container = new SimpleContainer(6);
        for (int i = 0; i < 6; ++i) {
            container.m_6836_(i, this.crafting.getStackInSlot(i));
        }
        return container;
    }

    public boolean m_6875_(Player pPlayer) {
        return ChiselTableMenu.m_38889_((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)BlockRegistry.CHISEL_TABLE.get()));
    }

    class MaterialSlot
    extends IngredientSlot {
        public MaterialSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return IS_WOOD.test(stack);
        }
    }

    class TemplateSlot
    extends IngredientSlot {
        public TemplateSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return IS_TEMPLATE.test(stack);
        }
    }

    class DyeSlot
    extends IngredientSlot {
        public DyeSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return IS_COLOR.test(stack);
        }
    }

    class OutputSlot
    extends SlotItemHandler {
        public OutputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean m_5857_(@Nonnull ItemStack stack) {
            return false;
        }

        public void m_142406_(Player pPlayer, ItemStack pStack) {
            super.m_142406_(pPlayer, pStack);
            ChiselTableMenu.this.onTake(pPlayer, pStack, this);
        }

        public void m_6654_() {
            super.m_6654_();
            ChiselTableMenu.this.slotsChanged(this);
        }

        public void m_40234_(@NotNull ItemStack oldStackIn, @NotNull ItemStack newStackIn) {
            int i = newStackIn.m_41613_() - oldStackIn.m_41613_();
            if (i > 0) {
                this.m_7169_(newStackIn, i);
            }
        }
    }

    class IngredientSlot
    extends SlotItemHandler {
        public IngredientSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public void m_6654_() {
            super.m_6654_();
            ChiselTableMenu.this.slotsChanged(this);
        }
    }
}

