/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.client.integration.jade;

import com.voxelutopia.ultramarine.world.block.entity.BrickKilnBlockEntity;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

public enum BrickKilnComponent implements IBlockComponentProvider,
StreamServerDataProvider<BlockAccessor, Data>
{
    INSTANCE;

    public static final ResourceLocation BRICK_KILN;

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Data data = this.decodeFromData((Accessor)accessor).orElse(null);
        if (data != null) {
            IElementHelper helper = IElementHelper.get();
            tooltip.add(helper.item(data.inventory.get(0)));
            tooltip.append(helper.item(data.inventory.get(1)));
            tooltip.append(helper.spacer(4, 0));
            tooltip.append(helper.progress((float)data.progress / (float)data.total).translate(new Vec2(-2.0f, 0.0f)));
            tooltip.append(helper.item(data.inventory.get(2)));
        }
    }

    public Data streamData(BlockAccessor accessor) {
        BrickKilnBlockEntity kiln = (BrickKilnBlockEntity)accessor.getBlockEntity();
        return new Data(kiln.getCookingProgress(), kiln.getCookingTotalTime(), List.of(kiln.getItem(0), kiln.getItem(1), kiln.getItem(3)));
    }

    public ResourceLocation getUid() {
        return BRICK_KILN;
    }

    public StreamCodec<RegistryFriendlyByteBuf, Data> streamCodec() {
        return Data.STREAM_CODEC;
    }

    static {
        BRICK_KILN = ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)"brick_kiln");
    }

    public record Data(int progress, int total, List<ItemStack> inventory) {
        public static final StreamCodec<RegistryFriendlyByteBuf, Data> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, Data::progress, (StreamCodec)ByteBufCodecs.VAR_INT, Data::total, (StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, Data::inventory, Data::new);
    }
}

