/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.data.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.voxelutopia.ultramarine.data.registry.RecipeSerializerRegistry;
import com.voxelutopia.ultramarine.data.registry.RecipeTypeRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ChiselTableRecipe
implements Recipe<RecipeInput> {
    protected final String group;
    protected final Ingredient material;
    protected final Ingredient template;
    protected final List<Ingredient> colors;
    protected final ItemStack result;

    public ChiselTableRecipe(String pGroup, Ingredient material, Ingredient template, List<Ingredient> colors, ItemStack pResult) {
        this.group = pGroup;
        this.material = material;
        this.template = template;
        this.colors = colors;
        this.result = pResult;
    }

    public boolean matches(RecipeInput pContainer, @NotNull Level pLevel) {
        ItemStack usedMaterial = pContainer.getItem(0);
        ItemStack usedTemplate = pContainer.getItem(1);
        List<Object> usedColors = Arrays.asList(ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY, ItemStack.EMPTY);
        int i = 0;
        for (int j = 2; j < pContainer.size(); ++j) {
            usedColors.set(i, pContainer.getItem(j));
            ++i;
        }
        usedColors = usedColors.stream().filter(item -> !item.isEmpty()).collect(Collectors.toList());
        return this.material.test(usedMaterial) && this.template.test(usedTemplate) && ChiselTableRecipe.compareColors(this.colors, usedColors);
    }

    @NotNull
    public ItemStack assemble(@NotNull RecipeInput pContainer, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryAccess) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registryAccess) {
        return this.result.copy();
    }

    public Ingredient getMaterial() {
        return this.material;
    }

    public Ingredient getTemplate() {
        return this.template;
    }

    public List<Ingredient> getColors() {
        return this.colors;
    }

    public ItemStack getResult() {
        return this.result;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RecipeSerializerRegistry.CHISEL_TABLE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)RecipeTypeRegistry.CHISEL_TABLE.get();
    }

    private static boolean compareColors(List<Ingredient> recipeColors, List<ItemStack> usedColors) {
        if (recipeColors.size() != usedColors.size()) {
            return false;
        }
        ArrayList<ItemStack> usedColorsReverse = new ArrayList<ItemStack>(usedColors);
        Collections.reverse(usedColorsReverse);
        boolean fwd = true;
        boolean rvs = true;
        for (int i = 0; i < recipeColors.size(); ++i) {
            fwd = recipeColors.get(i).test(usedColors.get(i)) && fwd;
            rvs = recipeColors.get(i).test((ItemStack)usedColorsReverse.get(i)) && rvs;
        }
        return fwd || rvs;
    }

    public static enum Serializer implements RecipeSerializer<ChiselTableRecipe>
    {
        INSTANCE;

        public static final MapCodec<ChiselTableRecipe> CODEC;
        public static final StreamCodec<RegistryFriendlyByteBuf, ChiselTableRecipe> STREAM_CODEC;

        @NotNull
        public MapCodec<ChiselTableRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ChiselTableRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        static {
            CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(Recipe::getGroup), (App)Ingredient.CODEC.fieldOf("material").forGetter(ChiselTableRecipe::getMaterial), (App)Ingredient.CODEC.fieldOf("template").forGetter(ChiselTableRecipe::getTemplate), (App)Ingredient.LIST_CODEC.fieldOf("colors").forGetter(ChiselTableRecipe::getColors), (App)ItemStack.CODEC.fieldOf("result").forGetter(ChiselTableRecipe::getResult)).apply((Applicative)i, ChiselTableRecipe::new));
            STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, Recipe::getGroup, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ChiselTableRecipe::getMaterial, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ChiselTableRecipe::getTemplate, (StreamCodec)ByteBufCodecs.list().apply(Ingredient.CONTENTS_STREAM_CODEC), ChiselTableRecipe::getColors, (StreamCodec)ItemStack.STREAM_CODEC, ChiselTableRecipe::getResult, ChiselTableRecipe::new);
        }
    }
}

