/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.data.registry;

import com.voxelutopia.ultramarine.data.ModCreativeTab;
import com.voxelutopia.ultramarine.data.registry.ItemRegistry;
import java.util.Collection;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="ultramarine")
public class CreativeTabRegistry {
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"ultramarine");
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> MATERIALS = CREATIVE_TABS.register("materials", () -> CreativeModeTab.builder().title(CreativeTabRegistry.itemGroupName("materials")).icon(() -> ((Item)((Item)ItemRegistry.CYAN_BRICK.get())).getDefaultInstance()).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).displayItems((displayParameters, output) -> CreativeTabRegistry.getItemsFromTab(ModCreativeTab.MATERIALS).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> TOOLS = CREATIVE_TABS.register("tools", () -> CreativeModeTab.builder().title(CreativeTabRegistry.itemGroupName("tools")).icon(() -> ((Item)((Item)ItemRegistry.WOODEN_MALLET.get())).getDefaultInstance()).withTabsBefore(new ResourceKey[]{MATERIALS.getKey()}).displayItems((displayParameters, output) -> CreativeTabRegistry.getItemsFromTab(ModCreativeTab.TOOLS).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> BUILDING_BLOCKS = CREATIVE_TABS.register("building_blocks", () -> CreativeModeTab.builder().title(CreativeTabRegistry.itemGroupName("building_blocks")).icon(() -> ((Item)((Item)ItemRegistry.CYAN_BRICKS.get())).getDefaultInstance()).withTabsBefore(new ResourceKey[]{TOOLS.getKey()}).displayItems((displayParameters, output) -> CreativeTabRegistry.getItemsFromTab(ModCreativeTab.BUILDING_BLOCKS).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> DECORATIVE_BLOCKS = CREATIVE_TABS.register("decorative_blocks", () -> CreativeModeTab.builder().title(CreativeTabRegistry.itemGroupName("decorative_blocks")).icon(() -> ((Item)((Item)ItemRegistry.CARVED_RED_PILLAR_BASE.get())).getDefaultInstance()).withTabsBefore(new ResourceKey[]{BUILDING_BLOCKS.getKey()}).displayItems((displayParameters, output) -> CreativeTabRegistry.getItemsFromTab(ModCreativeTab.DECORATIVE_BLOCKS).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> DECORATIONS = CREATIVE_TABS.register("decorations", () -> CreativeModeTab.builder().title(CreativeTabRegistry.itemGroupName("decorations")).icon(() -> ((Item)((Item)ItemRegistry.LARGE_BLUE_AND_WHITE_PORCELAIN_VASE.get())).getDefaultInstance()).withTabsBefore(new ResourceKey[]{DECORATIVE_BLOCKS.getKey()}).displayItems((displayParameters, output) -> CreativeTabRegistry.getItemsFromTab(ModCreativeTab.DECORATIONS).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> FURNITURE = CREATIVE_TABS.register("furniture", () -> CreativeModeTab.builder().title(CreativeTabRegistry.itemGroupName("furniture")).icon(() -> ((Item)((Item)ItemRegistry.OAK_CABINET.get())).getDefaultInstance()).withTabsBefore(new ResourceKey[]{DECORATIONS.getKey()}).displayItems((displayParameters, output) -> CreativeTabRegistry.getItemsFromTab(ModCreativeTab.FURNITURE).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> WINDOWS_AND_DOORS = CREATIVE_TABS.register("windows_and_doors", () -> CreativeModeTab.builder().title(CreativeTabRegistry.itemGroupName("windows_and_doors")).icon(() -> ((Item)((Item)ItemRegistry.CARVED_WOODEN_DOOR.get())).getDefaultInstance()).withTabsBefore(new ResourceKey[]{FURNITURE.getKey()}).displayItems((displayParameters, output) -> CreativeTabRegistry.getItemsFromTab(ModCreativeTab.WINDOWS_AND_DOORS).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> LAMPS = CREATIVE_TABS.register("lamps", () -> CreativeModeTab.builder().title(CreativeTabRegistry.itemGroupName("lamps")).icon(() -> ((Item)((Item)ItemRegistry.OCTAGONAL_PALACE_LANTERN.get())).getDefaultInstance()).withTabsBefore(new ResourceKey[]{WINDOWS_AND_DOORS.getKey()}).displayItems((displayParameters, output) -> CreativeTabRegistry.getItemsFromTab(ModCreativeTab.LAMPS).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());
    public static DeferredHolder<CreativeModeTab, CreativeModeTab> PLANTS = CREATIVE_TABS.register("plants", () -> CreativeModeTab.builder().title(CreativeTabRegistry.itemGroupName("plants")).icon(() -> ((Item)((Item)ItemRegistry.MEDIUM_LOTUS.get())).getDefaultInstance()).withTabsBefore(new ResourceKey[]{LAMPS.getKey()}).displayItems((displayParameters, output) -> CreativeTabRegistry.getItemsFromTab(ModCreativeTab.PLANTS).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0))).build());

    @SubscribeEvent
    public static void buildCreativeTab(BuildCreativeModeTabContentsEvent event) {
    }

    private static Component itemGroupName(String name) {
        return Component.translatable((String)("item_group.ultramarine." + name));
    }

    private static Collection<ItemStack> getItemsFromTab(ModCreativeTab tab) {
        return ModCreativeTab.getItemsFromSet(tab).stream().map(DeferredHolder::get).map(Item::getDefaultInstance).toList();
    }
}

