/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.datagen;

import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import com.voxelutopia.ultramarine.data.registry.ItemRegistry;
import com.voxelutopia.ultramarine.world.block.BaseFence;
import com.voxelutopia.ultramarine.world.block.BaseWall;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final List<DeferredHolder<Block, ? extends Block>> NON_SIMPLE_BLOCKS = new ArrayList<DeferredHolder<Block, ? extends Block>>();
    private static final List<DeferredHolder<Item, ? extends Item>> NON_SIMPLE_ITEMS = new ArrayList<DeferredHolder<Item, ? extends Item>>();

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "ultramarine", existingFileHelper);
    }

    protected void registerModels() {
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> !NON_SIMPLE_BLOCKS.contains(blockRegistryObject)).forEach(this::blockItem);
        this.wallInventory(ModItemModelProvider.name((Block)BlockRegistry.BLACK_BRICK_WALL.get()), this.blockLoc((Block)BlockRegistry.BLACK_BRICKS.get()));
        this.wallInventory(ModItemModelProvider.name((Block)BlockRegistry.CYAN_BRICK_WALL.get()), this.blockLoc((Block)BlockRegistry.CYAN_BRICKS.get()));
        this.wallInventory(ModItemModelProvider.name((Block)BlockRegistry.CYAN_FLOOR_TILE_WALL.get()), this.blockLoc((Block)BlockRegistry.CYAN_FLOOR_TILE.get()));
        this.wallInventory(ModItemModelProvider.name((Block)BlockRegistry.DARK_CYAN_FLOOR_TILE_WALL.get()), this.blockLoc((Block)BlockRegistry.DARK_CYAN_FLOOR_TILE.get()));
        this.wallInventory(ModItemModelProvider.name((Block)BlockRegistry.LIGHT_CYAN_FLOOR_TILE_WALL.get()), this.blockLoc((Block)BlockRegistry.LIGHT_CYAN_FLOOR_TILE.get()));
        this.wallInventory(ModItemModelProvider.name((Block)BlockRegistry.WEATHERED_RED_STONE_TILE_WALL.get()), this.blockLoc((Block)BlockRegistry.WEATHERED_RED_STONE_TILE.get()));
        this.wallInventory(ModItemModelProvider.name((Block)BlockRegistry.BLUE_AND_BLACK_TILE_WALL.get()), this.blockLoc((Block)BlockRegistry.BLUE_AND_BLACK_TILE.get()));
        this.wallInventory(ModItemModelProvider.name((Block)BlockRegistry.BROWNISH_RED_STONE_BRICK_WALL.get()), this.blockLoc((Block)BlockRegistry.BROWNISH_RED_STONE_BRICKS.get()));
        this.wallInventory(ModItemModelProvider.name((Block)BlockRegistry.POLISHED_WEATHERED_STONE_WALL.get()), this.blockLoc((Block)BlockRegistry.POLISHED_WEATHERED_STONE.get()));
        this.wallInventory(ModItemModelProvider.name((Block)BlockRegistry.WHITE_AND_PINK_MIXED_BRICK_WALL.get()), this.blockLoc((Block)BlockRegistry.WHITE_AND_PINK_MIXED_BRICKS.get()));
        this.wallInventory(ModItemModelProvider.name((Block)BlockRegistry.GREEN_WEATHERED_BRICK_WALL.get()), this.blockLoc((Block)BlockRegistry.GREEN_WEATHERED_BRICKS.get()));
        this.fenceInventory(ModItemModelProvider.name((Block)BlockRegistry.ROSEWOOD_FENCE.get()), this.blockLoc((Block)BlockRegistry.ROSEWOOD_PLANKS.get()));
        ItemRegistry.ITEMS.getEntries().stream().filter(blockRegistryObject -> !NON_SIMPLE_ITEMS.contains(blockRegistryObject)).filter(blockRegistryObject -> !(blockRegistryObject.get() instanceof BlockItem)).forEach(this::generatedItem);
        this.handheldItem(ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SWORD);
        this.handheldItem(ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHOVEL);
        this.handheldItem(ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PICKAXE);
        this.handheldItem(ItemRegistry.BLUE_AND_WHITE_PORCELAIN_AXE);
    }

    private ItemModelBuilder generatedItem(DeferredHolder<Item, ? extends Item> item) {
        return (ItemModelBuilder)this.singleTexture(ModItemModelProvider.name((Item)item.get()), this.mcLoc("item/generated"), "layer0", this.modLoc("item/" + ModItemModelProvider.name((Item)item.get())));
    }

    private ItemModelBuilder handheldItem(DeferredHolder<Item, ? extends Item> item) {
        return (ItemModelBuilder)this.singleTexture(ModItemModelProvider.name((Item)item.get()), this.mcLoc("item/handheld"), "layer0", this.modLoc("item/" + ModItemModelProvider.name((Item)item.get())));
    }

    private ItemModelBuilder blockItem(DeferredHolder<Block, ? extends Block> block) {
        return (ItemModelBuilder)this.withExistingParent(ModItemModelProvider.name((Block)block.get()), this.modLoc("block/" + ModItemModelProvider.name((Block)block.get())));
    }

    private ResourceLocation blockLoc(Block block) {
        return this.modLoc("block/" + ModItemModelProvider.name(block));
    }

    @NotNull
    public String getName() {
        return "ultramarine Item Models";
    }

    private static String name(Item item) {
        return Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item)).getPath();
    }

    private static String name(Block block) {
        return Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)block)).getPath();
    }

    static {
        BlockRegistry.BLOCKS.getEntries().stream().filter(blockRegistryObject -> blockRegistryObject.get() instanceof BaseWall || blockRegistryObject.get() instanceof BaseFence).forEach(NON_SIMPLE_BLOCKS::add);
        ItemRegistry.ITEMS.getEntries().stream().filter(itemRegistryObject -> itemRegistryObject.get() instanceof DiggerItem).forEach(NON_SIMPLE_ITEMS::add);
    }
}

