/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.datagen;

import com.voxelutopia.ultramarine.data.ModItemTags;
import com.voxelutopia.ultramarine.data.recipe.WoodworkingRecipe;
import com.voxelutopia.ultramarine.data.registry.ItemRegistry;
import com.voxelutopia.ultramarine.datagen.recipe.ChiselTableRecipeBuilder;
import com.voxelutopia.ultramarine.datagen.recipe.CompositeSmeltingRecipeBuilder;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SingleItemRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ModRecipeProvider
extends RecipeProvider {
    ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeConsumer) {
        ModRecipeProvider.categoryBuildingBlocks(recipeConsumer);
        ModRecipeProvider.categoryDecorativeBlocks(recipeConsumer);
        ModRecipeProvider.categoryDecorations(recipeConsumer);
        ModRecipeProvider.categoryFurniture(recipeConsumer);
        ModRecipeProvider.categoryPlants(recipeConsumer);
        ModRecipeProvider.categoryLamps(recipeConsumer);
        ModRecipeProvider.categoryWindowsDoors(recipeConsumer);
        ModRecipeProvider.categoryMaterials(recipeConsumer);
        ModRecipeProvider.categoryTools(recipeConsumer);
        CompositeSmeltingRecipeBuilder.compositeSmelting(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.UNFIRED_CLAY_BRICK.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.PRISMARINE_DUST.get()}), (ItemLike)ItemRegistry.CYAN_BRICK.get(), 0.1f, 40).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.UNFIRED_CLAY_BRICK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.UNFIRED_CLAY_BRICK.get())).save(recipeConsumer);
    }

    private static void categoryBuildingBlocks(@NotNull RecipeOutput recipeConsumer) {
        ModRecipeProvider.quadComposeRecipe((Item)ItemRegistry.CYAN_BRICK.get(), (Item)ItemRegistry.CYAN_BRICKS.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.stoneSlabAndStairsRecipe((Item)ItemRegistry.CYAN_BRICKS.get(), (Item)ItemRegistry.CYAN_BRICK_SLAB.get(), (Item)ItemRegistry.CYAN_BRICK_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.wallRecipe((Item)ItemRegistry.CYAN_BRICKS.get(), (Item)ItemRegistry.CYAN_BRICK_WALL.get(), recipeConsumer);
        ModRecipeProvider.quadComposeRecipe((Item)ItemRegistry.BLACK_BRICK.get(), (Item)ItemRegistry.BLACK_BRICKS.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.stoneSlabAndStairsRecipe((Item)ItemRegistry.BLACK_BRICKS.get(), (Item)ItemRegistry.BLACK_BRICK_SLAB.get(), (Item)ItemRegistry.BLACK_BRICK_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.wallRecipe((Item)ItemRegistry.BLACK_BRICKS.get(), (Item)ItemRegistry.BLACK_BRICK_WALL.get(), recipeConsumer);
        ModRecipeProvider.quadComposeRecipe((Item)ItemRegistry.BROWNISH_RED_STONE_BRICK.get(), (Item)ItemRegistry.BROWNISH_RED_STONE_BRICKS.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.stoneSlabAndStairsRecipe((Item)ItemRegistry.BROWNISH_RED_STONE_BRICKS.get(), (Item)ItemRegistry.BROWNISH_RED_STONE_BRICK_SLAB.get(), (Item)ItemRegistry.BROWNISH_RED_STONE_BRICK_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.wallRecipe((Item)ItemRegistry.BROWNISH_RED_STONE_BRICKS.get(), (Item)ItemRegistry.BROWNISH_RED_STONE_BRICK_WALL.get(), recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.WHITE_AND_PINK_MIXED_BRICKS.get()), (int)4).define(Character.valueOf('V'), (ItemLike)ItemRegistry.VARIEGATED_ROCKS.get()).define(Character.valueOf('Y'), (ItemLike)ItemRegistry.PALE_YELLOW_STONE.get()).pattern("VY").pattern("YV").unlockedBy("has_" + String.valueOf(ItemRegistry.VARIEGATED_ROCKS.get()), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.VARIEGATED_ROCKS.get()})).save(recipeConsumer);
        ModRecipeProvider.stoneSlabAndStairsRecipe((Item)ItemRegistry.WHITE_AND_PINK_MIXED_BRICKS.get(), (Item)ItemRegistry.WHITE_AND_PINK_MIXED_BRICK_SLAB.get(), (Item)ItemRegistry.WHITE_AND_PINK_MIXED_BRICK_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.wallRecipe((Item)ItemRegistry.WHITE_AND_PINK_MIXED_BRICKS.get(), (Item)ItemRegistry.WHITE_AND_PINK_MIXED_BRICK_WALL.get(), recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.GREEN_WEATHERED_BRICKS.get()), (int)4).define(Character.valueOf('S'), (ItemLike)ItemRegistry.GREEN_WEATHERED_STONE.get()).pattern("SS").pattern("SS").unlockedBy("has_" + String.valueOf(ItemRegistry.GREEN_WEATHERED_STONE.get()), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_WEATHERED_STONE.get()})).save(recipeConsumer);
        ModRecipeProvider.stoneSlabAndStairsRecipe((Item)ItemRegistry.GREEN_WEATHERED_BRICKS.get(), (Item)ItemRegistry.GREEN_WEATHERED_BRICK_SLAB.get(), (Item)ItemRegistry.GREEN_WEATHERED_BRICK_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.wallRecipe((Item)ItemRegistry.GREEN_WEATHERED_BRICKS.get(), (Item)ItemRegistry.GREEN_WEATHERED_BRICK_WALL.get(), recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.PALE_YELLOW_STONE.get()), (int)2).requires((ItemLike)Items.STONE).requires((ItemLike)Items.SAND).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.STONE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.STONE})).save(recipeConsumer);
        ModRecipeProvider.stoneSlabAndStairsRecipe((Item)ItemRegistry.PALE_YELLOW_STONE.get(), (Item)ItemRegistry.PALE_YELLOW_STONE_SLAB.get(), (Item)ItemRegistry.PALE_YELLOW_STONE_STAIRS.get(), recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.VARIEGATED_ROCKS.get()), (int)4).requires((ItemLike)Items.COBBLESTONE).requires((ItemLike)Items.GRANITE).requires((ItemLike)Items.DIORITE).requires((ItemLike)Items.ANDESITE).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.COBBLESTONE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.COBBLESTONE})).save(recipeConsumer);
        ModRecipeProvider.stoneSlabAndStairsRecipe((Item)ItemRegistry.VARIEGATED_ROCKS.get(), (Item)ItemRegistry.VARIEGATED_ROCK_SLAB.get(), (Item)ItemRegistry.VARIEGATED_ROCK_STAIRS.get(), recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.WEATHERED_STONE.get()), (int)2).requires((ItemLike)Items.STONE).requires((ItemLike)Items.GRAVEL).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.STONE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.STONE})).save(recipeConsumer);
        ModRecipeProvider.stoneSlabAndStairsRecipe((Item)ItemRegistry.WEATHERED_STONE.get(), (Item)ItemRegistry.WEATHERED_STONE_SLAB.get(), (Item)ItemRegistry.WEATHERED_STONE_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.stonePolishing((Item)ItemRegistry.WEATHERED_STONE.get(), (Item)ItemRegistry.POLISHED_WEATHERED_STONE.get(), recipeConsumer);
        ModRecipeProvider.stoneSlabAndStairsRecipe((Item)ItemRegistry.POLISHED_WEATHERED_STONE.get(), (Item)ItemRegistry.POLISHED_WEATHERED_STONE_SLAB.get(), (Item)ItemRegistry.POLISHED_WEATHERED_STONE_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.wallRecipe((Item)ItemRegistry.POLISHED_WEATHERED_STONE.get(), (Item)ItemRegistry.POLISHED_WEATHERED_STONE_WALL.get(), recipeConsumer);
        ModRecipeProvider.blockTransform((Item)ItemRegistry.WEATHERED_STONE.get(), ModItemTags.COMMON_GREEN_DYE, (Item)ItemRegistry.GREEN_WEATHERED_STONE.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.blockTransform(Items.SMOOTH_STONE, ModItemTags.COMMON_CYAN_DYE, (Item)ItemRegistry.CYAN_FLOOR_TILE.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.stoneSlabAndStairsRecipe((Item)ItemRegistry.CYAN_FLOOR_TILE.get(), (Item)ItemRegistry.CYAN_FLOOR_TILE_SLAB.get(), (Item)ItemRegistry.CYAN_FLOOR_TILE_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.wallRecipe((Item)ItemRegistry.CYAN_FLOOR_TILE.get(), (Item)ItemRegistry.CYAN_FLOOR_TILE_WALL.get(), recipeConsumer);
        ModRecipeProvider.blockTransform((Item)ItemRegistry.CYAN_FLOOR_TILE.get(), ModItemTags.COMMON_WHITE_DYE, (Item)ItemRegistry.LIGHT_CYAN_FLOOR_TILE.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.stoneSlabAndStairsRecipe((Item)ItemRegistry.LIGHT_CYAN_FLOOR_TILE.get(), (Item)ItemRegistry.LIGHT_CYAN_FLOOR_TILE_SLAB.get(), (Item)ItemRegistry.LIGHT_CYAN_FLOOR_TILE_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.wallRecipe((Item)ItemRegistry.LIGHT_CYAN_FLOOR_TILE.get(), (Item)ItemRegistry.LIGHT_CYAN_FLOOR_TILE_WALL.get(), recipeConsumer);
        ModRecipeProvider.blockTransform((Item)ItemRegistry.CYAN_FLOOR_TILE.get(), (ItemLike)Items.BLACK_DYE, (Item)ItemRegistry.DARK_CYAN_FLOOR_TILE.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.stoneSlabAndStairsRecipe((Item)ItemRegistry.DARK_CYAN_FLOOR_TILE.get(), (Item)ItemRegistry.DARK_CYAN_FLOOR_TILE_SLAB.get(), (Item)ItemRegistry.DARK_CYAN_FLOOR_TILE_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.wallRecipe((Item)ItemRegistry.DARK_CYAN_FLOOR_TILE.get(), (Item)ItemRegistry.DARK_CYAN_FLOOR_TILE_WALL.get(), recipeConsumer);
        ModRecipeProvider.simpleStonecutting((Item)ItemRegistry.CYAN_FLOOR_TILE.get(), (Item)ItemRegistry.LAYERED_CYAN_FLOOR_TILES.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.simpleStonecutting((Item)ItemRegistry.CYAN_FLOOR_TILE.get(), (Item)ItemRegistry.VERTICAL_CYAN_FLOOR_TILES.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.simpleStonecutting((Item)ItemRegistry.CYAN_FLOOR_TILE.get(), (Item)ItemRegistry.MIXED_CYAN_FLOOR_TILES.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.simpleStonecutting((Item)ItemRegistry.CYAN_FLOOR_TILE.get(), (Item)ItemRegistry.CHISELED_CYAN_FLOOR_TILE.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.simpleStonecutting((Item)ItemRegistry.CYAN_FLOOR_TILE.get(), (Item)ItemRegistry.CUT_CYAN_FLOOR_TILES.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.blockTransform((Item)ItemRegistry.POLISHED_WEATHERED_STONE.get(), ModItemTags.COMMON_RED_DYE, (Item)ItemRegistry.WEATHERED_RED_STONE_TILE.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.stoneSlabAndStairsRecipe((Item)ItemRegistry.WEATHERED_RED_STONE_TILE.get(), (Item)ItemRegistry.WEATHERED_RED_STONE_TILE_SLAB.get(), (Item)ItemRegistry.WEATHERED_RED_STONE_TILE_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.wallRecipe((Item)ItemRegistry.WEATHERED_RED_STONE_TILE.get(), (Item)ItemRegistry.WEATHERED_RED_STONE_TILE_WALL.get(), recipeConsumer);
        ModRecipeProvider.blockTransform((Item)ItemRegistry.DARK_CYAN_FLOOR_TILE.get(), ModItemTags.COMMON_BLUE_DYE, (Item)ItemRegistry.BLUE_AND_BLACK_TILE.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.stoneSlabAndStairsRecipe((Item)ItemRegistry.BLUE_AND_BLACK_TILE.get(), (Item)ItemRegistry.BLUE_AND_BLACK_TILE_SLAB.get(), (Item)ItemRegistry.BLUE_AND_BLACK_TILE_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.wallRecipe((Item)ItemRegistry.BLUE_AND_BLACK_TILE.get(), (Item)ItemRegistry.BLUE_AND_BLACK_TILE_WALL.get(), recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.GREEN_GLAZED_TILES.get()), (int)2).define(Character.valueOf('B'), (ItemLike)Items.GREEN_GLAZED_TERRACOTTA).define(Character.valueOf('T'), (ItemLike)ItemRegistry.GREEN_ROOF_TILE.get()).pattern(" T ").pattern("TBT").pattern(" T ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.GREEN_GLAZED_TERRACOTTA), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.GREEN_GLAZED_TERRACOTTA})).save(recipeConsumer);
        ModRecipeProvider.stoneSlabAndStairsRecipe((Item)ItemRegistry.GREEN_GLAZED_TILES.get(), (Item)ItemRegistry.GREEN_GLAZED_TILE_SLAB.get(), (Item)ItemRegistry.GREEN_GLAZED_TILE_STAIRS.get(), recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.BLACK_FLOOR_TILES.get()), (int)2).requires((ItemLike)Items.COBBLED_DEEPSLATE).requires((ItemLike)ItemRegistry.BLACK_BRICKS.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BLACK_BRICKS.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BLACK_BRICKS.get())).save(recipeConsumer);
        ModRecipeProvider.blockTransform((Item)ItemRegistry.BLACK_FLOOR_TILES.get(), (ItemLike)Items.MOSS_BLOCK, (Item)ItemRegistry.BLACK_FLOOR_TILES_LITTLE_MOSSY.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.blockTransform((Item)ItemRegistry.BLACK_FLOOR_TILES_LITTLE_MOSSY.get(), (ItemLike)Items.MOSS_BLOCK, (Item)ItemRegistry.BLACK_FLOOR_TILES_MODERATE_MOSSY.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.blockTransform((Item)ItemRegistry.BLACK_FLOOR_TILES_MODERATE_MOSSY.get(), (ItemLike)Items.MOSS_BLOCK, (Item)ItemRegistry.BLACK_FLOOR_TILES_VERY_MOSSY.get(), RecipeCategory.BUILDING_BLOCKS, recipeConsumer);
        ModRecipeProvider.smeltingAndBlasting(Items.MANGROVE_PLANKS, (Item)ItemRegistry.ROSEWOOD_PLANKS.get(), recipeConsumer);
        ModRecipeProvider.woodSlabAndStairsRecipe((Item)ItemRegistry.ROSEWOOD_PLANKS.get(), (Item)ItemRegistry.ROSEWOOD_SLAB.get(), (Item)ItemRegistry.ROSEWOOD_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.fenceRecipe((Item)ItemRegistry.ROSEWOOD_PLANKS.get(), (Item)ItemRegistry.ROSEWOOD_FENCE.get(), recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get())).define(Character.valueOf('B'), (ItemLike)ItemRegistry.ROSEWOOD_PLANKS.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.POLISHED_ROSEWOOD_PLANK.get()).define(Character.valueOf('D'), ModItemTags.COMMON_RED_DYE).pattern("DPD").pattern("PBP").pattern("DPD").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.ROSEWOOD_PLANKS.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.ROSEWOOD_PLANKS.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Items.BAMBOO_MOSAIC, (ItemLike)ItemRegistry.BAMBOO_MAT.get(), 1, recipeConsumer);
        ModRecipeProvider.woodSlabAndStairsRecipe((Item)ItemRegistry.BAMBOO_MAT.get(), (Item)ItemRegistry.BAMBOO_MAT_SLAB.get(), (Item)ItemRegistry.BAMBOO_MAT_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.roofTileBlocksRecipe("gray", recipeConsumer);
        ModRecipeProvider.roofTileBlocksRecipe("yellow", recipeConsumer);
        ModRecipeProvider.roofTileBlocksRecipe("green", recipeConsumer);
        ModRecipeProvider.roofTileBlocksRecipe("blue", recipeConsumer);
        ModRecipeProvider.roofTileBlocksRecipe("cyan", recipeConsumer);
        ModRecipeProvider.roofTileBlocksRecipe("black", recipeConsumer);
        ModRecipeProvider.roofTileRidgesRecipe("yellow", recipeConsumer);
        ModRecipeProvider.roofTileRidgesRecipe("black", recipeConsumer);
    }

    private static void categoryDecorativeBlocks(@NotNull RecipeOutput recipeConsumer) {
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((TagKey)ItemTags.OAK_LOGS), (ItemLike)ItemRegistry.OAK_BRACKET.get()).unlockedBy("has_wood", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.OAK_LOGS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((TagKey)ItemTags.SPRUCE_LOGS), (ItemLike)ItemRegistry.SPRUCE_BRACKET.get()).unlockedBy("has_wood", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.SPRUCE_LOGS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((TagKey)ItemTags.BIRCH_LOGS), (ItemLike)ItemRegistry.BIRCH_BRACKET.get()).unlockedBy("has_wood", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.BIRCH_LOGS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((TagKey)ItemTags.JUNGLE_LOGS), (ItemLike)ItemRegistry.JUNGLE_BRACKET.get()).unlockedBy("has_wood", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.JUNGLE_LOGS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((TagKey)ItemTags.ACACIA_LOGS), (ItemLike)ItemRegistry.ACACIA_BRACKET.get()).unlockedBy("has_wood", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.ACACIA_LOGS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((TagKey)ItemTags.DARK_OAK_LOGS), (ItemLike)ItemRegistry.DARK_OAK_BRACKET.get()).unlockedBy("has_wood", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.DARK_OAK_LOGS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((TagKey)ItemTags.CRIMSON_STEMS), (ItemLike)ItemRegistry.CRIMSON_BRACKET.get()).unlockedBy("has_wood", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.CRIMSON_STEMS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((TagKey)ItemTags.WARPED_STEMS), (ItemLike)ItemRegistry.WARPED_BRACKET.get()).unlockedBy("has_wood", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.WARPED_STEMS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((TagKey)ItemTags.MANGROVE_LOGS), (ItemLike)ItemRegistry.MANGROVE_BRACKET.get()).unlockedBy("has_wood", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.MANGROVE_LOGS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((TagKey)ItemTags.CHERRY_LOGS), (ItemLike)ItemRegistry.CHERRY_BRACKET.get()).unlockedBy("has_wood", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.CHERRY_LOGS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get()}), (ItemLike)ItemRegistry.VARNISHED_ROSEWOOD_BRACKET.get()).unlockedBy("has_wood", ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get())).save(recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.RED_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of(ModItemTags.COMMON_RED_DYE)}, recipeConsumer);
        ModRecipeProvider.woodSlabAndStairsRecipe((Item)ItemRegistry.RED_CARVED_WOOD.get(), (Item)ItemRegistry.RED_CARVED_WOODEN_SLAB.get(), (Item)ItemRegistry.RED_CARVED_WOODEN_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.BLUE_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.woodSlabAndStairsRecipe((Item)ItemRegistry.BLUE_CARVED_WOOD.get(), (Item)ItemRegistry.BLUE_CARVED_WOODEN_SLAB.get(), (Item)ItemRegistry.BLUE_CARVED_WOODEN_STAIRS.get(), recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.BLUE_CARVED_WOODEN_BRACKET.get()), (int)2).define(Character.valueOf('T'), (ItemLike)ItemRegistry.GREEN_CARVED_WOODEN_SLAB.get()).define(Character.valueOf('B'), (ItemLike)ItemRegistry.BLUE_CARVED_WOODEN_STAIRS.get()).pattern("T").pattern("B").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BLUE_CARVED_WOODEN_STAIRS.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BLUE_CARVED_WOODEN_STAIRS.get())).save(recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.BLUE_CARVED_WOODEN_BRACKET_STAIRS.get())).requires((ItemLike)ItemRegistry.BLUE_CARVED_WOODEN_STAIRS.get()).requires((ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BLUE_CARVED_WOODEN_STAIRS.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BLUE_CARVED_WOODEN_STAIRS.get())).save(recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.CYAN_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of(ModItemTags.COMMON_CYAN_DYE)}, recipeConsumer);
        ModRecipeProvider.woodSlabAndStairsRecipe((Item)ItemRegistry.CYAN_CARVED_WOOD.get(), (Item)ItemRegistry.CYAN_CARVED_WOODEN_SLAB.get(), (Item)ItemRegistry.CYAN_CARVED_WOODEN_STAIRS.get(), recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.CYAN_CARVED_WOODEN_BRACKET.get()), (int)2).define(Character.valueOf('T'), (ItemLike)ItemRegistry.CYAN_CARVED_WOODEN_SLAB.get()).define(Character.valueOf('B'), (ItemLike)ItemRegistry.RED_CARVED_WOODEN_STAIRS.get()).pattern("T").pattern("B").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.CYAN_CARVED_WOODEN_SLAB.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.CYAN_CARVED_WOODEN_SLAB.get())).save(recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.GREEN_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.woodSlabAndStairsRecipe((Item)ItemRegistry.GREEN_CARVED_WOOD.get(), (Item)ItemRegistry.GREEN_CARVED_WOODEN_SLAB.get(), (Item)ItemRegistry.GREEN_CARVED_WOODEN_STAIRS.get(), recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.GREEN_CARVED_WOODEN_BRACKET.get()), (int)2).define(Character.valueOf('T'), (ItemLike)ItemRegistry.BLUE_CARVED_WOODEN_SLAB.get()).define(Character.valueOf('B'), (ItemLike)ItemRegistry.GREEN_CARVED_WOODEN_STAIRS.get()).pattern("T").pattern("B").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GREEN_CARVED_WOODEN_STAIRS.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GREEN_CARVED_WOODEN_STAIRS.get())).save(recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.ORANGE_AND_BLUE_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_ORANGE_DYE), Ingredient.of(ModItemTags.COMMON_LIGHT_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.ORANGE_AND_GREEN_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_ORANGE_DYE), Ingredient.of(ModItemTags.COMMON_LIME_DYE)}, recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.GREEN_AND_BLUE_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_LIME_DYE), Ingredient.of(ModItemTags.COMMON_LIGHT_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.DARK_GREEN_AND_DARK_BLUE_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIME_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.DARK_BLUE_AND_DARK_GREEN_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIGHT_BLUE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.BLACK_WHITE_GREEN_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLACK_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.BLACK_WHITE_BLUE_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLACK_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.RED_AND_GREEN_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.BLUE_AND_RED_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_RED_DYE)}, recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.BLUE_WHITE_RED_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.GREEN_WHITE_RED_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_1.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE)}, recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_1.get()}), (ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_2.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_1.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_1.get())).save(recipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)"blue_and_yellow_carved_wood_1_to_2"));
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_1.get()}), (ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_3.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_1.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_1.get())).save(recipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)"blue_and_yellow_carved_wood_1_to_3"));
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_2.get()}), (ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_1.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_2.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_2.get())).save(recipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)"blue_and_yellow_carved_wood_2_to_1"));
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_2.get()}), (ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_3.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_2.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_2.get())).save(recipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)"blue_and_yellow_carved_wood_2_to_3"));
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_3.get()}), (ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_1.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_3.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_3.get())).save(recipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)"blue_and_yellow_carved_wood_3_to_1"));
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_3.get()}), (ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_2.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_3.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BLUE_AND_YELLOW_CARVED_WOOD_VARIANT_3.get())).save(recipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)"blue_and_yellow_carved_wood_3_to_2"));
        ModRecipeProvider.carvedWood((Item)ItemRegistry.YELLOW_AND_GREEN_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.YELLOW_GREEN_BLUE_CARVED_WOOD.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{Items.STRIPPED_DARK_OAK_LOG}), (ItemLike)ItemRegistry.CARVED_DARK_OAK_BEAM.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.STRIPPED_DARK_OAK_LOG), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.STRIPPED_DARK_OAK_LOG})).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{Items.STRIPPED_DARK_OAK_LOG}), (ItemLike)ItemRegistry.CARVED_DARK_OAK_BEAM_EDGE.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.STRIPPED_DARK_OAK_LOG), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.STRIPPED_DARK_OAK_LOG})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.GILDED_DARK_OAK.get()), (int)1).define(Character.valueOf('O'), (ItemLike)Items.STRIPPED_DARK_OAK_WOOD).define(Character.valueOf('G'), (ItemLike)ItemRegistry.GOLD_PARTS.get()).pattern(" G ").pattern("GOG").pattern(" G ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.STRIPPED_DARK_OAK_WOOD), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.STRIPPED_DARK_OAK_WOOD})).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GILDED_DARK_OAK.get()}), (ItemLike)ItemRegistry.CHISELED_GILDED_DARK_OAK.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GILDED_DARK_OAK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GILDED_DARK_OAK.get())).save(recipeConsumer);
        ModRecipeProvider.woodSlabAndStairsRecipe((Item)ItemRegistry.GILDED_DARK_OAK.get(), (Item)ItemRegistry.GILDED_DARK_OAK_SLAB.get(), (Item)ItemRegistry.GILDED_DARK_OAK_STAIRS.get(), recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GILDED_DARK_OAK.get()}), (ItemLike)ItemRegistry.GILDED_DARK_OAK_BRACKET.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GILDED_DARK_OAK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GILDED_DARK_OAK.get())).save(recipeConsumer);
        ModRecipeProvider.carvedWool((Item)ItemRegistry.RED_CARVED_CARPET.get(), Items.RED_WOOL, new Ingredient[]{Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.carvedWool((Item)ItemRegistry.BLUE_CARVED_CARPET.get(), Items.BLUE_WOOL, new Ingredient[]{Ingredient.of(ModItemTags.COMMON_WHITE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIGHT_BLUE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.carvedWood((Item)ItemRegistry.CARVED_RED_PILLAR.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of(ModItemTags.COMMON_RED_DYE)}, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.CARVED_RED_PILLAR_BASE.get()), (int)1).define(Character.valueOf('P'), (ItemLike)ItemRegistry.CARVED_RED_PILLAR.get()).define(Character.valueOf('S'), (ItemLike)Items.SMOOTH_STONE_SLAB).pattern("P").pattern("S").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.CARVED_RED_PILLAR.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.CARVED_RED_PILLAR.get())).save(recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.CARVED_RED_PILLAR_HEAD.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of(ModItemTags.COMMON_WHITE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.SPRUCE_PILLAR_BASE.get()), (int)1).define(Character.valueOf('P'), (ItemLike)Items.SPRUCE_LOG).define(Character.valueOf('S'), (ItemLike)Items.SMOOTH_STONE_SLAB).pattern("P").pattern("S").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.SPRUCE_LOG), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.SPRUCE_LOG})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ItemRegistry.STRIPPED_DARK_OAK_PILLAR_BASE.get()), (int)1).define(Character.valueOf('P'), (ItemLike)Items.STRIPPED_DARK_OAK_LOG).define(Character.valueOf('S'), (ItemLike)Items.SMOOTH_STONE_SLAB).pattern("P").pattern("S").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.STRIPPED_DARK_OAK_LOG), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.STRIPPED_DARK_OAK_LOG})).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GILDED_DARK_OAK.get()}), (ItemLike)ItemRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_1.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GILDED_DARK_OAK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GILDED_DARK_OAK.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GILDED_DARK_OAK.get()}), (ItemLike)ItemRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_2.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GILDED_DARK_OAK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GILDED_DARK_OAK.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GILDED_DARK_OAK.get()}), (ItemLike)ItemRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_3.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GILDED_DARK_OAK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GILDED_DARK_OAK.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GILDED_DARK_OAK.get()}), (ItemLike)ItemRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_4.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GILDED_DARK_OAK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GILDED_DARK_OAK.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GILDED_DARK_OAK.get()}), (ItemLike)ItemRegistry.GILDED_DARK_OAK_PILLAR_HEAD_VARIANT_5.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GILDED_DARK_OAK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GILDED_DARK_OAK.get())).save(recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.CYAN_AND_WHITE_PILLAR_BASE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_WHITE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLACK_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.CYAN_AND_WHITE_DECORATED_PILLAR.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_WHITE_DYE), Ingredient.of(ModItemTags.COMMON_BLACK_DYE)}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.CYAN_AND_WHITE_PILLAR_HEAD.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of(ModItemTags.COMMON_BLACK_DYE), Ingredient.of(ModItemTags.COMMON_WHITE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.CHISELED_STONE_BRICKS, (Item)ItemRegistry.STONE_PILLAR_BASE.get(), RecipeCategory.DECORATIONS, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.GREEN_FANGXIN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.GREEN_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.BLUE_FANGXIN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.BLUE_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.CYAN_AND_BLUE_FANGXIN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.CYAN_AND_BLUE_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.CYAN_AND_BLUE_FANGXIN_EDGE_VARIANT.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.CYAN_BLUE_WHITE_FANGXIN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.CYAN_BLUE_WHITE_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.BLUE_AND_GREEN_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.YELLOW_AND_GREEN_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.DARK_BLUE_FANGXIN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.DARK_BLUE_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.BLUE_AND_WHITE_FANGXIN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.GREEN_AND_DARK_BLUE_FANGXIN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.WHITE_AND_CYAN_FANGXIN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_WHITE_DYE), Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.WHITE_AND_CYAN_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_WHITE_DYE), Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.WHITE_AND_BLUE_FANGXIN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_WHITE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.WHITE_AND_BLUE_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CYAN_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_WHITE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.RED_CYAN_BLUE_FANGXIN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RED_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.RED_CYAN_BLUE_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.BLUE_CYAN_BLUE_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.BLUE_CYAN_RED_FANGXIN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.BLUE_CYAN_RED_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RED_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.CYAN_BLUE_CYAN_FANGXIN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_CYAN_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.RED_BLUE_RED_FANGXIN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_RED_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.CYAN_AND_YELLOW_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.MING_BLUE_JINZHUOMO_SHINIANYU_XUANZI_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.MING_BLUE_GILDED_JINZHUOMO_SHINIANYU_XUANZI_FANGXIN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIGHT_BLUE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.MING_BLUE_GILDED_JINZHUOMO_SHINIANYU_XUANZI_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.MING_GREEN_GILDED_JINZHUOMO_SHINIANYU_XUANZI_FANGXIN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIGHT_BLUE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.MING_GREEN_GILDED_JINZHUOMO_SHINIANYU_XUANZI_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.QING_BLUE_PLAIN_JINZHUOMO_SHINIANYU_FANGXIN.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_LIGHT_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.YUAN_NIANYUZHUANG_FANGXIN.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.YUAN_NIANYUZHUANG_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CYAN_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.YUAN_PATTERNED_NIANYUZHUANG_FANGXIN.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RED_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.YUAN_PATTERNED_NIANYUZHUANG_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CYAN_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RED_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.YUAN_GREEN_NIANYUZHUANG_FANGXIN.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.YUAN_GREEN_NIANYUZHUANG_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CYAN_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.YUAN_PATTERNED_WUCHAIZHUANG_FANGXIN.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.ORANGE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.YUAN_PATTERNED_WUCHAIZHUANG_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RED_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.ORANGE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinWood((Item)ItemRegistry.YUAN_GREEN_WUCHAIZHUANG_FANGXIN.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinEdgeWood((Item)ItemRegistry.YUAN_GREEN_WUCHAIZHUANG_FANGXIN_EDGE.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RED_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.BLUE_ZHAOTOU_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RED_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.GREEN_AND_BLUE_ZHAOTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.BLUE_AND_GREEN_ZHAOTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.BLUE_AND_GREEN_DOUBLE_LAYERED_ZHAOTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIGHT_BLUE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.CYAN_AND_RED_ZHAOTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of(ModItemTags.COMMON_CYAN_DYE)}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.CYAN_AND_BLUE_ZHAOTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_CYAN_DYE)}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.GRAY_BLACK_RED_ZHAOTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GRAY_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLACK_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_RED_DYE)}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.BLUE_GREEN_RED_ZHAOTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CYAN_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.RED_AND_BLUE_ZHAOTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.GREEN_AND_YELLOW_ZHAOTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE)}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.RED_GREEN_BLUE_ZHAOTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RED_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.WHITE_BLUE_GREEN_ZHAOTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_WHITE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.MING_YANZHUOMO_SHINIANYU_OUTER_ZHAOTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RED_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.MING_YANZHUOMO_SHINIANYU_OUTER_ZHAOTOU_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RED_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.YUAN_NIANYUZHUANG_ZHAOTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.zhaotouWood((Item)ItemRegistry.YUAN_NIANYUZHUANG_ZHAOTOU_CONNECTION.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.gutouWood((Item)ItemRegistry.GREEN_BLUE_BLACK_GUTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIGHT_BLUE_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLACK_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.gutouWood((Item)ItemRegistry.BLUE_GREEN_YELLOW_GUTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE)}, recipeConsumer);
        ModRecipeProvider.gutouWood((Item)ItemRegistry.BLUE_AND_YELLOW_GUTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE)}, recipeConsumer);
        ModRecipeProvider.gutouWood((Item)ItemRegistry.MING_YANZHUOMO_SHINIANYU_OUTER_GUTOU_EDGE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.gutouWood((Item)ItemRegistry.YUAN_NIANYUZHUANG_GUTOU.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_BROWN_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((ItemLike[])new ItemLike[]{Items.STRIPPED_DARK_OAK_LOG}), (ItemLike)ItemRegistry.DARK_OAK_RAFTER.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.STRIPPED_DARK_OAK_LOG), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.STRIPPED_DARK_OAK_LOG})).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((ItemLike[])new ItemLike[]{Items.STRIPPED_DARK_OAK_LOG}), (ItemLike)ItemRegistry.DARK_OAK_RAFTER_END.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.STRIPPED_DARK_OAK_LOG), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.STRIPPED_DARK_OAK_LOG})).save(recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.GILDED_DARK_OAK_RAFTER.get())).requires((ItemLike)ItemRegistry.DARK_OAK_RAFTER.get()).requires((ItemLike)ItemRegistry.GOLD_PARTS.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.DARK_OAK_RAFTER.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.DARK_OAK_RAFTER.get())).save(recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.GILDED_DARK_OAK_RAFTER_END.get())).requires((ItemLike)ItemRegistry.DARK_OAK_RAFTER_END.get()).requires((ItemLike)ItemRegistry.GOLD_PARTS.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.DARK_OAK_RAFTER_END.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.DARK_OAK_RAFTER_END.get())).save(recipeConsumer);
        ModRecipeProvider.rafter((Item)ItemRegistry.BLUE_TIGER_EYE_RAFTER.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.rafterEnd((Item)ItemRegistry.BLUE_TIGER_EYE_RAFTER_END.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.rafter((Item)ItemRegistry.BLUE_CARVED_TIGER_EYE_RAFTER.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.rafterEnd((Item)ItemRegistry.BLUE_CARVED_TIGER_EYE_RAFTER_END.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_BLUE_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.rafter((Item)ItemRegistry.GREEN_CARVED_TIGER_EYE_RAFTER.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.rafterEnd((Item)ItemRegistry.GREEN_CARVED_TIGER_EYE_RAFTER_END.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.rafter((Item)ItemRegistry.GREEN_WANZI_RAFTER.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.rafterEnd((Item)ItemRegistry.GREEN_WANZI_RAFTER_END.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.rafter((Item)ItemRegistry.GREEN_CARVED_WANZI_RAFTER.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.rafterEnd((Item)ItemRegistry.GREEN_CARVED_WANZI_RAFTER_END.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GILDED_DARK_OAK.get()}), (ItemLike)ItemRegistry.GILDED_DARK_OAK_BEAM_HEAD.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GILDED_DARK_OAK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GILDED_DARK_OAK.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_CARVED_WOOD.get()}), (ItemLike)ItemRegistry.QING_GREEN_BEAM_HEAD.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GREEN_CARVED_WOOD.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GREEN_CARVED_WOOD.get())).save(recipeConsumer);
        ModRecipeProvider.architrave((Item)ItemRegistry.RED_AND_CYAN_CARVED_ARCHITRAVE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_CYAN_DYE)}, recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, (Item)ItemRegistry.RED_AND_CYAN_CARVED_ARCHITRAVE.get(), (ItemLike)ItemRegistry.RED_AND_CYAN_CARVED_ARCHITRAVE_SLAB.get(), 2, recipeConsumer);
        ModRecipeProvider.architrave((Item)ItemRegistry.RED_AND_BLUE_CARVED_ARCHITRAVE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, (Item)ItemRegistry.RED_AND_BLUE_CARVED_ARCHITRAVE.get(), (ItemLike)ItemRegistry.RED_AND_BLUE_CARVED_ARCHITRAVE_SLAB.get(), 2, recipeConsumer);
        ModRecipeProvider.architrave((Item)ItemRegistry.EMPTY_TUANHUA_SLAB.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIGHT_BLUE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.architrave((Item)ItemRegistry.FULL_TUANHUA_SLAB.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIGHT_BLUE_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CYAN_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.architrave((Item)ItemRegistry.RED_AND_CYAN_TUANHUA_SLAB.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_CYAN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIGHT_BLUE_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RED_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CYAN_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.architrave((Item)ItemRegistry.RED_CARVED_ARCHITRAVE.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_RED_DYE)}, recipeConsumer);
        ModRecipeProvider.architrave((Item)ItemRegistry.WHITE_AND_RED_SLAB.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of(ModItemTags.COMMON_RED_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, (Item)ItemRegistry.GILDED_DARK_OAK.get(), (ItemLike)ItemRegistry.LONG_GILDED_DARK_OAK_QUETI.get(), 1, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.LONG_GILDED_DARK_OAK_QUETI_EDGE.get())).define(Character.valueOf('C'), (ItemLike)ItemRegistry.LONG_GILDED_DARK_OAK_QUETI.get()).pattern("CC").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.LONG_GILDED_DARK_OAK_QUETI.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.LONG_GILDED_DARK_OAK_QUETI.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, (Item)ItemRegistry.GILDED_DARK_OAK.get(), (ItemLike)ItemRegistry.HORIZONTAL_GILDED_DARK_OAK_QUETI.get(), 1, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.CENTRAL_GILDED_DARK_OAK_QUETI.get())).define(Character.valueOf('C'), (ItemLike)ItemRegistry.HORIZONTAL_GILDED_DARK_OAK_QUETI.get()).pattern("CC").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.HORIZONTAL_GILDED_DARK_OAK_QUETI.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.HORIZONTAL_GILDED_DARK_OAK_QUETI.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, (Item)ItemRegistry.GILDED_DARK_OAK.get(), (ItemLike)ItemRegistry.VERTICAL_GILDED_DARK_OAK_QUETI.get(), 1, recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.PLANKS), (ItemLike)ItemRegistry.WOODEN_QUETI.get(), 2).unlockedBy("has_plank", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.PLANKS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.PLANKS), (ItemLike)ItemRegistry.WOODEN_QUETI_EDGE.get(), 2).unlockedBy("has_plank", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.PLANKS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.PLANKS), (ItemLike)ItemRegistry.TALL_WOODEN_QUETI_EDGE.get(), 1).unlockedBy("has_plank", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.PLANKS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.PLANKS), (ItemLike)ItemRegistry.LARGE_WOODEN_QUETI_EDGE.get(), 1).unlockedBy("has_plank", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.PLANKS)).save(recipeConsumer);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_GLAZED_TILES.get()}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SHORT_GLAZED_QUETI.get()), (int)4).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GREEN_GLAZED_TILES.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GREEN_GLAZED_TILES.get())).save(recipeConsumer);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_GLAZED_TILES.get()}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.THICK_CARVED_QUETI.get()), (int)2).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GREEN_GLAZED_TILES.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GREEN_GLAZED_TILES.get())).save(recipeConsumer);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_GLAZED_TILES.get()}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SHORT_THICK_GLAZED_QUETI.get()), (int)1).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GREEN_GLAZED_TILES.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GREEN_GLAZED_TILES.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.PLANKS), (ItemLike)ItemRegistry.WOODEN_GUALUO.get(), 1).unlockedBy("has_plank", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.PLANKS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.PLANKS), (ItemLike)ItemRegistry.LARGE_WOODEN_GUALUO.get(), 1).unlockedBy("has_plank", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.PLANKS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.PLANKS), (ItemLike)ItemRegistry.LARGE_WOODEN_GUALUO_EDGE.get(), 1).unlockedBy("has_plank", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.PLANKS)).save(recipeConsumer);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.CARVED_STONE_PANEL.get()), (int)1).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.STONE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.STONE})).save(recipeConsumer);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.CARVED_STONE_PANEL_EDGE.get()), (int)1).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.STONE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.STONE})).save(recipeConsumer);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.STONE}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.CARVED_STONE_PANEL_CENTER.get()), (int)1).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.STONE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.STONE})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.CARVED_STONE_QUETI_PART.get())).define(Character.valueOf('E'), (ItemLike)ItemRegistry.CARVED_STONE_PANEL_EDGE.get()).define(Character.valueOf('C'), (ItemLike)ItemRegistry.CARVED_STONE_PANEL_CENTER.get()).pattern("EC").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.CARVED_STONE_PANEL.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.CARVED_STONE_PANEL.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.CARVED_STONE_BEAM.get())).define(Character.valueOf('C'), (ItemLike)ItemRegistry.CARVED_STONE_PANEL.get()).pattern("CCC").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.CARVED_STONE_PANEL.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.CARVED_STONE_PANEL.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.CARVED_STONE_QUETI.get())).define(Character.valueOf('E'), (ItemLike)ItemRegistry.CARVED_STONE_PANEL_EDGE.get()).pattern("E").pattern("E").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.CARVED_STONE_PANEL.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.CARVED_STONE_PANEL.get())).save(recipeConsumer);
        ModRecipeProvider.caihua((Item)ItemRegistry.YELLOW_CARVED_PATTERN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE)}, recipeConsumer);
        ModRecipeProvider.caihua((Item)ItemRegistry.CIRCULAR_YELLOW_CARVED_PATTERN.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinEdgePattern((Item)ItemRegistry.YELLOW_CARVED_FANGXIN_EDGE_PATTERN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinPattern((Item)ItemRegistry.YELLOW_CARVED_FANGXIN_PATTERN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE)}, recipeConsumer);
        ModRecipeProvider.caihua((Item)ItemRegistry.LARGE_YELLOW_CARVED_PATTERN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE)}, recipeConsumer);
        ModRecipeProvider.caihua((Item)ItemRegistry.MEDIUM_YELLOW_CARVED_PATTERN.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.zhaotouPattern((Item)ItemRegistry.YELLOW_CARVED_ZHAOTOU_PATTERN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE)}, recipeConsumer);
        ModRecipeProvider.zhaotouPattern((Item)ItemRegistry.LONG_YELLOW_CARVED_ZHAOTOU_PATTERN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.zhaotouPattern((Item)ItemRegistry.CARVED_ZHAOTOU_PATTERN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of(ModItemTags.COMMON_WHITE_DYE)}, recipeConsumer);
        ModRecipeProvider.caihua((Item)ItemRegistry.FLAME_ARCH_WALL_PATTERN.get(), new Ingredient[]{Ingredient.of(ModItemTags.COMMON_ORANGE_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.fangxinPattern((Item)ItemRegistry.BLUE_FANGXIN_PATTERN.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLACK_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIGHT_BLUE_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BROWN_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinEdgePattern((Item)ItemRegistry.BLUE_FANGXIN_PATTERN_EDGE.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLACK_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIGHT_BLUE_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BROWN_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinPattern((Item)ItemRegistry.GREEN_FANGXIN_PATTERN.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLACK_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIGHT_BLUE_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BROWN_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.fangxinEdgePattern((Item)ItemRegistry.GREEN_FANGXIN_PATTERN_EDGE.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLACK_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.LIGHT_BLUE_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BROWN_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.GOLDEN_DRAGON_FANGXIN_PATTERN.get())).define(Character.valueOf('C'), (ItemLike)ItemRegistry.BLUE_FANGXIN_PATTERN.get()).define(Character.valueOf('E'), (ItemLike)ItemRegistry.BLUE_FANGXIN_PATTERN_EDGE.get()).define(Character.valueOf('G'), (ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()).pattern("GGG").pattern("ECE").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BLUE_FANGXIN_PATTERN.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BLUE_FANGXIN_PATTERN.get())).save(recipeConsumer);
        ModRecipeProvider.caihua((Item)ItemRegistry.LIGHT_BLUE_SU_STYLE_CAIHUA.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RED_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_LIGHT_BLUE_DYE)}, recipeConsumer);
        ModRecipeProvider.caihua((Item)ItemRegistry.YELLOW_SU_STYLE_CAIHUA.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RED_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE)}, recipeConsumer);
        ModRecipeProvider.caihua((Item)ItemRegistry.LIGHT_YELLOW_SU_STYLE_CAIHUA.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GREEN_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RED_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_YELLOW_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.caihua((Item)ItemRegistry.MEDIUM_SU_STYLE_CAIHUA.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.WHITE_DYE_POWDER.get()})}, recipeConsumer);
        ModRecipeProvider.caihua((Item)ItemRegistry.LARGE_WHITE_SU_STYLE_CAIHUA.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_WHITE_DYE), Ingredient.of(ModItemTags.COMMON_WHITE_DYE)}, recipeConsumer);
        ModRecipeProvider.caihua((Item)ItemRegistry.LARGE_GREEN_SU_STYLE_CAIHUA.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GREEN_DYE), Ingredient.of(ModItemTags.COMMON_GREEN_DYE)}, recipeConsumer);
        ModRecipeProvider.caihua((Item)ItemRegistry.LARGE_GRAY_SU_STYLE_CAIHUA.get(), new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get()}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()}), Ingredient.of(ModItemTags.COMMON_GRAY_DYE), Ingredient.of(ModItemTags.COMMON_GRAY_DYE)}, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.BLUE_AND_GREEN_CHUIHUA.get())).define(Character.valueOf('R'), (ItemLike)ItemRegistry.RED_CARVED_WOODEN_SLAB.get()).define(Character.valueOf('B'), (ItemLike)ItemRegistry.BLUE_CARVED_WOODEN_SLAB.get()).define(Character.valueOf('G'), (ItemLike)ItemRegistry.GREEN_CARVED_WOODEN_SLAB.get()).pattern("R").pattern("B").pattern("G").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BLUE_CARVED_WOODEN_SLAB.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BLUE_CARVED_WOODEN_SLAB.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.CYAN_AND_YELLOW_CHUIHUA.get())).define(Character.valueOf('C'), (ItemLike)ItemRegistry.CYAN_CARVED_WOODEN_SLAB.get()).define(Character.valueOf('O'), (ItemLike)ItemRegistry.BLUE_AND_RED_CARVED_WOOD.get()).define(Character.valueOf('G'), (ItemLike)ItemRegistry.YELLOW_AND_GREEN_CARVED_WOOD.get()).pattern("C").pattern("O").pattern("G").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.CYAN_CARVED_WOODEN_SLAB.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.CYAN_CARVED_WOODEN_SLAB.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.GILDED_DARK_OAK_CHUIHUA.get())).define(Character.valueOf('S'), (ItemLike)ItemRegistry.GILDED_DARK_OAK_SLAB.get()).define(Character.valueOf('B'), (ItemLike)ItemRegistry.GILDED_DARK_OAK.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.GOLD_PARTS.get()).pattern("S").pattern("B").pattern("P").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GILDED_DARK_OAK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GILDED_DARK_OAK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.GOLDEN_GLAZED_ROOF_CHARM.get())).define(Character.valueOf('G'), (ItemLike)Items.YELLOW_GLAZED_TERRACOTTA).define(Character.valueOf('R'), (ItemLike)ItemRegistry.YELLOW_ROOF_RIDGE_CONNECTION.get()).define(Character.valueOf('S'), (ItemLike)ItemRegistry.YELLOW_ROOF_TILE_STAIRS.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.GOLD_PARTS.get()).define(Character.valueOf('D'), (ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()).pattern(" SP").pattern("DGG").pattern("RGG").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.YELLOW_GLAZED_TERRACOTTA), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.YELLOW_GLAZED_TERRACOTTA})).save(recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.YELLOW_GLAZED_TERRACOTTA, (Item)ItemRegistry.GOLDEN_GLAZED_ROOF_CHARM_ACCESSORY.get(), RecipeCategory.DECORATIONS, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.GREEN_GLAZED_ROOF_CHARM.get())).define(Character.valueOf('G'), (ItemLike)Items.GREEN_GLAZED_TERRACOTTA).define(Character.valueOf('R'), (ItemLike)ItemRegistry.BLACK_ROOF_RIDGE_CONNECTION.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.GOLD_PARTS.get()).define(Character.valueOf('S'), (ItemLike)ItemRegistry.GRAY_ROOF_TILE_STAIRS.get()).pattern(" SP").pattern(" PG").pattern("RRG").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.GREEN_GLAZED_TERRACOTTA), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.GREEN_GLAZED_TERRACOTTA})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.DARK_PRISMARINE_CHIWEI.get())).define(Character.valueOf('B'), (ItemLike)Items.DARK_PRISMARINE).define(Character.valueOf('S'), (ItemLike)Items.DARK_PRISMARINE_STAIRS).define(Character.valueOf('H'), (ItemLike)Items.DARK_PRISMARINE_SLAB).pattern("HS").pattern("SB").pattern("BB").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.GREEN_GLAZED_TERRACOTTA), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.GREEN_GLAZED_TERRACOTTA})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.QING_GOLDEN_DRAGON_CEILING.get())).define(Character.valueOf('G'), (ItemLike)ItemRegistry.GREEN_CARVED_WOOD.get()).define(Character.valueOf('B'), ModItemTags.COMMON_BLUE_DYE).define(Character.valueOf('D'), (ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()).pattern("G").pattern("B").pattern("D").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GREEN_CARVED_WOOD.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GREEN_CARVED_WOOD.get())).save(recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.QUARTZ_BLOCK, (Item)ItemRegistry.WHITE_MARBLE_RAILING.get(), RecipeCategory.DECORATIONS, recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.QUARTZ_BLOCK, (Item)ItemRegistry.WHITE_MARBLE_RAILING_SLANT.get(), RecipeCategory.DECORATIONS, recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.PLANKS), (ItemLike)ItemRegistry.CARVED_WOODEN_RAILING.get(), 1).unlockedBy("has_plank", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.PLANKS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.PLANKS), (ItemLike)ItemRegistry.WOODEN_RAILING.get(), 1).unlockedBy("has_plank", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.PLANKS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.PLANKS), (ItemLike)ItemRegistry.WOODEN_RAILING_VARIANT.get(), 1).unlockedBy("has_plank", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.PLANKS)).save(recipeConsumer);
        ModRecipeProvider.blockTransform((Item)ItemRegistry.WOODEN_RAILING.get(), ModItemTags.COMMON_RED_DYE, (Item)ItemRegistry.RED_WOODEN_RAILING_EDGE.get(), RecipeCategory.DECORATIONS, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.RED_WOODEN_RAILING.get()), (int)2).define(Character.valueOf('C'), (ItemLike)ItemRegistry.RED_WOODEN_RAILING_EDGE.get()).pattern("CC").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.RED_WOODEN_RAILING_EDGE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.RED_WOODEN_RAILING_EDGE.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.LOGS), (ItemLike)ItemRegistry.SMALL_WOODEN_GUARDIAN_LION.get(), 1).unlockedBy("has_log", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.LOGS)).save(recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.STONE, (Item)ItemRegistry.SMALL_STONE_GUARDIAN_LION.get(), RecipeCategory.DECORATIONS, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SMALL_JADE_GUARDIAN_LION.get())).define(Character.valueOf('L'), (ItemLike)ItemRegistry.SMALL_STONE_GUARDIAN_LION.get()).define(Character.valueOf('J'), (ItemLike)ItemRegistry.JADE.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.JADE_PARTS.get()).pattern("PJP").pattern("JLJ").pattern("PJP").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_STONE_GUARDIAN_LION.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_STONE_GUARDIAN_LION.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SMALL_YELLOW_GLAZED_GUARDIAN_LION.get())).define(Character.valueOf('L'), (ItemLike)ItemRegistry.SMALL_STONE_GUARDIAN_LION.get()).define(Character.valueOf('G'), (ItemLike)Items.YELLOW_GLAZED_TERRACOTTA).define(Character.valueOf('P'), (ItemLike)ItemRegistry.GOLD_PARTS.get()).define(Character.valueOf('D'), (ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()).pattern("DGD").pattern("GLG").pattern("PGP").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_STONE_GUARDIAN_LION.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_STONE_GUARDIAN_LION.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SMALL_GREEN_GLAZED_GUARDIAN_LION.get())).define(Character.valueOf('L'), (ItemLike)ItemRegistry.SMALL_STONE_GUARDIAN_LION.get()).define(Character.valueOf('G'), (ItemLike)ItemRegistry.GREEN_GLAZED_TILES.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.PORCELAIN_PARTS.get()).pattern("PGP").pattern("GLG").pattern("PGP").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_STONE_GUARDIAN_LION.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_STONE_GUARDIAN_LION.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.XUMI_STONE_MONOLITH.get())).define(Character.valueOf('B'), (ItemLike)ItemRegistry.STONE_PILLAR_BASE.get()).define(Character.valueOf('C'), (ItemLike)Items.CHISELED_STONE_BRICKS).define(Character.valueOf('S'), (ItemLike)Items.STONE).define(Character.valueOf('H'), (ItemLike)Items.STONE_SLAB).pattern("HHH").pattern("SCS").pattern("BBB").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.STONE_PILLAR_BASE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.STONE_PILLAR_BASE.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Items.BOOKSHELF, (ItemLike)ItemRegistry.BOOKSHELF.get(), 1, recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Items.BOOKSHELF, (ItemLike)ItemRegistry.BOOKSHELF_VARIANT.get(), 1, recipeConsumer);
    }

    private static void categoryDecorations(@NotNull RecipeOutput recipeConsumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.ABACUS.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.WOODEN_PARTS.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("PFP").pattern("SSS").pattern("PFP").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.WOODEN_PARTS.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.WOODEN_PARTS.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.BRUSH_TOOLS.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.WOODEN_PARTS.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("SSS").pattern("S S").pattern("PFP").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.WOODEN_PARTS.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.WOODEN_PARTS.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.BRUSH_AND_INKSTONE.get())).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('F'), (ItemLike)ItemRegistry.FUR.get()).define(Character.valueOf('R'), (ItemLike)Items.STONE_SLAB).define(Character.valueOf('I'), (ItemLike)Items.INK_SAC).define(Character.valueOf('P'), (ItemLike)ItemRegistry.XUAN_PAPER.get()).pattern("S ").pattern("FI").pattern("RP").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.XUAN_PAPER.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.XUAN_PAPER.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.RULER.get())).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('P'), (ItemLike)ItemRegistry.WOODEN_PARTS.get()).pattern("SPS").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.WOODEN_PARTS.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.WOODEN_PARTS.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.BOOK_STACK.get())).define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('D'), (ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()).pattern("BD").pattern("BD").pattern("BD").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.BOOK), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.BOOK})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.PAPER.get()), (int)2).define(Character.valueOf('P'), (ItemLike)ItemRegistry.XUAN_PAPER.get()).pattern("PP").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.XUAN_PAPER.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.XUAN_PAPER.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.BLUE_BOOK.get())).define(Character.valueOf('B'), (ItemLike)Items.BOOK).define(Character.valueOf('D'), (ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()).pattern("BD").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.BOOK), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.BOOK})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.BAMBOO_SLIPS.get())).define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('B'), (ItemLike)Items.BAMBOO).pattern("BBS").pattern("BBS").pattern("BBS").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.BAMBOO), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.BAMBOO})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.BACK_CUSHION.get())).define(Character.valueOf('W'), (ItemLike)Items.YELLOW_WOOL).define(Character.valueOf('S'), (ItemLike)ItemRegistry.SILK.get()).pattern("WS").pattern("WS").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SILK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SILK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.CHESSBOARD.get())).define(Character.valueOf('P'), ModItemTags.POLISHED_PLANKS).define(Character.valueOf('B'), (ItemLike)Items.POLISHED_BLACKSTONE).define(Character.valueOf('W'), (ItemLike)Items.SMOOTH_QUARTZ).pattern("BW").pattern("PP").unlockedBy("has_polished_plank", ModRecipeProvider.tagUnlock(ModItemTags.POLISHED_PLANKS)).save(recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_VASE.get(), (Item)ItemRegistry.MEDIUM_CLAY_VASE.get(), (Item)ItemRegistry.BLUE_AND_WHITE_GLAZE_POWDER.get(), 0.1f, 200, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.LARGE_BLUE_AND_WHITE_PORCELAIN_VASE.get(), (Item)ItemRegistry.LARGE_CLAY_VASE.get(), (Item)ItemRegistry.BLUE_AND_WHITE_GLAZE_POWDER.get(), 0.1f, 200, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.SHORT_BLUE_AND_WHITE_PORCELAIN_POT.get(), (Item)ItemRegistry.CLAY_POT.get(), (Item)ItemRegistry.BLUE_AND_WHITE_GLAZE_POWDER.get(), 0.1f, 200, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.TALL_BLUE_AND_WHITE_PORCELAIN_POT.get(), (Item)ItemRegistry.TALL_CLAY_POT.get(), (Item)ItemRegistry.BLUE_AND_WHITE_GLAZE_POWDER.get(), 0.1f, 200, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_BOWL.get(), (Item)ItemRegistry.CLAY_BOWL.get(), (Item)ItemRegistry.BLUE_AND_WHITE_GLAZE_POWDER.get(), 0.1f, 200, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.BRONZE_MIRROR.get())).define(Character.valueOf('I'), (ItemLike)ItemRegistry.BRONZE_INGOT.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.BRONZE_PARTS.get()).define(Character.valueOf('C'), (ItemLike)Items.COPPER_INGOT).pattern("PIP").pattern("CIC").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BRONZE_INGOT.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BRONZE_INGOT.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.MEMORIAL_TABLET.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('P'), ModItemTags.POLISHED_PLANKS).define(Character.valueOf('E'), (ItemLike)ItemRegistry.WOODEN_PARTS.get()).define(Character.valueOf('S'), (ItemLike)ItemRegistry.SILK.get()).define(Character.valueOf('W'), (ItemLike)Items.BLACK_WOOL).pattern("EWE").pattern("SPS").pattern("EFE").unlockedBy("has_polished_plank", ModRecipeProvider.tagUnlock(ModItemTags.POLISHED_PLANKS)).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.BRONZE_CENSER.get())).define(Character.valueOf('I'), (ItemLike)ItemRegistry.BRONZE_INGOT.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.BRONZE_PARTS.get()).pattern("PIP").pattern("III").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BRONZE_INGOT.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BRONZE_INGOT.get())).save(recipeConsumer);
        CompositeSmeltingRecipeBuilder.compositeSmelting(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BRONZE_CENSER.get()}), Ingredient.of(ModItemTags.COMMON_CYAN_DYE), (ItemLike)ItemRegistry.ROYAL_CENSER.get(), 0.5f, 200).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BRONZE_CENSER.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BRONZE_CENSER.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.BOOTS.get())).define(Character.valueOf('B'), (ItemLike)Items.LEATHER_BOOTS).define(Character.valueOf('S'), (ItemLike)ItemRegistry.SILK.get()).define(Character.valueOf('D'), (ItemLike)ItemRegistry.BLACK_DYE_POWDER.get()).pattern("D D").pattern("SBS").pattern("SSS").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SILK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SILK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.JADE_PENDANT.get())).define(Character.valueOf('J'), (ItemLike)ItemRegistry.JADE.get()).define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('R'), (ItemLike)ItemRegistry.RED_DYE_POWDER.get()).pattern("J").pattern("S").pattern("R").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.JADE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.JADE.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.IMPERIAL_JADE_SEAL.get())).define(Character.valueOf('J'), (ItemLike)ItemRegistry.JADE.get()).define(Character.valueOf('G'), (ItemLike)Items.ENCHANTED_GOLDEN_APPLE).define(Character.valueOf('P'), (ItemLike)ItemRegistry.GOLD_PARTS.get()).pattern("PG").pattern("JJ").pattern("JJ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.JADE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.JADE.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.LONG_PILLOW.get())).define(Character.valueOf('Y'), (ItemLike)Items.YELLOW_WOOL).define(Character.valueOf('R'), (ItemLike)Items.RED_WOOL).define(Character.valueOf('S'), (ItemLike)ItemRegistry.SILK.get()).pattern("SSS").pattern("YRY").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SILK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SILK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.WIND_CHIME.get())).define(Character.valueOf('C'), (ItemLike)Items.CHAIN).define(Character.valueOf('B'), (ItemLike)ItemRegistry.BRONZE_INGOT.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.BRONZE_PARTS.get()).pattern("C").pattern("B").pattern("P").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BRONZE_INGOT.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BRONZE_INGOT.get())).save(recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_FLOWERPOT.get(), Items.FLOWER_POT, (Item)ItemRegistry.BLUE_AND_WHITE_GLAZE_POWDER.get(), 0.1f, 200, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.TERRACOTTA_FLOWERPOT.get())).define(Character.valueOf('P'), (ItemLike)Items.FLOWER_POT).define(Character.valueOf('T'), (ItemLike)Items.TERRACOTTA).pattern("T T").pattern("TPT").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.FLOWER_POT), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.FLOWER_POT})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.BLACK_IRON_FLOWERPOT.get())).define(Character.valueOf('P'), (ItemLike)Items.FLOWER_POT).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('D'), (ItemLike)Items.BLACK_DYE).pattern("IDI").pattern("IPI").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.FLOWER_POT), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.FLOWER_POT})).save(recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.BLUE_PORCELAIN_FLOWERPOT.get(), Items.FLOWER_POT, Items.BLUE_DYE, 0.1f, 200, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SACK.get())).define(Character.valueOf('T'), (ItemLike)Items.STRING).define(Character.valueOf('S'), (ItemLike)ItemRegistry.SILK.get()).pattern(" T ").pattern("SSS").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SILK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SILK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.EMPTY_BAMBOO_TEA_BASKET.get())).define(Character.valueOf('B'), (ItemLike)Items.BAMBOO).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('R'), (ItemLike)Items.RED_DYE).define(Character.valueOf('X'), (ItemLike)ItemRegistry.XUAN_PAPER.get()).pattern("BRB").pattern("PXP").pattern("BPB").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.BAMBOO), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.BAMBOO})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.STRAW_HAT.get())).define(Character.valueOf('W'), (ItemLike)Items.WHEAT).define(Character.valueOf('S'), (ItemLike)ItemRegistry.SILK.get()).define(Character.valueOf('R'), (ItemLike)ItemRegistry.RED_DYE_POWDER.get()).pattern("RSR").pattern("WWW").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SILK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SILK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.KNIFE.get())).define(Character.valueOf('S'), (ItemLike)Items.IRON_SWORD).define(Character.valueOf('B'), (ItemLike)ItemRegistry.BRONZE_PARTS.get()).pattern("S ").pattern(" B").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BRONZE_PARTS.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BRONZE_PARTS.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.BROOM.get())).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('H'), (ItemLike)Items.HAY_BLOCK).pattern("S").pattern("H").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.HAY_BLOCK), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.HAY_BLOCK})).save(recipeConsumer);
        ModRecipeProvider.simpleStonecutting((Item)ItemRegistry.PALE_YELLOW_STONE.get(), (Item)ItemRegistry.STONE_PEDESTAL.get(), RecipeCategory.DECORATIONS, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.TERRACOTTA_POT.get())).define(Character.valueOf('T'), (ItemLike)Items.CYAN_TERRACOTTA).pattern("T T").pattern("TTT").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CYAN_TERRACOTTA), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CYAN_TERRACOTTA})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.FRUIT_BOX.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('P'), ModItemTags.POLISHED_PLANKS).define(Character.valueOf('A'), (ItemLike)Items.APPLE).pattern("PAP").pattern("PFP").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.APPLE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.APPLE})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.WOODEN_CRATE.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('P'), ModItemTags.POLISHED_PLANKS).pattern("PPP").pattern("PFP").pattern("PPP").unlockedBy("has_polished_plank", ModRecipeProvider.tagUnlock(ModItemTags.POLISHED_PLANKS)).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.GUNNY_SACK.get())).define(Character.valueOf('S'), (ItemLike)ItemRegistry.SILK.get()).pattern("S S").pattern("S S").pattern("SSS").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SILK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SILK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.WOODEN_POLES.get())).define(Character.valueOf('F'), ItemTags.WOODEN_FENCES).pattern("F F").pattern("F F").pattern("F F").unlockedBy("has_fence", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.WOODEN_FENCES)).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.TEAHOUSE_FLAG.get())).define(Character.valueOf('F'), ItemTags.WOODEN_FENCES).define(Character.valueOf('P'), (ItemLike)ItemRegistry.WOODEN_PARTS.get()).define(Character.valueOf('B'), ItemTags.BANNERS).pattern("PFP").pattern(" B ").pattern(" F ").unlockedBy("has_banner", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.BANNERS)).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.KNIFE_REST.get())).define(Character.valueOf('F'), ItemTags.WOODEN_FENCES).define(Character.valueOf('P'), ItemTags.PLANKS).pattern("FFF").pattern("PPP").pattern("FFF").unlockedBy("has_fence", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.WOODEN_FENCES)).save(recipeConsumer);
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.HORIZONTAL_LANDSCAPE_PAINTING.get()}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.DAMAGED_LANDSCAPE_PAINTING.get()), (float)0.1f, (int)400).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.HORIZONTAL_LANDSCAPE_PAINTING.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.HORIZONTAL_LANDSCAPE_PAINTING.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ItemRegistry.FOOD_HAMPER.get())).define(Character.valueOf('C'), (ItemLike)Items.CHEST).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('P'), ModItemTags.POLISHED_PLANKS).define(Character.valueOf('B'), (ItemLike)Items.BREAD).pattern("FBF").pattern("PCP").pattern("PCP").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CHEST), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CHEST})).save(recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ItemRegistry.PLATED_MOON_CAKES.get())).requires((ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PLATE.get()).requires((ItemLike)ItemRegistry.MOONCAKE.get(), 4).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.MOONCAKE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.MOONCAKE.get())).save(recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ItemRegistry.PLATED_MUNG_BEAN_CAKES.get())).requires((ItemLike)ItemRegistry.BLACK_PORCELAIN_PLATE.get()).requires((ItemLike)ItemRegistry.MUNG_BEAN_CAKE.get(), 7).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.MUNG_BEAN_CAKE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.MUNG_BEAN_CAKE.get())).save(recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ItemRegistry.PLATED_HAM.get())).requires((ItemLike)ItemRegistry.POLISHED_OAK_PLANK.get()).requires((ItemLike)ItemRegistry.COOKED_MEAT.get(), 4).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.COOKED_MEAT.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.COOKED_MEAT.get())).save(recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ItemRegistry.PLATED_FISH.get())).requires((ItemLike)ItemRegistry.POLISHED_OAK_PLANK.get()).requires(Ingredient.of((TagKey)ItemTags.FISHES), 3).unlockedBy("has_fish", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.FISHES)).save(recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ItemRegistry.SCATTERED_CARROTS.get())).requires((ItemLike)ItemRegistry.POLISHED_OAK_PLANK.get()).requires((ItemLike)Items.CARROT, 2).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CARROT), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CARROT})).save(recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ItemRegistry.XIAOLONGBAO.get())).requires((ItemLike)ItemRegistry.BAMBOO_MAT_SLAB.get()).requires((ItemLike)ItemRegistry.BAOZI.get(), 8).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BAOZI.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BAOZI.get())).save(recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.ICE, (Item)ItemRegistry.ICICLE.get(), RecipeCategory.DECORATIONS, recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.ICE, (Item)ItemRegistry.LARGE_ICICLE.get(), RecipeCategory.DECORATIONS, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.COUPLET.get()), (int)2).define(Character.valueOf('P'), (ItemLike)ItemRegistry.XUAN_PAPER.get()).define(Character.valueOf('R'), (ItemLike)ItemRegistry.RED_DYE_POWDER.get()).define(Character.valueOf('I'), (ItemLike)Items.INK_SAC).pattern("PRP").pattern("PIP").pattern("PRP").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.XUAN_PAPER.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.XUAN_PAPER.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.COUPLET_TOP.get())).define(Character.valueOf('P'), (ItemLike)ItemRegistry.XUAN_PAPER.get()).define(Character.valueOf('R'), (ItemLike)ItemRegistry.RED_DYE_POWDER.get()).define(Character.valueOf('I'), (ItemLike)Items.INK_SAC).pattern("PPP").pattern("RIR").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.XUAN_PAPER.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.XUAN_PAPER.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.FU_MARK.get())).define(Character.valueOf('P'), (ItemLike)ItemRegistry.XUAN_PAPER.get()).define(Character.valueOf('R'), (ItemLike)ItemRegistry.RED_DYE_POWDER.get()).define(Character.valueOf('G'), (ItemLike)ItemRegistry.GOLD_DYE_POWDER.get()).define(Character.valueOf('I'), (ItemLike)Items.INK_SAC).pattern("GPR").pattern("PIP").pattern("RPG").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.XUAN_PAPER.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.XUAN_PAPER.get())).save(recipeConsumer);
    }

    private static void categoryPlants(@NotNull RecipeOutput recipeConsumer) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SMALL_LOTUS_LEAF.get()), (int)2).requires((ItemLike)Items.LILY_PAD).requires((ItemLike)Items.BIG_DRIPLEAF).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.BIG_DRIPLEAF), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.LILY_PAD, Items.BIG_DRIPLEAF})).save(recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SMALL_DARK_GREEN_LOTUS_LEAF.get()), (int)1).requires((ItemLike)ItemRegistry.SMALL_LOTUS_LEAF.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_LOTUS_LEAF.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_LOTUS_LEAF.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.MEDIUM_LOTUS_LEAF.get()), (int)1).define(Character.valueOf('L'), (ItemLike)ItemRegistry.SMALL_LOTUS_LEAF.get()).pattern("LL").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_LOTUS_LEAF.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_LOTUS_LEAF.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.LARGE_LOTUS_LEAF.get()), (int)1).define(Character.valueOf('L'), (ItemLike)ItemRegistry.SMALL_LOTUS_LEAF.get()).pattern("LLL").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_LOTUS_LEAF.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_LOTUS_LEAF.get())).save(recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.TILTED_LOTUS_LEAF.get()), (int)1).requires((ItemLike)ItemRegistry.LARGE_LOTUS_LEAF.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.LARGE_LOTUS_LEAF.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.LARGE_LOTUS_LEAF.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SMALL_LOTUS_LEAF_CLUSTER.get()), (int)2).define(Character.valueOf('L'), (ItemLike)ItemRegistry.SMALL_LOTUS_LEAF.get()).pattern("L ").pattern(" L").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_LOTUS_LEAF.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_LOTUS_LEAF.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.MEDIUM_LOTUS_LEAF_CLUSTER.get()), (int)2).define(Character.valueOf('L'), (ItemLike)ItemRegistry.MEDIUM_LOTUS_LEAF.get()).pattern("L ").pattern(" L").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.MEDIUM_LOTUS_LEAF.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.MEDIUM_LOTUS_LEAF.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.LOTUS_BUD.get()), (int)1).define(Character.valueOf('L'), (ItemLike)Items.BIG_DRIPLEAF).define(Character.valueOf('F'), (ItemLike)Items.SPORE_BLOSSOM).pattern("F").pattern("L").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.SPORE_BLOSSOM), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.SPORE_BLOSSOM})).save(recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.MEDIUM_LOTUS.get()), (int)1).requires((ItemLike)ItemRegistry.LOTUS_BUD.get()).requires((ItemLike)Items.BONE_MEAL).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.LOTUS_BUD.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.LOTUS_BUD.get())).save(recipeConsumer);
        ModRecipeProvider.blockTransform(Items.VINE, ModItemTags.COMMON_RED_DYE, (Item)ItemRegistry.SMALL_RED_IVY.get(), RecipeCategory.DECORATIONS, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.MEDIUM_RED_IVY.get()), (int)1).define(Character.valueOf('I'), (ItemLike)ItemRegistry.SMALL_RED_IVY.get()).pattern("I").pattern("I").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_RED_IVY.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_RED_IVY.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.LARGE_RED_IVY.get()), (int)1).define(Character.valueOf('I'), (ItemLike)ItemRegistry.SMALL_RED_IVY.get()).pattern("I").pattern("I").pattern("I").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_RED_IVY.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_RED_IVY.get())).save(recipeConsumer);
        ModRecipeProvider.blockTransform(Items.VINE, ModItemTags.COMMON_YELLOW_DYE, (Item)ItemRegistry.SMALL_YELLOW_IVY.get(), RecipeCategory.DECORATIONS, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.MEDIUM_YELLOW_IVY.get()), (int)1).define(Character.valueOf('I'), (ItemLike)ItemRegistry.SMALL_YELLOW_IVY.get()).pattern("I").pattern("I").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_YELLOW_IVY.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_YELLOW_IVY.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.LARGE_YELLOW_IVY.get()), (int)1).define(Character.valueOf('I'), (ItemLike)ItemRegistry.SMALL_YELLOW_IVY.get()).pattern("I").pattern("I").pattern("I").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_YELLOW_IVY.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_YELLOW_IVY.get())).save(recipeConsumer);
        ModRecipeProvider.blockTransform(Items.VINE, ModItemTags.COMMON_GREEN_DYE, (Item)ItemRegistry.SMALL_GREEN_IVY.get(), RecipeCategory.DECORATIONS, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.MEDIUM_GREEN_IVY.get()), (int)1).define(Character.valueOf('I'), (ItemLike)ItemRegistry.SMALL_GREEN_IVY.get()).pattern("I").pattern("I").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_GREEN_IVY.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_GREEN_IVY.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.LARGE_GREEN_IVY.get()), (int)1).define(Character.valueOf('I'), (ItemLike)ItemRegistry.SMALL_RED_IVY.get()).pattern("I").pattern("I").pattern("I").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_GREEN_IVY.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_GREEN_IVY.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.LEAVES), (ItemLike)ItemRegistry.SMALL_LEAF_PILE.get(), 8).unlockedBy("has_leaves", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.LEAVES)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.LEAVES), (ItemLike)ItemRegistry.MEDIUM_LEAF_PILE.get(), 5).unlockedBy("has_leaves", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.LEAVES)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.LEAVES), (ItemLike)ItemRegistry.LARGE_LEAF_PILE.get(), 3).unlockedBy("has_leaves", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.LEAVES)).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SMALL_GREETING_PINE_BONSAI.get()), (int)1).define(Character.valueOf('P'), (ItemLike)Items.FLOWER_POT).define(Character.valueOf('S'), (ItemLike)Items.SPRUCE_SAPLING).define(Character.valueOf('D'), (ItemLike)Items.BROWN_DYE).pattern("S ").pattern("PD").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.FLOWER_POT), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.FLOWER_POT})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.MEDIUM_GREETING_PINE_BONSAI.get()), (int)1).define(Character.valueOf('P'), (ItemLike)Items.FLOWER_POT).define(Character.valueOf('S'), (ItemLike)Items.SPRUCE_SAPLING).define(Character.valueOf('D'), (ItemLike)Items.BLACK_DYE).pattern("SS").pattern("PD").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.FLOWER_POT), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.FLOWER_POT})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.LARGE_GREETING_PINE_BONSAI.get()), (int)1).define(Character.valueOf('P'), (ItemLike)Items.FLOWER_POT).define(Character.valueOf('S'), (ItemLike)Items.SPRUCE_SAPLING).define(Character.valueOf('D'), (ItemLike)Items.CYAN_DYE).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('W'), ModItemTags.POLISHED_PLANKS).pattern("SS").pattern("PD").pattern("FW").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.FLOWER_POT), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.FLOWER_POT})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SMALL_WHITE_PORCELAIN_VASE_BONSAI.get()), (int)1).define(Character.valueOf('V'), (ItemLike)ItemRegistry.SMALL_WHITE_PORCELAIN_VASE.get()).define(Character.valueOf('S'), ItemTags.SAPLINGS).pattern("S").pattern("V").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_WHITE_PORCELAIN_VASE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_WHITE_PORCELAIN_VASE.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.MEDIUM_WHITE_PORCELAIN_VASE_BONSAI.get()), (int)1).define(Character.valueOf('V'), (ItemLike)ItemRegistry.MEDIUM_WHITE_PORCELAIN_VASE.get()).define(Character.valueOf('S'), ItemTags.SAPLINGS).pattern("S").pattern("V").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.MEDIUM_WHITE_PORCELAIN_VASE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.MEDIUM_WHITE_PORCELAIN_VASE.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.LARGE_WHITE_PORCELAIN_VASE_BONSAI.get()), (int)1).define(Character.valueOf('V'), (ItemLike)ItemRegistry.LARGE_WHITE_PORCELAIN_VASE.get()).define(Character.valueOf('S'), ItemTags.SAPLINGS).pattern("S").pattern("V").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.LARGE_WHITE_PORCELAIN_VASE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.LARGE_WHITE_PORCELAIN_VASE.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SMALL_GREEN_PORCELAIN_VASE_BONSAI.get()), (int)1).define(Character.valueOf('V'), (ItemLike)ItemRegistry.SMALL_GREEN_PORCELAIN_VASE.get()).define(Character.valueOf('S'), ItemTags.SAPLINGS).pattern("S").pattern("V").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_GREEN_PORCELAIN_VASE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_GREEN_PORCELAIN_VASE.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.GREEN_PORCELAIN_VASE_BONSAI.get()), (int)1).define(Character.valueOf('V'), (ItemLike)ItemRegistry.MEDIUM_GREEN_PORCELAIN_VASE.get()).define(Character.valueOf('S'), ItemTags.SAPLINGS).pattern("S").pattern("V").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.MEDIUM_GREEN_PORCELAIN_VASE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.MEDIUM_GREEN_PORCELAIN_VASE.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.RED_CORAL_BONSAI.get()), (int)1).define(Character.valueOf('P'), (ItemLike)Items.FLOWER_POT).define(Character.valueOf('C'), (ItemLike)Items.FIRE_CORAL).define(Character.valueOf('D'), (ItemLike)Items.BLACK_DYE).pattern("C ").pattern("PD").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.FLOWER_POT), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.FLOWER_POT})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.RED_PLUM_BONSAI.get()), (int)1).define(Character.valueOf('P'), (ItemLike)Items.FLOWER_POT).define(Character.valueOf('C'), ItemTags.SAPLINGS).define(Character.valueOf('D'), (ItemLike)Items.CYAN_DYE).pattern("C ").pattern("PD").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.FLOWER_POT), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.FLOWER_POT})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.BAMBOO_BONSAI.get()), (int)1).define(Character.valueOf('P'), (ItemLike)Items.FLOWER_POT).define(Character.valueOf('C'), (ItemLike)Items.BAMBOO).define(Character.valueOf('D'), (ItemLike)Items.CYAN_DYE).pattern("C ").pattern("PD").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.FLOWER_POT), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.FLOWER_POT})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.TALL_BLUE_VASE_BONSAI.get()), (int)1).define(Character.valueOf('V'), (ItemLike)ItemRegistry.TALL_BLUE_PORCELAIN_VASE.get()).define(Character.valueOf('S'), ItemTags.SAPLINGS).pattern("S").pattern("V").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.TALL_BLUE_PORCELAIN_VASE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.TALL_BLUE_PORCELAIN_VASE.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.TALL_BLUE_AND_WHITE_PORCELAIN_BONSAI.get()), (int)1).define(Character.valueOf('V'), (ItemLike)ItemRegistry.TALL_BLUE_AND_WHITE_PORCELAIN_VASE.get()).define(Character.valueOf('S'), ItemTags.SAPLINGS).pattern("S").pattern("V").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.TALL_BLUE_AND_WHITE_PORCELAIN_VASE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.TALL_BLUE_AND_WHITE_PORCELAIN_VASE.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.MEDIUM_BONSAI.get()), (int)1).define(Character.valueOf('P'), (ItemLike)Items.FLOWER_POT).define(Character.valueOf('B'), (ItemLike)Items.BRICK).define(Character.valueOf('S'), ItemTags.SAPLINGS).define(Character.valueOf('D'), (ItemLike)Items.CYAN_DYE).pattern(" S ").pattern("DPD").pattern(" B ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.FLOWER_POT), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.FLOWER_POT})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.LARGE_BONSAI.get()), (int)1).define(Character.valueOf('P'), (ItemLike)Items.FLOWER_POT).define(Character.valueOf('B'), (ItemLike)Items.BRICK).define(Character.valueOf('S'), ItemTags.SAPLINGS).pattern(" S ").pattern("BPB").pattern(" B ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.FLOWER_POT), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.FLOWER_POT})).save(recipeConsumer);
    }

    private static void categoryFurniture(@NotNull RecipeOutput recipeConsumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.OAK_CABINET.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('W'), (ItemLike)ItemRegistry.POLISHED_OAK_PLANK.get()).define(Character.valueOf('C'), (ItemLike)Items.CHEST).pattern("WWW").pattern("WCW").pattern("WFW").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.POLISHED_OAK_PLANK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.POLISHED_OAK_PLANK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.WARPED_CABINET.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('W'), (ItemLike)ItemRegistry.POLISHED_WARPED_PLANK.get()).define(Character.valueOf('P'), (ItemLike)Items.WARPED_PLANKS).define(Character.valueOf('C'), (ItemLike)Items.CHEST).pattern("WWW").pattern("WCW").pattern("PFP").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.POLISHED_WARPED_PLANK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.POLISHED_WARPED_PLANK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.EBONY_CABINET.get())).define(Character.valueOf('W'), (ItemLike)ItemRegistry.POLISHED_EBONY_PLANK.get()).define(Character.valueOf('G'), (ItemLike)ItemRegistry.GOLD_PARTS.get()).define(Character.valueOf('C'), (ItemLike)Items.CHEST).pattern("GWG").pattern("WCW").pattern("WCW").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.POLISHED_WARPED_PLANK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.POLISHED_WARPED_PLANK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.LARGE_TEA_TABLE.get())).define(Character.valueOf('P'), (ItemLike)Items.SPRUCE_PLANKS).define(Character.valueOf('W'), (ItemLike)ItemRegistry.POLISHED_SPRUCE_PLANK.get()).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("WWW").pattern("PPP").pattern("SFS").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.POLISHED_SPRUCE_PLANK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.POLISHED_SPRUCE_PLANK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.CHESS_TABLE.get())).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('B'), (ItemLike)ItemRegistry.CHESSBOARD.get()).pattern(" B ").pattern("PPP").pattern("SFS").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.CHESSBOARD.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.CHESSBOARD.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.HIGH_TABLE_WITH_WHITE_TOP.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('W'), (ItemLike)ItemRegistry.POLISHED_BIRCH_PLANK.get()).pattern(" W ").pattern("SFS").pattern("S S").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.POLISHED_BIRCH_PLANK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.POLISHED_BIRCH_PLANK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.CENSER_TABLE.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('W'), (ItemLike)ItemRegistry.POLISHED_SPRUCE_PLANK.get()).define(Character.valueOf('G'), (ItemLike)ItemRegistry.GOLD_PARTS.get()).pattern("GWG").pattern("SFS").pattern("SWS").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.POLISHED_SPRUCE_PLANK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.POLISHED_SPRUCE_PLANK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.PORCELAIN_INLAID_TABLE.get())).define(Character.valueOf('P'), (ItemLike)ItemRegistry.PORCELAIN_PARTS.get()).define(Character.valueOf('W'), (ItemLike)ItemRegistry.WOODEN_PARTS.get()).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('S'), (ItemLike)ItemRegistry.POLISHED_ROSEWOOD_PLANK.get()).define(Character.valueOf('L'), (ItemLike)ItemRegistry.ROSEWOOD_PLANKS.get()).pattern(" P ").pattern("WSW").pattern("LFL").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.POLISHED_ROSEWOOD_PLANK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.POLISHED_ROSEWOOD_PLANK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SMALL_TABLE.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('W'), ModItemTags.POLISHED_PLANKS).pattern(" W ").pattern("SFS").unlockedBy("has_polished_plank", ModRecipeProvider.tagUnlock(ModItemTags.POLISHED_PLANKS)).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SMALL_EBONY_TABLE.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('W'), (ItemLike)ItemRegistry.POLISHED_EBONY_PLANK.get()).pattern(" W ").pattern("SFS").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.POLISHED_EBONY_PLANK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.POLISHED_EBONY_PLANK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.LARGE_TABLE.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('P'), ItemTags.PLANKS).pattern("PPP").pattern("PPP").pattern("SFS").unlockedBy("has_plank", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.PLANKS)).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.LONG_TABLE.get())).define(Character.valueOf('P'), (ItemLike)ItemRegistry.ROSEWOOD_PLANKS.get()).define(Character.valueOf('W'), (ItemLike)ItemRegistry.POLISHED_ROSEWOOD_PLANK.get()).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("WWW").pattern("PPP").pattern("SFS").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.POLISHED_ROSEWOOD_PLANK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.POLISHED_ROSEWOOD_PLANK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.EBONY_CHAIR.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('W'), (ItemLike)ItemRegistry.POLISHED_EBONY_PLANK.get()).pattern("FW ").pattern("SFS").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.POLISHED_EBONY_PLANK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.POLISHED_EBONY_PLANK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.CHAIR_WITH_YELLOW_CUSHION.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('C'), (ItemLike)ItemRegistry.YELLOW_CUSHION.get()).pattern("FC ").pattern("SFS").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.YELLOW_CUSHION.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.YELLOW_CUSHION.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.PAINTED_CHAIR.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('W'), ModItemTags.POLISHED_PLANKS).define(Character.valueOf('A'), (ItemLike)ItemRegistry.WOODEN_PARTS.get()).define(Character.valueOf('P'), ModItemTags.PAINTING_SCROLL_ITEMS).pattern("P  ").pattern("FWA").pattern("WFW").unlockedBy("has_painting", ModRecipeProvider.tagUnlock(ModItemTags.PAINTING_SCROLL_ITEMS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.LOGS), (ItemLike)ItemRegistry.WOODEN_STOOL.get(), 1).unlockedBy("has_log", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.LOGS)).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.PORCELAIN_INLAID_GRAND_CHAIR.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('W'), (ItemLike)ItemRegistry.POLISHED_ROSEWOOD_PLANK.get()).define(Character.valueOf('A'), (ItemLike)ItemRegistry.WOODEN_PARTS.get()).define(Character.valueOf('I'), (ItemLike)ItemRegistry.PORCELAIN_PARTS.get()).pattern("FIA").pattern("WIA").pattern("WFW").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.POLISHED_ROSEWOOD_PLANK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.POLISHED_ROSEWOOD_PLANK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.YELLOW_CUSHION.get())).define(Character.valueOf('W'), (ItemLike)Items.YELLOW_WOOL).define(Character.valueOf('S'), (ItemLike)ItemRegistry.SILK.get()).pattern("SS").pattern("WW").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SILK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SILK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.OAK_BED.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('W'), (ItemLike)ItemRegistry.POLISHED_OAK_PLANK.get()).define(Character.valueOf('A'), (ItemLike)ItemRegistry.WOODEN_PARTS.get()).pattern("FAF").pattern("WWW").pattern("WFW").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.POLISHED_OAK_PLANK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.POLISHED_OAK_PLANK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.EBONY_BED.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('W'), (ItemLike)ItemRegistry.POLISHED_OAK_PLANK.get()).define(Character.valueOf('G'), (ItemLike)ItemRegistry.GILDED_DARK_OAK.get()).define(Character.valueOf('S'), (ItemLike)ItemRegistry.SILK.get()).pattern("FSF").pattern("GWG").pattern("WFW").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.POLISHED_EBONY_PLANK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.POLISHED_EBONY_PLANK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.LARGE_LANDSCAPE_PAINTING_SCREEN.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('W'), ModItemTags.POLISHED_PLANKS).define(Character.valueOf('B'), ItemTags.PLANKS).define(Character.valueOf('A'), (ItemLike)ItemRegistry.WOODEN_PARTS.get()).define(Character.valueOf('P'), ModItemTags.PAINTING_SCROLL_ITEMS).pattern("AFA").pattern("PPP").pattern("WBW").unlockedBy("has_painting", ModRecipeProvider.tagUnlock(ModItemTags.PAINTING_SCROLL_ITEMS)).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.PAINTED_SCREEN.get())).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('W'), (ItemLike)ItemRegistry.POLISHED_ROSEWOOD_PLANK.get()).define(Character.valueOf('B'), (ItemLike)ItemRegistry.ROSEWOOD_PLANKS.get()).define(Character.valueOf('A'), (ItemLike)ItemRegistry.WOODEN_PARTS.get()).define(Character.valueOf('P'), ModItemTags.PAINTING_SCROLL_ITEMS).pattern("AWA").pattern("FPF").pattern("WBW").unlockedBy("has_painting", ModRecipeProvider.tagUnlock(ModItemTags.PAINTING_SCROLL_ITEMS)).save(recipeConsumer);
    }

    private static void categoryLamps(@NotNull RecipeOutput recipeConsumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Items.WHITE_CANDLE, (int)1).define(Character.valueOf('S'), (ItemLike)Items.STRING).define(Character.valueOf('G'), (ItemLike)ItemRegistry.GREASE.get()).pattern("S").pattern("G").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GREASE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GREASE.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.OCTAGONAL_PALACE_LANTERN.get()), (int)1).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('P'), ModItemTags.POLISHED_PLANKS).define(Character.valueOf('C'), ItemTags.CANDLES).pattern("FPF").pattern("PCP").pattern("FPF").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CANDLE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CANDLE})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SQUARE_PALACE_LANTERN.get()), (int)1).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('C'), ItemTags.CANDLES).pattern(" F ").pattern("FCF").pattern(" F ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CANDLE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CANDLE})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.STANDING_LAMP.get()), (int)1).define(Character.valueOf('X'), (ItemLike)ItemRegistry.XUAN_PAPER.get()).define(Character.valueOf('C'), ItemTags.CANDLES).define(Character.valueOf('W'), ItemTags.PLANKS).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.WOODEN_PARTS.get()).pattern("XCX").pattern("PFP").pattern(" W ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CANDLE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CANDLE})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SMALL_STANDING_LAMP.get()), (int)1).define(Character.valueOf('X'), (ItemLike)ItemRegistry.XUAN_PAPER.get()).define(Character.valueOf('C'), ItemTags.CANDLES).define(Character.valueOf('W'), (ItemLike)Items.STICK).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.WOODEN_PARTS.get()).pattern("XCX").pattern("PFP").pattern(" W ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CANDLE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CANDLE})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.WHITE_SKY_LANTERN.get()), (int)1).define(Character.valueOf('X'), (ItemLike)ItemRegistry.XUAN_PAPER.get()).define(Character.valueOf('C'), ItemTags.CANDLES).define(Character.valueOf('D'), (ItemLike)Items.WHITE_DYE).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).pattern("XDX").pattern("XCX").pattern(" F ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CANDLE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CANDLE})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.YELLOW_SKY_LANTERN.get()), (int)1).define(Character.valueOf('X'), (ItemLike)ItemRegistry.XUAN_PAPER.get()).define(Character.valueOf('C'), ItemTags.CANDLES).define(Character.valueOf('D'), (ItemLike)Items.YELLOW_DYE).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).pattern("XDX").pattern("XCX").pattern(" F ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CANDLE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CANDLE})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.RED_SKY_LANTERN.get()), (int)1).define(Character.valueOf('X'), (ItemLike)ItemRegistry.XUAN_PAPER.get()).define(Character.valueOf('C'), ItemTags.CANDLES).define(Character.valueOf('D'), (ItemLike)Items.RED_DYE).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).pattern("XDX").pattern("XCX").pattern(" F ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CANDLE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CANDLE})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SMALL_RED_LANTERN.get()), (int)1).define(Character.valueOf('S'), (ItemLike)Items.STICK).define(Character.valueOf('C'), ItemTags.CANDLES).define(Character.valueOf('D'), (ItemLike)Items.RED_DYE).define(Character.valueOf('P'), (ItemLike)Items.PAPER).pattern(" S ").pattern("PCP").pattern("DPD").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CANDLE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CANDLE})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.STONE_LAMP.get()), (int)1).define(Character.valueOf('S'), (ItemLike)Items.STONE).define(Character.valueOf('C'), ItemTags.CANDLES).define(Character.valueOf('W'), (ItemLike)Items.COBBLESTONE_WALL).define(Character.valueOf('T'), (ItemLike)Items.STONE_SLAB).pattern(" T ").pattern("WCW").pattern(" S ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CANDLE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CANDLE})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.RED_CANDLE.get()), (int)1).define(Character.valueOf('C'), (ItemLike)Items.RED_CANDLE).define(Character.valueOf('P'), (ItemLike)ItemRegistry.WOODEN_PARTS.get()).pattern("C").pattern("P").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CANDLE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CANDLE})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.TRICOLOR_CANDLESTICK.get()), (int)1).define(Character.valueOf('C'), (ItemLike)Items.WHITE_CANDLE).define(Character.valueOf('P'), (ItemLike)ItemRegistry.PORCELAIN_PARTS.get()).pattern("C").pattern("P").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CANDLE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CANDLE})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.JADE_CANDLESTICK.get()), (int)1).define(Character.valueOf('C'), (ItemLike)Items.WHITE_CANDLE).define(Character.valueOf('P'), (ItemLike)ItemRegistry.JADE_PARTS.get()).pattern("C").pattern("P").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CANDLE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CANDLE})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.RED_LANTERN_STREETLIGHT.get())).define(Character.valueOf('L'), ItemTags.LOGS).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('R'), (ItemLike)ItemRegistry.SMALL_RED_LANTERN.get()).pattern("PP").pattern("LR").pattern("L ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_RED_LANTERN.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_RED_LANTERN.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.HANGING_RED_LANTERN_STREETLIGHT.get())).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('R'), (ItemLike)ItemRegistry.SMALL_RED_LANTERN.get()).pattern("PPP").pattern(" R ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_RED_LANTERN.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_RED_LANTERN.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.STREETLIGHT_POLE.get())).define(Character.valueOf('L'), ItemTags.LOGS).define(Character.valueOf('P'), ItemTags.PLANKS).pattern("P").pattern("L").pattern("L").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_RED_LANTERN.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_RED_LANTERN.get())).save(recipeConsumer);
    }

    private static void categoryWindowsDoors(@NotNull RecipeOutput recipeConsumer) {
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.LOGS), (ItemLike)ItemRegistry.CARVED_WOODEN_DOOR.get(), 1).unlockedBy("has_log", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.LOGS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.LOGS), (ItemLike)ItemRegistry.SONG_WOODEN_DOOR.get(), 1).unlockedBy("has_log", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.LOGS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.PLANKS), (ItemLike)ItemRegistry.SONG_WOODEN_WINDOW.get(), 1).unlockedBy("has_plank", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.PLANKS)).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get()}), (ItemLike)ItemRegistry.ROYAL_ROSEWOOD_WINDOW.get(), 2).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.TALL_ROYAL_ROSEWOOD_WINDOW.get()), (int)1).define(Character.valueOf('W'), (ItemLike)ItemRegistry.ROYAL_ROSEWOOD_WINDOW.get()).pattern("W").pattern("W").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.ROYAL_ROSEWOOD_WINDOW.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.ROYAL_ROSEWOOD_WINDOW.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.GLAZED_TILE_GRID_WINDOW.get())).define(Character.valueOf('G'), (ItemLike)ItemRegistry.GREEN_GLAZED_TILES.get()).define(Character.valueOf('I'), (ItemLike)Items.IRON_BARS).pattern("GGG").pattern("GIG").pattern("GGG").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GREEN_GLAZED_TILES.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GREEN_GLAZED_TILES.get())).save(recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.CHISELED_STONE_BRICKS, (Item)ItemRegistry.STONE_FLOWER_WINDOW.get(), RecipeCategory.DECORATIONS, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.KNOCKER.get())).define(Character.valueOf('I'), (ItemLike)ItemRegistry.BRONZE_INGOT.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.BRONZE_PARTS.get()).pattern("IP").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BRONZE_INGOT.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BRONZE_INGOT.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get()}), (ItemLike)ItemRegistry.ROSEWOOD_PANEL.get(), 2).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get()}), (ItemLike)ItemRegistry.ROSEWOOD_DOOR_PANEL.get(), 2).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get()}), (ItemLike)ItemRegistry.LARGE_ROSEWOOD_PANEL.get(), 2).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get()}), (ItemLike)ItemRegistry.LARGE_ROSEWOOD_PANEL_EDGE.get(), 2).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.VARNISHED_ROSEWOOD.get())).save(recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((TagKey)ItemTags.PLANKS), (ItemLike)ItemRegistry.CARVED_WOODEN_DOOR_PANEL.get(), 1).unlockedBy("has_plank", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.PLANKS)).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.PLAQUE.get())).define(Character.valueOf('P'), (ItemLike)ItemRegistry.XUAN_PAPER.get()).define(Character.valueOf('W'), (ItemLike)ItemRegistry.WOODEN_PARTS.get()).define(Character.valueOf('F'), (ItemLike)ItemRegistry.WOODEN_FRAME.get()).define(Character.valueOf('S'), ModItemTags.POLISHED_PLANKS).define(Character.valueOf('I'), (ItemLike)Items.INK_SAC).pattern("W W").pattern("FSF").pattern("PIP").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.XUAN_PAPER.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.XUAN_PAPER.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.PAPER_STRIP_SEAL.get()), (int)2).define(Character.valueOf('P'), (ItemLike)ItemRegistry.XUAN_PAPER.get()).define(Character.valueOf('I'), (ItemLike)Items.INK_SAC).pattern("P P").pattern(" I ").pattern("P P").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.XUAN_PAPER.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.XUAN_PAPER.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.SMALL_BLUE_CURTAIN.get()), (int)2).define(Character.valueOf('S'), (ItemLike)ItemRegistry.SILK.get()).define(Character.valueOf('D'), (ItemLike)ItemRegistry.BLUE_DYE_POWDER.get()).pattern("SSS").pattern("DDD").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SILK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SILK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.MEDIUM_BLUE_CURTAIN.get()), (int)1).define(Character.valueOf('C'), (ItemLike)ItemRegistry.SMALL_BLUE_CURTAIN.get()).pattern("CC").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_BLUE_CURTAIN.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_BLUE_CURTAIN.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.LARGE_BLUE_CURTAIN.get()), (int)1).define(Character.valueOf('C'), (ItemLike)ItemRegistry.SMALL_BLUE_CURTAIN.get()).pattern("CCC").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SMALL_BLUE_CURTAIN.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SMALL_BLUE_CURTAIN.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.RED_CURTAIN.get())).define(Character.valueOf('S'), (ItemLike)ItemRegistry.SILK.get()).define(Character.valueOf('D'), (ItemLike)ItemRegistry.RED_DYE_POWDER.get()).define(Character.valueOf('G'), (ItemLike)ItemRegistry.GOLD_PARTS.get()).pattern("SSS").pattern("DDD").pattern(" G ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.SILK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.SILK.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.RED_CURTAIN_CORNER.get())).define(Character.valueOf('C'), (ItemLike)ItemRegistry.RED_CURTAIN.get()).pattern("C ").pattern(" C").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.RED_CURTAIN.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.RED_CURTAIN.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((ItemLike)ItemRegistry.BAMBOO_CURTAIN.get())).define(Character.valueOf('B'), (ItemLike)Items.BAMBOO).define(Character.valueOf('S'), (ItemLike)Items.STRING).pattern("BBB").pattern("SSS").pattern("BBB").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.BAMBOO), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.BAMBOO})).save(recipeConsumer);
    }

    private static void categoryMaterials(@NotNull RecipeOutput recipeConsumer) {
        ModRecipeProvider.smeltingAndBlasting((Item)ItemRegistry.UNFIRED_RAW_CYAN_BRICK.get(), (Item)ItemRegistry.CYAN_BRICK.get(), recipeConsumer);
        ModRecipeProvider.smeltingAndBlasting((Item)ItemRegistry.UNFIRED_BLACK_BRICK.get(), (Item)ItemRegistry.BLACK_BRICK.get(), recipeConsumer);
        ModRecipeProvider.smeltingAndBlasting((Item)ItemRegistry.UNFIRED_RAW_BROWNISH_RED_STONE_BRICK.get(), (Item)ItemRegistry.BROWNISH_RED_STONE_BRICK.get(), recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.UNFIRED_CLAY_BRICK.get()), (int)3).define(Character.valueOf('C'), (ItemLike)Items.CLAY_BALL).pattern("CCC").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CLAY_BALL), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CLAY_BALL})).save(recipeConsumer);
        ModRecipeProvider.brickMixture((Item)ItemRegistry.UNFIRED_CLAY_BRICK.get(), 6, (Item)ItemRegistry.PRISMARINE_DUST.get(), (Item)ItemRegistry.UNFIRED_RAW_CYAN_BRICK.get(), recipeConsumer);
        ModRecipeProvider.brickMixture((Item)ItemRegistry.UNFIRED_CLAY_BRICK.get(), 6, (Item)ItemRegistry.HEMATITE_DUST.get(), (Item)ItemRegistry.UNFIRED_BLACK_BRICK.get(), recipeConsumer);
        ModRecipeProvider.brickMixture((Item)ItemRegistry.UNFIRED_CLAY_BRICK.get(), 6, (Item)ItemRegistry.MAGNESITE_DUST.get(), (Item)ItemRegistry.UNFIRED_RAW_BROWNISH_RED_STONE_BRICK.get(), recipeConsumer);
        ModRecipeProvider.smeltingAndBlasting((Item)ItemRegistry.UNFIRED_CLAY_BRICK.get(), (Item)ItemRegistry.FIRED_BRICK.get(), recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BRICK, (int)1).requires((ItemLike)ItemRegistry.FIRED_BRICK.get()).unlockedBy("has_" + String.valueOf(ItemRegistry.FIRED_BRICK.get()), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.FIRED_BRICK.get()})).save(recipeConsumer, "brick_from_fired_brick");
        ModRecipeProvider.dust(Items.PRISMARINE_SHARD, (Item)ItemRegistry.PRISMARINE_DUST.get(), recipeConsumer);
        ModRecipeProvider.dust((Item)ItemRegistry.RAW_HEMATITE.get(), (Item)ItemRegistry.HEMATITE_DUST.get(), recipeConsumer);
        ModRecipeProvider.dust((Item)ItemRegistry.MAGNESITE.get(), (Item)ItemRegistry.MAGNESITE_DUST.get(), recipeConsumer);
        ModRecipeProvider.dust((Item)ItemRegistry.RAW_COBALT.get(), (Item)ItemRegistry.COBALT_DUST.get(), recipeConsumer);
        ModRecipeProvider.nineBlockStorageRecipes((RecipeOutput)recipeConsumer, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.JADE.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.JADE_BLOCK.get()));
        ModRecipeProvider.nineBlockStorageRecipes((RecipeOutput)recipeConsumer, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.BRONZE_INGOT.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.BRONZE_BLOCK.get()));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.UNFIRED_ROOF_TILE.get()), (int)2).define(Character.valueOf('C'), (ItemLike)Items.CLAY_BALL).pattern("C ").pattern(" C").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CLAY_BALL), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CLAY_BALL})).save(recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.GRAY_ROOF_TILE.get(), (Item)ItemRegistry.UNFIRED_ROOF_TILE.get(), (Item)ItemRegistry.GRAY_DYE_POWDER.get(), 0.05f, 20, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.YELLOW_ROOF_TILE.get(), (Item)ItemRegistry.UNFIRED_ROOF_TILE.get(), (Item)ItemRegistry.YELLOW_DYE_POWDER.get(), 0.05f, 20, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.GREEN_ROOF_TILE.get(), (Item)ItemRegistry.UNFIRED_ROOF_TILE.get(), (Item)ItemRegistry.GREEN_DYE_POWDER.get(), 0.05f, 20, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.BLUE_ROOF_TILE.get(), (Item)ItemRegistry.UNFIRED_ROOF_TILE.get(), (Item)ItemRegistry.BLUE_DYE_POWDER.get(), 0.05f, 20, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.CYAN_ROOF_TILE.get(), (Item)ItemRegistry.UNFIRED_ROOF_TILE.get(), (Item)ItemRegistry.CYAN_DYE_POWDER.get(), 0.05f, 20, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.BLACK_ROOF_TILE.get(), (Item)ItemRegistry.UNFIRED_ROOF_TILE.get(), (Item)ItemRegistry.BLACK_DYE_POWDER.get(), 0.05f, 20, recipeConsumer);
        ModRecipeProvider.polishedPlankRecipe(Items.OAK_PLANKS, (Item)ItemRegistry.POLISHED_OAK_PLANK.get(), recipeConsumer);
        ModRecipeProvider.polishedPlankRecipe(Items.BIRCH_PLANKS, (Item)ItemRegistry.POLISHED_BIRCH_PLANK.get(), recipeConsumer);
        ModRecipeProvider.polishedPlankRecipe(Items.SPRUCE_PLANKS, (Item)ItemRegistry.POLISHED_SPRUCE_PLANK.get(), recipeConsumer);
        ModRecipeProvider.polishedPlankRecipe(Items.JUNGLE_PLANKS, (Item)ItemRegistry.POLISHED_JUNGLE_PLANK.get(), recipeConsumer);
        ModRecipeProvider.polishedPlankRecipe(Items.ACACIA_PLANKS, (Item)ItemRegistry.POLISHED_ACACIA_PLANK.get(), recipeConsumer);
        ModRecipeProvider.polishedPlankRecipe(Items.DARK_OAK_PLANKS, (Item)ItemRegistry.POLISHED_DARK_OAK_PLANK.get(), recipeConsumer);
        ModRecipeProvider.polishedPlankRecipe(Items.CRIMSON_PLANKS, (Item)ItemRegistry.POLISHED_CRIMSON_PLANK.get(), recipeConsumer);
        ModRecipeProvider.polishedPlankRecipe(Items.WARPED_PLANKS, (Item)ItemRegistry.POLISHED_WARPED_PLANK.get(), recipeConsumer);
        ModRecipeProvider.polishedPlankRecipe(Items.MANGROVE_PLANKS, (Item)ItemRegistry.POLISHED_MANGROVE_PLANK.get(), recipeConsumer);
        ModRecipeProvider.polishedPlankRecipe(Items.CHERRY_PLANKS, (Item)ItemRegistry.POLISHED_CHERRY_PLANK.get(), recipeConsumer);
        ModRecipeProvider.polishedPlankRecipe((Item)ItemRegistry.ROSEWOOD_PLANKS.get(), (Item)ItemRegistry.POLISHED_ROSEWOOD_PLANK.get(), recipeConsumer);
        ModRecipeProvider.woodworking(RecipeCategory.MISC, Ingredient.of((TagKey)ItemTags.PLANKS), (ItemLike)ItemRegistry.WOODEN_FRAME.get(), 2, Items.OAK_PLANKS, recipeConsumer);
        ModRecipeProvider.dust(Items.CALCITE, (Item)ItemRegistry.CALCITE_DUST.get(), recipeConsumer);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.BLUE_AND_WHITE_GLAZE_POWDER.get()), (int)3).requires((ItemLike)ItemRegistry.CALCITE_DUST.get(), 2).requires((ItemLike)ItemRegistry.COBALT_DUST.get()).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.COBALT_DUST.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.COBALT_DUST.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.SMALL_CLAY_VASE.get()), (int)1).define(Character.valueOf('o'), (ItemLike)Items.CLAY_BALL).pattern("o").pattern("o").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CLAY), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CLAY})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.MEDIUM_CLAY_VASE.get()), (int)1).define(Character.valueOf('O'), (ItemLike)Items.CLAY).define(Character.valueOf('o'), (ItemLike)Items.CLAY_BALL).pattern("o").pattern("O").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CLAY), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CLAY})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.LARGE_CLAY_VASE.get()), (int)1).define(Character.valueOf('O'), (ItemLike)Items.CLAY).pattern("O").pattern("O").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CLAY), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CLAY})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.TALL_CLAY_VASE.get()), (int)1).define(Character.valueOf('O'), (ItemLike)Items.CLAY).define(Character.valueOf('o'), (ItemLike)Items.CLAY_BALL).pattern("o").pattern("o").pattern("O").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CLAY), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CLAY})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.CLAY_POT.get()), (int)1).define(Character.valueOf('O'), (ItemLike)Items.CLAY).define(Character.valueOf('o'), (ItemLike)Items.CLAY_BALL).pattern("o o").pattern(" O ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CLAY), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CLAY})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.TALL_CLAY_POT.get()), (int)1).define(Character.valueOf('O'), (ItemLike)Items.CLAY).define(Character.valueOf('o'), (ItemLike)Items.CLAY_BALL).pattern("o o").pattern("o o").pattern(" O ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CLAY), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CLAY})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.CLAY_PLATE.get()), (int)1).define(Character.valueOf('O'), (ItemLike)Items.CLAY).define(Character.valueOf('o'), (ItemLike)Items.CLAY_BALL).pattern("oOo").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CLAY), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CLAY})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.CLAY_BOWL.get()), (int)1).define(Character.valueOf('o'), (ItemLike)Items.CLAY_BALL).pattern("o o").pattern(" o ").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CLAY), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CLAY})).save(recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.SMALL_WHITE_PORCELAIN_VASE.get(), (Item)ItemRegistry.SMALL_CLAY_VASE.get(), Items.WHITE_DYE, 0.1f, 200, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.MEDIUM_WHITE_PORCELAIN_VASE.get(), (Item)ItemRegistry.MEDIUM_CLAY_VASE.get(), Items.WHITE_DYE, 0.1f, 200, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.LARGE_WHITE_PORCELAIN_VASE.get(), (Item)ItemRegistry.LARGE_CLAY_VASE.get(), Items.WHITE_DYE, 0.1f, 200, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.SMALL_GREEN_PORCELAIN_VASE.get(), (Item)ItemRegistry.SMALL_CLAY_VASE.get(), Items.GREEN_DYE, 0.1f, 200, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.MEDIUM_GREEN_PORCELAIN_VASE.get(), (Item)ItemRegistry.MEDIUM_CLAY_VASE.get(), Items.GREEN_DYE, 0.1f, 200, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.TALL_BLUE_PORCELAIN_VASE.get(), (Item)ItemRegistry.TALL_CLAY_VASE.get(), Items.BLUE_DYE, 0.1f, 200, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.TALL_BLUE_AND_WHITE_PORCELAIN_VASE.get(), (Item)ItemRegistry.TALL_CLAY_VASE.get(), (Item)ItemRegistry.BLUE_AND_WHITE_GLAZE_POWDER.get(), 0.1f, 200, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.BLACK_PORCELAIN_PLATE.get(), (Item)ItemRegistry.CLAY_PLATE.get(), Items.BLACK_DYE, 0.1f, 200, recipeConsumer);
        ModRecipeProvider.compositeSmelting((Item)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PLATE.get(), (Item)ItemRegistry.CLAY_PLATE.get(), (Item)ItemRegistry.BLUE_AND_WHITE_GLAZE_POWDER.get(), 0.1f, 200, recipeConsumer);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.PORCELAIN_PIECE.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.CLAY_BALL).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.PORCELAIN_PIECE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.PORCELAIN_PIECE.get())).save(recipeConsumer, "porcelain_piece_grinding");
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.CLAY_BALL).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE.get())).save(recipeConsumer, "blue_and_white_porcelain_piece_grinding");
        ModRecipeProvider.woodworking(RecipeCategory.MISC, Ingredient.of((TagKey)ItemTags.PLANKS), (ItemLike)ItemRegistry.WOODEN_PARTS.get(), 2, Items.OAK_PLANKS, recipeConsumer);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.GOLD_INGOT}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.GOLD_PARTS.get()), (int)2).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.GOLD_INGOT), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.GOLD_INGOT})).save(recipeConsumer);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.JADE.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.JADE_PARTS.get()), (int)2).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.JADE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.JADE.get())).save(recipeConsumer);
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.PORCELAIN_PARTS.get())).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE.get())).save(recipeConsumer, "porcelain_parts_from_blue_and_white_porcelain_piece");
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.PORCELAIN_PIECE.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.PORCELAIN_PARTS.get())).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.PORCELAIN_PIECE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.PORCELAIN_PIECE.get())).save(recipeConsumer, "porcelain_parts_from_porcelain_piece");
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BRONZE_INGOT.get()}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ItemRegistry.BRONZE_PARTS.get()), (int)2).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BRONZE_INGOT.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BRONZE_INGOT.get())).save(recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_WHITE_DYE, (ItemLike)ItemRegistry.WHITE_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_ORANGE_DYE, (ItemLike)ItemRegistry.ORANGE_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_MAGENTA_DYE, (ItemLike)ItemRegistry.MAGENTA_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_LIGHT_BLUE_DYE, (ItemLike)ItemRegistry.LIGHT_BLUE_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_YELLOW_DYE, (ItemLike)ItemRegistry.YELLOW_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_LIME_DYE, (ItemLike)ItemRegistry.LIME_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_PINK_DYE, (ItemLike)ItemRegistry.PINK_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_GRAY_DYE, (ItemLike)ItemRegistry.GRAY_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_LIGHT_GRAY_DYE, (ItemLike)ItemRegistry.LIGHT_GRAY_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_CYAN_DYE, (ItemLike)ItemRegistry.CYAN_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_PURPLE_DYE, (ItemLike)ItemRegistry.PURPLE_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_BLUE_DYE, (ItemLike)ItemRegistry.BLUE_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_BROWN_DYE, (ItemLike)ItemRegistry.BROWN_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_GREEN_DYE, (ItemLike)ItemRegistry.GREEN_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_RED_DYE, (ItemLike)ItemRegistry.RED_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.dyePowder(ModItemTags.COMMON_BLACK_DYE, (ItemLike)ItemRegistry.BLACK_DYE_POWDER.get(), recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.GOLD_NUGGET, (Item)ItemRegistry.GOLD_DYE_POWDER.get(), RecipeCategory.MISC, recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.POLISHED_BLACKSTONE, (Item)ItemRegistry.CARVED_WOOD_TEMPLATE.get(), RecipeCategory.MISC, recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.POLISHED_BLACKSTONE, (Item)ItemRegistry.CARVED_WOOL_TEMPLATE.get(), RecipeCategory.MISC, recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.POLISHED_BLACKSTONE, (Item)ItemRegistry.FANGXIN_TEMPLATE.get(), RecipeCategory.MISC, recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.POLISHED_BLACKSTONE, (Item)ItemRegistry.FANGXIN_EDGE_TEMPLATE.get(), RecipeCategory.MISC, recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.POLISHED_BLACKSTONE, (Item)ItemRegistry.ZHAOTOU_TEMPLATE.get(), RecipeCategory.MISC, recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.POLISHED_BLACKSTONE, (Item)ItemRegistry.GUTOU_TEMPLATE.get(), RecipeCategory.MISC, recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.POLISHED_BLACKSTONE, (Item)ItemRegistry.RAFTER_TEMPLATE.get(), RecipeCategory.MISC, recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.POLISHED_BLACKSTONE, (Item)ItemRegistry.RAFTER_END_TEMPLATE.get(), RecipeCategory.MISC, recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.POLISHED_BLACKSTONE, (Item)ItemRegistry.ARCHITRAVE_TEMPLATE.get(), RecipeCategory.MISC, recipeConsumer);
        ModRecipeProvider.simpleStonecutting(Items.POLISHED_BLACKSTONE, (Item)ItemRegistry.CAIHUA_TEMPLATE.get(), RecipeCategory.MISC, recipeConsumer);
        ModRecipeProvider.dust((Item)ItemRegistry.BRONZE_INGOT.get(), (Item)ItemRegistry.BRONZE_DUST.get(), recipeConsumer);
    }

    private static void categoryTools(@NotNull RecipeOutput recipeConsumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ItemRegistry.WOODEN_MALLET.get()), (int)1).define(Character.valueOf('S'), ItemTags.WOODEN_FENCES).define(Character.valueOf('W'), ItemTags.PLANKS).pattern("WWW").pattern(" S ").pattern(" S ").unlockedBy("has_fence", ModRecipeProvider.tagUnlock((TagKey<Item>)ItemTags.FENCES)).save(recipeConsumer);
        ModRecipeProvider.blueAndWhitePorcelainUpgrade(Items.GOLDEN_SWORD, (Item)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SWORD.get(), RecipeCategory.COMBAT, recipeConsumer);
        ModRecipeProvider.blueAndWhitePorcelainUpgrade(Items.GOLDEN_SHOVEL, (Item)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHOVEL.get(), RecipeCategory.TOOLS, recipeConsumer);
        ModRecipeProvider.blueAndWhitePorcelainUpgrade(Items.GOLDEN_PICKAXE, (Item)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PICKAXE.get(), RecipeCategory.TOOLS, recipeConsumer);
        ModRecipeProvider.blueAndWhitePorcelainUpgrade(Items.GOLDEN_AXE, (Item)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_AXE.get(), RecipeCategory.TOOLS, recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_UPGRADE_SMITHING_TEMPLATE.get()), (int)1).define(Character.valueOf('W'), (ItemLike)ItemRegistry.PORCELAIN_PIECE.get()).define(Character.valueOf('P'), (ItemLike)ItemRegistry.PORCELAIN_PARTS.get()).define(Character.valueOf('D'), (ItemLike)ItemRegistry.BLUE_AND_WHITE_GLAZE_POWDER.get()).define(Character.valueOf('S'), (ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS.get()).pattern("PSP").pattern("PDP").pattern("WWW").unlockedBy("has_shards", ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_SHARDS.get())).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ItemRegistry.WOODWORKING_WORKBENCH.get()), (int)1).define(Character.valueOf('P'), ItemTags.PLANKS).define(Character.valueOf('C'), (ItemLike)Items.CRAFTING_TABLE).pattern("P").pattern("C").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)Items.CRAFTING_TABLE), ModRecipeProvider.itemCriterion(new ItemLike[]{Items.CRAFTING_TABLE})).save(recipeConsumer);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ItemRegistry.BRICK_KILN.get()), (int)1).define(Character.valueOf('B'), (ItemLike)ItemRegistry.CYAN_BRICK.get()).define(Character.valueOf('F'), (ItemLike)Items.FURNACE).pattern("BBB").pattern("BFB").pattern("BBB").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.CYAN_BRICK.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.CYAN_BRICK.get())).save(recipeConsumer);
    }

    @NotNull
    private static String itemUnlockName(ItemLike item) {
        return "has_" + String.valueOf(item);
    }

    @NotNull
    private static Criterion<InventoryChangeTrigger.TriggerInstance> itemCriterion(ItemLike ... item) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])item);
    }

    private static void quadComposeRecipe(Item part, Item combined, RecipeCategory category, RecipeOutput pFinishedRecipeConsumer) {
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)combined, (int)1).define(Character.valueOf('A'), (ItemLike)part).pattern("AA").pattern("AA").unlockedBy("has_" + ModRecipeProvider.name(part), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{part})).save(pFinishedRecipeConsumer);
    }

    private static void quadDecomposeRecipe(Item part, Item combined, RecipeCategory category, RecipeOutput pFinishedRecipeConsumer) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)part, (int)4).requires((ItemLike)combined).unlockedBy("has_" + ModRecipeProvider.name(combined), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{combined})).save(pFinishedRecipeConsumer);
    }

    private static void stonePolishing(Item raw, Item polished, RecipeOutput pFinishedRecipeConsumer) {
        String rawPath = ModRecipeProvider.name(raw);
        String polishedPath = ModRecipeProvider.name(polished);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)polished, (int)4).define(Character.valueOf('A'), (ItemLike)raw).pattern("AA").pattern("AA").unlockedBy("has_" + rawPath, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{raw})).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(polishedPath + "_from_crafting")));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{raw}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)polished).unlockedBy("has_" + rawPath, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{raw})).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(polishedPath + "_from_stonecutting")));
    }

    private static void blockTransform(Item block, TagKey<Item> dye, Item output, RecipeCategory category, RecipeOutput pFinishedRecipeConsumer) {
        String blockPath = ModRecipeProvider.name(block);
        String outputPath = ModRecipeProvider.name(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)output).requires((ItemLike)block).requires(dye).unlockedBy("has_" + blockPath, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{block})).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)outputPath));
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)output, (int)8).define(Character.valueOf('B'), (ItemLike)block).define(Character.valueOf('D'), dye).pattern("BBB").pattern("BDB").pattern("BBB").unlockedBy("has_" + blockPath, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{block})).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(outputPath + "_batch")));
    }

    private static void blockTransform(Item block, ItemLike dye, Item output, RecipeCategory category, RecipeOutput pFinishedRecipeConsumer) {
        String blockPath = ModRecipeProvider.name(block);
        String outputPath = ModRecipeProvider.name(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)output).requires((ItemLike)block).requires(dye).unlockedBy("has_" + blockPath, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{block})).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)outputPath));
        ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)output, (int)8).define(Character.valueOf('B'), (ItemLike)block).define(Character.valueOf('D'), dye).pattern("BBB").pattern("BDB").pattern("BBB").unlockedBy("has_" + blockPath, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{block})).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(outputPath + "_batch")));
    }

    private static void dust(Item input, Item output, RecipeOutput pFinishedRecipeConsumer) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output).unlockedBy("has_" + ModRecipeProvider.name(input), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{input})).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)ModRecipeProvider.name(output)));
    }

    private static void brickMixture(Item brick, int brickAmount, Item additive, Item output, RecipeOutput pFinishedRecipeConsumer) {
        String brickPath = ModRecipeProvider.name(brick);
        String additivePath = ModRecipeProvider.name(additive);
        String outputPath = ModRecipeProvider.name(output);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)brickAmount).requires((ItemLike)brick, brickAmount).requires((ItemLike)additive).unlockedBy("has_" + brickPath, InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{brick})).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)outputPath));
    }

    private static void smeltingAndBlasting(Item input, Item output, RecipeOutput pFinishedRecipeConsumer) {
        ModRecipeProvider.smeltingAndBlasting(input, output, 0.1f, pFinishedRecipeConsumer);
    }

    private static void smeltingAndBlasting(Item input, Item output, float exp, RecipeOutput pFinishedRecipeConsumer) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)exp, (int)200).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)input), ModRecipeProvider.itemCriterion(new ItemLike[]{input})).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(ModRecipeProvider.name(output) + "_from_smelting")));
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)(exp / 2.0f), (int)100).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)input), ModRecipeProvider.itemCriterion(new ItemLike[]{input})).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(ModRecipeProvider.name(output) + "_from_blasting")));
    }

    private static void stoneSlabAndStairsRecipe(Item baseBlock, Item slabBlock, Item stairBlock, RecipeOutput pFinishedRecipeConsumer) {
        String baseBlockPath = ModRecipeProvider.name(baseBlock);
        String stairsBlockPath = ModRecipeProvider.name(stairBlock);
        String slabBlockPath = ModRecipeProvider.name(slabBlock);
        String baseBlockAdvancement = "has_" + baseBlockPath;
        Criterion trigger = InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{baseBlock});
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairBlock, (int)4).define(Character.valueOf('B'), (ItemLike)baseBlock).pattern("B  ").pattern("BB ").pattern("BBB").unlockedBy(baseBlockAdvancement, trigger).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(stairsBlockPath + "_from_crafting")));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slabBlock, (int)6).define(Character.valueOf('B'), (ItemLike)baseBlock).pattern("BBB").unlockedBy(baseBlockAdvancement, trigger).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(slabBlockPath + "_from_crafting")));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{baseBlock}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairBlock).unlockedBy(baseBlockAdvancement, trigger).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(stairsBlockPath + "_from_stonecutting")));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{baseBlock}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slabBlock, (int)2).unlockedBy(baseBlockAdvancement, trigger).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(slabBlockPath + "_from_stonecutting")));
    }

    private static void simpleStonecutting(Item input, Item output, RecipeCategory category, RecipeOutput pFinishedRecipeConsumer) {
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)category, (ItemLike)output).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)input), ModRecipeProvider.itemCriterion(new ItemLike[]{input})).save(pFinishedRecipeConsumer);
    }

    private static void woodSlabAndStairsRecipe(Item baseBlock, Item slabBlock, Item stairBlock, RecipeOutput pFinishedRecipeConsumer) {
        String baseBlockPath = ModRecipeProvider.name(baseBlock);
        String stairsBlockPath = ModRecipeProvider.name(stairBlock);
        String slabBlockPath = ModRecipeProvider.name(slabBlock);
        String baseBlockAdvancement = "has_" + baseBlockPath;
        Criterion trigger = InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{baseBlock});
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairBlock, (int)4).define(Character.valueOf('B'), (ItemLike)baseBlock).pattern("B  ").pattern("BB ").pattern("BBB").unlockedBy(baseBlockAdvancement, trigger).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(stairsBlockPath + "_from_crafting")));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slabBlock, (int)6).define(Character.valueOf('B'), (ItemLike)baseBlock).pattern("BBB").unlockedBy(baseBlockAdvancement, trigger).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(slabBlockPath + "_from_crafting")));
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{baseBlock}), (ItemLike)stairBlock).unlockedBy(baseBlockAdvancement, trigger).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(stairsBlockPath + "_from_woodworking")));
        ModRecipeProvider.woodworking(RecipeCategory.BUILDING_BLOCKS, Ingredient.of((ItemLike[])new ItemLike[]{baseBlock}), (ItemLike)slabBlock, 2).unlockedBy(baseBlockAdvancement, trigger).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(slabBlockPath + "_from_woodworking")));
    }

    private static void wallRecipe(Item baseBlock, Item wallBlock, RecipeOutput pFinishedRecipeConsumer) {
        String baseBlockPath = ModRecipeProvider.name(baseBlock);
        String wallBlockPath = ModRecipeProvider.name(wallBlock);
        String baseBlockAdvancement = "has_" + baseBlockPath;
        Criterion trigger = InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{baseBlock});
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)wallBlock, (int)6).define(Character.valueOf('B'), (ItemLike)baseBlock).pattern("BBB").pattern("BBB").unlockedBy(baseBlockAdvancement, trigger).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(wallBlockPath + "_from_crafting")));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{baseBlock}), (RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)wallBlock).unlockedBy(baseBlockAdvancement, trigger).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(wallBlockPath + "_from_stonecutting")));
    }

    private static void fenceRecipe(Item baseBlock, Item fenceBlock, RecipeOutput pFinishedRecipeConsumer) {
        String baseBlockPath = ModRecipeProvider.name(baseBlock);
        String fenceBlockPath = ModRecipeProvider.name(fenceBlock);
        String baseBlockAdvancement = "has_" + baseBlockPath;
        Criterion trigger = InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{baseBlock});
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)fenceBlock, (int)3).define(Character.valueOf('B'), (ItemLike)baseBlock).define(Character.valueOf('S'), (ItemLike)Items.STICK).pattern("BSB").pattern("BSB").unlockedBy(baseBlockAdvancement, trigger).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(fenceBlockPath + "_from_crafting")));
        ModRecipeProvider.woodworking(RecipeCategory.DECORATIONS, Ingredient.of((ItemLike[])new ItemLike[]{baseBlock}), (ItemLike)fenceBlock).unlockedBy(baseBlockAdvancement, trigger).save(pFinishedRecipeConsumer, ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(fenceBlockPath + "_from_woodworking")));
    }

    private static void polishedPlankRecipe(Item planks, Item polishedPlank, RecipeOutput pFinishedRecipeConsumer) {
        ModRecipeProvider.woodworking(RecipeCategory.MISC, Ingredient.of((ItemLike[])new ItemLike[]{planks}), (ItemLike)polishedPlank, 2).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)planks), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{planks})).save(pFinishedRecipeConsumer);
    }

    private static void roofTileBlocksRecipe(String color, RecipeOutput pFinishedRecipeConsumer) {
        DefaultedRegistry ITEMS = BuiltInRegistries.ITEM;
        Item tileItem = (Item)ITEMS.get(ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(color + "_roof_tile")));
        Item tileBlock = (Item)ITEMS.get(ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(color + "_roof_tiles")));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)tileBlock, (int)1).define(Character.valueOf('T'), (ItemLike)tileItem).pattern("TTT").unlockedBy("has_" + color + "_roof_tile", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{tileItem})).save(pFinishedRecipeConsumer);
        tileBlock = (Item)ITEMS.get(ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(color + "_roof_tile_stairs")));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)tileBlock, (int)1).define(Character.valueOf('T'), (ItemLike)tileItem).pattern("T  ").pattern("TT ").pattern("TTT").unlockedBy("has_" + color + "_roof_tile", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{tileItem})).save(pFinishedRecipeConsumer);
        tileBlock = (Item)ITEMS.get(ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(color + "_roof_tile_edge")));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)tileBlock, (int)1).define(Character.valueOf('T'), (ItemLike)tileItem).pattern("T  ").pattern("TTT").unlockedBy("has_" + color + "_roof_tile", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{tileItem})).save(pFinishedRecipeConsumer);
    }

    private static void roofTileRidgesRecipe(String color, RecipeOutput pFinishedRecipeConsumer) {
        DefaultedRegistry ITEMS = BuiltInRegistries.ITEM;
        Item tileItem = (Item)ITEMS.get(ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(color + "_roof_tile")));
        Item ridgeBlock = (Item)ITEMS.get(ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(color + "_roof_ridge_upper")));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ridgeBlock, (int)1).define(Character.valueOf('T'), (ItemLike)tileItem).pattern("TTT").pattern("T T").unlockedBy("has_" + color + "_roof_tile", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{tileItem})).save(pFinishedRecipeConsumer);
        Item ridgeSlabBlock = (Item)ITEMS.get(ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(color + "_roof_ridge_upper_slab")));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ridgeBlock}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ridgeSlabBlock, (int)2).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ridgeBlock), ModRecipeProvider.itemCriterion(new ItemLike[]{ridgeBlock})).save(pFinishedRecipeConsumer);
        ridgeBlock = (Item)ITEMS.get(ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(color + "_roof_ridge_lower")));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ridgeBlock, (int)1).define(Character.valueOf('T'), (ItemLike)tileItem).pattern("T T").pattern("TTT").unlockedBy("has_" + color + "_roof_tile", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{tileItem})).save(pFinishedRecipeConsumer);
        ridgeBlock = (Item)ITEMS.get(ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(color + "_roof_ridge_connection")));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ridgeBlock, (int)1).define(Character.valueOf('T'), (ItemLike)tileItem).pattern("TTT").pattern("TTT").unlockedBy("has_" + color + "_roof_tile", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{tileItem})).save(pFinishedRecipeConsumer);
        Item ridgeMainBlock = (Item)ITEMS.get(ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(color + "_main_roof_ridge_connection")));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ridgeMainBlock, (int)3).define(Character.valueOf('R'), (ItemLike)ridgeBlock).define(Character.valueOf('T'), (ItemLike)tileItem).pattern("TTT").pattern("RRR").unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ridgeBlock), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{ridgeBlock})).save(pFinishedRecipeConsumer);
        Item ridgeMainSlabBlock = (Item)ITEMS.get(ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(color + "_main_roof_ridge_slab")));
        Item ridgeMainStairBlock = (Item)ITEMS.get(ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(color + "_main_roof_ridge_stairs")));
        ModRecipeProvider.stoneSlabAndStairsRecipe(ridgeMainBlock, ridgeMainSlabBlock, ridgeMainStairBlock, pFinishedRecipeConsumer);
        Item ridgeMainPanelBlock = (Item)ITEMS.get(ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(color + "_main_roof_ridge_panel")));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ridgeMainSlabBlock}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ridgeMainPanelBlock, (int)2).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ridgeMainSlabBlock), ModRecipeProvider.itemCriterion(new ItemLike[]{ridgeMainSlabBlock})).save(pFinishedRecipeConsumer);
        Item ridgeMainPlateBlock = (Item)ITEMS.get(ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)(color + "_main_roof_ridge_plate")));
        SingleItemRecipeBuilder.stonecutting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{ridgeMainPanelBlock}), (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)ridgeMainPlateBlock, (int)2).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ridgeMainPanelBlock), ModRecipeProvider.itemCriterion(new ItemLike[]{ridgeMainPanelBlock})).save(pFinishedRecipeConsumer);
    }

    private static void dyePowder(TagKey<Item> dye, ItemLike powder, RecipeOutput pFinishedRecipeConsumer) {
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)powder, (int)4).requires(dye).unlockedBy("has_dye", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(dye)})).save(pFinishedRecipeConsumer);
    }

    private static SingleItemRecipeBuilder woodworking(RecipeCategory category, Ingredient pIngredient, ItemLike pResult) {
        return ModRecipeProvider.woodworking(category, pIngredient, pResult, 1);
    }

    private static SingleItemRecipeBuilder woodworking(RecipeCategory category, Ingredient pIngredient, ItemLike pResult, int pCount) {
        return new SingleItemRecipeBuilder(category, WoodworkingRecipe::new, pIngredient, pResult, pCount);
    }

    private static void woodworking(RecipeCategory category, Item input, ItemLike pResult, int pCount, RecipeOutput pFinishedRecipeConsumer) {
        SingleItemRecipeBuilder recipe = new SingleItemRecipeBuilder(category, WoodworkingRecipe::new, Ingredient.of((ItemLike[])new ItemLike[]{input}), pResult, pCount);
        recipe.unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)input), ModRecipeProvider.itemCriterion(new ItemLike[]{input})).save(pFinishedRecipeConsumer);
    }

    private static void woodworking(RecipeCategory category, Ingredient ingredient, ItemLike pResult, int pCount, Item unlockItem, RecipeOutput pFinishedRecipeConsumer) {
        SingleItemRecipeBuilder recipe = new SingleItemRecipeBuilder(category, WoodworkingRecipe::new, ingredient, pResult, pCount);
        recipe.unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)unlockItem), ModRecipeProvider.itemCriterion(new ItemLike[]{unlockItem})).save(pFinishedRecipeConsumer);
    }

    private static void carvedWood(Item result, Ingredient[] dye, RecipeOutput pFinishedRecipeConsumer) {
        ChiselTableRecipeBuilder.chiselTableRecipe(Ingredient.of((TagKey)ItemTags.LOGS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CARVED_WOOD_TEMPLATE.get()}), dye, (ItemLike)result).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.CARVED_WOOD_TEMPLATE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.CARVED_WOOD_TEMPLATE.get())).save(pFinishedRecipeConsumer);
    }

    private static void carvedWool(Item result, Item baseWool, Ingredient[] dye, RecipeOutput pFinishedRecipeConsumer) {
        ChiselTableRecipeBuilder.chiselTableRecipe(Ingredient.of((ItemLike[])new ItemLike[]{baseWool}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CARVED_WOOL_TEMPLATE.get()}), dye, (ItemLike)result).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.CARVED_WOOL_TEMPLATE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.CARVED_WOOL_TEMPLATE.get())).save(pFinishedRecipeConsumer);
    }

    private static void fangxinWood(Item result, Ingredient[] dye, RecipeOutput pFinishedRecipeConsumer) {
        ChiselTableRecipeBuilder.chiselTableRecipe(Ingredient.of((TagKey)ItemTags.LOGS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.FANGXIN_TEMPLATE.get()}), dye, (ItemLike)result).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.FANGXIN_TEMPLATE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.FANGXIN_TEMPLATE.get())).save(pFinishedRecipeConsumer);
    }

    private static void fangxinEdgeWood(Item result, Ingredient[] dye, RecipeOutput pFinishedRecipeConsumer) {
        ChiselTableRecipeBuilder.chiselTableRecipe(Ingredient.of((TagKey)ItemTags.LOGS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.FANGXIN_EDGE_TEMPLATE.get()}), dye, (ItemLike)result).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.FANGXIN_EDGE_TEMPLATE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.FANGXIN_EDGE_TEMPLATE.get())).save(pFinishedRecipeConsumer);
    }

    private static void zhaotouWood(Item result, Ingredient[] dye, RecipeOutput pFinishedRecipeConsumer) {
        ChiselTableRecipeBuilder.chiselTableRecipe(Ingredient.of((TagKey)ItemTags.LOGS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.ZHAOTOU_TEMPLATE.get()}), dye, (ItemLike)result).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.ZHAOTOU_TEMPLATE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.ZHAOTOU_TEMPLATE.get())).save(pFinishedRecipeConsumer);
    }

    private static void gutouWood(Item result, Ingredient[] dye, RecipeOutput pFinishedRecipeConsumer) {
        ChiselTableRecipeBuilder.chiselTableRecipe(Ingredient.of((TagKey)ItemTags.LOGS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.GUTOU_TEMPLATE.get()}), dye, (ItemLike)result).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.GUTOU_TEMPLATE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.GUTOU_TEMPLATE.get())).save(pFinishedRecipeConsumer);
    }

    private static void rafter(Item result, Ingredient[] dye, RecipeOutput pFinishedRecipeConsumer) {
        ChiselTableRecipeBuilder.chiselTableRecipe(Ingredient.of((TagKey)ItemTags.LOGS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RAFTER_TEMPLATE.get()}), dye, (ItemLike)result).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.RAFTER_TEMPLATE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.RAFTER_TEMPLATE.get())).save(pFinishedRecipeConsumer);
    }

    private static void rafterEnd(Item result, Ingredient[] dye, RecipeOutput pFinishedRecipeConsumer) {
        ChiselTableRecipeBuilder.chiselTableRecipe(Ingredient.of((TagKey)ItemTags.LOGS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.RAFTER_END_TEMPLATE.get()}), dye, (ItemLike)result).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.RAFTER_END_TEMPLATE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.RAFTER_END_TEMPLATE.get())).save(pFinishedRecipeConsumer);
    }

    private static void architrave(Item result, Ingredient[] dye, RecipeOutput pFinishedRecipeConsumer) {
        ChiselTableRecipeBuilder.chiselTableRecipe(Ingredient.of((TagKey)ItemTags.LOGS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.ARCHITRAVE_TEMPLATE.get()}), dye, (ItemLike)result).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.ARCHITRAVE_TEMPLATE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.ARCHITRAVE_TEMPLATE.get())).save(pFinishedRecipeConsumer);
    }

    private static void caihua(Item result, Ingredient[] dye, RecipeOutput pFinishedRecipeConsumer) {
        ChiselTableRecipeBuilder.chiselTableRecipe(Ingredient.of(ModItemTags.POLISHED_PLANKS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.CAIHUA_TEMPLATE.get()}), dye, (ItemLike)result).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.CAIHUA_TEMPLATE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.CAIHUA_TEMPLATE.get())).save(pFinishedRecipeConsumer);
    }

    private static void fangxinPattern(Item result, Ingredient[] dye, RecipeOutput pFinishedRecipeConsumer) {
        ChiselTableRecipeBuilder.chiselTableRecipe(Ingredient.of(ModItemTags.POLISHED_PLANKS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.FANGXIN_TEMPLATE.get()}), dye, (ItemLike)result).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.FANGXIN_TEMPLATE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.FANGXIN_TEMPLATE.get())).save(pFinishedRecipeConsumer);
    }

    private static void fangxinEdgePattern(Item result, Ingredient[] dye, RecipeOutput pFinishedRecipeConsumer) {
        ChiselTableRecipeBuilder.chiselTableRecipe(Ingredient.of(ModItemTags.POLISHED_PLANKS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.FANGXIN_EDGE_TEMPLATE.get()}), dye, (ItemLike)result).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.FANGXIN_EDGE_TEMPLATE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.FANGXIN_EDGE_TEMPLATE.get())).save(pFinishedRecipeConsumer);
    }

    private static void zhaotouPattern(Item result, Ingredient[] dye, RecipeOutput pFinishedRecipeConsumer) {
        ChiselTableRecipeBuilder.chiselTableRecipe(Ingredient.of(ModItemTags.POLISHED_PLANKS), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.ZHAOTOU_TEMPLATE.get()}), dye, (ItemLike)result).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.ZHAOTOU_TEMPLATE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.ZHAOTOU_TEMPLATE.get())).save(pFinishedRecipeConsumer);
    }

    private static void compositeSmelting(Item result, Item primary, Item secondary, float exp, int time, RecipeOutput pFinishedRecipeConsumer) {
        CompositeSmeltingRecipeBuilder.compositeSmelting(Ingredient.of((ItemLike[])new ItemLike[]{primary}), Ingredient.of((ItemLike[])new ItemLike[]{secondary}), (ItemLike)result, exp, time).unlockedBy(ModRecipeProvider.itemUnlockName((ItemLike)primary), ModRecipeProvider.itemCriterion(new ItemLike[]{primary})).save(pFinishedRecipeConsumer);
    }

    private static void blueAndWhitePorcelainUpgrade(Item from, Item to, RecipeCategory category, RecipeOutput pFinishedRecipeConsumer) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_UPGRADE_SMITHING_TEMPLATE.get()}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{from}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE.get()}), (RecipeCategory)category, (Item)to).unlocks(ModRecipeProvider.itemUnlockName((ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE.get()), ModRecipeProvider.itemCriterion((ItemLike)ItemRegistry.BLUE_AND_WHITE_PORCELAIN_PIECE.get())).save(pFinishedRecipeConsumer, ModRecipeProvider.name(to));
    }

    private static Criterion<InventoryChangeTrigger.TriggerInstance> tagUnlock(TagKey<Item> tag) {
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate.Builder[])new ItemPredicate.Builder[]{ItemPredicate.Builder.item().of(tag)});
    }

    private static String name(Item item) {
        return Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item)).getPath();
    }
}

