/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.ModBlockTags;
import com.voxelutopia.ultramarine.data.registry.SoundRegistry;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.PushReaction;

public final class BaseBlockProperty {
    public static BaseBlockProperty STONE = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(1.5f, 6.0f).requiresCorrectToolForDrops().instrument(NoteBlockInstrument.BASEDRUM), BlockMaterial.STONE);
    public static BaseBlockProperty MARBLE = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(1.8f, 7.0f).requiresCorrectToolForDrops().instrument(NoteBlockInstrument.BASEDRUM), BlockMaterial.STONE);
    public static BaseBlockProperty TERRACOTTA = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(1.2f, 4.0f).requiresCorrectToolForDrops().instrument(NoteBlockInstrument.BASEDRUM), BlockMaterial.STONE);
    public static BaseBlockProperty IRON = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(5.0f, 6.0f).requiresCorrectToolForDrops().instrument(NoteBlockInstrument.IRON_XYLOPHONE), BlockMaterial.METAL);
    public static BaseBlockProperty COPPER = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(5.0f, 6.0f).requiresCorrectToolForDrops(), BlockMaterial.METAL);
    public static BaseBlockProperty BRONZE = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(5.5f, 6.5f).requiresCorrectToolForDrops(), BlockMaterial.METAL);
    public static BaseBlockProperty TILE = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.BONE_BLOCK).strength(1.5f, 6.0f).requiresCorrectToolForDrops().instrument(NoteBlockInstrument.BASEDRUM), BlockMaterial.STONE);
    public static BaseBlockProperty PORCELAIN = new BaseBlockProperty(BlockBehaviour.Properties.of().sound((SoundType)SoundRegistry.PORCELAIN).strength(1.0f, 1.0f).instrument(NoteBlockInstrument.HAT), BlockMaterial.PORCELAIN);
    public static BaseBlockProperty WOOD = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.0f, 3.0f).ignitedByLava().instrument(NoteBlockInstrument.BASS), BlockMaterial.WOOD);
    public static BaseBlockProperty BAMBOO_WOOD = new BaseBlockProperty(BlockBehaviour.Properties.of().sound((SoundType)SoundRegistry.BAMBOO_WOOD).strength(2.0f, 3.0f).ignitedByLava().instrument(NoteBlockInstrument.BASS), BlockMaterial.WOOD);
    public static BaseBlockProperty BAMBOO = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.BAMBOO).ignitedByLava().instrument(NoteBlockInstrument.XYLOPHONE).strength(1.5f, 2.5f), BlockMaterial.BAMBOO);
    public static BaseBlockProperty GLAZED = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.GLASS).strength(1.5f, 6.0f).requiresCorrectToolForDrops().instrument(NoteBlockInstrument.HAT), BlockMaterial.STONE);
    public static BaseBlockProperty JADE = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.GLASS).strength(1.2f, 5.0f).requiresCorrectToolForDrops().instrument(NoteBlockInstrument.BELL), BlockMaterial.STONE);
    public static BaseBlockProperty FLAX = new BaseBlockProperty(BlockBehaviour.Properties.of().sound((SoundType)SoundRegistry.FLAX).strength(1.0f, 2.0f).ignitedByLava().instrument(NoteBlockInstrument.BANJO), BlockMaterial.FLAX);
    public static BaseBlockProperty CROP = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.CROP).strength(1.0f, 1.5f).ignitedByLava().pushReaction(PushReaction.DESTROY), BlockMaterial.PLANT);
    public static BaseBlockProperty PLANT = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.CROP).strength(1.0f, 1.5f).ignitedByLava().pushReaction(PushReaction.DESTROY), BlockMaterial.PLANT);
    public static BaseBlockProperty LILY = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.LILY_PAD).strength(1.0f, 1.5f).instabreak(), BlockMaterial.PLANT);
    public static BaseBlockProperty SILK = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(1.0f, 2.0f).ignitedByLava().instrument(NoteBlockInstrument.GUITAR), BlockMaterial.FABRIC);
    public static BaseBlockProperty WOOL = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(1.0f, 2.0f).ignitedByLava().instrument(NoteBlockInstrument.GUITAR), BlockMaterial.WOOL);
    public static BaseBlockProperty PAPER = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(1.0f, 2.0f).ignitedByLava(), BlockMaterial.PAPER);
    public static BaseBlockProperty DYE = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(1.0f, 1.0f), BlockMaterial.PAPER);
    public static BaseBlockProperty ICE = new BaseBlockProperty(BlockBehaviour.Properties.of().sound(SoundType.CROP).strength(0.5f, 1.0f), BlockMaterial.ICE);
    final BlockBehaviour.Properties properties;
    final BlockMaterial material;

    BaseBlockProperty(BlockBehaviour.Properties properties, BlockMaterial material) {
        this.properties = properties;
        this.material = material;
    }

    public BlockMaterial getMaterial() {
        return this.material;
    }

    public BaseBlockProperty copy() {
        return new BaseBlockProperty(this.properties, this.material);
    }

    public static enum BlockMaterial {
        STONE((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE),
        METAL((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE),
        ICE((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE),
        WOOD((TagKey<Block>)BlockTags.MINEABLE_WITH_AXE),
        PORCELAIN((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE),
        BAMBOO((TagKey<Block>)BlockTags.MINEABLE_WITH_AXE),
        FABRIC(ModBlockTags.MINEABLE_WITH_SHEARS),
        WOOL(ModBlockTags.MINEABLE_WITH_SHEARS),
        PAPER(ModBlockTags.MINEABLE_WITH_SHEARS),
        PLANT((TagKey<Block>)BlockTags.MINEABLE_WITH_HOE),
        FLAX((TagKey<Block>)BlockTags.MINEABLE_WITH_HOE);

        final TagKey<Block> tool;

        public TagKey<Block> getTool() {
            return this.tool;
        }

        private BlockMaterial(TagKey<Block> tool) {
            this.tool = tool;
        }
    }
}

