/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.registry.BlockEntityRegistry;
import com.voxelutopia.ultramarine.world.block.DecorativeBlock;
import com.voxelutopia.ultramarine.world.block.entity.BottleGourdBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class BottleGourd
extends DecorativeBlock
implements EntityBlock {
    public static final VoxelShape GOURD = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0);

    public BottleGourd(DecorativeBlock.Builder builder) {
        super(builder);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        Optional optionalBlockEntity = level.getBlockEntity(pos, (BlockEntityType)BlockEntityRegistry.BOTTLE_GOURD.get());
        if (optionalBlockEntity.isEmpty()) {
            return InteractionResult.PASS;
        }
        BottleGourdBlockEntity blockEntity = (BottleGourdBlockEntity)((Object)optionalBlockEntity.get());
        if (blockEntity.hasCharges()) {
            if (!level.isClientSide()) {
                for (MobEffectInstance effectInstance : blockEntity.getPotion().getEffects()) {
                    if (((MobEffect)effectInstance.getEffect().value()).isInstantenous()) {
                        ((MobEffect)effectInstance.getEffect().value()).applyInstantenousEffect((Entity)player, (Entity)player, (LivingEntity)player, effectInstance.getAmplifier(), 1.0);
                        continue;
                    }
                    player.addEffect(new MobEffectInstance(effectInstance));
                }
                blockEntity.shrinkCharge();
            } else {
                level.playSound(null, (Entity)player, SoundEvents.GENERIC_DRINK, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Optional optionalBlockEntity = level.getBlockEntity(pos, (BlockEntityType)BlockEntityRegistry.BOTTLE_GOURD.get());
        if (optionalBlockEntity.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BottleGourdBlockEntity blockEntity = (BottleGourdBlockEntity)((Object)optionalBlockEntity.get());
        if (stack.is(Items.POTION) && stack.has(DataComponents.POTION_CONTENTS)) {
            Potion potion = (Potion)Optional.ofNullable((PotionContents)stack.get(DataComponents.POTION_CONTENTS)).map(PotionContents::potion).flatMap(x -> x).orElse(Potions.WATER).value();
            if (blockEntity.canAddCharge(potion)) {
                if (!level.isClientSide()) {
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE));
                    }
                    blockEntity.setPotion(potion);
                    blockEntity.addCharge();
                } else {
                    level.playSound(null, pos, SoundEvents.BREWING_STAND_BREW, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.FAIL;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public BlockState playerWillDestroy(Level pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        BlockState state = super.playerWillDestroy(pLevel, pPos, pState, pPlayer);
        pLevel.getBlockEntity(pPos, (BlockEntityType)BlockEntityRegistry.BOTTLE_GOURD.get()).ifPresent(entity -> {
            if (entity.hasCharges() && !pLevel.isClientSide()) {
                int charges = entity.getCharges();
                List effects = entity.getPotion().getEffects();
                if (!effects.isEmpty()) {
                    AreaEffectCloud areaeffectcloud = new AreaEffectCloud(pLevel, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ());
                    areaeffectcloud.setRadius(0.5f * (float)charges);
                    areaeffectcloud.setRadiusOnUse(-0.5f);
                    areaeffectcloud.setWaitTime(10);
                    areaeffectcloud.setDuration(areaeffectcloud.getDuration() * charges / 2);
                    areaeffectcloud.setRadiusPerTick(-areaeffectcloud.getRadius() / (float)areaeffectcloud.getDuration());
                    for (MobEffectInstance mobeffectinstance : effects) {
                        areaeffectcloud.addEffect(new MobEffectInstance(mobeffectinstance));
                    }
                    pLevel.addFreshEntity((Entity)areaeffectcloud);
                }
            }
        });
        return state;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new BottleGourdBlockEntity(pPos, pState);
    }
}

