/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.BaseHorizontalDirectionalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Bracket
extends BaseHorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape TOP = Block.box((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape FUNNEL = Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0);
    private static final VoxelShape BASE = Shapes.or((VoxelShape)FUNNEL, (VoxelShape)TOP);
    private static final VoxelShape EAST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)12.0, (double)2.0, (double)3.0, (double)16.0, (double)8.0, (double)13.0));
    private static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)3.0, (double)2.0, (double)0.0, (double)13.0, (double)8.0, (double)4.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)3.0, (double)2.0, (double)12.0, (double)13.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)0.0, (double)2.0, (double)3.0, (double)4.0, (double)8.0, (double)13.0));

    public Bracket(BaseBlockProperty property) {
        super(property);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.getValue((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            case Direction.EAST -> EAST_SHAPE;
            default -> Shapes.empty();
        };
    }

    public FluidState getFluidState(BlockState pState) {
        return (Boolean)pState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(pState);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pContext.getLevel().getFluidState(pContext.getClickedPos()).getType() == Fluids.WATER));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{WATERLOGGED});
    }
}

