/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block;

import com.voxelutopia.ultramarine.data.shape.ShapeFunction;
import com.voxelutopia.ultramarine.world.block.BaseBlockProperty;
import com.voxelutopia.ultramarine.world.block.SideBlock;
import com.voxelutopia.ultramarine.world.block.SixSideBlock;
import com.voxelutopia.ultramarine.world.block.state.ModBlockStateProperties;
import java.util.Arrays;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;

public class OrientableSixSideBlock
extends SixSideBlock
implements SideBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final DirectionProperty DIRECTION = ModBlockStateProperties.ON_FACE_DIRECTION;

    public OrientableSixSideBlock(BaseBlockProperty property, ShapeFunction shapeFunction) {
        super(property, shapeFunction);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)DIRECTION, (Comparable)Direction.EAST)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public OrientableSixSideBlock(BaseBlockProperty property, int sideThickness) {
        this(property, ShapeFunction.sixSideShape(sideThickness));
    }

    public OrientableSixSideBlock(BaseBlockProperty property) {
        this(property, 1);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Direction face = pContext.getClickedFace();
        Direction direction = Arrays.stream(pContext.getNearestLookingDirections()).filter(dir -> dir != face && dir != face.getOpposite()).findFirst().orElse(Direction.EAST);
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pContext.getLevel().getFluidState(pContext.getClickedPos()).getType() == Fluids.WATER))).setValue((Property)FACING, (Comparable)face)).setValue((Property)DIRECTION, (Comparable)direction);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, DIRECTION, WATERLOGGED});
    }

    @Override
    public BlockState rotate(BlockState pState, Rotation pRot) {
        BlockState newState = pState;
        Direction facing = (Direction)pState.getValue((Property)FACING);
        Direction onFaceDir = (Direction)pState.getValue((Property)DIRECTION);
        if (facing.getAxis().isHorizontal()) {
            newState = (BlockState)newState.setValue((Property)FACING, (Comparable)pRot.rotate(facing));
        }
        if (onFaceDir.getAxis().isHorizontal()) {
            newState = (BlockState)newState.setValue((Property)DIRECTION, (Comparable)pRot.rotate(onFaceDir));
        }
        return newState;
    }

    @Override
    public BlockState mirror(BlockState pState, Mirror pMirror) {
        BlockState newState = pState;
        Direction facing = (Direction)pState.getValue((Property)FACING);
        Direction onFaceDir = (Direction)pState.getValue((Property)DIRECTION);
        if (facing.getAxis().isHorizontal()) {
            newState = (BlockState)newState.setValue((Property)FACING, (Comparable)pMirror.rotation().rotate(facing));
        }
        if (onFaceDir.getAxis().isHorizontal()) {
            newState = (BlockState)newState.setValue((Property)DIRECTION, (Comparable)pMirror.rotation().rotate(onFaceDir));
        }
        return newState;
    }
}

