/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block.entity;

import com.voxelutopia.ultramarine.data.registry.BlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BottleGourdBlockEntity
extends BlockEntity {
    public static final int MAX_CHARGE = 6;
    private Potion potion;
    private int charges;

    public BottleGourdBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.BOTTLE_GOURD.get(), pos, state);
    }

    public void addCharge() {
        ++this.charges;
        this.charges = Math.min(6, this.charges);
        this.setChanged();
    }

    public void shrinkCharge() {
        --this.charges;
        if (this.charges <= 0) {
            this.charges = 0;
            this.potion = (Potion)Potions.WATER.value();
        }
        this.setChanged();
    }

    public boolean canAddCharge(Potion potion) {
        if (this.hasCharges()) {
            return potion.equals(this.potion) && this.charges < 6;
        }
        return true;
    }

    public boolean hasCharges() {
        return this.charges > 0 && !this.potion.equals(Potions.WATER.value());
    }

    public int getCharges() {
        return this.charges;
    }

    public Potion getPotion() {
        return this.potion;
    }

    public void setPotion(Potion potion) {
        this.potion = potion;
    }

    public void loadAdditional(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(pTag, provider);
        this.potion = (Potion)BuiltInRegistries.POTION.get(ResourceLocation.tryParse((String)pTag.getString("Potion")));
        this.charges = pTag.getInt("Charges");
    }

    protected void saveAdditional(@NotNull CompoundTag pTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(pTag, provider);
        ResourceLocation potionId = BuiltInRegistries.POTION.getKey((Object)this.potion);
        if (potionId != null) {
            pTag.putString("Potion", potionId.toString());
        }
        pTag.putInt("Charges", this.charges);
    }
}

