/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block.entity;

import com.google.common.collect.Lists;
import com.voxelutopia.ultramarine.data.recipe.CompositeSmeltingRecipe;
import com.voxelutopia.ultramarine.data.registry.BlockEntityRegistry;
import com.voxelutopia.ultramarine.data.registry.RecipeTypeRegistry;
import com.voxelutopia.ultramarine.world.block.menu.BrickKilnMenu;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import net.neoforged.neoforge.registries.datamaps.builtin.FurnaceFuel;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BrickKilnBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int SLOT_INPUT_PRIMARY = 0;
    public static final int SLOT_INPUT_SECONDARY = 1;
    public static final int SLOT_FUEL = 2;
    public static final int SLOT_RESULT = 3;
    public static final int DATA_LIT_TIME = 0;
    public static final int DATA_LIT_DURATION = 1;
    public static final int DATA_COOKING_PROGRESS = 2;
    public static final int DATA_COOKING_TOTAL_TIME = 3;
    public static final int NUM_DATA_VALUES = 4;
    public static final int NUM_SLOTS = 4;
    public static final int BURN_TIME_STANDARD = 200;
    public static final int BURN_COOL_SPEED = 2;
    private static final Component CONTAINER_TITLE = Component.translatable((String)"container.brick_kiln");
    int litTime;
    int litDuration;
    int cookingProgress;
    int cookingTotalTime;
    private final ItemStackHandler ingredientsHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            BrickKilnBlockEntity.this.setChanged();
        }
    };
    private final ItemStackHandler fuelHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            BrickKilnBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return Optional.ofNullable((FurnaceFuel)stack.getItemHolder().getData(NeoForgeDataMaps.FURNACE_FUELS)).map(FurnaceFuel::burnTime).orElse(0) > 0;
        }
    };
    private final ItemStackHandler resultHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            BrickKilnBlockEntity.this.setChanged();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }
    };
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int key) {
            return switch (key) {
                case 0 -> BrickKilnBlockEntity.this.litTime;
                case 1 -> BrickKilnBlockEntity.this.litDuration;
                case 2 -> BrickKilnBlockEntity.this.cookingProgress;
                case 3 -> BrickKilnBlockEntity.this.cookingTotalTime;
                default -> 0;
            };
        }

        public void set(int key, int value) {
            switch (key) {
                case 0: {
                    BrickKilnBlockEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    BrickKilnBlockEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    BrickKilnBlockEntity.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    BrickKilnBlockEntity.this.cookingTotalTime = value;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();

    public BrickKilnBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.BRICK_KILN.get(), blockPos, blockState);
    }

    public static void serverTick(Level pLevel, BlockPos pPos, BlockState pState, BrickKilnBlockEntity pBlockEntity) {
        boolean lit = pBlockEntity.isLit();
        boolean changed = false;
        ItemStack fuelItem = pBlockEntity.fuelHandler.getStackInSlot(0);
        ItemStack primaryItem = pBlockEntity.ingredientsHandler.getStackInSlot(0);
        ItemStack secondaryItem = pBlockEntity.ingredientsHandler.getStackInSlot(1);
        ItemStack resultItem = pBlockEntity.resultHandler.getStackInSlot(0);
        RecipeHolder recipe = pLevel.getRecipeManager().getRecipeFor((RecipeType)RecipeTypeRegistry.COMPOSITE_SMELTING.get(), (RecipeInput)BrickKilnBlockEntity.wrapRecipe(pBlockEntity), pLevel).orElse(null);
        if (pBlockEntity.isLit()) {
            --pBlockEntity.litTime;
        }
        if (recipe != null) {
            pBlockEntity.cookingTotalTime = ((CompositeSmeltingRecipe)recipe.value()).getCookingTime();
        }
        if (pBlockEntity.isLit() || !fuelItem.isEmpty() && !primaryItem.isEmpty() && !secondaryItem.isEmpty()) {
            int maxStack = 64;
            if (!pBlockEntity.isLit() && recipe != null && pBlockEntity.canBurn((CompositeSmeltingRecipe)recipe.value(), fuelItem, primaryItem, secondaryItem, resultItem, maxStack)) {
                pBlockEntity.litDuration = pBlockEntity.litTime = Optional.ofNullable((FurnaceFuel)fuelItem.getItemHolder().getData(NeoForgeDataMaps.FURNACE_FUELS)).map(FurnaceFuel::burnTime).orElse(0).intValue();
                if (pBlockEntity.isLit()) {
                    changed = true;
                    fuelItem.shrink(1);
                    pBlockEntity.fuelHandler.setStackInSlot(0, fuelItem);
                }
            }
            if (recipe != null && pBlockEntity.isLit() && pBlockEntity.canBurn((CompositeSmeltingRecipe)recipe.value(), fuelItem, primaryItem, secondaryItem, resultItem, maxStack)) {
                ++pBlockEntity.cookingProgress;
                if (pBlockEntity.cookingProgress == pBlockEntity.cookingTotalTime) {
                    pBlockEntity.cookingProgress = 0;
                    pBlockEntity.cookingTotalTime = BrickKilnBlockEntity.getTotalCookTime(pLevel, pBlockEntity);
                    if (pBlockEntity.burn((CompositeSmeltingRecipe)recipe.value(), pBlockEntity, fuelItem, primaryItem, secondaryItem, resultItem, maxStack)) {
                        pBlockEntity.setRecipeUsed(recipe);
                    }
                    changed = true;
                }
            } else {
                pBlockEntity.cookingProgress = 0;
            }
        } else if (pBlockEntity.cookingProgress > 0) {
            pBlockEntity.cookingProgress = Mth.clamp((int)(pBlockEntity.cookingProgress - 2), (int)0, (int)pBlockEntity.cookingTotalTime);
        }
        if (lit != pBlockEntity.isLit()) {
            changed = true;
            pState = (BlockState)pState.setValue((Property)AbstractFurnaceBlock.LIT, (Comparable)Boolean.valueOf(pBlockEntity.isLit()));
            pLevel.setBlock(pPos, pState, 3);
        }
        if (changed) {
            BrickKilnBlockEntity.setChanged((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    private boolean canBurn(@Nullable CompositeSmeltingRecipe pRecipe, ItemStack fuel, ItemStack primary, ItemStack secondary, ItemStack resultPrev, int maxStackSize) {
        if (!primary.isEmpty() && !secondary.isEmpty() && pRecipe != null) {
            assert (this.level != null);
            ItemStack result = pRecipe.assemble((RecipeInput)new RecipeWrapper((IItemHandler)new InvWrapper((Container)new SimpleContainer(new ItemStack[]{primary, secondary}))), (HolderLookup.Provider)this.level.registryAccess());
            if (result.isEmpty()) {
                return false;
            }
            if (resultPrev.isEmpty()) {
                return true;
            }
            if (!ItemStack.isSameItem((ItemStack)resultPrev, (ItemStack)result)) {
                return false;
            }
            if (resultPrev.getCount() + result.getCount() <= maxStackSize && resultPrev.getCount() + result.getCount() <= resultPrev.getMaxStackSize()) {
                return true;
            }
            return resultPrev.getCount() + result.getCount() <= result.getMaxStackSize();
        }
        return false;
    }

    private boolean burn(CompositeSmeltingRecipe pRecipe, BrickKilnBlockEntity entity, ItemStack fuel, ItemStack primary, ItemStack secondary, ItemStack resultPrev, int maxStackSize) {
        if (this.canBurn(pRecipe, fuel, primary, secondary, resultPrev, maxStackSize)) {
            assert (this.level != null);
            ItemStack newResult = pRecipe.assemble((RecipeInput)new RecipeWrapper((IItemHandler)new InvWrapper((Container)new SimpleContainer(new ItemStack[]{primary, secondary}))), (HolderLookup.Provider)this.level.registryAccess());
            if (resultPrev.isEmpty()) {
                entity.resultHandler.setStackInSlot(0, newResult.copy());
            } else if (resultPrev.is(newResult.getItem())) {
                resultPrev.grow(newResult.getCount());
            }
            primary.shrink(1);
            secondary.shrink(1);
            entity.ingredientsHandler.setStackInSlot(0, primary);
            entity.ingredientsHandler.setStackInSlot(1, secondary);
            return true;
        }
        return false;
    }

    private static int getTotalCookTime(Level pLevel, BrickKilnBlockEntity entity) {
        return pLevel.getRecipeManager().getRecipeFor((RecipeType)RecipeTypeRegistry.COMPOSITE_SMELTING.get(), (RecipeInput)BrickKilnBlockEntity.wrapRecipe(entity), pLevel).map(RecipeHolder::value).map(CompositeSmeltingRecipe::getCookingTime).orElse(200);
    }

    public void setRecipeUsed(@Nullable RecipeHolder<?> pRecipe) {
        if (pRecipe != null) {
            ResourceLocation resourcelocation = pRecipe.id();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    public void awardUsedRecipes(Player pPlayer) {
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer pPlayer) {
        if (!pPlayer.level().isClientSide()) {
            List<RecipeHolder<?>> list = this.getRecipesToAwardAndPopExperience((ServerLevel)pPlayer.level(), pPlayer.position());
            pPlayer.awardRecipes(list);
            this.recipesUsed.clear();
        }
    }

    public List<RecipeHolder<?>> getRecipesToAwardAndPopExperience(ServerLevel pLevel, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            pLevel.getRecipeManager().byKey((ResourceLocation)entry.getKey()).ifPresent(p_155023_ -> {
                list.add(p_155023_);
                BrickKilnBlockEntity.createExperience(pLevel, pos, entry.getIntValue(), ((AbstractCookingRecipe)p_155023_.value()).getExperience());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel pLevel, Vec3 p_155000_, int p_155001_, float p_155002_) {
        int i = Mth.floor((float)((float)p_155001_ * p_155002_));
        float f = Mth.frac((float)((float)p_155001_ * p_155002_));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.award((ServerLevel)pLevel, (Vec3)p_155000_, (int)i);
    }

    private boolean isLit() {
        return this.litTime > 0;
    }

    public Component getDisplayName() {
        return CONTAINER_TITLE;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new BrickKilnMenu(pContainerId, this.worldPosition, pInventory, (IItemHandler)this.wrapHandlers(), this.dataAccess);
    }

    public CombinedInvWrapper wrapHandlers() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.ingredientsHandler, this.fuelHandler, this.resultHandler});
    }

    private static RecipeWrapper wrapRecipe(BrickKilnBlockEntity entity) {
        return new RecipeWrapper((IItemHandler)entity.ingredientsHandler);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider provider) {
        super.loadAdditional(pTag, provider);
        this.litTime = pTag.getInt("BurnTime");
        this.cookingProgress = pTag.getInt("CookTime");
        this.cookingTotalTime = pTag.getInt("CookTimeTotal");
        ListTag itemListTag = pTag.getList("Items", 10);
        block6: for (int i = 0; i < itemListTag.size(); ++i) {
            CompoundTag itemTag = itemListTag.getCompound(i);
            int j = itemTag.getByte("Slot") & 0xFF;
            switch (j) {
                case 0: {
                    this.ingredientsHandler.setStackInSlot(0, ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemTag));
                    continue block6;
                }
                case 1: {
                    this.ingredientsHandler.setStackInSlot(1, ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemTag));
                    continue block6;
                }
                case 2: {
                    this.fuelHandler.setStackInSlot(0, ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemTag));
                    continue block6;
                }
                case 3: {
                    this.resultHandler.setStackInSlot(0, ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)itemTag));
                }
            }
        }
        this.litDuration = Optional.ofNullable((FurnaceFuel)this.fuelHandler.getStackInSlot(0).getItemHolder().getData(NeoForgeDataMaps.FURNACE_FUELS)).map(FurnaceFuel::burnTime).orElse(0);
        CompoundTag recipesTag = pTag.getCompound("RecipesUsed");
        for (String s : recipesTag.getAllKeys()) {
            this.recipesUsed.put((Object)ResourceLocation.tryParse((String)s), recipesTag.getInt(s));
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider provider) {
        super.saveAdditional(pTag, provider);
        pTag.putInt("BurnTime", this.litTime);
        pTag.putInt("CookTime", this.cookingProgress);
        pTag.putInt("CookTimeTotal", this.cookingTotalTime);
        ListTag itemListTag = new ListTag();
        CombinedInvWrapper items = this.wrapHandlers();
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack item = items.getStackInSlot(i);
            if (item.isEmpty()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.putByte("Slot", (byte)i);
            itemTag = (CompoundTag)item.save(provider, (Tag)itemTag);
            itemListTag.add((Object)itemTag);
        }
        if (!itemListTag.isEmpty()) {
            pTag.put("Items", (Tag)itemListTag);
        }
        CompoundTag recipesTag = new CompoundTag();
        this.recipesUsed.forEach((resourceLocation, count) -> recipesTag.putInt(resourceLocation.toString(), count.intValue()));
        pTag.put("RecipesUsed", (Tag)recipesTag);
    }

    public int getCookingProgress() {
        return this.cookingProgress;
    }

    public int getCookingTotalTime() {
        return this.cookingTotalTime;
    }

    public ItemStack getItem(int slot) {
        return this.wrapHandlers().getStackInSlot(slot);
    }
}

