/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block.entity;

import com.voxelutopia.ultramarine.data.registry.BlockEntityRegistry;
import com.voxelutopia.ultramarine.world.block.ContainerDecorativeBlock;
import com.voxelutopia.ultramarine.world.block.menu.ContainerDecorativeBlockMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ContainerDecorativeBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items;
    private int rows = 3;
    private Block block;

    public ContainerDecorativeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.CONTAINER_DECORATIVE_BLOCK.get(), pos, state);
    }

    public ContainerDecorativeBlockEntity(BlockPos pos, BlockState state, int rows) {
        this(pos, state);
        this.block = state.getBlock();
        this.rows = rows;
        this.items = NonNullList.withSize((int)(rows * 9), (Object)ItemStack.EMPTY);
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> pItemStacks) {
        this.items = pItemStacks;
    }

    @NotNull
    protected Component getDefaultName() {
        return Component.translatable((String)("container." + BuiltInRegistries.BLOCK.getKey((Object)this.block).getPath()));
    }

    @NotNull
    protected AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pInventory) {
        Block block = this.block;
        if (block instanceof ContainerDecorativeBlock) {
            ContainerDecorativeBlock container = (ContainerDecorativeBlock)block;
            return container.getContainerType().createMenu(pContainerId, pInventory, this);
        }
        return ContainerDecorativeBlockMenu.genericThreeRows(pContainerId, pInventory, (Container)this);
    }

    public int getContainerSize() {
        return this.rows * 9;
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbt, provider);
        nbt.putString("Block", BuiltInRegistries.BLOCK.getKey((Object)this.block).toString());
        nbt.putByte("Rows", (byte)this.rows);
        if (!this.trySaveLootTable(nbt)) {
            ContainerHelper.saveAllItems((CompoundTag)nbt, this.items, (HolderLookup.Provider)provider);
        }
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)nbt.getString("Block")));
        this.rows = nbt.getByte("Rows");
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(nbt)) {
            ContainerHelper.loadAllItems((CompoundTag)nbt, this.items, (HolderLookup.Provider)provider);
        }
    }
}

