/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.block.menu;

import com.voxelutopia.ultramarine.data.recipe.CompositeSmeltingRecipe;
import com.voxelutopia.ultramarine.data.registry.BlockRegistry;
import com.voxelutopia.ultramarine.data.registry.MenuTypeRegistry;
import com.voxelutopia.ultramarine.data.registry.RecipeTypeRegistry;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.registries.datamaps.builtin.FurnaceFuel;
import net.neoforged.neoforge.registries.datamaps.builtin.NeoForgeDataMaps;
import org.jetbrains.annotations.NotNull;

public class BrickKilnMenu
extends AbstractContainerMenu {
    public static final int SLOT_INPUT_PRIMARY = 0;
    public static final int SLOT_INPUT_SECONDARY = 1;
    public static final int SLOT_FUEL = 2;
    public static final int SLOT_RESULT = 3;
    private static final int INV_SLOT_START = 4;
    private static final int INV_SLOT_END = 31;
    private static final int USE_ROW_SLOT_START = 31;
    private static final int USE_ROW_SLOT_END = 40;
    private final BlockEntity blockEntity;
    private final Player playerEntity;
    private final IItemHandler storage;
    private final IItemHandler inventory;
    private final ContainerData data;

    public BrickKilnMenu(int pId, BlockPos pos, Inventory inventory) {
        this(pId, pos, inventory, (IItemHandler)new ItemStackHandler(4), (ContainerData)new SimpleContainerData(4));
    }

    public BrickKilnMenu(int id, BlockPos pos, Inventory inventory, IItemHandler container, ContainerData containerData) {
        super((MenuType)MenuTypeRegistry.BRICK_KILN.get(), id);
        this.playerEntity = inventory.player;
        this.blockEntity = this.playerEntity.getCommandSenderWorld().getBlockEntity(pos);
        this.storage = container;
        this.inventory = new InvWrapper((Container)inventory);
        this.data = containerData;
        this.addSlot((Slot)new IngredientSlot(this.storage, 0, 46, 17));
        this.addSlot((Slot)new IngredientSlot(this.storage, 1, 66, 17));
        this.addSlot((Slot)new FuelSlot(this.storage, 2, 56, 53));
        this.addSlot((Slot)new OutputSlot(this.storage, 3, 116, 35));
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 9; ++c) {
                this.addSlot((Slot)new SlotItemHandler(this.inventory, c + r * 9 + 9, 8 + c * 18, 84 + r * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot((Slot)new SlotItemHandler(this.inventory, k, 8 + k * 18, 142));
        }
        this.addDataSlots(this.data);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot.hasItem()) {
            ItemStack slotItem = slot.getItem();
            itemstack = slotItem.copy();
            if (pIndex == 3) {
                if (!this.moveItemStackTo(slotItem, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(slotItem, itemstack);
            } else if (pIndex != 2 && pIndex != 0 && pIndex != 1 ? (this.canProcess(slotItem) ? !this.moveItemStackTo(slotItem, 0, 2, false) : (BrickKilnMenu.isFuel(slotItem) ? !this.moveItemStackTo(slotItem, 2, 3, false) : (pIndex >= 4 && pIndex < 31 ? !this.moveItemStackTo(slotItem, 31, 40, false) : pIndex >= 31 && pIndex < 40 && !this.moveItemStackTo(slotItem, 4, 31, false)))) : !this.moveItemStackTo(slotItem, 4, 40, false)) {
                return ItemStack.EMPTY;
            }
            if (slotItem.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotItem.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(pPlayer, slotItem);
        }
        return itemstack;
    }

    protected boolean canProcess(ItemStack item) {
        assert (this.blockEntity.getLevel() != null);
        return this.blockEntity.getLevel().getRecipeManager().getAllRecipesFor((RecipeType)RecipeTypeRegistry.COMPOSITE_SMELTING.get()).stream().anyMatch(recipe -> ((CompositeSmeltingRecipe)recipe.value()).partialMatch((RecipeInput)new SingleRecipeInput(item)));
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        assert (this.blockEntity.getLevel() != null);
        return BrickKilnMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.blockEntity.getLevel(), (BlockPos)this.blockEntity.getBlockPos()), (Player)this.playerEntity, (Block)((Block)BlockRegistry.BRICK_KILN.get()));
    }

    public boolean isLit() {
        return this.data.get(0) > 0;
    }

    public int getBurnProgress() {
        int i = this.data.get(2);
        int j = this.data.get(3);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public int getLitProgress() {
        int i = this.data.get(1);
        if (i == 0) {
            i = 200;
        }
        return this.data.get(0) * 13 / i;
    }

    private static boolean isFuel(@NotNull ItemStack stack) {
        return Optional.ofNullable((FurnaceFuel)stack.getItemHolder().getData(NeoForgeDataMaps.FURNACE_FUELS)).map(FurnaceFuel::burnTime).orElse(0) > 0;
    }

    static class IngredientSlot
    extends SlotItemHandler {
        public IngredientSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }
    }

    static class FuelSlot
    extends SlotItemHandler {
        public FuelSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return BrickKilnMenu.isFuel(stack);
        }
    }

    static class OutputSlot
    extends SlotItemHandler {
        public OutputSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }

        public boolean mayPlace(@Nonnull ItemStack stack) {
            return false;
        }
    }
}

