/*
 * Decompiled with CFR 0.152.
 */
package com.voxelutopia.ultramarine.world.worldgen;

import com.voxelutopia.ultramarine.world.worldgen.ModConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> OVERWORLD_JADE_ORE_PLACED_KEY = ModPlacedFeatures.key("overworld_jade_ore_placed");
    public static final ResourceKey<PlacedFeature> OVERWORLD_MAGNESITE_ORE_PLACED_KEY = ModPlacedFeatures.key("overworld_magnesite_ore_placed");
    public static final ResourceKey<PlacedFeature> OVERWORLD_HEMATITE_ORE_PLACED_KEY = ModPlacedFeatures.key("overworld_hematite_ore_placed");
    public static final ResourceKey<PlacedFeature> NETHER_COBALT_ORE_PLACED_KEY = ModPlacedFeatures.key("nether_cobalt_ore_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter lookup = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, OVERWORLD_JADE_ORE_PLACED_KEY, lookup.getOrThrow(ModConfiguredFeatures.OVERWORLD_JADE_ORE_KEY), ModPlacedFeatures.commonOrePlacement(7, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-80), (VerticalAnchor)VerticalAnchor.absolute((int)80))));
        ModPlacedFeatures.register(context, OVERWORLD_MAGNESITE_ORE_PLACED_KEY, lookup.getOrThrow(ModConfiguredFeatures.OVERWORLD_MAGNESITE_ORE_KEY), ModPlacedFeatures.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-40), (VerticalAnchor)VerticalAnchor.absolute((int)60))));
        ModPlacedFeatures.register(context, OVERWORLD_HEMATITE_ORE_PLACED_KEY, lookup.getOrThrow(ModConfiguredFeatures.OVERWORLD_HEMATITE_ORE_KEY), ModPlacedFeatures.commonOrePlacement(10, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-24), (VerticalAnchor)VerticalAnchor.absolute((int)56))));
        ModPlacedFeatures.register(context, NETHER_COBALT_ORE_PLACED_KEY, lookup.getOrThrow(ModConfiguredFeatures.NETHER_COBALT_ORE_KEY), ModPlacedFeatures.commonOrePlacement(8, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)32))));
    }

    public static List<PlacementModifier> orePlacement(PlacementModifier countPlacementModifier, PlacementModifier heightPlacementModifier) {
        return List.of(countPlacementModifier, InSquarePlacement.spread(), heightPlacementModifier, BiomeFilter.biome());
    }

    public static List<PlacementModifier> commonOrePlacement(int veinsPerChunk, PlacementModifier placementModifier) {
        return ModPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.of((int)veinsPerChunk), placementModifier);
    }

    public static List<PlacementModifier> rareOrePlacement(int rarity, PlacementModifier placementModifier) {
        return ModPlacedFeatures.orePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)rarity), placementModifier);
    }

    public static ResourceKey<PlacedFeature> key(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ultramarine", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuredFeature, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuredFeature, List.copyOf(modifiers)));
    }
}

