/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import ch.njol.skript.util.Timespan;
import ch.njol.skript.util.Version;
import it.jakegblp.lusk.UpdateChecker;
import it.jakegblp.lusk.api.listeners.AnvilGuiClickListener;
import it.jakegblp.lusk.api.listeners.AnvilGuiCloseListener;
import it.jakegblp.lusk.api.listeners.AnvilGuiOpenListener;
import it.jakegblp.lusk.api.listeners.BlockBreakListener;
import it.jakegblp.lusk.api.listeners.DamageListener;
import it.jakegblp.lusk.api.listeners.DeathListener;
import it.jakegblp.lusk.api.listeners.HealListener;
import it.jakegblp.lusk.api.listeners.InventoryClickListener;
import it.jakegblp.lusk.api.listeners.JumpListener;
import it.jakegblp.lusk.api.listeners.PlayerItemDropListener;
import it.jakegblp.lusk.api.listeners.ResurrectListener;
import it.jakegblp.lusk.api.listeners.RightClickListener;
import it.jakegblp.lusk.libs.bstats.bukkit.Metrics;
import it.jakegblp.lusk.libs.bstats.charts.DrilldownPie;
import it.jakegblp.lusk.utils.BorrowedUtils;
import it.jakegblp.lusk.utils.Constants;
import it.jakegblp.lusk.utils.LuskUtils;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Lusk
extends JavaPlugin {
    private static Lusk instance;
    private SkriptAddon addon;

    public void onEnable() {
        long start = System.currentTimeMillis();
        instance = this;
        this.addon = Skript.registerAddon((JavaPlugin)this);
        this.addon.setLanguageFileDirectory("lang");
        int[] elementCountBefore = BorrowedUtils.getElementCount();
        try {
            this.addon.loadClasses("it.jakegblp.lusk", new String[]{"elements"});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (Constants.PAPER_HAS_PLAYER_JUMP_EVENT && Constants.PAPER_HAS_ENTITY_JUMP_EVENT) {
            Lusk.registerListeners(new JumpListener.PaperJumpListener());
        }
        Lusk.registerListeners(new JumpListener.SpigotJumpListener(), new JumpListener(), new RightClickListener(), new BlockBreakListener(), new HealListener(), new DeathListener(), new ResurrectListener(), new DamageListener(), new PlayerItemDropListener(), new InventoryClickListener(), new AnvilGuiOpenListener(), new AnvilGuiClickListener(), new AnvilGuiCloseListener());
        int pluginId = 17730;
        Metrics metrics = new Metrics(this, pluginId);
        String version = this.getDescription().getVersion().toLowerCase();
        String buildType = this.getBuildType();
        metrics.addCustomChart(new DrilldownPie("version_type", () -> {
            HashMap map = new HashMap();
            String localBuildType = this.getBuildType();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(localBuildType, 1);
            map.put(switch (localBuildType) {
                case "beta" -> "Beta";
                case "prerelease" -> "Prerelease";
                case "alpha" -> "Alpha";
                case "release" -> "Release";
                default -> "Other";
            }, entry);
            return map;
        }));
        metrics.addCustomChart(new DrilldownPie("skript_version", () -> {
            HashMap map = new HashMap();
            Version skriptVersion = Skript.getVersion();
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(skriptVersion.toString(), 1);
            map.put((CallSite)((Object)(skriptVersion.getMajor() + "." + skriptVersion.getMinor() + "." + skriptVersion.getRevision())), entry);
            return map;
        }));
        int[] elementCountAfter = BorrowedUtils.getElementCount();
        int[] finish = new int[elementCountBefore.length];
        int total = 0;
        for (int i = 0; i < elementCountBefore.length; ++i) {
            finish[i] = elementCountAfter[i] - elementCountBefore[i];
            total += finish[i];
        }
        String[] elementNames = new String[]{"event", "effect", "expression", "condition", "section"};
        LuskUtils.consoleLog("Loaded {0} elements:", total);
        for (int i = 0; i < finish.length; ++i) {
            LuskUtils.consoleLog(" - {0} {1}{2}", finish[i], elementNames[i], finish[i] == 1 ? "" : "s");
        }
        if (!buildType.equals("release")) {
            LuskUtils.consoleLog("&eThis is a {0} build and should not be used in production unless stated to be stable.", buildType);
            LuskUtils.consoleLog("&eReport bugs at https://github.com/JakeGBLP/Lusk/issues", new Object[0]);
        }
        new UpdateChecker(this);
        long end = System.currentTimeMillis();
        LuskUtils.consoleLog("&aLusk {0} has been enabled! &8[&7{1}&8]", version, new Timespan(end - start));
    }

    public static void registerListeners(Listener ... listeners) {
        for (Listener listener : listeners) {
            Bukkit.getPluginManager().registerEvents(listener, (Plugin)instance);
        }
    }

    public static void callEvent(Event event) {
        Bukkit.getPluginManager().callEvent(event);
    }

    public SkriptAddon getAddonInstance() {
        return this.addon;
    }

    public String getBuildType() {
        String version = this.getDescription().getVersion().toLowerCase();
        if (version.contains("beta")) {
            return "beta";
        }
        if (version.contains("pre")) {
            return "prerelease";
        }
        if (version.contains("alpha")) {
            return "alpha";
        }
        return "release";
    }

    @Generated
    public static Lusk getInstance() {
        return instance;
    }
}

