/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.api;

import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.entity.EntityData;
import ch.njol.skript.paperlib.PaperLib;
import it.jakegblp.lusk.utils.Constants;
import it.jakegblp.lusk.utils.EntityUtils;
import it.jakegblp.lusk.utils.ItemUtils;
import it.jakegblp.lusk.utils.LuskUtils;
import java.util.ArrayList;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.block.Bell;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.Jukebox;
import org.bukkit.block.Sign;
import org.bukkit.block.TrialSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.bukkit.inventory.BrewerInventory;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.util.BoundingBox;
import org.bukkit.util.VoxelShape;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockWrapper {
    @Nullable
    private final Block block;
    @Nullable
    private final ItemType item;
    @Nullable
    private final BlockStateMeta blockStateMeta;
    @Nullable
    private final BlockState blockState;
    @Nullable
    private final BlockDataMeta blockDataMeta;
    @Nullable
    private final BlockData blockData;
    @Nullable
    @ApiStatus.Experimental
    private final Entity entity;
    private final boolean shouldUpdate;

    public BlockWrapper(Object object) {
        this(object, false);
    }

    public BlockWrapper(Object object, boolean shouldUpdate) {
        this(object instanceof Block ? (aBlock = (Block)object) : null, object instanceof ItemType ? (itemType = (ItemType)object) : null, object instanceof BlockStateMeta ? (itemMeta = (BlockStateMeta)object) : null, object instanceof BlockState ? (aBlockState = (BlockState)object) : null, (BlockDataMeta)(object instanceof BlockDataMeta ? (itemMeta = (BlockDataMeta)object) : null), object instanceof BlockData ? (aBlockData = (BlockData)object) : null, object instanceof Entity ? (anEntity = (Entity)object) : null, shouldUpdate);
        Entity anEntity;
        BlockData aBlockData;
        BlockState aBlockState;
        BlockStateMeta itemMeta;
        ItemType itemType;
        Block aBlock;
    }

    public BlockWrapper(Block block, ItemType item, BlockStateMeta blockStateMeta, BlockState blockState, BlockDataMeta blockDataMeta, BlockData blockData, Entity entity) {
        this(block, item, blockStateMeta, blockState, blockDataMeta, blockData, entity, false);
    }

    public BlockWrapper(@NotNull Block block, boolean shouldUpdate) {
        this(block, null, null, null, null, null, null, shouldUpdate);
    }

    public BlockWrapper(@NotNull Block block) {
        this(block, false);
    }

    public BlockWrapper(@NotNull BlockState blockState, boolean shouldUpdate) {
        this(null, null, null, blockState, null, null, null, shouldUpdate);
    }

    public BlockWrapper(@NotNull BlockState blockState) {
        this(blockState, false);
    }

    public BlockWrapper(@NotNull BlockData blockData, boolean shouldUpdate) {
        this(null, null, null, null, null, blockData, null, shouldUpdate);
    }

    public BlockWrapper(@NotNull BlockData blockData) {
        this(blockData, false);
    }

    public BlockWrapper(@NotNull ItemType item, boolean shouldUpdate) {
        this(null, item, null, null, null, null, null, shouldUpdate);
    }

    public BlockWrapper(@NotNull ItemType item) {
        this(item, false);
    }

    public BlockWrapper(@NotNull ItemMeta itemMeta, boolean shouldUpdate) {
        this(null, null, itemMeta instanceof BlockStateMeta ? (meta = (BlockStateMeta)itemMeta) : null, null, (BlockDataMeta)(itemMeta instanceof BlockDataMeta ? (meta = (BlockDataMeta)itemMeta) : null), null, null, shouldUpdate);
        BlockStateMeta meta;
    }

    public BlockWrapper(@NotNull ItemMeta itemMeta) {
        this(itemMeta, false);
    }

    public BlockWrapper(@NotNull Entity entity, boolean shouldUpdate) {
        this(null, null, null, null, null, null, entity, shouldUpdate);
    }

    public BlockWrapper(@NotNull Entity entity) {
        this(entity, false);
    }

    @Nullable
    public Block getBlock() {
        ItemMeta itemMeta;
        if (this.block != null) {
            return this.block;
        }
        if (this.blockState != null) {
            return this.blockState.getBlock();
        }
        if (this.item != null && (itemMeta = this.item.getItemMeta()) instanceof BlockStateMeta) {
            BlockStateMeta meta = (BlockStateMeta)itemMeta;
            return meta.getBlockState().getBlock();
        }
        return null;
    }

    @Nullable
    public BlockData getBlockData() {
        if (this.block != null) {
            return this.block.getBlockData();
        }
        if (this.blockState != null) {
            return this.blockState.getBlockData();
        }
        if (this.blockStateMeta != null) {
            return this.blockStateMeta.getBlockState().getBlockData();
        }
        if (this.item != null) {
            ItemMeta itemMeta = this.item.getItemMeta();
            if (itemMeta instanceof BlockStateMeta) {
                BlockStateMeta meta = (BlockStateMeta)itemMeta;
                return meta.getBlockState().getBlockData();
            }
            if (itemMeta instanceof BlockDataMeta) {
                BlockDataMeta meta = (BlockDataMeta)itemMeta;
                return meta.getBlockData(this.item.getMaterial());
            }
        }
        return this.blockData;
    }

    @Nullable
    public Entity getEntity() {
        return this.entity;
    }

    public void updateBlockData(BlockData blockData) {
        if (!this.shouldUpdate) {
            return;
        }
        if (this.block != null) {
            this.block.setBlockData(blockData);
        } else if (this.blockState != null) {
            this.blockState.setBlockData(blockData);
            this.blockState.update(true);
        } else if (this.item != null) {
            ItemMeta itemMeta = this.item.getItemMeta();
            if (itemMeta instanceof BlockStateMeta) {
                BlockStateMeta meta = (BlockStateMeta)itemMeta;
                BlockState blockState = meta.getBlockState();
                blockState.setBlockData(blockData);
                meta.setBlockState(blockState);
                this.item.setItemMeta((ItemMeta)meta);
            } else {
                itemMeta = this.item.getItemMeta();
                if (itemMeta instanceof BlockDataMeta) {
                    BlockDataMeta meta = (BlockDataMeta)itemMeta;
                    meta.setBlockData(blockData);
                    this.item.setItemMeta((ItemMeta)meta);
                }
            }
        } else if (this.blockStateMeta != null) {
            BlockState blockState = this.blockStateMeta.getBlockState();
            blockState.setBlockData(blockData);
            this.blockStateMeta.setBlockState(blockState);
        } else if (this.blockDataMeta != null) {
            this.blockDataMeta.setBlockData(blockData);
        }
    }

    public void updateBlockState(BlockState blockState) {
        ItemMeta itemMeta;
        if (!this.shouldUpdate) {
            return;
        }
        if (this.item != null && (itemMeta = this.item.getItemMeta()) instanceof BlockStateMeta) {
            BlockStateMeta meta = (BlockStateMeta)itemMeta;
            meta.setBlockState(blockState);
            this.item.setItemMeta((ItemMeta)meta);
        }
    }

    @Nullable
    public Material getMaterial() {
        if (this.item != null) {
            return this.item.getMaterial();
        }
        if (this.block != null) {
            return this.block.getType();
        }
        if (this.blockState != null) {
            return this.blockState.getType();
        }
        if (this.blockData != null) {
            return this.blockData.getMaterial();
        }
        if (this.blockStateMeta != null) {
            return this.blockStateMeta.getBlockState().getType();
        }
        return null;
    }

    @Nullable
    public BlockState getBlockState() {
        ItemMeta itemMeta;
        BlockState state = this.getPlacedBlockState();
        if (state != null) {
            return state;
        }
        if (this.item != null && (itemMeta = this.item.getItemMeta()) instanceof BlockStateMeta) {
            BlockStateMeta meta = (BlockStateMeta)itemMeta;
            return meta.getBlockState();
        }
        if (this.blockStateMeta != null) {
            return this.blockStateMeta.getBlockState();
        }
        return null;
    }

    @Nullable
    public Block getPlacedBlock() {
        if (this.block != null) {
            return this.block;
        }
        if (this.blockState != null && this.blockState.isPlaced()) {
            return this.blockState.getBlock();
        }
        return null;
    }

    @Nullable
    public BlockState getPlacedBlockState() {
        if (this.block != null) {
            return this.block.getState(!this.shouldUpdate);
        }
        if (this.blockState != null && this.blockState.isPlaced()) {
            return this.blockState;
        }
        return null;
    }

    @Nullable
    public BlockStateMeta getBlockStateMeta() {
        ItemMeta itemMeta;
        if (this.item != null && (itemMeta = this.item.getItemMeta()) instanceof BlockStateMeta) {
            BlockStateMeta meta = (BlockStateMeta)itemMeta;
            return meta;
        }
        return this.blockStateMeta;
    }

    @Nullable
    public BlockDataMeta getBlockDataMeta() {
        ItemMeta itemMeta;
        if (this.item != null && (itemMeta = this.item.getItemMeta()) instanceof BlockDataMeta) {
            BlockDataMeta meta = (BlockDataMeta)itemMeta;
            return meta;
        }
        return this.blockDataMeta;
    }

    public boolean isPlaced() {
        if (this.block != null) {
            return true;
        }
        if (this.blockState != null) {
            return this.blockState.isPlaced();
        }
        return false;
    }

    public boolean shouldUpdate() {
        return this.shouldUpdate;
    }

    @Nullable
    public VoxelShape getCollisionShape() {
        Block aBlock = this.getPlacedBlock();
        if (aBlock == null) {
            return null;
        }
        return aBlock.getCollisionShape();
    }

    public boolean isFull() {
        VoxelShape shape = this.getCollisionShape();
        if (shape == null) {
            return false;
        }
        ArrayList boundingBoxes = new ArrayList(shape.getBoundingBoxes());
        if (boundingBoxes.size() != 1) {
            return false;
        }
        BoundingBox box = (BoundingBox)boundingBoxes.getFirst();
        return box.getWidthX() == 1.0 && box.getHeight() == 1.0 && box.getWidthZ() == 1.0;
    }

    public void setWaterLogged(boolean waterLog) {
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Waterlogged) {
            Waterlogged waterlogged = (Waterlogged)blockData;
            waterlogged.setWaterlogged(waterLog);
            this.updateBlockData((BlockData)waterlogged);
        }
    }

    public boolean isWaterLogged() {
        Waterlogged waterlogged;
        BlockData blockData = this.getBlockData();
        return blockData instanceof Waterlogged && (waterlogged = (Waterlogged)blockData).isWaterlogged();
    }

    public boolean canBeWaterlogged() {
        return this.getBlockData() instanceof Waterlogged;
    }

    public void setLiquidLevel(int level) {
        Levelled levelled;
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Levelled && level <= (levelled = (Levelled)blockData).getMaximumLevel() && (!Constants.PAPER_1_18_2 || level >= levelled.getMinimumLevel())) {
            try {
                levelled.setLevel(level);
            }
            catch (IllegalArgumentException e) {
                LuskUtils.warning("Illegal block liquid level: {0}, error: {1}", level, e.getMessage());
            }
            this.updateBlockData((BlockData)levelled);
        }
    }

    public Integer getLiquidLevel() {
        Integer n;
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Levelled) {
            Levelled levelled = (Levelled)blockData;
            n = levelled.getLevel();
        } else {
            n = null;
        }
        return n;
    }

    public Integer getMaxLiquidLevel() {
        Integer n;
        BlockData blockData = this.getBlockData();
        if (blockData instanceof Levelled) {
            Levelled levelled = (Levelled)blockData;
            n = levelled.getMaximumLevel();
        } else {
            n = null;
        }
        return n;
    }

    public Integer getMinLiquidLevel() {
        Integer n;
        BlockData blockData;
        if (PaperLib.isPaper() && (blockData = this.getBlockData()) instanceof Levelled) {
            Levelled levelled = (Levelled)blockData;
            n = levelled.getMinimumLevel();
        } else {
            n = null;
        }
        return n;
    }

    @Nullable
    public ItemType getBrewingFuel() {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof BrewingStand) {
            BrewingStand brewingStand = (BrewingStand)blockState;
            return ItemUtils.getNullableItemType(brewingStand.getInventory().getFuel());
        }
        return null;
    }

    public void setBrewingFuel(ItemType ingredient) {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof BrewingStand) {
            BrewingStand brewingStand = (BrewingStand)blockState;
            brewingStand.getInventory().setFuel(ItemUtils.getNullableItemStack(ingredient));
            this.updateBlockState((BlockState)brewingStand);
        }
    }

    @Nullable
    public BrewerInventory getBrewerInventory() {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof BrewingStand) {
            BrewingStand brewingStand = (BrewingStand)blockState;
            return brewingStand.getInventory();
        }
        return null;
    }

    @Nullable
    public Integer getBrewingFuelLevel() {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof BrewingStand) {
            BrewingStand brewingStand = (BrewingStand)blockState;
            return brewingStand.getFuelLevel();
        }
        return null;
    }

    public void setBrewingFuelLevel(Integer brewingFuelLevel) {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof BrewingStand) {
            BrewingStand brewingStand = (BrewingStand)blockState;
            brewingStand.setFuelLevel(brewingFuelLevel == null ? 0 : brewingFuelLevel);
            this.updateBlockState((BlockState)brewingStand);
        }
    }

    @Nullable
    public ItemType getBrewingIngredient() {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof BrewingStand) {
            BrewingStand brewingStand = (BrewingStand)blockState;
            return ItemUtils.getNullableItemType(brewingStand.getInventory().getIngredient());
        }
        return null;
    }

    public void setBrewingIngredient(ItemType ingredient) {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof BrewingStand) {
            BrewingStand brewingStand = (BrewingStand)blockState;
            brewingStand.getInventory().setIngredient(ItemUtils.getNullableItemStack(ingredient));
            this.updateBlockState((BlockState)brewingStand);
        }
    }

    @Nullable
    public Integer getBrewingTime() {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof BrewingStand) {
            BrewingStand brewingStand = (BrewingStand)blockState;
            return brewingStand.getBrewingTime();
        }
        return null;
    }

    public void setBrewingTime(Integer integer) {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof BrewingStand) {
            BrewingStand brewingStand = (BrewingStand)blockState;
            brewingStand.setBrewingTime(integer == null ? 0 : integer);
            this.updateBlockState((BlockState)brewingStand);
        }
    }

    @Nullable
    public ItemType getJukeboxRecord() {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof Jukebox) {
            Jukebox jukebox = (Jukebox)blockState;
            return ItemUtils.getNullableItemType(jukebox.getRecord());
        }
        return null;
    }

    public void setJukeboxRecord(ItemType itemType) {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof Jukebox) {
            Jukebox jukebox = (Jukebox)blockState;
            jukebox.setRecord(ItemUtils.getNullableItemStack(itemType));
            this.updateBlockState((BlockState)jukebox);
        }
    }

    public boolean isJukeboxPlaying() {
        Jukebox jukebox;
        BlockState blockState = this.getBlockState();
        return blockState instanceof Jukebox && (jukebox = (Jukebox)blockState).isPlaying();
    }

    public void startPlayingJukebox() {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof Jukebox) {
            Jukebox jukebox = (Jukebox)blockState;
            jukebox.startPlaying();
        }
    }

    public void stopPlayingJukebox() {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof Jukebox) {
            Jukebox jukebox = (Jukebox)blockState;
            jukebox.stopPlaying();
        }
    }

    public void ejectJukeboxDisc() {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof Jukebox) {
            Jukebox jukebox = (Jukebox)blockState;
            jukebox.eject();
        }
    }

    public boolean isSignWaxed() {
        Sign sign;
        BlockState blockState = this.getBlockState();
        return blockState instanceof Sign && (sign = (Sign)blockState).isWaxed();
    }

    public void setIsSignWaxed(boolean isSignWaxed) {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof Sign) {
            Sign sign = (Sign)blockState;
            sign.setWaxed(isSignWaxed);
            this.updateBlockState((BlockState)sign);
        }
    }

    public boolean isSignEditable() {
        Sign sign;
        BlockState blockState;
        boolean bl = Constants.MINECRAFT_1_20_1 ? !this.isSignWaxed() : (blockState = this.getBlockState()) instanceof Sign && (sign = (Sign)blockState).isEditable();
        return bl;
    }

    public void setIsSignEditable(boolean isSignEditable) {
        if (Constants.MINECRAFT_1_20_1) {
            this.setIsSignWaxed(!isSignEditable);
        } else {
            BlockState blockState = this.getBlockState();
            if (blockState instanceof Sign) {
                Sign sign = (Sign)blockState;
                sign.setEditable(isSignEditable);
            }
        }
    }

    @Nullable
    public Integer getBellResonatingTicks() {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof Bell) {
            Bell bell = (Bell)blockState;
            return bell.getResonatingTicks();
        }
        return null;
    }

    @Nullable
    public Integer getBellShakingTicks() {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof Bell) {
            Bell bell = (Bell)blockState;
            return bell.getShakingTicks();
        }
        return null;
    }

    public boolean isBellResonating() {
        Bell bell;
        BlockState blockState = this.getBlockState();
        return blockState instanceof Bell && (bell = (Bell)blockState).isResonating();
    }

    public boolean isBellRinging() {
        Bell bell;
        BlockState blockState = this.getBlockState();
        return blockState instanceof Bell && (bell = (Bell)blockState).isShaking();
    }

    public void ringBell(@Nullable Entity entity, @Nullable BlockFace blockFace) {
        BlockState blockState = this.getBlockState();
        if (blockState instanceof Bell) {
            Bell bell = (Bell)blockState;
            if (blockFace != null && blockFace.isCartesian()) {
                if (entity != null) {
                    bell.ring(entity, blockFace);
                } else {
                    bell.ring(blockFace);
                }
            } else if (entity != null) {
                bell.ring(entity);
            } else {
                bell.ring();
            }
        }
    }

    @Nullable
    public Float getSlipperiness() {
        Material material = this.getMaterial();
        if (material != null && material.isBlock()) {
            return Float.valueOf(material.getSlipperiness());
        }
        return null;
    }

    @Nullable
    public Float getBlastResistance() {
        Material material = this.getMaterial();
        if (material != null && material.isBlock()) {
            return Float.valueOf(material.getBlastResistance());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public EntityData<?> getSpawnerEntityType() {
        EntityType entityType;
        BlockState blockState = this.getBlockState();
        if (blockState instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            entityType = spawner.getSpawnedType();
            return EntityUtils.toEntityData(entityType);
        } else {
            if (!Constants.MINECRAFT_1_21) return null;
            if (blockState instanceof TrialSpawner) {
                TrialSpawner trialSpawner = (TrialSpawner)blockState;
                entityType = trialSpawner.isOminous() ? trialSpawner.getOminousConfiguration().getSpawnedType() : trialSpawner.getNormalConfiguration().getSpawnedType();
                return EntityUtils.toEntityData(entityType);
            } else {
                Entity entity = this.getEntity();
                if (!(entity instanceof SpawnerMinecart)) return null;
                SpawnerMinecart spawnerMinecart = (SpawnerMinecart)entity;
                entityType = spawnerMinecart.getSpawnedType();
            }
        }
        return EntityUtils.toEntityData(entityType);
    }

    public void setSpawnerEntityType(@Nullable EntityData<?> entityData) {
        this.setSpawnerEntityType(EntityUtils.toEntityType(entityData));
    }

    public void setSpawnerEntityType(@Nullable EntityType entityType) {
        BlockState blockState = this.getBlockState();
        if (entityType == null && !Constants.MINECRAFT_1_20) {
            return;
        }
        if (blockState instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)blockState;
            spawner.setSpawnedType(entityType);
            spawner.update();
        } else if (Constants.MINECRAFT_1_21) {
            if (blockState instanceof TrialSpawner) {
                TrialSpawner trialSpawner = (TrialSpawner)blockState;
                if (trialSpawner.isOminous()) {
                    trialSpawner.getOminousConfiguration().setSpawnedType(entityType);
                } else {
                    trialSpawner.getNormalConfiguration().setSpawnedType(entityType);
                }
                trialSpawner.update();
            } else {
                Entity entity = this.getEntity();
                if (entity instanceof SpawnerMinecart) {
                    SpawnerMinecart spawnerMinecart = (SpawnerMinecart)entity;
                    spawnerMinecart.setSpawnedType(entityType);
                }
            }
        }
    }

    @Generated
    public BlockWrapper(@Nullable Block block, @Nullable ItemType item, @Nullable BlockStateMeta blockStateMeta, @Nullable BlockState blockState, @Nullable BlockDataMeta blockDataMeta, @Nullable BlockData blockData, @Nullable Entity entity, boolean shouldUpdate) {
        this.block = block;
        this.item = item;
        this.blockStateMeta = blockStateMeta;
        this.blockState = blockState;
        this.blockDataMeta = blockDataMeta;
        this.blockData = blockData;
        this.entity = entity;
        this.shouldUpdate = shouldUpdate;
    }
}

