/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.api.events;

import it.jakegblp.lusk.Lusk;
import it.jakegblp.lusk.utils.EventUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Item;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerInventorySlotDropEvent
extends PlayerEvent
implements Cancellable {
    private static final HandlerList HANDLERS = new HandlerList();
    private static InventoryClickEvent LAST_INVENTORY_CLICK_EVENT = null;
    private final InventoryClickEvent inventoryClickEvent;
    private final PlayerDropItemEvent playerDropItemEvent;
    private final Inventory inventory;
    private final ItemStack originalItem;
    private final int slot;
    private final boolean dropsFromCursor;
    private final boolean dropsAll;
    private final boolean dropsFromInventory;

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public PlayerInventorySlotDropEvent(@Nullable InventoryClickEvent inventoryClickEvent, @NotNull PlayerDropItemEvent playerDropItemEvent) {
        super(playerDropItemEvent.getPlayer());
        this.playerDropItemEvent = playerDropItemEvent;
        this.inventoryClickEvent = inventoryClickEvent;
        this.dropsFromInventory = EventUtils.matchesDropEvent(inventoryClickEvent, playerDropItemEvent);
        if (this.dropsFromInventory) {
            this.dropsFromCursor = EventUtils.dropsFromCursor(inventoryClickEvent);
            this.inventory = inventoryClickEvent.getClickedInventory() != null ? inventoryClickEvent.getClickedInventory() : this.player.getInventory();
            this.slot = inventoryClickEvent.getSlot();
            this.dropsAll = EventUtils.dropsAllItems(inventoryClickEvent);
        } else {
            this.dropsFromCursor = false;
            this.inventory = this.player.getInventory();
            this.slot = this.player.getInventory().getHeldItemSlot();
            this.dropsAll = this.getItem().getAmount() > 1;
        }
        this.originalItem = this.getItem().clone();
        if (this.dropsAll) {
            this.originalItem.add();
        }
    }

    public int getSlot() {
        return this.slot;
    }

    public ItemStack getItem() {
        if (this.dropsFromInventory) {
            return this.dropsFromCursor ? this.inventoryClickEvent.getCursor() : this.inventoryClickEvent.getCurrentItem();
        }
        return this.playerDropItemEvent.getItemDrop().getItemStack();
    }

    public ItemStack getOriginalItem() {
        return this.originalItem;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    @Nullable
    public static InventoryClickEvent getLastInventoryClickEvent() {
        return LAST_INVENTORY_CLICK_EVENT;
    }

    public Item getItemEntity() {
        return this.playerDropItemEvent.getItemDrop();
    }

    public PlayerDropItemEvent getPlayerDropItemEvent() {
        return this.playerDropItemEvent;
    }

    public InventoryClickEvent getInventoryClickEvent() {
        return this.inventoryClickEvent;
    }

    public boolean isDropsAll() {
        return this.dropsAll;
    }

    public boolean isDropsFromCursor() {
        return this.dropsFromCursor;
    }

    public static void setLastInventoryClickEvent(@NotNull InventoryClickEvent lastInventoryClickEvent) {
        LAST_INVENTORY_CLICK_EVENT = lastInventoryClickEvent;
        Bukkit.getScheduler().runTaskLater((Plugin)Lusk.getInstance(), () -> {
            if (lastInventoryClickEvent.equals(LAST_INVENTORY_CLICK_EVENT)) {
                LAST_INVENTORY_CLICK_EVENT = null;
            }
        }, 1L);
    }

    public boolean isCancelled() {
        return this.playerDropItemEvent.isCancelled();
    }

    public void setCancelled(boolean cancel) {
        this.playerDropItemEvent.setCancelled(cancel);
    }
}

