/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.api.listeners;

import com.destroystokyo.paper.event.entity.EntityJumpEvent;
import com.destroystokyo.paper.event.player.PlayerJumpEvent;
import it.jakegblp.lusk.Lusk;
import it.jakegblp.lusk.api.events.GenericEntityJumpEvent;
import it.jakegblp.lusk.utils.Constants;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Horse;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.HorseJumpEvent;

public class JumpListener
implements Listener {
    private static final Map<Entity, Consumer<GenericEntityJumpEvent>> SECTIONS = new HashMap<Entity, Consumer<GenericEntityJumpEvent>>();

    public static boolean canLog(Entity entity) {
        if (Constants.PAPER_HAS_PLAYER_JUMP_EVENT && Constants.PAPER_HAS_ENTITY_JUMP_EVENT) {
            return true;
        }
        return entity instanceof Horse;
    }

    public static void log(Consumer<GenericEntityJumpEvent> consumer, Entity entity) {
        if (JumpListener.canLog(entity)) {
            SECTIONS.put(entity, consumer);
        }
    }

    public static void remove(Entity entity) {
        SECTIONS.remove(entity);
    }

    @EventHandler
    public static void onGenericEntityJump(GenericEntityJumpEvent event) {
        Entity entity = event.getEntity();
        if (SECTIONS.containsKey(entity)) {
            SECTIONS.get(entity).accept(event);
        }
    }

    public static class PaperJumpListener
    implements Listener {
        @EventHandler
        public void onEntityJump(EntityJumpEvent event) {
            Lusk.callEvent((Event)new GenericEntityJumpEvent((Entity)event.getEntity()));
        }

        @EventHandler
        public static void onPlayerJump(PlayerJumpEvent event) {
            Lusk.callEvent((Event)new GenericEntityJumpEvent((Entity)event.getPlayer()));
        }
    }

    public static class SpigotJumpListener
    implements Listener {
        @EventHandler
        public static void onHorseJump(HorseJumpEvent event) {
            Lusk.callEvent((Event)new GenericEntityJumpEvent((Entity)event.getEntity()));
        }
    }
}

