/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.api.skript;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.lang.ParseContext;
import ch.njol.util.StringUtils;
import it.jakegblp.lusk.api.GenericRelation;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnumWrapper<E extends Enum<E>> {
    private final Class<E> enumClass;
    private final String[] names;
    private final HashMap<String, E> parseMap = new HashMap();

    public EnumWrapper(@NotNull Class<E> c, @Nullable String prefix, @Nullable String suffix) {
        assert (c.isEnum());
        this.enumClass = c;
        this.names = new String[((Enum[])c.getEnumConstants()).length];
        for (Enum enumConstant : (Enum[])c.getEnumConstants()) {
            Object name = enumConstant.name().toLowerCase(Locale.ROOT);
            if (prefix != null && !((String)name).startsWith(prefix)) {
                name = prefix + "_" + (String)name;
            }
            if (suffix != null && !((String)name).endsWith(suffix)) {
                name = (String)name + "_" + suffix;
            }
            this.parseMap.put((String)name, enumConstant);
            this.names[enumConstant.ordinal()] = name;
        }
        this.registerComparator(c);
    }

    public EnumWrapper(@NotNull Class<E> c) {
        this(c, null, null);
    }

    @Nullable
    public E parse(String s) {
        return (E)((Enum)this.parseMap.get(s.toLowerCase(Locale.ROOT).replace(" ", "_")));
    }

    public void replace(String toReplace, String replacement) {
        if (this.parseMap.containsKey(toReplace)) {
            Enum e = (Enum)this.parseMap.get(toReplace);
            replacement = replacement.replace(" ", "_");
            this.parseMap.put(replacement, e);
            this.parseMap.remove(toReplace);
            this.names[e.ordinal()] = replacement;
        }
    }

    public String toString(E e, int flags) {
        return this.names[((Enum)e).ordinal()];
    }

    private String getAllNames() {
        ArrayList names = new ArrayList();
        Collections.addAll(names, this.names);
        Collections.sort(names);
        return StringUtils.join(names, (String)", ");
    }

    public ClassInfo<E> getClassInfo(String codeName) {
        return new ClassInfo(this.enumClass, codeName).usage(new String[]{this.getAllNames()}).parser(new EnumParser(this));
    }

    public ClassInfo<E> getClassInfoWithoutUsage(String codeName) {
        return new ClassInfo(this.enumClass, codeName).parser(new EnumParser(this));
    }

    private void registerComparator(Class<E> c) {
        if (CompatibilityUtils.exactComparatorExists(c, c)) {
            return;
        }
        CompatibilityUtils.registerComparator(c, c, (o1, o2) -> GenericRelation.get(o1.equals(o2)));
    }

    static class EnumParser<T extends Enum<T>>
    extends Parser<T> {
        private final EnumWrapper<T> enumWrapper;

        public EnumParser(EnumWrapper<T> enumWrapper) {
            this.enumWrapper = enumWrapper;
        }

        @Nullable
        public T parse(@NotNull String s, @NotNull ParseContext context) {
            return this.enumWrapper.parse(s);
        }

        @NotNull
        public String toString(T o, int flags) {
            return this.enumWrapper.toString(o, flags);
        }

        @NotNull
        public String toVariableNameString(T o) {
            return this.toString(o, 0);
        }
    }
}

