/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.api.skript;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.util.SimpleExpression;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import java.util.Arrays;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnknownNullability;

public abstract class PropertyExpression<F, T>
extends SimpleExpression<T> {
    private @UnknownNullability Expression<? extends F> expr;

    private static String[] patternsOf(String property, String fromType, boolean defaultExpr) {
        Preconditions.checkNotNull((Object)property, (Object)"property must be present");
        Preconditions.checkNotNull((Object)fromType, (Object)"fromType must be present");
        String types = defaultExpr ? "[of %" + fromType + "%]" : "of %" + fromType + "%";
        return new String[]{"[the] " + property + " " + types, "%" + fromType + "%'[s] " + property};
    }

    public static String[] getPatterns(String property, String fromType) {
        return PropertyExpression.patternsOf(property, fromType, false);
    }

    public static String[] getDefaultPatterns(String property, String fromType) {
        return PropertyExpression.patternsOf(property, fromType, true);
    }

    public static <T> void register(Class<? extends Expression<T>> expressionClass, Class<T> type, String property, String fromType) {
        Skript.registerExpression(expressionClass, type, (ExpressionType)ExpressionType.PROPERTY, (String[])PropertyExpression.getPatterns(property, fromType));
    }

    public static <T> void registerDefault(Class<? extends Expression<T>> expressionClass, Class<T> type, String property, String fromType) {
        Skript.registerExpression(expressionClass, type, (ExpressionType)ExpressionType.PROPERTY, (String[])PropertyExpression.getDefaultPatterns(property, fromType));
    }

    protected final void setExpr(@NotNull Expression<? extends F> expr) {
        Preconditions.checkNotNull(expr, (Object)"The expr param cannot be null");
        this.expr = expr;
    }

    public final Expression<? extends F> getExpr() {
        return this.expr;
    }

    protected final T[] get(Event event) {
        return this.get(event, this.expr.getArray(event));
    }

    public final T[] getAll(Event event) {
        T[] result = this.get(event, this.expr.getAll(event));
        return Arrays.copyOf(result, result.length);
    }

    protected abstract T[] get(Event var1, F[] var2);

    protected T[] get(F[] source, Function<? super F, ? extends T> converter) {
        assert (source != null);
        assert (converter != null);
        return CompatibilityUtils.convertUnsafe(source, this.getReturnType(), converter);
    }

    public boolean isSingle() {
        return this.expr.isSingle();
    }

    public final boolean getAnd() {
        return this.expr.getAnd();
    }

    public Expression<? extends T> simplify() {
        this.expr = this.expr.simplify();
        return this;
    }
}

