/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.anvilgui.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.AnvilGuiWrapper;
import it.jakegblp.lusk.api.events.AnvilGuiEvent;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Anvil GUI - Can Be Closed")
@Description(value={"Checks if an anvil gui can be closed.\nThis is only true if the `Anvil GUI - Prevent Closing` effect is used and cannot be reversed without creating a new gui."})
@Examples(value={"if {_anvilGui} can be closed:"})
@Since(value={"1.3"})
public class CondAnvilGuiCanBeClosed
extends Condition {
    private boolean isEvent;
    private Expression<AnvilGuiWrapper> anvilGuiWrapperExpression;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        this.isEvent = parser.hasTag("event");
        if (this.isEvent) {
            if (!this.getParser().isCurrentEvent(AnvilGuiEvent.class)) {
                Skript.error((String)"This condition can only be used in anvil gui events!");
                return false;
            }
        } else {
            this.anvilGuiWrapperExpression = expressions[0];
        }
        this.setNegated(parser.hasTag("not"));
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return (this.isEvent && this.anvilGuiWrapperExpression != null ? this.anvilGuiWrapperExpression.toString(event, debug) : " the anvil ") + "can" + (this.isNegated() ? "not" : "") + " be closed";
    }

    public boolean check(@NotNull Event event) {
        return this.isNegated() ^ ((AnvilGuiEvent)event).getAnvil().isPreventsClose();
    }

    static {
        Skript.registerCondition(CondAnvilGuiCanBeClosed.class, (String[])new String[]{"(%anvilguiinventory%|event:[the] anvil) can[not:([ ]no|n')t] be closed"});
    }
}

