/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.anvilgui.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.AnvilGuiWrapper;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Anvil GUI - is Viewing")
@Description(value={"Checks if a player is currently viewing a specific anvil GUI or any at all."})
@Examples(value={"if player is viewing any anvil guis:\n\tbroadcast \"%player% is viewing an anvil gui!\""})
@Since(value={"1.3"})
public class CondAnvilGuiViewing
extends Condition {
    private boolean any;
    private Expression<Player> playerExpression;
    private Expression<AnvilGuiWrapper> anvilGuiWrapperExpression;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        this.any = parser.hasTag("any");
        if (!this.any) {
            this.anvilGuiWrapperExpression = expressions[1];
        }
        this.playerExpression = expressions[0];
        this.setNegated(parser.hasTag("not"));
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return this.playerExpression.toString(event, debug) + " are " + (this.isNegated() ? "not " : "") + "viewing " + (String)(this.any ? "any anvil gui" : "anvil gui " + this.anvilGuiWrapperExpression.toString(event, debug));
    }

    public boolean check(@NotNull Event event) {
        return CompatibilityUtils.test(this.playerExpression, event, player -> {
            if (this.any) {
                return AnvilGuiWrapper.isViewingAnyAnvilGui(player);
            }
            AnvilGuiWrapper anvilGuiWrapper = (AnvilGuiWrapper)this.anvilGuiWrapperExpression.getSingle(event);
            if (anvilGuiWrapper == null) {
                return false;
            }
            return anvilGuiWrapper.isOpenTo((Player)player);
        });
    }

    static {
        Skript.registerCondition(CondAnvilGuiViewing.class, (String[])new String[]{"%players% (is[not:(n't| not)]|are[not:(n't| not)]) viewing (any:an[y] anvil gui[s]|[lusk] anvil[(-| )gui] %-anvilguiinventory%)"});
    }
}

