/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.anvilgui.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.AnvilGuiWrapper;
import it.jakegblp.lusk.api.events.AnvilGuiEvent;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Anvil GUI - The Anvil Gui")
@Description(value={"Gets the anvil gui involved in an event."})
@Examples(value={"set anvil title of anvil gui to \"hello\"\nopen anvil anvil gui to player"})
@Since(value={"1.3"})
public class ExprAnvilGui
extends SimpleExpression<AnvilGuiWrapper> {
    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        return this.getParser().isCurrentEvent(AnvilGuiEvent.class);
    }

    protected AnvilGuiWrapper @NotNull [] get(@NotNull Event e) {
        if (e instanceof AnvilGuiEvent) {
            AnvilGuiEvent anvilGuiEvent = (AnvilGuiEvent)e;
            return new AnvilGuiWrapper[]{anvilGuiEvent.getAnvil()};
        }
        return new AnvilGuiWrapper[0];
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends AnvilGuiWrapper> getReturnType() {
        return AnvilGuiWrapper.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the anvil gui";
    }

    static {
        Skript.registerExpression(ExprAnvilGui.class, AnvilGuiWrapper.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the] anvil gui"});
    }
}

