/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.anvilgui.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.AnvilGuiWrapper;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Anvil GUI - Interactable Slots")
@Description(value={"Gets the interactable slots of an Anvil GUI.\nAllowed slots: 0, 1 and 2\nNo slots are interactable by default, resetting or deleting this will make all slots not interactable."})
@Examples(value={"set anvil gui interactable slots of {_anvil} to 0 and 1"})
@Since(value={"1.3"})
public class ExprAnvilGuiInteractableSlots
extends PropertyExpression<AnvilGuiWrapper, Integer> {
    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.setExpr(expressions[0]);
        return true;
    }

    protected Integer @NotNull [] get(@NotNull Event event, AnvilGuiWrapper @NotNull [] source) {
        return (Integer[])Arrays.stream(source).map(AnvilGuiWrapper::getInteractableSlots).filter(Objects::nonNull).flatMapToInt(Arrays::stream).boxed().toArray(Integer[]::new);
    }

    @NotNull
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case ADD: 
            case REMOVE: 
            case SET: 
            case REMOVE_ALL: {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = Integer[].class;
                break;
            }
            case DELETE: 
            case RESET: {
                classArray = new Class[]{};
            }
        }
        return classArray;
    }

    public void change(@NotNull Event event, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Stream anvilGuiStream = this.getExpr().stream(event);
        int[] slots = mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE ? null : Arrays.stream((Integer[])delta).mapToInt(Integer::intValue).toArray();
        switch (mode) {
            case SET: {
                anvilGuiStream.forEach(anvilGuiWrapper -> anvilGuiWrapper.setInteractableSlots(slots));
                break;
            }
            case ADD: {
                anvilGuiStream.forEach(anvilGuiWrapper -> anvilGuiWrapper.addInteractableSlots(slots));
                break;
            }
            case REMOVE: 
            case REMOVE_ALL: {
                anvilGuiStream.forEach(anvilGuiWrapper -> anvilGuiWrapper.removeInteractableSlots(slots));
                break;
            }
            case DELETE: 
            case RESET: {
                anvilGuiStream.forEach(AnvilGuiWrapper::resetInteractableSlots);
            }
        }
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "lusk anvil gui interactable slots of " + this.getExpr().toString(event, debug);
    }

    static {
        ExprAnvilGuiInteractableSlots.register(ExprAnvilGuiInteractableSlots.class, Integer.class, "[[lusk] anvil[(-| )gui]] interactable slots", "anvilguiinventories");
    }
}

