/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.anvilgui.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.AnvilGuiWrapper;
import it.jakegblp.lusk.api.events.AnvilGuiSnapshotEvent;
import it.jakegblp.lusk.api.skript.PropertyExpression;
import it.jakegblp.lusk.utils.LuskUtils;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Anvil GUI - First/Second/Result Item")
@Description(value={"Gets one of the 3 items in an anvil gui.\n*NOTES*:\n- These can be set.\n- To apply the changes you need to reopen the anvil gui to the player."})
@Examples(value={"set anvil gui right item of {_anvil} to barrier named \"<red>Click To Close!\""})
@Since(value={"1.3"})
public class ExprAnvilGuiSlots
extends PropertyExpression<AnvilGuiWrapper, ItemStack> {
    private Kleenean left;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult) {
        this.setExpr(expressions[0]);
        this.left = LuskUtils.getKleenean(parseResult.hasTag("left"), parseResult.hasTag("right"));
        return true;
    }

    protected ItemStack @NotNull [] get(@NotNull Event event, AnvilGuiWrapper @NotNull [] source) {
        return (ItemStack[])this.get(source, anvilGuiWrapper -> {
            if (event instanceof AnvilGuiSnapshotEvent) {
                AnvilGuiSnapshotEvent snapshotEvent = (AnvilGuiSnapshotEvent)event;
                return switch (this.left) {
                    default -> throw new IncompatibleClassChangeError();
                    case Kleenean.TRUE -> snapshotEvent.getLeftItem();
                    case Kleenean.FALSE -> snapshotEvent.getRightItem();
                    case Kleenean.UNKNOWN -> snapshotEvent.getOutputItem();
                };
            }
            return switch (this.left) {
                default -> throw new IncompatibleClassChangeError();
                case Kleenean.TRUE -> anvilGuiWrapper.getLeft();
                case Kleenean.FALSE -> anvilGuiWrapper.getRight();
                case Kleenean.UNKNOWN -> anvilGuiWrapper.getOutput();
            };
        });
    }

    @NotNull
    public Class<? extends ItemStack> getReturnType() {
        return ItemStack.class;
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{ItemStack.class};
        }
        return null;
    }

    public void change(@NotNull Event event, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object;
        if (mode == Changer.ChangeMode.SET && (object = delta[0]) instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)object;
            this.getExpr().stream(event).forEach(anvilGuiWrapper -> {
                switch (this.left) {
                    case TRUE: {
                        anvilGuiWrapper.setLeft(itemStack);
                        break;
                    }
                    case FALSE: {
                        anvilGuiWrapper.setRight(itemStack);
                        break;
                    }
                    case UNKNOWN: {
                        anvilGuiWrapper.setOutput(itemStack);
                    }
                }
            });
        }
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "lusk anvil gui " + (switch (this.left) {
            default -> throw new IncompatibleClassChangeError();
            case Kleenean.TRUE -> "left";
            case Kleenean.FALSE -> "right";
            case Kleenean.UNKNOWN -> "output";
        }) + " slot of " + this.getExpr().toString(event, debug);
    }

    static {
        ExprAnvilGuiSlots.register(ExprAnvilGuiSlots.class, ItemStack.class, "[lusk] anvil[(-| )gui] (left:(left|first)|right:(right|second)|output|result|third) (item|slot)", "anvilguiinventories");
    }
}

