/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.anvilgui.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.AnvilGuiWrapper;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Anvil GUI - New Anvil Gui")
@Description(value={"Creates a new anvil gui. Allows you to copy slots and text data from another anvil gui, this doesn't copy the \"prevent closing\" property, this is intentional."})
@Examples(value={"set {_anvil} to a new anvil gui"})
@Since(value={"1.3"})
public class ExprNewAnvilGui
extends SimpleExpression<AnvilGuiWrapper> {
    private Expression<AnvilGuiWrapper> anvilGuiWrapperExpression;
    private boolean clone;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        this.anvilGuiWrapperExpression = expressions[0];
        this.clone = parseResult.hasTag("clone");
        return true;
    }

    protected AnvilGuiWrapper @NotNull [] get(@NotNull Event e) {
        AnvilGuiWrapper anvilGuiWrapper;
        if (this.clone && this.anvilGuiWrapperExpression != null && (anvilGuiWrapper = (AnvilGuiWrapper)this.anvilGuiWrapperExpression.getSingle(e)) != null) {
            return new AnvilGuiWrapper[]{new AnvilGuiWrapper(anvilGuiWrapper)};
        }
        return new AnvilGuiWrapper[]{new AnvilGuiWrapper()};
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends AnvilGuiWrapper> getReturnType() {
        return AnvilGuiWrapper.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "a new anvil gui" + (String)(this.clone ? " copying " + this.anvilGuiWrapperExpression.toString(e, debug) : "");
    }

    static {
        Skript.registerExpression(ExprNewAnvilGui.class, AnvilGuiWrapper.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[a] new anvil gui [clone:(copying|cloning|from) %-anvilguiinventory%]"});
    }
}

