/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.anvilgui.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.AnvilGuiWrapper;
import it.jakegblp.lusk.api.events.AnvilGuiClickEvent;
import it.jakegblp.lusk.api.events.AnvilGuiCloseEvent;
import it.jakegblp.lusk.api.events.AnvilGuiOpenEvent;
import it.jakegblp.lusk.api.listeners.AnvilGuiClickListener;
import it.jakegblp.lusk.api.listeners.AnvilGuiCloseListener;
import it.jakegblp.lusk.api.listeners.AnvilGuiOpenListener;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Anvil Gui - on Open/Close/Click Section")
@Description(value={"Runs the code inside of it when the provided anvil gui is opened, closed or clicked.\n\nLocal Variables that are:\n- defined BEFORE this section CAN be used inside of it.\n- defined AFTER this section CANNOT be used inside of it.\n- defined INSIDE this section CANNOT be used outside of it.\n"})
@Examples(value={"set {_anvilGui} to a new anvil gui\n\nwhen {_anvilGui} gets opened:\n    broadcast \"%{_anvilGui}% has been opened!\"\n\nwhen {_anvilGui} gets clicked:\n    broadcast \"%{_anvilGui}% has been clicked!\"\n\nwhen {_anvilGui} gets closed:\n    broadcast \"%{_anvilGui}% has been closed!\"\n"})
@Since(value={"1.3"})
public class SecEvtAnvilGui
extends Section {
    private Expression<AnvilGuiWrapper> anvilGuiWrapperExpression;
    private int state;
    @Nullable
    private Trigger trigger;

    public boolean init(Expression<?>[] expressions, int i, @NotNull Kleenean kleenean, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult, @NotNull SectionNode sectionNode, @NotNull List<TriggerItem> list) {
        this.anvilGuiWrapperExpression = expressions[0];
        if (parseResult.hasTag("open")) {
            this.trigger = this.loadCode(sectionNode, "anvilguiopen", new Class[]{AnvilGuiOpenEvent.class});
            this.state = -1;
        } else if (parseResult.hasTag("close")) {
            this.trigger = this.loadCode(sectionNode, "anvilguiclose", new Class[]{AnvilGuiCloseEvent.class});
            this.state = 0;
        } else {
            this.trigger = this.loadCode(sectionNode, "anvilguiclick", new Class[]{AnvilGuiClickEvent.class});
            this.state = 1;
        }
        return true;
    }

    @Nullable
    protected TriggerItem walk(@NotNull Event event) {
        Object vars = Variables.copyLocalVariables((Event)event);
        if (this.state == -1) {
            Consumer<AnvilGuiOpenEvent> consumer = this.trigger == null ? null : anvilGuiOpenEvent -> {
                Variables.setLocalVariables((Event)anvilGuiOpenEvent, (Object)vars);
                TriggerItem.walk((TriggerItem)this.trigger, (Event)anvilGuiOpenEvent);
                Variables.removeLocals((Event)anvilGuiOpenEvent);
            };
            AnvilGuiOpenListener.log(consumer, (AnvilGuiWrapper)this.anvilGuiWrapperExpression.getSingle(event));
        } else if (this.state == 0) {
            Consumer<AnvilGuiCloseEvent> consumer = this.trigger == null ? null : anvilGuiCloseEvent -> {
                Variables.setLocalVariables((Event)anvilGuiCloseEvent, (Object)vars);
                TriggerItem.walk((TriggerItem)this.trigger, (Event)anvilGuiCloseEvent);
                Variables.removeLocals((Event)anvilGuiCloseEvent);
            };
            AnvilGuiCloseListener.log(consumer, (AnvilGuiWrapper)this.anvilGuiWrapperExpression.getSingle(event));
        } else {
            Consumer<AnvilGuiClickEvent> consumer = this.trigger == null ? null : anvilGuiClickEvent -> {
                Variables.setLocalVariables((Event)anvilGuiClickEvent, (Object)vars);
                TriggerItem.walk((TriggerItem)this.trigger, (Event)anvilGuiClickEvent);
                Variables.removeLocals((Event)anvilGuiClickEvent);
            };
            AnvilGuiClickListener.log(consumer, (AnvilGuiWrapper)this.anvilGuiWrapperExpression.getSingle(event));
        }
        return super.walk(event, false);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "when anvil gui " + this.anvilGuiWrapperExpression.toString(event, b) + " gets " + (this.state == -1 ? "opened" : (this.state == 0 ? "closed" : "clicked"));
    }

    static {
        Skript.registerSection(SecEvtAnvilGui.class, (String[])new String[]{"[execute|run] on anvil [gui|inventory] (:open|:close|click) of %~anvilguiinventory%", "[execute|run] when [[the] anvil [gui|inventory]] %~anvilguiinventory% ((get[s]|is) (open:opened|close:closed|clicked))"});
    }
}

