/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.citizens.conditions;

import ch.njol.skript.conditions.base.PropertyCondition;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.utils.CitizensUtils;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;

@Name(value="Citizens - is NPC")
@Description(value={"Checks if an entity is an NPC. (Citizens)"})
@Examples(value={"on right click:\n\tif entity is npc:\n\t\tbroadcast \"you clicked an NPC!\""})
@Since(value={"1.0.0"})
public class CondNPC
extends PropertyCondition<Entity> {
    public boolean check(Entity entity) {
        return CitizensUtils.isNPC(entity);
    }

    @NotNull
    protected String getPropertyName() {
        return "npc";
    }

    static {
        CondNPC.register(CondNPC.class, (String)"(npc|citizen)", (String)"entity");
    }
}

