/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blockface.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.block.BlockFace;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="BlockFace - Mod XYZ")
@Description(value={"Returns the amount of x/y/z to modify to get the represented block(s)."})
@Examples(value={"broadcast mod-y of {_blockfaces::*}"})
@Since(value={"1.2"})
public class ExprBlockFaceModXYZ
extends SimplePropertyExpression<BlockFace, Integer> {
    int which;

    @NotNull
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.which = parseResult.hasTag("y") ? 0 : (parseResult.hasTag("x") ? 1 : 2);
        return super.init(expressions, matchedPattern, isDelayed, parseResult);
    }

    @Nullable
    public Integer convert(BlockFace blockFace) {
        return this.which == 0 ? blockFace.getModX() : (this.which == 1 ? blockFace.getModY() : blockFace.getModZ());
    }

    @NotNull
    protected String getPropertyName() {
        return "opposite blockface";
    }

    static {
        ExprBlockFaceModXYZ.register(ExprBlockFaceModXYZ.class, Integer.class, (String)"mod(-| )(:y|:x|z)", (String)"blockfaces");
    }
}

