/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.banner.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.util.SkriptColor;
import ch.njol.util.Kleenean;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="Banner Pattern - From Pattern Type and Color")
@Description(value={"Created a Banner Pattern from a Pattern Type and a (dye) Color."})
@Examples(value={"banner pattern skull pattern type with color blue"})
@Since(value={"1.3"})
public class ExprBannerPattern
extends SimpleExpression<Pattern> {
    Expression<PatternType> patternTypeExpression;
    Expression<SkriptColor> colorExpression;

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.patternTypeExpression = expressions[0];
        this.colorExpression = expressions[1];
        return true;
    }

    @Nullable
    protected Pattern[] get(Event event) {
        PatternType patternType = (PatternType)this.patternTypeExpression.getSingle(event);
        SkriptColor color = (SkriptColor)this.colorExpression.getSingle(event);
        if (patternType == null || color == null || color.asDyeColor() == null) {
            return new Pattern[0];
        }
        return new Pattern[]{new Pattern(color.asDyeColor(), patternType)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends Pattern> getReturnType() {
        return Pattern.class;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "banner pattern " + this.patternTypeExpression.toString(event, debug) + " with color " + this.colorExpression.toString(event, debug);
    }

    static {
        Skript.registerExpression(ExprBannerPattern.class, Pattern.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"banner pattern %bannerpatterntype% with color %color%"});
    }
}

