/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.bell.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.BlockWrapper;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Bell - Ring")
@Description(value={"Rings a bell.\nThe blockface must be cartesian.\n\n**NOTE: Skript has its own version of this effect, difference is in the fact that Skript's uses Directions while Lusk's uses Blockfaces, for that reason I will not deprecate this Effect.**"})
@Examples(value={"ring target block", "make {_p} ring {_block} from north"})
@Since(value={"1.1, 1.3 (Plural, BlockStates)"})
public class EffRingBell
extends Effect {
    private Expression<Entity> entityExpression;
    private Expression<Object> blockExpression;
    private Expression<BlockFace> blockFaceExpression;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.entityExpression = expressions[0];
        this.blockExpression = expressions[1];
        this.blockFaceExpression = expressions[2];
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "make " + this.entityExpression.toString(event, debug) + " ring " + this.blockExpression.toString(event, debug) + " from " + this.blockFaceExpression.toString(event, debug);
    }

    protected void execute(@NotNull Event event) {
        for (Object o : this.blockExpression.getAll(event)) {
            new BlockWrapper(o).ringBell(this.entityExpression != null ? (Entity)this.entityExpression.getSingle(event) : null, this.blockFaceExpression != null ? (BlockFace)this.blockFaceExpression.getSingle(event) : null);
        }
    }

    static {
        Skript.registerEffect(EffRingBell.class, (String[])new String[]{"[make %-entity%] ring %blocks/blockstates% [from %-blockface%]"});
    }
}

