/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.block.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.BlockWrapper;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Block - Water Log")
@Description(value={"Changes whether one or more blocks or blockstates are waterlogged."})
@Examples(value={"waterlog target block"})
@Since(value={"1.3"})
public class EffBlockWaterLog
extends Effect {
    private Expression<Object> blockExpression;
    private boolean waterlog;

    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parser) {
        this.blockExpression = expressions[0];
        this.waterlog = !parser.hasTag("not");
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "make " + this.blockExpression.toString(event, debug) + (this.waterlog ? "" : " not") + " waterlogged";
    }

    protected void execute(@NotNull Event event) {
        new BlockWrapper(this.blockExpression.getSingle(event), true).setWaterLogged(this.waterlog);
    }

    static {
        Skript.registerEffect(EffBlockWaterLog.class, (String[])new String[]{"[not:un]water[ |-]log %blocks/blockdatas/blockstates/itemtypes%", "make %blocks/blockdatas/blockstates/itemtypes% [:not] water[ |-]logged"});
    }
}

