/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.block.events;

import ch.njol.skript.Skript;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import it.jakegblp.lusk.utils.ArrayUtils;
import it.jakegblp.lusk.utils.CompatibilityUtils;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockIgniteEvent;
import org.jetbrains.annotations.Nullable;

public class EvtBlockIgnite
extends SkriptEvent {
    private boolean justPlayer;
    private boolean allIgniteCauses = false;
    private Literal<BlockIgniteEvent.IgniteCause> igniteCauseLiterals;

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parseResult) {
        this.justPlayer = parseResult.hasTag("player");
        this.igniteCauseLiterals = args[0];
        if (ArrayUtils.haveSameElements((BlockIgniteEvent.IgniteCause[])this.igniteCauseLiterals.getArray(), BlockIgniteEvent.IgniteCause.values())) {
            this.allIgniteCauses = true;
            Skript.warning((String)"You've selected every single ignition cause, this is the same as not putting any.");
        }
        return true;
    }

    public boolean check(Event event) {
        BlockIgniteEvent e = (BlockIgniteEvent)event;
        return !(!this.allIgniteCauses && ((BlockIgniteEvent.IgniteCause[])this.igniteCauseLiterals.getAll()).length != 0 && !this.igniteCauseLiterals.stream((Event)e).anyMatch(igniteCause -> igniteCause.equals((Object)e.getCause())) || this.justPlayer && e.getPlayer() == null);
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "lusk " + (this.justPlayer ? "player " : "") + "block ignite";
    }

    static {
        Skript.registerEvent((String)"Block - on Ignite [Lusk Extension]", EvtBlockIgnite.class, BlockIgniteEvent.class, (String[])new String[]{"[lusk] [:player] block ignit(e|ion) [due to %-*ignitecauses%]"}).description(new String[]{"**THIS IS AN EXTENDED VERSION OF SKRIPT'S IGNITE EVENT.**\n\n`event-player` = the Player that placed/ignited the fire block, or not set if not ignited by a Player.\n\n`event-entity` = the Entity that placed/ignited the fire block, or not set if not ignited by an Entity.\n\n`event-ignitecause` = the value detailing the cause of the block ignition.\n\nCalled when a block is ignited. If you want to catch when a Player places fire, use the place event.\nIf this event is cancelled, the block will not be ignited.\n"}).examples(new String[]{"on lusk block ignite due to lava_ignition:", "on lusk player block ignition:"}).since("1.3");
        CompatibilityUtils.registerEventValue(BlockIgniteEvent.class, Entity.class, BlockIgniteEvent::getIgnitingEntity, 0);
        CompatibilityUtils.registerEventValue(BlockIgniteEvent.class, BlockIgniteEvent.IgniteCause.class, BlockIgniteEvent::getCause, 0);
    }
}

