/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.block.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.BlockWrapper;
import it.jakegblp.lusk.api.skript.SimpleBooleanPropertyExpression;
import org.jetbrains.annotations.Nullable;

@Name(value="Block - is Waterlogged (Property)")
@Description(value={"Returns whether or not one or more blocks, blockstates or blockdatas are waterlogged.\nCan be set."})
@Examples(value={"broadcast waterlogged property of block"})
@Since(value={"1.3"})
public class ExprBlockIsWaterLogged
extends SimpleBooleanPropertyExpression<Object> {
    @Nullable
    public Boolean convert(Object from) {
        return new BlockWrapper(from).isWaterLogged();
    }

    @Override
    public void set(Object from, Boolean to) {
        new BlockWrapper(from, true).setWaterLogged(to);
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    protected String getPropertyName() {
        return "is waterlogged";
    }

    static {
        ExprBlockIsWaterLogged.register(ExprBlockIsWaterLogged.class, Boolean.class, "[block]", "[is] water[ |-]log[ged]", "blocks/blockstates/blockdatas/itemtypes");
    }
}

