/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.block.sections;

import ch.njol.skript.Skript;
import ch.njol.skript.config.SectionNode;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.Section;
import ch.njol.skript.lang.Trigger;
import ch.njol.skript.lang.TriggerItem;
import ch.njol.skript.variables.Variables;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.api.listeners.BlockBreakListener;
import it.jakegblp.lusk.utils.EventUtils;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.block.Block;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Block - on Break Section")
@Description(value={"Runs the code inside of it when the provided block gets broken.\nLocal Variables that are:\n- defined BEFORE this section CAN be used inside of it.\n- defined AFTER this section CANNOT be used inside of it.\n- defined INSIDE this section CANNOT be used outside of it.\n"})
@Examples(value={""})
@Since(value={"1.2"})
public class SecEvtBreak
extends Section {
    private Expression<Block> blockExpression;
    @Nullable
    private Trigger trigger;
    private boolean mine = false;

    public boolean init(Expression<?>[] expressions, int i, @NotNull Kleenean kleenean, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SkriptParser.ParseResult parseResult, @NotNull SectionNode sectionNode, @NotNull List<TriggerItem> list) {
        this.blockExpression = expressions[0];
        this.trigger = this.loadCode(sectionNode, "break", new Class[]{BlockBreakEvent.class});
        this.mine = parseResult.hasTag("mine");
        return true;
    }

    @Nullable
    protected TriggerItem walk(@NotNull Event event) {
        Object vars = Variables.copyLocalVariables((Event)event);
        Consumer<BlockBreakEvent> consumer = this.trigger == null ? null : breakEvent -> {
            if (!this.mine || EventUtils.willItemsDrop(breakEvent)) {
                Variables.setLocalVariables((Event)breakEvent, (Object)vars);
                TriggerItem.walk((TriggerItem)this.trigger, (Event)breakEvent);
                Variables.removeLocals((Event)breakEvent);
            }
        };
        BlockBreakListener.log(consumer, (Block)this.blockExpression.getSingle(event));
        return super.walk(event, false);
    }

    @NotNull
    public String toString(@Nullable Event event, boolean b) {
        return "when " + this.blockExpression.toString(event, b) + " gets " + (this.mine ? "mined" : "broken");
    }

    static {
        Skript.registerSection(SecEvtBreak.class, (String[])new String[]{"[execute|run] on (break[ing]|mine:min(e|ing)) of %~block%", "[execute|run] when %~block% get[s] (broken|mine:mined)"});
    }
}

