/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.brewingstand.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.BrewingStandFuelEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Brewing Stand - Will Consume Fuel")
@Description(value={"Checks whether or not the brewing stand's fuel will be consumed in a Brewing Stand Fuel Event"})
@Examples(value={"on brewing stand fuel:\n  # checks if the fuel will be consumed, it will by default\n  if the brewing fuel will be consumed:\n    # cancels it\n    cancel brewing fuel consume\n"})
@Since(value={"1.0.2"})
public class CondConsumeBrewingFuel
extends Condition {
    public boolean init(Expression<?> @NotNull [] expressions, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parser) {
        if (!this.getParser().isCurrentEvent(BrewingStandFuelEvent.class)) {
            Skript.error((String)"This condition can only be used in the Brewing Stand Fuel event!");
            return false;
        }
        this.setNegated(matchedPattern == 1);
        return true;
    }

    @NotNull
    public String toString(@Nullable Event event, boolean debug) {
        return "the brewing fuel will " + (this.isNegated() ? "not" : "") + " be consumed";
    }

    public boolean check(@NotNull Event event) {
        return this.isNegated() ^ ((BrewingStandFuelEvent)event).isConsuming();
    }

    static {
        Skript.registerCondition(CondConsumeBrewingFuel.class, (String[])new String[]{"[the] brewing fuel will be consumed", "[the] brewing fuel w(ill not|on't) be consumed"});
    }
}

