/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.brewingstand.expressions;

import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import it.jakegblp.lusk.api.BlockWrapper;
import it.jakegblp.lusk.api.skript.SimplerPropertyExpression;
import org.jetbrains.annotations.Nullable;

@Name(value="Brewing - Fuel Level")
@Description(value={"Returns the brewing fuel level of a Brewing Stand.\nCan be set, reset and deleted."})
@Examples(value={"on brewing start:\n\tbroadcast the brewing fuel level of event-block"})
@Since(value={"1.0.2, 1.3 (Plural, Blockstate, Item)"})
public class ExprBrewingFuelLevel
extends SimplerPropertyExpression<Object, Integer> {
    @Nullable
    public Integer convert(Object from) {
        return new BlockWrapper(from).getBrewingFuelLevel();
    }

    @Override
    public boolean allowSet() {
        return true;
    }

    @Override
    public boolean allowReset() {
        return true;
    }

    @Override
    public boolean allowDelete() {
        return true;
    }

    @Override
    public void set(Object from, Integer to) {
        new BlockWrapper(from, true).setBrewingFuelLevel(to);
    }

    @Override
    public void delete(Object from) {
        this.set(from, null);
    }

    @Override
    public void reset(Object from) {
        this.delete(from);
    }

    protected String getPropertyName() {
        return "brewing stand fuel level";
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    static {
        ExprBrewingFuelLevel.register(ExprBrewingFuelLevel.class, Integer.class, (String)"brewing [stand] fuel level", (String)"blocks/blockstates/itemtypes");
    }
}

