/*
 * Decompiled with CFR 0.152.
 */
package it.jakegblp.lusk.elements.minecraft.blocks.brewingstand.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import it.jakegblp.lusk.utils.Constants;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.BrewingStandFuelEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Name(value="Brewing Stand Fuel Power")
@Description(value={"Returns the fuel power for the fuel in the Brewing Stand Fuel event.\n Can be set."})
@Examples(value={"on brewing stand fuel:\n\tset brewing fuel power to 5"})
@Since(value={"1.0.2"})
public class ExprBrewingFuelPower
extends SimpleExpression<Integer> {
    public boolean init(Expression<?> @NotNull [] exprs, int matchedPattern, @NotNull Kleenean isDelayed, @NotNull SkriptParser.ParseResult parseResult) {
        if (!this.getParser().isCurrentEvent(BrewingStandFuelEvent.class)) {
            Skript.error((String)"This expression can only be used in the Brewing Stand Fuel event!");
            return false;
        }
        return true;
    }

    protected Integer @NotNull [] get(@NotNull Event e) {
        return new Integer[]{((BrewingStandFuelEvent)e).getFuelPower()};
    }

    public Class<?>[] acceptChange(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Class[] classArray;
        if (mode == Changer.ChangeMode.SET) {
            Class[] classArray2 = new Class[1];
            classArray = classArray2;
            classArray2[0] = Integer.class;
        } else {
            classArray = null;
        }
        return classArray;
    }

    public void change(@NotNull Event e, Object @NotNull [] delta, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Changer.ChangeMode mode) {
        Object object = delta[0];
        if (object instanceof Integer) {
            Integer integer = (Integer)object;
            ((BrewingStandFuelEvent)e).setFuelPower(integer.intValue());
        }
    }

    public boolean isSingle() {
        return true;
    }

    @NotNull
    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    @NotNull
    public String toString(@Nullable Event e, boolean debug) {
        return "the brewing fuel power";
    }

    static {
        Skript.registerExpression(ExprBrewingFuelPower.class, Integer.class, (ExpressionType)Constants.EVENT_OR_SIMPLE, (String[])new String[]{"[the] brewing fuel power"});
    }
}

